(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[18],{

/***/ "+/ys":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModQuizConnectionErrorComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("fXoL");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("TEn/");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("sYmb");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Component that displays a quiz entry page.
 */
let AddonModQuizConnectionErrorComponent = /*@__PURE__*/ (() => {
    class AddonModQuizConnectionErrorComponent {
    }
    AddonModQuizConnectionErrorComponent.ɵfac = function AddonModQuizConnectionErrorComponent_Factory(t) { return new (t || AddonModQuizConnectionErrorComponent)(); };
    AddonModQuizConnectionErrorComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineComponent */ "sc"]({ type: AddonModQuizConnectionErrorComponent, selectors: [["addon-mod-quiz-connection-error"]], decls: 4, vars: 3, consts: [[1, "ion-text-wrap"]], template: function AddonModQuizConnectionErrorComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtext */ "pd"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵpipe */ "Pc"](3, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵpipeBind1 */ "Qc"](3, 1, "addon.mod_quiz.connectionerror"));
            }
        }, directives: [_ionic_angular__WEBPACK_IMPORTED_MODULE_1__[/* IonItem */ "H"], _ionic_angular__WEBPACK_IMPORTED_MODULE_1__[/* IonLabel */ "N"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_2__[/* TranslatePipe */ "d"]], styles: ["[_nghost-%COMP%]{background-color:var(--red-light)}[_nghost-%COMP%]   .item[_ngcontent-%COMP%]{--background:var(--red-light)}"] });
    return AddonModQuizConnectionErrorComponent;
})();


/***/ }),

/***/ "+8pu":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModQuizHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModQuizHelper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("n9nU");
/* harmony import */ var _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("93ts");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("ULAo");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("pHTc");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("j3ag");
/* harmony import */ var _components_preflight_modal_preflight_modal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("d59U");
/* harmony import */ var _access_rules_delegate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("odRd");
/* harmony import */ var _handlers_module__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("y4f6");
/* harmony import */ var _quiz__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("Ohwm");
/* harmony import */ var _quiz_offline__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("7H4o");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.















/**
 * Helper service that provides some features for quiz.
 */
let AddonModQuizHelperProvider = /*@__PURE__*/ (() => {
    class AddonModQuizHelperProvider {
        /**
         * Validate a preflight data or show a modal to input the preflight data if required.
         * It calls AddonModQuizProvider.startAttempt if a new attempt is needed.
         *
         * @param quiz Quiz.
         * @param accessInfo Quiz access info.
         * @param preflightData Object where to store the preflight data.
         * @param attempt Attempt to continue. Don't pass any value if the user needs to start a new attempt.
         * @param offline Whether the attempt is offline.
         * @param prefetch Whether user is prefetching.
         * @param title The title to display in the modal and in the submit button.
         * @param siteId Site ID. If not defined, current site.
         * @param retrying Whether we're retrying after a failure.
         * @return Promise resolved when the preflight data is validated. The resolve param is the attempt.
         */
        getAndCheckPreflightData(quiz, accessInfo, preflightData, attempt, offline, prefetch, title, siteId, retrying) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const rules = accessInfo === null || accessInfo === void 0 ? void 0 : accessInfo.activerulenames;
                // Check if the user needs to input preflight data.
                const preflightCheckRequired = yield _access_rules_delegate__WEBPACK_IMPORTED_MODULE_10__[/* AddonModQuizAccessRuleDelegate */ "a"].isPreflightCheckRequired(rules, quiz, attempt, prefetch, siteId);
                if (preflightCheckRequired) {
                    // Preflight check is required. Show a modal with the preflight form.
                    const data = yield this.getPreflightData(quiz, accessInfo, attempt, prefetch, title, siteId);
                    // Data entered by the user, add it to preflight data and check it again.
                    Object.assign(preflightData, data);
                }
                // Get some fixed preflight data from access rules (data that doesn't require user interaction).
                yield _access_rules_delegate__WEBPACK_IMPORTED_MODULE_10__[/* AddonModQuizAccessRuleDelegate */ "a"].getFixedPreflightData(rules, quiz, preflightData, attempt, prefetch, siteId);
                try {
                    // All the preflight data is gathered, now validate it.
                    return yield this.validatePreflightData(quiz, accessInfo, preflightData, attempt, offline, prefetch, siteId);
                }
                catch (error) {
                    if (prefetch) {
                        throw error;
                    }
                    else if (retrying && !preflightCheckRequired) {
                        // We're retrying after a failure, but the preflight check wasn't required.
                        // This means there's something wrong with some access rule or user is offline and data isn't cached.
                        // Don't retry again because it would lead to an infinite loop.
                        throw error;
                    }
                    // Show error and ask for the preflight again.
                    // Wait to show the error because we want it to be shown over the preflight modal.
                    setTimeout(() => {
                        _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, 'core.error', true);
                    }, 100);
                    return this.getAndCheckPreflightData(quiz, accessInfo, preflightData, attempt, offline, prefetch, title, siteId, true);
                }
            });
        }
        /**
         * Get the preflight data from the user using a modal.
         *
         * @param quiz Quiz.
         * @param accessInfo Quiz access info.
         * @param attempt The attempt started/continued. If not supplied, user is starting a new attempt.
         * @param prefetch Whether the user is prefetching the quiz.
         * @param title The title to display in the modal and in the submit button.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with the preflight data. Rejected if user cancels.
         */
        getPreflightData(quiz, accessInfo, attempt, prefetch, title, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const notSupported = [];
                const rules = accessInfo === null || accessInfo === void 0 ? void 0 : accessInfo.activerulenames;
                // Check if there is any unsupported rule.
                rules.forEach((rule) => {
                    if (!_access_rules_delegate__WEBPACK_IMPORTED_MODULE_10__[/* AddonModQuizAccessRuleDelegate */ "a"].isAccessRuleSupported(rule)) {
                        notSupported.push(rule);
                    }
                });
                if (notSupported.length) {
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_8__[/* Translate */ "L"].instant('addon.mod_quiz.errorrulesnotsupported') + ' ' + JSON.stringify(notSupported));
                }
                // Create and show the modal.
                const modalData = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__[/* CoreDomUtils */ "a"].openModal({
                    component: _components_preflight_modal_preflight_modal__WEBPACK_IMPORTED_MODULE_9__[/* AddonModQuizPreflightModalComponent */ "a"],
                    componentProps: {
                        title: title,
                        quiz,
                        attempt,
                        prefetch: !!prefetch,
                        siteId: siteId,
                        rules: rules,
                    },
                });
                if (!modalData) {
                    throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__[/* CoreCanceledError */ "a"]();
                }
                return modalData;
            });
        }
        /**
         * Gets the mark string from a question HTML.
         * Example result: "Marked out of 1.00".
         *
         * @param html Question's HTML.
         * @return Question's mark.
         */
        getQuestionMarkFromHtml(html) {
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__[/* CoreDomUtils */ "a"].convertToElement(html);
            return _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__[/* CoreDomUtils */ "a"].getContentsOfElement(element, '.grade');
        }
        /**
         * Get a quiz ID by attempt ID.
         *
         * @param attemptId Attempt ID.
         * @param options Other options.
         * @return Promise resolved with the quiz ID.
         */
        getQuizIdByAttemptId(attemptId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Use getAttemptReview to retrieve the quiz ID.
                const reviewData = yield _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].getAttemptReview(attemptId, options);
                if (reviewData.attempt.quiz) {
                    return reviewData.attempt.quiz;
                }
                throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__[/* CoreError */ "a"]('Cannot get quiz ID.');
            });
        }
        /**
         * Handle a review link.
         *
         * @param attemptId Attempt ID.
         * @param page Page to load, -1 to all questions in same page.
         * @param courseId Course ID.
         * @param quizId Quiz ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when done.
         */
        handleReviewLink(attemptId, page, courseId, quizId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getCurrentSiteId();
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__[/* CoreDomUtils */ "a"].showModalLoading();
                try {
                    if (!quizId) {
                        quizId = yield this.getQuizIdByAttemptId(attemptId, { siteId });
                    }
                    const module = yield _features_course_services_course__WEBPACK_IMPORTED_MODULE_3__[/* CoreCourse */ "a"].getModuleBasicInfoByInstance(quizId, 'quiz', siteId);
                    courseId = courseId || module.course;
                    // Go to the review page.
                    yield _services_navigator__WEBPACK_IMPORTED_MODULE_4__[/* CoreNavigator */ "a"].navigateToSitePath(`${_handlers_module__WEBPACK_IMPORTED_MODULE_11__[/* AddonModQuizModuleHandlerService */ "b"].PAGE_NAME}/${courseId}/${module.id}/review/${attemptId}`, {
                        params: {
                            page: page == undefined || isNaN(page) ? -1 : page,
                        },
                        siteId,
                    });
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_6__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, 'An error occurred while loading the required data.');
                }
                finally {
                    modal.dismiss();
                }
            });
        }
        /**
         * Add some calculated data to the attempt.
         *
         * @param quiz Quiz.
         * @param attempt Attempt.
         * @param highlight Whether we should check if attempt should be highlighted.
         * @param bestGrade Quiz's best grade (formatted). Required if highlight=true.
         * @param isLastAttempt Whether the attempt is the last one.
         * @param siteId Site ID.
         */
        setAttemptCalculatedData(quiz, attempt, highlight, bestGrade, isLastAttempt, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const formattedAttempt = attempt;
                formattedAttempt.rescaledGrade = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].rescaleGrade(attempt.sumgrades, quiz, false);
                formattedAttempt.finished = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].isAttemptFinished(attempt.state);
                formattedAttempt.readableState = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].getAttemptReadableState(quiz, attempt);
                if (quiz.showMarkColumn && formattedAttempt.finished) {
                    formattedAttempt.readableMark = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].formatGrade(attempt.sumgrades, quiz.decimalpoints);
                }
                else {
                    formattedAttempt.readableMark = '';
                }
                if (quiz.showGradeColumn && formattedAttempt.finished) {
                    formattedAttempt.readableGrade = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].formatGrade(Number(formattedAttempt.rescaledGrade), quiz.decimalpoints);
                    // Highlight the highest grade if appropriate.
                    formattedAttempt.highlightGrade = !!(highlight && !attempt.preview &&
                        attempt.state == _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuizProvider */ "b"].ATTEMPT_FINISHED && formattedAttempt.readableGrade == bestGrade);
                }
                else {
                    formattedAttempt.readableGrade = '';
                }
                if (isLastAttempt || isLastAttempt === undefined) {
                    formattedAttempt.finishedOffline = yield _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].isAttemptFinishedOffline(attempt.id, siteId);
                }
                return formattedAttempt;
            });
        }
        /**
         * Add some calculated data to the quiz.
         *
         * @param quiz Quiz.
         * @param options Review options.
         */
        setQuizCalculatedData(quiz, options) {
            const formattedQuiz = quiz;
            formattedQuiz.sumGradesFormatted = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].formatGrade(quiz.sumgrades, quiz.decimalpoints);
            formattedQuiz.gradeFormatted = _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].formatGrade(quiz.grade, quiz.decimalpoints);
            formattedQuiz.showAttemptColumn = quiz.attempts != 1;
            formattedQuiz.showGradeColumn = options.someoptions.marks >= _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuizProvider */ "b"].QUESTION_OPTIONS_MARK_AND_MAX &&
                _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].quizHasGrades(quiz);
            formattedQuiz.showMarkColumn = formattedQuiz.showGradeColumn && quiz.grade != quiz.sumgrades;
            formattedQuiz.showFeedbackColumn = !!quiz.hasfeedback && !!options.alloptions.overallfeedback;
            return formattedQuiz;
        }
        /**
         * Validate the preflight data. It calls AddonModQuizProvider.startAttempt if a new attempt is needed.
         *
         * @param quiz Quiz.
         * @param accessInfo Quiz access info.
         * @param preflightData Object where to store the preflight data.
         * @param attempt Attempt to continue. Don't pass any value if the user needs to start a new attempt.
         * @param offline Whether the attempt is offline.
         * @param sent Whether preflight data has been entered by the user.
         * @param prefetch Whether user is prefetching.
         * @param title The title to display in the modal and in the submit button.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the preflight data is validated.
         */
        validatePreflightData(quiz, accessInfo, preflightData, attempt, offline, prefetch, siteId) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const rules = accessInfo.activerulenames;
                const modOptions = {
                    cmId: quiz.coursemodule,
                    readingStrategy: offline ? 1 /* PREFER_CACHE */ : 2 /* ONLY_NETWORK */,
                    siteId,
                };
                try {
                    if (attempt) {
                        if (attempt.state != _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuizProvider */ "b"].ATTEMPT_OVERDUE && !attempt.finishedOffline) {
                            // We're continuing an attempt. Call getAttemptData to validate the preflight data.
                            yield _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].getAttemptData(attempt.id, attempt.currentpage, preflightData, modOptions);
                            if (offline) {
                                // Get current page stored in local.
                                const storedAttempt = yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].ignoreErrors(_quiz_offline__WEBPACK_IMPORTED_MODULE_13__[/* AddonModQuizOffline */ "a"].getAttemptById(attempt.id));
                                attempt.currentpage = (_a = storedAttempt === null || storedAttempt === void 0 ? void 0 : storedAttempt.currentpage) !== null && _a !== void 0 ? _a : attempt.currentpage;
                            }
                        }
                        else {
                            // Attempt is overdue or finished in offline, we can only see the summary.
                            // Call getAttemptSummary to validate the preflight data.
                            yield _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].getAttemptSummary(attempt.id, preflightData, modOptions);
                        }
                    }
                    else {
                        // We're starting a new attempt, call startAttempt.
                        attempt = yield _quiz__WEBPACK_IMPORTED_MODULE_12__[/* AddonModQuiz */ "a"].startAttempt(quiz.id, preflightData, false, siteId);
                    }
                    // Preflight data validated.
                    _access_rules_delegate__WEBPACK_IMPORTED_MODULE_10__[/* AddonModQuizAccessRuleDelegate */ "a"].notifyPreflightCheckPassed(rules, quiz, attempt, preflightData, prefetch, siteId);
                    return attempt;
                }
                catch (error) {
                    if (_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // The WebService returned an error, assume the preflight failed.
                        _access_rules_delegate__WEBPACK_IMPORTED_MODULE_10__[/* AddonModQuizAccessRuleDelegate */ "a"].notifyPreflightCheckFailed(rules, quiz, attempt, preflightData, prefetch, siteId);
                    }
                    throw error;
                }
            });
        }
    }
    AddonModQuizHelperProvider.ɵfac = function AddonModQuizHelperProvider_Factory(t) { return new (t || AddonModQuizHelperProvider)(); };
    AddonModQuizHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_14__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModQuizHelperProvider, factory: AddonModQuizHelperProvider.ɵfac, providedIn: 'root' });
    return AddonModQuizHelperProvider;
})();
const AddonModQuizHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_8__[/* makeSingleton */ "P"])(AddonModQuizHelperProvider);


/***/ }),

/***/ "+9OH":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModH5PActivityModuleHandlerService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModH5PActivityModuleHandler; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("BaYo");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ULAo");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("pHTc");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _components_index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ArZS");
/* harmony import */ var _h5pactivity__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("pOwY");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Handler to support H5P activities.
 */
let AddonModH5PActivityModuleHandlerService = /*@__PURE__*/ (() => {
    class AddonModH5PActivityModuleHandlerService {
        constructor() {
            this.name = 'AddonModH5PActivity';
            this.modName = 'h5pactivity';
            this.supportedFeatures = {
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GROUPS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GROUPINGS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_MOD_INTRO]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_SHOW_DESCRIPTION]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_COMPLETION_TRACKS_VIEWS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_MODEDIT_DEFAULT_COMPLETION]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GRADE_HAS_GRADE]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GRADE_OUTCOMES]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_BACKUP_MOODLE2]: true,
            };
        }
        /**
         * @inheritdoc
         */
        isEnabled() {
            return _h5pactivity__WEBPACK_IMPORTED_MODULE_6__[/* AddonModH5PActivity */ "a"].isPluginEnabled();
        }
        /**
         * @inheritdoc
         */
        getData(module) {
            return {
                icon: _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourse */ "a"].getModuleIconSrc(this.modName, 'modicon' in module ? module.modicon : undefined),
                title: module.name,
                class: 'addon-mod_h5pactivity-handler',
                showDownloadButton: true,
                action(event, module, courseId, options) {
                    options = options || {};
                    options.params = options.params || {};
                    Object.assign(options.params, { module });
                    const routeParams = '/' + courseId + '/' + module.id;
                    _services_navigator__WEBPACK_IMPORTED_MODULE_3__[/* CoreNavigator */ "a"].navigateToSitePath(AddonModH5PActivityModuleHandlerService.PAGE_NAME + routeParams, options);
                },
            };
        }
        /**
         * @inheritdoc
         */
        getMainComponent() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return _components_index__WEBPACK_IMPORTED_MODULE_5__[/* AddonModH5PActivityIndexComponent */ "a"];
            });
        }
    }
    AddonModH5PActivityModuleHandlerService.PAGE_NAME = 'mod_h5pactivity';
    AddonModH5PActivityModuleHandlerService.ɵfac = function AddonModH5PActivityModuleHandlerService_Factory(t) { return new (t || AddonModH5PActivityModuleHandlerService)(); };
    AddonModH5PActivityModuleHandlerService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModH5PActivityModuleHandlerService, factory: AddonModH5PActivityModuleHandlerService.ɵfac, providedIn: 'root' });
    return AddonModH5PActivityModuleHandlerService;
})();
const AddonModH5PActivityModuleHandler = Object(_singletons__WEBPACK_IMPORTED_MODULE_4__[/* makeSingleton */ "P"])(AddonModH5PActivityModuleHandlerService);


/***/ }),

/***/ "+L8p":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreInterceptor; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * Interceptor for Http calls. Adds the header 'Content-Type'='application/x-www-form-urlencoded'
 * and serializes the parameters if needed.
 */
let CoreInterceptor = /*@__PURE__*/ (() => {
    class CoreInterceptor {
        /**
         * Serialize an object to be used in a request.
         *
         * @param obj Object to serialize.
         * @param addNull Add null values to the serialized as empty parameters.
         * @return Serialization of the object.
         */
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        static serialize(obj, addNull) {
            let query = '';
            for (const name in obj) {
                const value = obj[name];
                if (value instanceof Array) {
                    for (let i = 0; i < value.length; ++i) {
                        const subValue = value[i];
                        const fullSubName = name + '[' + i + ']';
                        const innerObj = {};
                        innerObj[fullSubName] = subValue;
                        query += this.serialize(innerObj) + '&';
                    }
                }
                else if (value instanceof Object) {
                    for (const subName in value) {
                        const subValue = value[subName];
                        const fullSubName = name + '[' + subName + ']';
                        const innerObj = {};
                        innerObj[fullSubName] = subValue;
                        query += this.serialize(innerObj) + '&';
                    }
                }
                else if (addNull || (typeof value != 'undefined' && value !== null)) {
                    query += encodeURIComponent(name) + '=' + encodeURIComponent(value) + '&';
                }
            }
            return query.length ? query.substr(0, query.length - 1) : query;
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        intercept(req, next) {
            // Add the header and serialize the body if needed.
            const newReq = req.clone({
                headers: req.headers.set('Content-Type', 'application/x-www-form-urlencoded'),
                body: typeof req.body == 'object' && String(req.body) != '[object File]' ?
                    CoreInterceptor.serialize(req.body) : req.body,
            });
            // Pass on the cloned request instead of the original request.
            return next.handle(newReq);
        }
    }
    CoreInterceptor.ɵfac = function CoreInterceptor_Factory(t) { return new (t || CoreInterceptor)(); };
    CoreInterceptor.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreInterceptor, factory: CoreInterceptor.ɵfac });
    return CoreInterceptor;
})();


/***/ }),

/***/ "+c6a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonNotesOfflineProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonNotesOffline; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("Q98t");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("j3ag");
/* harmony import */ var _database_notes__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("9gdW");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Service to handle offline notes.
 */
let AddonNotesOfflineProvider = /*@__PURE__*/ (() => {
    class AddonNotesOfflineProvider {
        /**
         * Delete an offline note.
         *
         * @param userId User ID the note is about.
         * @param content The note content.
         * @param timecreated The time the note was created.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if deleted, rejected if failure.
         */
        deleteOfflineNote(userId, content, timecreated, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                yield site.getDb().deleteRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], {
                    userid: userId,
                    content: content,
                    created: timecreated,
                });
            });
        }
        /**
         * Get all offline deleted notes.
         *
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getAllDeletedNotes(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_DELETED_TABLE */ "a"]);
            });
        }
        /**
         * Get course offline deleted notes.
         *
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getCourseDeletedNotes(courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_DELETED_TABLE */ "a"], { courseid: courseId });
            });
        }
        /**
         * Get all offline notes.
         *
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getAllNotes(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"]);
            });
        }
        /**
         * Get an offline note.
         *
         * @param userId User ID the note is about.
         * @param content The note content.
         * @param timecreated The time the note was created.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with the notes.
         */
        getNote(userId, content, timecreated, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return site.getDb().getRecord(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], {
                    userid: userId,
                    content: content,
                    created: timecreated,
                });
            });
        }
        /**
         * Get offline notes for a certain course and user.
         *
         * @param courseId Course ID.
         * @param userId User ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getNotesForCourseAndUser(courseId, userId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!userId) {
                    return this.getNotesForCourse(courseId, siteId);
                }
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return yield site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], { userid: userId, courseid: courseId });
            });
        }
        /**
         * Get offline notes for a certain course.
         *
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getNotesForCourse(courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], { courseid: courseId });
            });
        }
        /**
         * Get offline notes for a certain user.
         *
         * @param userId User ID the notes are about.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getNotesForUser(userId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return yield site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], { userid: userId });
            });
        }
        /**
         * Get offline notes with a certain publish state (Personal, Site or Course).
         *
         * @param state Publish state ('personal', 'site' or 'course').
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with notes.
         */
        getNotesWithPublishState(state, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                return yield site.getDb().getRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], { publishstate: state });
            });
        }
        /**
         * Check if there are offline notes for a certain course.
         *
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with boolean: true if has offline notes, false otherwise.
         */
        hasNotesForCourse(courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const notes = yield this.getNotesForCourse(courseId, siteId);
                return !!notes.length;
            });
        }
        /**
         * Check if there are offline notes for a certain user.
         *
         * @param userId User ID the notes are about.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with boolean: true if has offline notes, false otherwise.
         */
        hasNotesForUser(userId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const notes = yield this.getNotesForUser(userId, siteId);
                return !!notes.length;
            });
        }
        /**
         * Check if there are offline notes with a certain publish state (Personal, Site or Course).
         *
         * @param state Publish state ('personal', 'site' or 'course').
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with boolean: true if has offline notes, false otherwise.
         */
        hasNotesWithPublishState(state, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const notes = yield this.getNotesWithPublishState(state, siteId);
                return !!notes.length;
            });
        }
        /**
         * Save a note to be sent later.
         *
         * @param userId User ID the note is about.
         * @param courseId Course ID.
         * @param state Publish state ('personal', 'site' or 'course').
         * @param content The note content.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if stored, rejected if failure.
         */
        saveNote(userId, courseId, state, content, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                const now = _services_utils_time__WEBPACK_IMPORTED_MODULE_2__[/* CoreTimeUtils */ "a"].timestamp();
                const data = {
                    userid: userId,
                    courseid: courseId,
                    publishstate: state,
                    content: content,
                    format: 1,
                    created: now,
                    lastmodified: now,
                };
                yield site.getDb().insertRecord(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_TABLE */ "c"], data);
            });
        }
        /**
         * Delete a note offline to be sent later.
         *
         * @param noteId Note ID.
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if stored, rejected if failure.
         */
        deleteNote(noteId, courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                const data = {
                    noteid: noteId,
                    courseid: courseId,
                    deleted: _services_utils_time__WEBPACK_IMPORTED_MODULE_2__[/* CoreTimeUtils */ "a"].timestamp(),
                };
                yield site.getDb().insertRecord(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_DELETED_TABLE */ "a"], data);
            });
        }
        /**
         * Undo delete a note.
         *
         * @param noteId Note ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if deleted, rejected if failure.
         */
        undoDeleteNote(noteId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getSite(siteId);
                yield site.getDb().deleteRecords(_database_notes__WEBPACK_IMPORTED_MODULE_4__[/* NOTES_DELETED_TABLE */ "a"], { noteid: noteId });
            });
        }
    }
    AddonNotesOfflineProvider.ɵfac = function AddonNotesOfflineProvider_Factory(t) { return new (t || AddonNotesOfflineProvider)(); };
    AddonNotesOfflineProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_5__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonNotesOfflineProvider, factory: AddonNotesOfflineProvider.ɵfac, providedIn: 'root' });
    return AddonNotesOfflineProvider;
})();
const AddonNotesOffline = Object(_singletons__WEBPACK_IMPORTED_MODULE_3__[/* makeSingleton */ "P"])(AddonNotesOfflineProvider);


/***/ }),

/***/ "+iNp":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Zip; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _ionic_native_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("C6fG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");




var Zip = /** @class */ /*@__PURE__*/ (function (_super) {
    Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __extends */ "b"])(Zip, _super);
    function Zip() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Zip.prototype.unzip = function (sourceZip, destUrl, onProgress) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "unzip", { "successIndex": 2, "errorIndex": 4 }, arguments); };
    Zip.pluginName = "Zip";
    Zip.plugin = "cordova-plugin-zip";
    Zip.pluginRef = "zip";
    Zip.repo = "https://github.com/MobileChromeApps/cordova-plugin-zip";
    Zip.platforms = ["Android", "iOS"];
    Zip.ɵfac = function Zip_Factory(t) { return ɵZip_BaseFactory(t || Zip); };
    Zip.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineInjectable */ "uc"]({ token: Zip, factory: function (t) { return Zip.ɵfac(t); } });
    var ɵZip_BaseFactory = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵgetInheritedFactory */ "Gc"](Zip);
    return Zip;
}(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* IonicNativePlugin */ "a"]));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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


/***/ }),

/***/ "+jNv":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModAssignDefaultFeedbackHandler; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Default handler used when a feedback plugin doesn't have a specific implementation.
 */
let AddonModAssignDefaultFeedbackHandler = /*@__PURE__*/ (() => {
    class AddonModAssignDefaultFeedbackHandler {
        constructor() {
            this.name = 'AddonModAssignDefaultFeedbackHandler';
            this.type = 'default';
        }
        /**
         * Discard the draft data of the feedback plugin.
         *
         * @return If the function is async, it should return a Promise resolved when done.
         */
        discardDraft() {
            // Nothing to do.
        }
        /**
         * Return the draft saved data of the feedback plugin.
         *
         * @return Data (or promise resolved with the data).
         */
        getDraft() {
            // Nothing to do.
            return;
        }
        /**
         * Get files used by this plugin.
         * The files returned by this function will be prefetched when the user prefetches the assign.
         *
         * @return The files (or promise resolved with the files).
         */
        getPluginFiles() {
            return [];
        }
        /**
         * Get a readable name to use for the plugin.
         *
         * @param plugin The plugin object.
         * @return The plugin name.
         */
        getPluginName(plugin) {
            // Check if there's a translated string for the plugin.
            const translationId = 'addon.mod_assign_feedback_' + plugin.type + '.pluginname';
            const translation = _singletons__WEBPACK_IMPORTED_MODULE_1__[/* Translate */ "L"].instant(translationId);
            if (translationId != translation) {
                // Translation found, use it.
                return translation;
            }
            // Fallback to WS string.
            if (plugin.name) {
                return plugin.name;
            }
            return '';
        }
        /**
         * Check if the feedback data has changed for this plugin.
         *
         * @return Boolean (or promise resolved with boolean): whether the data has changed.
         */
        hasDataChanged() {
            return false;
        }
        /**
         * Check whether the plugin has draft data stored.
         *
         * @return Boolean or promise resolved with boolean: whether the plugin has draft data.
         */
        hasDraftData() {
            return false;
        }
        /**
         * Whether or not the handler is enabled on a site level.
         *
         * @return True or promise resolved with true if enabled.
         */
        isEnabled() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return true;
            });
        }
        /**
         * Prefetch any required data for the plugin.
         * This should NOT prefetch files. Files to be prefetched should be returned by the getPluginFiles function.
         *
         * @return Promise resolved when done.
         */
        prefetch() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return;
            });
        }
        /**
         * Prepare and add to pluginData the data to send to the server based on the draft data saved.
         *
         * @return If the function is async, it should return a Promise resolved when done.
         */
        prepareFeedbackData() {
            // Nothing to do.
        }
        /**
         * Save draft data of the feedback plugin.
         *
         * @return If the function is async, it should return a Promise resolved when done.
         */
        saveDraft() {
            // Nothing to do.
        }
    }
    AddonModAssignDefaultFeedbackHandler.ɵfac = function AddonModAssignDefaultFeedbackHandler_Factory(t) { return new (t || AddonModAssignDefaultFeedbackHandler)(); };
    AddonModAssignDefaultFeedbackHandler.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModAssignDefaultFeedbackHandler, factory: AddonModAssignDefaultFeedbackHandler.ɵfac, providedIn: 'root' });
    return AddonModAssignDefaultFeedbackHandler;
})();


/***/ }),

/***/ "+jPs":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreUserDelegateService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreUserDelegate; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("2Vo4");
/* harmony import */ var _classes_delegate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("03Vu");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fjkH");
/* harmony import */ var _user__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("4pns");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("j3ag");
/* harmony import */ var _features_courses_services_courses__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("Xzvb");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("9+EE");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.










/**
 * Service to interact with plugins to be shown in user profile. Provides functions to register a plugin
 * and notify an update in the data.
 */
let CoreUserDelegateService = /*@__PURE__*/ (() => {
    class CoreUserDelegateService extends _classes_delegate__WEBPACK_IMPORTED_MODULE_2__[/* CoreDelegate */ "a"] {
        constructor() {
            super('CoreUserDelegate', true);
            /**
             * Cache object that checks enabled for use.
             */
            this.enabledForUserCache = {};
            this.featurePrefix = 'CoreUserDelegate_';
            // Hold the handlers and the observable to notify them for each user.
            this.userHandlers = {};
            _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].on(CoreUserDelegateService.UPDATE_HANDLER_EVENT, (data) => {
                if (!data || !data.handler || !this.userHandlers[data.userId]) {
                    return;
                }
                // Search the handler.
                const handler = this.userHandlers[data.userId].handlers.find((userHandler) => userHandler.name == data.handler);
                if (!handler) {
                    return;
                }
                // Update the data and notify.
                Object.assign(handler.data, data.data);
                this.userHandlers[data.userId].observable.next(this.userHandlers[data.userId].handlers);
            });
            _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].LOGOUT, () => {
                this.clearHandlerCache();
            });
            _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].on(_user__WEBPACK_IMPORTED_MODULE_5__[/* CoreUserProvider */ "b"].PROFILE_REFRESHED, (data) => {
                this.clearHandlerCache(data.courseId, data.userId);
            });
        }
        /**
         * Check if handlers are loaded.
         *
         * @return True if handlers are loaded, false otherwise.
         */
        areHandlersLoaded(userId) {
            var _a;
            return (_a = this.userHandlers[userId]) === null || _a === void 0 ? void 0 : _a.loaded;
        }
        /**
         * Clear current user handlers.
         *
         * @param userId The user to clear.
         */
        clearUserHandlers(userId) {
            const userData = this.userHandlers[userId];
            if (userData) {
                userData.handlers = [];
                userData.observable.next([]);
                userData.loaded = false;
            }
        }
        /**
         * Get the profile handlers for a user.
         *
         * @param user The user object.
         * @param courseId The course ID.
         * @return Resolved with the handlers.
         */
        getProfileHandlersFor(user, courseId) {
            // Initialize the user handlers if it isn't initialized already.
            if (!this.userHandlers[user.id]) {
                this.userHandlers[user.id] = {
                    loaded: false,
                    handlers: [],
                    observable: new rxjs__WEBPACK_IMPORTED_MODULE_1__[/* BehaviorSubject */ "a"]([]),
                };
            }
            this.calculateUserHandlers(user, courseId);
            return this.userHandlers[user.id].observable;
        }
        /**
         * Get the profile handlers for a user.
         *
         * @param user The user object.
         * @param courseId The course ID.
         * @return Promise resolved when done.
         */
        calculateUserHandlers(user, courseId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                let navOptions;
                let admOptions;
                if (_features_courses_services_courses__WEBPACK_IMPORTED_MODULE_7__[/* CoreCourses */ "a"].canGetAdminAndNavOptions()) {
                    // Get course options.
                    const courses = yield _features_courses_services_courses__WEBPACK_IMPORTED_MODULE_7__[/* CoreCourses */ "a"].getUserCourses(true);
                    const courseIds = courses.map((course) => course.id);
                    const options = yield _features_courses_services_courses__WEBPACK_IMPORTED_MODULE_7__[/* CoreCourses */ "a"].getCoursesAdminAndNavOptions(courseIds);
                    // For backwards compatibility we don't modify the courseId.
                    const courseIdForOptions = courseId || _services_sites__WEBPACK_IMPORTED_MODULE_8__[/* CoreSites */ "b"].getCurrentSiteHomeId();
                    navOptions = options.navOptions[courseIdForOptions];
                    admOptions = options.admOptions[courseIdForOptions];
                }
                const userData = this.userHandlers[user.id];
                userData.handlers = [];
                yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__[/* CoreUtils */ "a"].allPromises(Object.keys(this.enabledHandlers).map((name) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    // Checks if the handler is enabled for the user.
                    const handler = this.handlers[name];
                    try {
                        const enabled = yield this.getAndCacheEnabledForUserFromHandler(handler, user, courseId, navOptions, admOptions);
                        if (enabled) {
                            userData.handlers.push({
                                name: name,
                                data: handler.getDisplayData(user, courseId),
                                priority: handler.priority || 0,
                                type: handler.type || CoreUserDelegateService.TYPE_NEW_PAGE,
                            });
                        }
                    }
                    catch (_a) {
                        // Nothing to do here, it is not enabled for this user.
                    }
                })));
                // Sort them by priority.
                userData.handlers.sort((a, b) => b.priority - a.priority);
                userData.loaded = true;
                userData.observable.next(userData.handlers);
            });
        }
        /**
         * Helper funtion to get enabled for user from the handler.
         *
         * @param handler Handler object.
         * @param user User object.
         * @param courseId Course ID where to show.
         * @param navOptions Navigation options for the course.
         * @param admOptions Admin options for the course.
         * @return Whether or not the handler is enabled for a user.
         */
        getAndCacheEnabledForUserFromHandler(handler, user, courseId, navOptions, admOptions) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (handler.isEnabledForCourse) {
                    const enabledOnCourse = yield handler.isEnabledForCourse(courseId, navOptions, admOptions);
                    if (!enabledOnCourse) {
                        // If is not enabled in the course, is not enabled for the user.
                        // Do not cache if this is false.
                        return false;
                    }
                }
                if (!handler.cacheEnabled) {
                    if (!handler.isEnabledForUser) {
                        // True by default.
                        return true;
                    }
                    return handler.isEnabledForUser(user, courseId);
                }
                if (typeof this.enabledForUserCache[handler.name] == 'undefined') {
                    this.enabledForUserCache[handler.name] = {};
                }
                const cacheKey = this.getCacheKey(courseId, user.id);
                const cache = this.enabledForUserCache[handler.name][cacheKey];
                if (typeof cache != 'undefined') {
                    return cache;
                }
                let enabled = true; // Default value.
                if (handler.isEnabledForUser) {
                    enabled = yield handler.isEnabledForUser(user, courseId);
                }
                this.enabledForUserCache[handler.name][cacheKey] = enabled;
                return enabled;
            });
        }
        /**
         * Clear handler enabled for user cache.
         * If a courseId and userId are specified, it will only delete the entry for that user and course.
         *
         * @param courseId Course ID.
         * @param userId User ID.
         */
        clearHandlerCache(courseId, userId) {
            if (courseId && userId) {
                Object.keys(this.enabledHandlers).forEach((name) => {
                    delete this.enabledForUserCache[name][this.getCacheKey(courseId, userId)];
                });
            }
            else {
                this.enabledForUserCache = {};
            }
        }
        /**
         * Get a cache key to identify a course and a user.
         *
         * @param courseId Course ID.
         * @param userId User ID.
         * @return Cache key.
         */
        getCacheKey(courseId = 0, userId = 0) {
            return courseId + '#' + userId;
        }
    }
    /**
     * User profile handler type for communication.
     */
    CoreUserDelegateService.TYPE_COMMUNICATION = 'communication';
    /**
     * User profile handler type for new page.
     */
    CoreUserDelegateService.TYPE_NEW_PAGE = 'newpage';
    /**
     * User profile handler type for actions.
     */
    CoreUserDelegateService.TYPE_ACTION = 'action';
    /**
     * Update handler information event.
     */
    CoreUserDelegateService.UPDATE_HANDLER_EVENT = 'CoreUserDelegate_update_handler_event';
    CoreUserDelegateService.ɵfac = function CoreUserDelegateService_Factory(t) { return new (t || CoreUserDelegateService)(); };
    CoreUserDelegateService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_9__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreUserDelegateService, factory: CoreUserDelegateService.ɵfac, providedIn: 'root' });
    return CoreUserDelegateService;
})();
const CoreUserDelegate = Object(_singletons__WEBPACK_IMPORTED_MODULE_6__[/* makeSingleton */ "P"])(CoreUserDelegateService);


/***/ }),

/***/ "+lfu":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonCalendarSyncProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonCalendarSync; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _classes_base_sync__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("wl8P");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("nvXB");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fjkH");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("bFG1");
/* harmony import */ var _calendar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("SmTL");
/* harmony import */ var _calendar_offline__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("Lc7R");
/* harmony import */ var _calendar_helper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("n6RP");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("j3ag");
/* harmony import */ var _services_sync__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("uT8i");
/* harmony import */ var _classes_errors_network_error__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("+mW7");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.













/**
 * Service to sync calendar.
 */
let AddonCalendarSyncProvider = /*@__PURE__*/ (() => {
    class AddonCalendarSyncProvider extends _classes_base_sync__WEBPACK_IMPORTED_MODULE_1__[/* CoreSyncBaseProvider */ "a"] {
        constructor() {
            super('AddonCalendarSync');
            this.componentTranslatableString = 'addon.calendar.calendarevent';
        }
        /**
         * Try to synchronize all events in a certain site or in all sites.
         *
         * @param siteId Site ID to sync. If not defined, sync all sites.
         * @param force Wether to force sync not depending on last execution.
         * @return Promise resolved if sync is successful, rejected if sync fails.
         */
        syncAllEvents(siteId, force = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                yield this.syncOnSites('all calendar events', this.syncAllEventsFunc.bind(this, force), siteId);
            });
        }
        /**
         * Sync all events on a site.
         *
         * @param force Wether to force sync not depending on last execution.
         * @param siteId Site ID to sync.
         * @return Promise resolved if sync is successful, rejected if sync fails.
         */
        syncAllEventsFunc(force = false, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const result = force
                    ? yield this.syncEvents(siteId)
                    : yield this.syncEventsIfNeeded(siteId);
                if (result === null || result === void 0 ? void 0 : result.updated) {
                    // Sync successful, send event.
                    _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].trigger(AddonCalendarSyncProvider.AUTO_SYNCED, result, siteId);
                }
            });
        }
        /**
         * Sync a site events only if a certain time has passed since the last time.
         *
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the events are synced or if it doesn't need to be synced.
         */
        syncEventsIfNeeded(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId();
                const needed = yield this.isSyncNeeded(AddonCalendarSyncProvider.SYNC_ID, siteId);
                if (needed) {
                    return this.syncEvents(siteId);
                }
            });
        }
        /**
         * Synchronize all offline events of a certain site.
         *
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if sync is successful, rejected otherwise.
         */
        syncEvents(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId();
                if (this.isSyncing(AddonCalendarSyncProvider.SYNC_ID, siteId)) {
                    // There's already a sync ongoing for this site, return the promise.
                    return this.getOngoingSync(AddonCalendarSyncProvider.SYNC_ID, siteId);
                }
                this.logger.debug('Try to sync calendar events for site ' + siteId);
                // Get offline events.
                const syncPromise = this.performSyncEvents(siteId);
                return this.addOngoingSync(AddonCalendarSyncProvider.SYNC_ID, syncPromise, siteId);
            });
        }
        /**
         * Sync user preferences of a site.
         *
         * @param siteId Site ID to sync.
         * @param Promise resolved if sync is successful, rejected if sync fails.
         */
        performSyncEvents(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const result = {
                    warnings: [],
                    events: [],
                    deleted: [],
                    toinvalidate: [],
                    updated: false,
                };
                const eventIds = yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].ignoreErrors(_calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].getAllEventsIds(siteId), []);
                if (eventIds.length > 0) {
                    if (!_services_app__WEBPACK_IMPORTED_MODULE_2__[/* CoreApp */ "a"].isOnline()) {
                        // Cannot sync in offline.
                        throw new _classes_errors_network_error__WEBPACK_IMPORTED_MODULE_11__[/* CoreNetworkError */ "a"]();
                    }
                    const promises = eventIds.map((eventId) => this.syncOfflineEvent(eventId, result, siteId));
                    yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].allPromises(promises);
                    if (result.updated) {
                        // Data has been sent to server. Now invalidate the WS calls.
                        const promises = [
                            _calendar__WEBPACK_IMPORTED_MODULE_6__[/* AddonCalendar */ "a"].invalidateEventsList(siteId),
                            _calendar_helper__WEBPACK_IMPORTED_MODULE_8__[/* AddonCalendarHelper */ "b"].refreshAfterChangeEvents(result.toinvalidate, siteId),
                        ];
                        yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].ignoreErrors(Promise.all(promises));
                    }
                }
                // Sync finished, set sync time.
                yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].ignoreErrors(this.setSyncTime(AddonCalendarSyncProvider.SYNC_ID, siteId));
                // All done, return the result.
                return result;
            });
        }
        /**
         * Synchronize an offline event.
         *
         * @param eventId The event ID to sync.
         * @param result Object where to store the result of the sync.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if sync is successful, rejected otherwise.
         */
        syncOfflineEvent(eventId, result, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Verify that event isn't blocked.
                if (_services_sync__WEBPACK_IMPORTED_MODULE_10__[/* CoreSync */ "a"].isBlocked(_calendar__WEBPACK_IMPORTED_MODULE_6__[/* AddonCalendarProvider */ "c"].COMPONENT, eventId, siteId)) {
                    this.logger.debug('Cannot sync event ' + eventId + ' because it is blocked.');
                    throw new _classes_base_sync__WEBPACK_IMPORTED_MODULE_1__[/* CoreSyncBlockedError */ "b"](_singletons__WEBPACK_IMPORTED_MODULE_9__[/* Translate */ "L"].instant('core.errorsyncblocked', { $a: _singletons__WEBPACK_IMPORTED_MODULE_9__[/* Translate */ "L"].instant('addon.calendar.calendarevent') }));
                }
                // First of all, check if the event has been deleted.
                try {
                    const data = yield _calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].getDeletedEvent(eventId, siteId);
                    // Delete the event.
                    try {
                        yield _calendar__WEBPACK_IMPORTED_MODULE_6__[/* AddonCalendar */ "a"].deleteEventOnline(data.id, !!data.repeat, siteId);
                        result.updated = true;
                        result.deleted.push(eventId);
                        // Event sent, delete the offline data.
                        const promises = [];
                        promises.push(_calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].unmarkDeleted(eventId, siteId));
                        promises.push(_calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].deleteEvent(eventId, siteId).catch(() => {
                            // Ignore errors, maybe there was no edit data.
                        }));
                        // We need the event data to invalidate it. Get it from local DB.
                        promises.push(_calendar__WEBPACK_IMPORTED_MODULE_6__[/* AddonCalendar */ "a"].getEventFromLocalDb(eventId, siteId).then((event) => {
                            result.toinvalidate.push({
                                id: event.id,
                                repeatid: event.repeatid,
                                timestart: event.timestart,
                                repeated: (data === null || data === void 0 ? void 0 : data.repeat) ? event.eventcount || 1 : 1,
                            });
                            return;
                        }).catch(() => {
                            // Ignore errors.
                        }));
                        yield Promise.all(promises);
                    }
                    catch (error) {
                        if (!_services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                            // Local error, reject.
                            throw error;
                        }
                        // The WebService has thrown an error, this means that the event cannot be created. Delete it.
                        result.updated = true;
                        const promises = [];
                        promises.push(_calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].unmarkDeleted(eventId, siteId));
                        promises.push(_calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].deleteEvent(eventId, siteId).catch(() => {
                            // Ignore errors, maybe there was no edit data.
                        }));
                        yield Promise.all(promises);
                        // Event deleted, add a warning.
                        this.addOfflineDataDeletedWarning(result.warnings, data.name, error);
                    }
                    return;
                }
                catch (_a) {
                    // Not deleted.
                }
                // Not deleted. Now get the event data.
                const event = yield _calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].getEvent(eventId, siteId);
                // Try to send the data.
                const data = Object.assign(_services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].clone(event), {
                    description: {
                        text: event.description || '',
                        format: 1,
                    },
                }); // Clone the object because it will be modified in the submit function.
                try {
                    const newEvent = yield _calendar__WEBPACK_IMPORTED_MODULE_6__[/* AddonCalendar */ "a"].submitEventOnline(eventId > 0 ? eventId : 0, data, siteId);
                    result.updated = true;
                    result.events.push(newEvent);
                    // Add data to invalidate.
                    const numberOfRepetitions = data.repeat ? data.repeats :
                        (data.repeateditall && newEvent.repeatid ? newEvent.eventcount : 1);
                    result.toinvalidate.push({
                        id: newEvent.id,
                        repeatid: newEvent.repeatid,
                        timestart: newEvent.timestart,
                        repeated: numberOfRepetitions || 1,
                    });
                    // Event sent, delete the offline data.
                    return _calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].deleteEvent(event.id, siteId);
                }
                catch (error) {
                    if (!_services_utils_utils__WEBPACK_IMPORTED_MODULE_5__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // Local error, reject.
                        throw error;
                    }
                    // The WebService has thrown an error, this means that the event cannot be created. Delete it.
                    result.updated = true;
                    yield _calendar_offline__WEBPACK_IMPORTED_MODULE_7__[/* AddonCalendarOffline */ "a"].deleteEvent(event.id, siteId);
                    // Event deleted, add a warning.
                    this.addOfflineDataDeletedWarning(result.warnings, event.name, error);
                }
            });
        }
    }
    AddonCalendarSyncProvider.AUTO_SYNCED = 'addon_calendar_autom_synced';
    AddonCalendarSyncProvider.MANUAL_SYNCED = 'addon_calendar_manual_synced';
    AddonCalendarSyncProvider.SYNC_ID = 'calendar';
    AddonCalendarSyncProvider.ɵfac = function AddonCalendarSyncProvider_Factory(t) { return new (t || AddonCalendarSyncProvider)(); };
    AddonCalendarSyncProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_12__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonCalendarSyncProvider, factory: AddonCalendarSyncProvider.ɵfac, providedIn: 'root' });
    return AddonCalendarSyncProvider;
})();
const AddonCalendarSync = Object(_singletons__WEBPACK_IMPORTED_MODULE_9__[/* makeSingleton */ "P"])(AddonCalendarSyncProvider);


/***/ }),

/***/ "+mW7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreNetworkError; });
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("j3ag");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * Network error. It will automatically set the right error message if none is provided.
 */
class CoreNetworkError extends Error {
    constructor(message) {
        super(message || _singletons__WEBPACK_IMPORTED_MODULE_0__[/* Translate */ "L"].instant('core.networkerrormsg'));
    }
}


/***/ }),

/***/ "+s0g":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Dutch [nl]
//! author : Joris Röling : https://github.com/jorisroling
//! author : Jacob Middag : https://github.com/middagj

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var monthsShortWithDots = 'jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split(
            '_'
        ),
        monthsShortWithoutDots = 'jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split(
            '_'
        ),
        monthsParse = [
            /^jan/i,
            /^feb/i,
            /^maart|mrt.?$/i,
            /^apr/i,
            /^mei$/i,
            /^jun[i.]?$/i,
            /^jul[i.]?$/i,
            /^aug/i,
            /^sep/i,
            /^okt/i,
            /^nov/i,
            /^dec/i,
        ],
        monthsRegex = /^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;

    var nl = moment.defineLocale('nl', {
        months: 'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split(
            '_'
        ),
        monthsShort: function (m, format) {
            if (!m) {
                return monthsShortWithDots;
            } else if (/-MMM-/.test(format)) {
                return monthsShortWithoutDots[m.month()];
            } else {
                return monthsShortWithDots[m.month()];
            }
        },

        monthsRegex: monthsRegex,
        monthsShortRegex: monthsRegex,
        monthsStrictRegex: /^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,
        monthsShortStrictRegex: /^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,

        monthsParse: monthsParse,
        longMonthsParse: monthsParse,
        shortMonthsParse: monthsParse,

        weekdays: 'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split(
            '_'
        ),
        weekdaysShort: 'zo._ma._di._wo._do._vr._za.'.split('_'),
        weekdaysMin: 'zo_ma_di_wo_do_vr_za'.split('_'),
        weekdaysParseExact: true,
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'DD-MM-YYYY',
            LL: 'D MMMM YYYY',
            LLL: 'D MMMM YYYY HH:mm',
            LLLL: 'dddd D MMMM YYYY HH:mm',
        },
        calendar: {
            sameDay: '[vandaag om] LT',
            nextDay: '[morgen om] LT',
            nextWeek: 'dddd [om] LT',
            lastDay: '[gisteren om] LT',
            lastWeek: '[afgelopen] dddd [om] LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: 'over %s',
            past: '%s geleden',
            s: 'een paar seconden',
            ss: '%d seconden',
            m: 'één minuut',
            mm: '%d minuten',
            h: 'één uur',
            hh: '%d uur',
            d: 'één dag',
            dd: '%d dagen',
            w: 'één week',
            ww: '%d weken',
            M: 'één maand',
            MM: '%d maanden',
            y: 'één jaar',
            yy: '%d jaar',
        },
        dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
        ordinal: function (number) {
            return (
                number +
                (number === 1 || number === 8 || number >= 20 ? 'ste' : 'de')
            );
        },
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 4, // The week that contains Jan 4th is the first week of the year.
        },
    });

    return nl;

})));


/***/ }),

/***/ "//9w":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Northern Sami [se]
//! authors : Bård Rolstad Henriksen : https://github.com/karamell

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var se = moment.defineLocale('se', {
        months: 'ođđajagemánnu_guovvamánnu_njukčamánnu_cuoŋománnu_miessemánnu_geassemánnu_suoidnemánnu_borgemánnu_čakčamánnu_golggotmánnu_skábmamánnu_juovlamánnu'.split(
            '_'
        ),
        monthsShort: 'ođđj_guov_njuk_cuo_mies_geas_suoi_borg_čakč_golg_skáb_juov'.split(
            '_'
        ),
        weekdays: 'sotnabeaivi_vuossárga_maŋŋebárga_gaskavahkku_duorastat_bearjadat_lávvardat'.split(
            '_'
        ),
        weekdaysShort: 'sotn_vuos_maŋ_gask_duor_bear_láv'.split('_'),
        weekdaysMin: 's_v_m_g_d_b_L'.split('_'),
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'DD.MM.YYYY',
            LL: 'MMMM D. [b.] YYYY',
            LLL: 'MMMM D. [b.] YYYY [ti.] HH:mm',
            LLLL: 'dddd, MMMM D. [b.] YYYY [ti.] HH:mm',
        },
        calendar: {
            sameDay: '[otne ti] LT',
            nextDay: '[ihttin ti] LT',
            nextWeek: 'dddd [ti] LT',
            lastDay: '[ikte ti] LT',
            lastWeek: '[ovddit] dddd [ti] LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: '%s geažes',
            past: 'maŋit %s',
            s: 'moadde sekunddat',
            ss: '%d sekunddat',
            m: 'okta minuhta',
            mm: '%d minuhtat',
            h: 'okta diimmu',
            hh: '%d diimmut',
            d: 'okta beaivi',
            dd: '%d beaivvit',
            M: 'okta mánnu',
            MM: '%d mánut',
            y: 'okta jahki',
            yy: '%d jagit',
        },
        dayOfMonthOrdinalParse: /\d{1,2}\./,
        ordinal: '%d.',
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 4, // The week that contains Jan 4th is the first week of the year.
        },
    });

    return se;

})));


/***/ }),

/***/ "/A5c":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return SiteSubscriptionPlan; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return SiteSubscription; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DefaultSiteSubscription; });
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("BaYo");
/* harmony import */ var _singletons_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("r0Kd");
/* harmony import */ var _freemium_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("K1b7");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("j3ag");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Subscription plans.
 */
var SiteSubscriptionPlan = /*@__PURE__*/ (function (SiteSubscriptionPlan) {
    SiteSubscriptionPlan["Free"] = "free";
    SiteSubscriptionPlan["Pro"] = "pro";
    SiteSubscriptionPlan["Premium"] = "premium";
    SiteSubscriptionPlan["BMA"] = "bma";
    return SiteSubscriptionPlan;
})({});
const GRACE_PERIOD = _core_constants__WEBPACK_IMPORTED_MODULE_0__[/* CoreConstants */ "a"].MILLISECONDS_DAY;
// Optional json attributes mapped to class attributes
const OPTIONAL_ATTRIBUTES_MAP = {
    name: 'name',
    description: 'description',
    informationUrl: 'informationUrl',
    limits: 'limits',
    features: 'features',
    brandingColors: 'brandingColors',
    storeConfig: 'storeConfig',
    restrictAccess: 'restrictAccess',
};
/**
 * Subscription info.
 */
class SiteSubscription {
    constructor(plan, created, updated, validUntil) {
        /**
         * Limits to features specific to this subscription.
         */
        this.limits = {};
        /**
         * Enabled or disabled features specific to this subscription.
         */
        this.features = {};
        this.plan = plan;
        this.created = created;
        this.updated = updated;
        this.validUntil = validUntil;
    }
    /**
     * Parse a site subscription json object.
     *
     * @param json Subscription json.
     */
    static fromJSON(json) {
        const subscription = new SiteSubscription(json.plan, new Date(json.createdTimestamp), new Date(json.updatedTimestamp), json.validUntilTimestamp ? new Date(json.validUntilTimestamp) : undefined);
        for (const [jsonAttribute, classAttribute] of Object.entries(OPTIONAL_ATTRIBUTES_MAP)) {
            if (jsonAttribute in json) {
                subscription[classAttribute] = json[jsonAttribute];
            }
        }
        // Migrate legacy attributes.
        if ('standardAppLogin' in json && json['standardAppLogin'] !== 'allowed') {
            const enforce = json['standardAppLogin'] === 'disabled';
            const message = _singletons__WEBPACK_IMPORTED_MODULE_3__[/* Translate */ "L"].instant('freemium.downloadmainapplication' + (enforce ? 'required' : 'suggestion'));
            subscription.restrictAccess = { enforce, message };
        }
        return subscription;
    }
    /**
     * Check if a subscription is active.
     *
     * Subscriptions can remain active after expiring if they are within the grace period.
     *
     * @return Boolean indicating if the subscription is active.
     */
    isActive() {
        if (!this.hasValidUntil()) {
            return true;
        }
        const expirationDate = this.validUntil.getTime();
        return expirationDate + GRACE_PERIOD > Date.now();
    }
    /**
     * Check if a subscription has an expiration date.
     *
     * @return Boolean indicating if the subscription has an expiration date.
     */
    hasValidUntil() {
        return typeof this.validUntil != 'undefined' && this.validUntil !== null;
    }
    /**
     * Check if a subscription has expired.
     *
     * Expired subscriptions can remain active within the grace period.
     *
     * @return boolean indicating if the subscription has expired.
     */
    hasExpired() {
        if (!this.hasValidUntil()) {
            return false;
        }
        const expirationDate = this.validUntil.getTime();
        return expirationDate < Date.now();
    }
    /**
     * Get active subscription plan.
     *
     * @return Active subscription plan.
     */
    getActivePlan() {
        if (!this.isActive()) {
            return SiteSubscriptionPlan.Free;
        }
        return this.plan;
    }
    /**
     * Get feature limit.
     *
     * @param feature Name of the feature.
     * @param defaultValue Default limit if it wasn't found in the subscription nor defaults.
     *
     * @return Number indicating the feature limit or null if there isn't any limitation.
     */
    getFeatureLimit(feature, defaultValue = null) {
        if (this.isActive() && feature in this.limits) {
            return this.limits[feature];
        }
        const activePlan = this.getActivePlan();
        const planDefaults = _freemium_constants__WEBPACK_IMPORTED_MODULE_2__[/* FREEMIUM_PLAN_DEFAULTS */ "a"][feature] || {};
        return activePlan in planDefaults ? planDefaults[activePlan] : defaultValue;
    }
    /**
     * Get the timestamp in milliseconds when the plan expires. Null if the plan doesn't expire.
     *
     * @return The timestamp.
     */
    getValidUntilTime() {
        return this.hasValidUntil() ? this.validUntil.getTime() : null;
    }
    /**
     * Check if a feature is enabled.
     *
     * @param feature Name of the feature.
     * @param defaultValue Default value if it wasn't found in the subscription nor defaults.
     *
     * @return Boolean indicating whether the feature is enabled.
     */
    isFeatureEnabled(feature, defaultValue = false) {
        if (this.isActive() && feature in this.features) {
            return this.features[feature];
        }
        const activePlan = this.getActivePlan();
        const planDefaults = _freemium_constants__WEBPACK_IMPORTED_MODULE_2__[/* FREEMIUM_PLAN_DEFAULTS */ "a"][feature] || {};
        return activePlan in planDefaults ? planDefaults[activePlan] : defaultValue;
    }
    /**
     * Serialize object into its JSON representation.
     */
    toJSON() {
        return _singletons_object__WEBPACK_IMPORTED_MODULE_1__[/* CoreObject */ "a"].withoutUndefined({
            plan: this.plan,
            createdTimestamp: this.created.getTime(),
            updatedTimestamp: this.updated.getTime(),
            validUntilTimestamp: this.validUntil ? this.validUntil.getTime() : null,
            name: this.name,
            description: this.description,
            informationUrl: this.informationUrl,
            limits: this.limits,
            features: this.features,
            brandingColors: this.brandingColors,
            storeConfig: this.storeConfig,
            restrictAccess: this.restrictAccess,
        });
    }
}
/**
 * Default subscription for non-registered sites.
 */
class DefaultSiteSubscription extends SiteSubscription {
    constructor() {
        var _a;
        const defaultSubscription = (_a = _core_constants__WEBPACK_IMPORTED_MODULE_0__[/* CoreConstants */ "a"].CONFIG.defaultsubscription) !== null && _a !== void 0 ? _a : SiteSubscriptionPlan.Free;
        super(defaultSubscription, new Date(), new Date(), new Date(Date.now() + _core_constants__WEBPACK_IMPORTED_MODULE_0__[/* CoreConstants */ "a"].MILLISECONDS_YEAR));
    }
}


/***/ }),

/***/ "/BoF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreNavigationBarComponent; });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("fXoL");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("vuGA");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ofXK");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("TEn/");
/* harmony import */ var _directives_fa_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("3CSS");
/* harmony import */ var _directives_format_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("hMzs");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("sYmb");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








function CoreNavigationBarComponent_ion_grid_0_ion_button_3_core_format_text_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelement */ "zc"](0, "core-format-text", 10);
    }
    if (rf & 2) {
        const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("text", ctx_r4.previousTitle)("component", ctx_r4.component)("componentId", ctx_r4.componentId)("contextLevel", ctx_r4.contextLevel)("contextInstanceId", ctx_r4.contextInstanceId)("courseId", ctx_r4.courseId);
    }
}
function CoreNavigationBarComponent_ion_grid_0_ion_button_3_Template(rf, ctx) {
    if (rf & 1) {
        const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("click", function CoreNavigationBarComponent_ion_grid_0_ion_button_3_Template_ion_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵrestoreView */ "gd"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](2); return ctx_r5.action == null ? null : ctx_r5.action.emit(ctx_r5.previous); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelement */ "zc"](2, "ion-icon", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtemplate */ "nd"](3, CoreNavigationBarComponent_ion_grid_0_ion_button_3_core_format_text_3_Template, 1, 6, "core-format-text", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵattribute */ "mc"]("aria-label", ctx_r1.previousTitle || _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵpipeBind1 */ "Qc"](1, 3, "core.previous"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("slot", ctx_r1.previousTitle ? "start" : "icon-only");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.previousTitle);
    }
}
function CoreNavigationBarComponent_ion_grid_0_ion_col_4_Template(rf, ctx) {
    if (rf & 1) {
        const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](0, "ion-col", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](1, "ion-button", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("click", function CoreNavigationBarComponent_ion_grid_0_ion_col_4_Template_ion_button_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵrestoreView */ "gd"](_r8); const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](2); return ctx_r7.showInfo(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelement */ "zc"](2, "ion-icon", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵattribute */ "mc"]("aria-label", ctx_r2.title);
    }
}
function CoreNavigationBarComponent_ion_grid_0_ion_button_6_core_format_text_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelement */ "zc"](0, "core-format-text", 10);
    }
    if (rf & 2) {
        const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("text", ctx_r9.nextTitle)("component", ctx_r9.component)("componentId", ctx_r9.componentId)("contextLevel", ctx_r9.contextLevel)("contextInstanceId", ctx_r9.contextInstanceId)("courseId", ctx_r9.courseId);
    }
}
function CoreNavigationBarComponent_ion_grid_0_ion_button_6_Template(rf, ctx) {
    if (rf & 1) {
        const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("click", function CoreNavigationBarComponent_ion_grid_0_ion_button_6_Template_ion_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵrestoreView */ "gd"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](2); return ctx_r10.action == null ? null : ctx_r10.action.emit(ctx_r10.next); });
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtemplate */ "nd"](2, CoreNavigationBarComponent_ion_grid_0_ion_button_6_core_format_text_2_Template, 1, 6, "core-format-text", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelement */ "zc"](3, "ion-icon", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵattribute */ "mc"]("aria-label", ctx_r3.nextTitle || _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵpipeBind1 */ "Qc"](1, 3, "core.next"));
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r3.nextTitle);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("slot", ctx_r3.nextTitle ? "end" : "icon-only");
    }
}
function CoreNavigationBarComponent_ion_grid_0_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](0, "ion-grid", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](1, "ion-row");
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](2, "ion-col", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtemplate */ "nd"](3, CoreNavigationBarComponent_ion_grid_0_ion_button_3_Template, 4, 5, "ion-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtemplate */ "nd"](4, CoreNavigationBarComponent_ion_grid_0_ion_col_4_Template, 3, 1, "ion-col", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementStart */ "Ec"](5, "ion-col", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtemplate */ "nd"](6, CoreNavigationBarComponent_ion_grid_0_ion_button_6_Template, 4, 5, "ion-button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("size", ctx_r0.info ? 4 : 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r0.previous);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r0.info);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("size", ctx_r0.info ? 4 : 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r0.next);
    }
}
/**
 * Component to show a "bar" with arrows to navigate forward/backward and a "info" icon to display more data.
 *
 * This directive will show two arrows at the left and right of the screen to navigate to previous/next item when clicked.
 * If no previous/next item is defined, that arrow won't be shown. It will also show a button to show more info.
 *
 * Example usage:
 * <core-navigation-bar [previous]="prevItem" [next]="nextItem" (action)="goTo($event)"></core-navigation-bar>
 */
let CoreNavigationBarComponent = /*@__PURE__*/ (() => {
    class CoreNavigationBarComponent {
        constructor() {
            this.info = ''; // Info to show when clicking the info button. If not defined, the info button won't be shown.
            this.title = ''; // Title to show when seeing the info (new page).
            this.action = new _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* EventEmitter */ "t"](); // Function to call when arrow is clicked. Will receive as a param the item to load.
        }
        showInfo() {
            _services_utils_text__WEBPACK_IMPORTED_MODULE_1__[/* CoreTextUtils */ "a"].viewText(this.title, this.info, {
                component: this.component,
                componentId: this.componentId,
                filter: true,
                contextLevel: this.contextLevel,
                instanceId: this.contextInstanceId,
                courseId: this.courseId,
            });
        }
    }
    CoreNavigationBarComponent.ɵfac = function CoreNavigationBarComponent_Factory(t) { return new (t || CoreNavigationBarComponent)(); };
    CoreNavigationBarComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineComponent */ "sc"]({ type: CoreNavigationBarComponent, selectors: [["core-navigation-bar"]], inputs: { previous: "previous", previousTitle: "previousTitle", next: "next", nextTitle: "nextTitle", info: "info", title: "title", component: "component", componentId: "componentId", contextLevel: "contextLevel", contextInstanceId: "contextInstanceId", courseId: "courseId" }, outputs: { action: "action" }, decls: 1, vars: 1, consts: [["class", "ion-no-padding ion-padding-bottom", 4, "ngIf"], [1, "ion-no-padding", "ion-padding-bottom"], [1, "ion-text-start", "ion-padding-end", 3, "size"], ["class", "core-navigation-bar-arrow", "fill", "outline", 3, "click", 4, "ngIf"], ["class", "ion-text-center", "size", "4", 4, "ngIf"], [1, "ion-text-end", "ion-padding-start", 3, "size"], ["class", "core-navigation-bar-arrow", 3, "click", 4, "ngIf"], ["fill", "outline", 1, "core-navigation-bar-arrow", 3, "click"], ["name", "fas-arrow-left", "aria-hidden", "true", 3, "slot"], ["aria-hidden", "true", 3, "text", "component", "componentId", "contextLevel", "contextInstanceId", "courseId", 4, "ngIf"], ["aria-hidden", "true", 3, "text", "component", "componentId", "contextLevel", "contextInstanceId", "courseId"], ["size", "4", 1, "ion-text-center"], ["fill", "clear", 3, "click"], ["slot", "icon-only", "name", "fas-info-circle", "aria-hidden", "true"], [1, "core-navigation-bar-arrow", 3, "click"], ["name", "fas-arrow-right", "aria-hidden", "true", 3, "slot"]], template: function CoreNavigationBarComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵtemplate */ "nd"](0, CoreNavigationBarComponent_ion_grid_0_Template, 7, 5, "ion-grid", 0);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.previous || ctx.info || ctx.next);
            }
        }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_2__[/* NgIf */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonGrid */ "A"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonRow */ "gb"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonCol */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonButton */ "k"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonIcon */ "C"], _directives_fa_icon__WEBPACK_IMPORTED_MODULE_4__[/* CoreFaIconDirective */ "a"], _directives_format_text__WEBPACK_IMPORTED_MODULE_5__[/* CoreFormatTextDirective */ "a"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__[/* TranslatePipe */ "d"]], styles: [".core-navigation-bar-arrow[_ngcontent-%COMP%]{text-transform:none;max-width:100%}.core-navigation-bar-arrow[_ngcontent-%COMP%]   ion-icon[_ngcontent-%COMP%]{flex-shrink:0}"] });
    return CoreNavigationBarComponent;
})();


/***/ }),

/***/ "/K1O":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreLocalFileComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fXoL");
/* harmony import */ var _services_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("EmGO");
/* harmony import */ var _services_file_helper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("L2dF");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_mimetype__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("vbeB");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("vuGA");
/* harmony import */ var _services_utils_time__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("Q98t");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons_form__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("4reR");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("nvXB");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("3Pt+");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("TEn/");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("ofXK");
/* harmony import */ var _directives_auto_focus__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("6uVz");
/* harmony import */ var _directives_fa_icon__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("3CSS");
/* harmony import */ var _directives_supress_events__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("ArDJ");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__("sYmb");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



















const _c0 = ["nameForm"];
function CoreLocalFileComponent_p_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "p", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate */ "qd"](ctx_r1.fileName);
    }
}
function CoreLocalFileComponent_p_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate */ "qd"](ctx_r2.size);
    }
}
function CoreLocalFileComponent_p_8_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate */ "qd"](ctx_r3.timemodified);
    }
}
function CoreLocalFileComponent_ion_input_9_Template(rf, ctx) {
    if (rf & 1) {
        const _r8 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-input", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreLocalFileComponent_ion_input_9_Template_ion_input_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r8); return $event.stopPropagation(); })("ngModelChange", function CoreLocalFileComponent_ion_input_9_Template_ion_input_ngModelChange_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r8); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](); return ctx_r9.newFileName = $event; });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("placeholder", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](1, 2, "core.filename"))("ngModel", ctx_r4.newFileName);
    }
}
function CoreLocalFileComponent_ion_button_11_Template(rf, ctx) {
    if (rf & 1) {
        const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreLocalFileComponent_ion_button_11_Template_ion_button_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](); return ctx_r10.openFile($event, true); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](2, "ion-icon", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](1, 2, ctx_r5.openButtonLabel));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("name", ctx_r5.openButtonIcon);
    }
}
function CoreLocalFileComponent_ng_container_12_ion_button_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("onClick", function CoreLocalFileComponent_ng_container_12_ion_button_1_Template_ion_button_onClick_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2); return ctx_r14.activateEdit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](2, "ion-icon", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "core.edit"));
    }
}
function CoreLocalFileComponent_ng_container_12_ion_button_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](2, "ion-icon", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "core.save"));
    }
}
function CoreLocalFileComponent_ng_container_12_Template(rf, ctx) {
    if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](1, CoreLocalFileComponent_ng_container_12_ion_button_1_Template, 3, 3, "ion-button", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](2, CoreLocalFileComponent_ng_container_12_ion_button_2_Template, 3, 3, "ion-button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](3, "ion-button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreLocalFileComponent_ng_container_12_Template_ion_button_click_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r17); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](); return ctx_r16.deleteFile($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](5, "ion-icon", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r6.editMode);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r6.editMode);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](4, 3, "core.delete"));
    }
}
/**
 * Component to handle a local file. Only files inside the app folder can be managed.
 *
 * Shows the file name, icon (depending on extension), size and time modified.
 * Also, if managing is enabled it will also show buttons to rename and delete the file.
 */
let CoreLocalFileComponent = /*@__PURE__*/ (() => {
    class CoreLocalFileComponent {
        constructor() {
            this.onDelete = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"](); // Will notify when the file is deleted.
            this.onRename = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"](); // Will notify when the file is renamed.
            this.onClick = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"](); // Will notify when the file is clicked. Only if overrideClick is true.
            this.newFileName = '';
            this.editMode = false;
            this.isIOS = false;
            this.openButtonIcon = '';
            this.openButtonLabel = '';
            this.defaultIsOpenWithPicker = false;
        }
        /**
         * Component being initialized.
         */
        ngOnInit() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                this.manage = _services_utils_utils__WEBPACK_IMPORTED_MODULE_9__[/* CoreUtils */ "a"].isTrueOrOne(this.manage);
                if (!this.file) {
                    return;
                }
                this.loadFileBasicData(this.file);
                // Get the size and timemodified.
                const metadata = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getMetadata(this.file);
                if (metadata.size >= 0) {
                    this.size = _services_utils_text__WEBPACK_IMPORTED_MODULE_7__[/* CoreTextUtils */ "a"].bytesToSize(metadata.size, 2);
                }
                this.timemodified = _services_utils_time__WEBPACK_IMPORTED_MODULE_8__[/* CoreTimeUtils */ "a"].userDate(metadata.modificationTime.getTime(), 'core.strftimedatetimeshort');
                this.isIOS = _services_app__WEBPACK_IMPORTED_MODULE_11__[/* CoreApp */ "a"].isIOS();
                this.defaultIsOpenWithPicker = _services_file_helper__WEBPACK_IMPORTED_MODULE_3__[/* CoreFileHelper */ "a"].defaultIsOpenWithPicker();
                this.openButtonIcon = this.defaultIsOpenWithPicker ? 'fas-file' : 'fas-share-square';
                this.openButtonLabel = this.defaultIsOpenWithPicker ? 'core.openfile' : 'core.openwith';
            });
        }
        /**
         * Load the basic data for the file.
         */
        loadFileBasicData(file) {
            this.fileName = file.name;
            this.fileIcon = _services_utils_mimetype__WEBPACK_IMPORTED_MODULE_6__[/* CoreMimetypeUtils */ "a"].getFileIcon(file.name);
            this.fileExtension = _services_utils_mimetype__WEBPACK_IMPORTED_MODULE_6__[/* CoreMimetypeUtils */ "a"].getFileExtension(file.name);
            // Let's calculate the relative path for the file.
            this.relativePath = _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].removeBasePath(file.toURL());
            if (!this.relativePath) {
                // Didn't find basePath, use fullPath but if the user tries to manage the file it'll probably fail.
                this.relativePath = file.fullPath;
            }
        }
        /**
         * Open file.
         *
         * @param e Click event.
         * @param isOpenButton Whether the open button was clicked.
         */
        openFile(e, isOpenButton = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.editMode) {
                    return;
                }
                e.preventDefault();
                e.stopPropagation();
                if (!isOpenButton && _services_utils_utils__WEBPACK_IMPORTED_MODULE_9__[/* CoreUtils */ "a"].isTrueOrOne(this.overrideClick) && this.onClick.observers.length) {
                    this.onClick.emit();
                    return;
                }
                if (!_services_file_helper__WEBPACK_IMPORTED_MODULE_3__[/* CoreFileHelper */ "a"].isOpenableInApp(this.file)) {
                    try {
                        yield _services_file_helper__WEBPACK_IMPORTED_MODULE_3__[/* CoreFileHelper */ "a"].showConfirmOpenUnsupportedFile();
                    }
                    catch (error) {
                        return; // Cancelled, stop.
                    }
                }
                const options = {};
                if (isOpenButton) {
                    // Use the non-default method.
                    options.iOSOpenFileAction = this.defaultIsOpenWithPicker ? _services_utils_utils__WEBPACK_IMPORTED_MODULE_9__[/* OpenFileAction */ "c"].OPEN : _services_utils_utils__WEBPACK_IMPORTED_MODULE_9__[/* OpenFileAction */ "c"].OPEN_WITH;
                }
                _services_utils_utils__WEBPACK_IMPORTED_MODULE_9__[/* CoreUtils */ "a"].openFile(this.file.toURL(), options);
            });
        }
        /**
         * Activate the edit mode.
         *
         * @param e Click event.
         */
        activateEdit(e) {
            e.preventDefault();
            e.stopPropagation();
            this.editMode = true;
            this.newFileName = this.file.name;
        }
        /**
         * Rename the file.
         *
         * @param newName New name.
         * @param e Click event.
         */
        changeName(newName, e) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                e.preventDefault();
                e.stopPropagation();
                if (newName == this.file.name) {
                    // Name hasn't changed, stop.
                    this.editMode = false;
                    _singletons_form__WEBPACK_IMPORTED_MODULE_10__[/* CoreForms */ "a"].triggerFormCancelledEvent(this.formElement, _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId());
                    return;
                }
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].showModalLoading();
                const fileAndDir = _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileAndDirectoryFromPath(this.relativePath);
                const newPath = _services_utils_text__WEBPACK_IMPORTED_MODULE_7__[/* CoreTextUtils */ "a"].concatenatePaths(fileAndDir.directory, newName);
                try {
                    // Check if there's a file with this name.
                    yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFile(newPath);
                    // There's a file with this name, show error and stop.
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].showErrorModal('core.errorfileexistssamename', true);
                }
                catch (_a) {
                    try {
                        // File doesn't exist, move it.
                        const fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].moveFile(this.relativePath, newPath);
                        _singletons_form__WEBPACK_IMPORTED_MODULE_10__[/* CoreForms */ "a"].triggerFormSubmittedEvent(this.formElement, false, _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId());
                        this.editMode = false;
                        this.file = fileEntry;
                        this.loadFileBasicData(this.file);
                        this.onRename.emit({ file: this.file });
                    }
                    catch (error) {
                        _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, 'core.errorrenamefile', true);
                    }
                }
                finally {
                    modal.dismiss();
                }
            });
        }
        /**
         * Delete the file.
         *
         * @param e Click event.
         */
        deleteFile(e) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                e.preventDefault();
                e.stopPropagation();
                let modal;
                try {
                    // Ask confirmation.
                    yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].showDeleteConfirm('core.confirmdeletefile');
                    modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].showModalLoading('core.deleting', true);
                    yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].removeFile(this.relativePath);
                    this.onDelete.emit();
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, 'core.errordeletefile', true);
                }
                finally {
                    modal === null || modal === void 0 ? void 0 : modal.dismiss();
                }
            });
        }
    }
    CoreLocalFileComponent.ɵfac = function CoreLocalFileComponent_Factory(t) { return new (t || CoreLocalFileComponent)(); };
    CoreLocalFileComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵdefineComponent */ "sc"]({ type: CoreLocalFileComponent, selectors: [["core-local-file"]], viewQuery: function CoreLocalFileComponent_Query(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵviewQuery */ "ud"](_c0, true);
            }
            if (rf & 2) {
                var _t;
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵqueryRefresh */ "ed"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵloadQuery */ "Nc"]()) && (ctx.formElement = _t.first);
            }
        }, inputs: { file: "file", manage: "manage", overrideClick: "overrideClick" }, outputs: { onDelete: "onDelete", onRename: "onRename", onClick: "onClick" }, decls: 13, vars: 8, consts: [[3, "ngSubmit"], ["nameForm", ""], ["button", "", "detail", "false", 1, "ion-text-wrap", "item-file", 3, "click"], ["slot", "start"], ["role", "presentation", 3, "src", "alt"], ["class", "item-heading", 4, "ngIf"], [4, "ngIf"], ["type", "text", "name", "filename", "autocapitalize", "none", "autocorrect", "off", "core-auto-focus", "", 3, "placeholder", "ngModel", "click", "ngModelChange", 4, "ngIf"], ["slot", "end", 1, "buttons"], ["fill", "clear", 3, "click", 4, "ngIf"], [1, "item-heading"], ["type", "text", "name", "filename", "autocapitalize", "none", "autocorrect", "off", "core-auto-focus", "", 3, "placeholder", "ngModel", "click", "ngModelChange"], ["fill", "clear", 3, "click"], ["slot", "icon-only", "aria-hidden", "true", 3, "name"], ["fill", "clear", "color", "dark", 3, "core-suppress-events", "onClick", 4, "ngIf"], ["fill", "clear", "color", "success", "type", "submit", 4, "ngIf"], ["fill", "clear", "color", "danger", 3, "click"], ["name", "fas-trash", "slot", "icon-only", "aria-hidden", "true"], ["fill", "clear", "color", "dark", 3, "core-suppress-events", "onClick"], ["name", "fas-pen", "slot", "icon-only", "aria-hidden", "true"], ["fill", "clear", "color", "success", "type", "submit"], ["name", "fas-check", "slot", "icon-only", "aria-hidden", "true"]], template: function CoreLocalFileComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "form", 0, 1);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("ngSubmit", function CoreLocalFileComponent_Template_form_ngSubmit_0_listener($event) { return ctx.changeName(ctx.newFileName, $event); });
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](2, "ion-item", 2);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreLocalFileComponent_Template_ion_item_click_2_listener($event) { return ctx.openFile($event); });
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](3, "ion-thumbnail", 3);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](4, "img", 4);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](5, "ion-label");
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](6, CoreLocalFileComponent_p_6_Template, 2, 1, "p", 5);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](7, CoreLocalFileComponent_p_7_Template, 2, 1, "p", 6);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](8, CoreLocalFileComponent_p_8_Template, 2, 1, "p", 6);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](9, CoreLocalFileComponent_ion_input_9_Template, 2, 4, "ion-input", 7);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](10, "div", 8);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](11, CoreLocalFileComponent_ion_button_11_Template, 3, 4, "ion-button", 9);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](12, CoreLocalFileComponent_ng_container_12_Template, 6, 5, "ng-container", 6);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](4);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("src", ctx.fileIcon, _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵsanitizeUrl */ "jd"])("alt", ctx.fileExtension);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx.editMode);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.size && !ctx.editMode);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.timemodified && !ctx.editMode);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.editMode);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.isIOS);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.manage);
            }
        }, directives: [_angular_forms__WEBPACK_IMPORTED_MODULE_12__[/* ɵangular_packages_forms_forms_y */ "H"], _angular_forms__WEBPACK_IMPORTED_MODULE_12__[/* NgControlStatusGroup */ "s"], _angular_forms__WEBPACK_IMPORTED_MODULE_12__[/* NgForm */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* IonItem */ "H"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* IonThumbnail */ "wb"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* IonLabel */ "N"], _angular_common__WEBPACK_IMPORTED_MODULE_14__[/* NgIf */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* IonInput */ "G"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* TextValueAccessor */ "Ob"], _directives_auto_focus__WEBPACK_IMPORTED_MODULE_15__[/* CoreAutoFocusDirective */ "a"], _angular_forms__WEBPACK_IMPORTED_MODULE_12__[/* NgControlStatus */ "r"], _angular_forms__WEBPACK_IMPORTED_MODULE_12__[/* NgModel */ "u"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* IonButton */ "k"], _ionic_angular__WEBPACK_IMPORTED_MODULE_13__[/* IonIcon */ "C"], _directives_fa_icon__WEBPACK_IMPORTED_MODULE_16__[/* CoreFaIconDirective */ "a"], _directives_supress_events__WEBPACK_IMPORTED_MODULE_17__[/* CoreSupressEventsDirective */ "a"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_18__[/* TranslatePipe */ "d"]], encapsulation: 2 });
    return CoreLocalFileComponent;
})();


/***/ }),

/***/ "/LWs":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CORE_FILTER_SERVICES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreFilterModule; });
/* harmony import */ var _services_filter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("tS8V");
/* harmony import */ var _services_filter_delegate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Sp6y");
/* harmony import */ var _services_filter_helper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("D2MD");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





const CORE_FILTER_SERVICES = [
    _services_filter__WEBPACK_IMPORTED_MODULE_0__[/* CoreFilterProvider */ "b"],
    _services_filter_delegate__WEBPACK_IMPORTED_MODULE_1__[/* CoreFilterDelegateService */ "b"],
    _services_filter_helper__WEBPACK_IMPORTED_MODULE_2__[/* CoreFilterHelperProvider */ "b"],
];
let CoreFilterModule = /*@__PURE__*/ (() => {
    class CoreFilterModule {
    }
    CoreFilterModule.ɵmod = _angular_core__WEBPACK_IMPORTED_MODULE_3__[/* ɵɵdefineNgModule */ "wc"]({ type: CoreFilterModule });
    CoreFilterModule.ɵinj = _angular_core__WEBPACK_IMPORTED_MODULE_3__[/* ɵɵdefineInjector */ "vc"]({ factory: function CoreFilterModule_Factory(t) { return new (t || CoreFilterModule)(); } });
    return CoreFilterModule;
})();


/***/ }),

/***/ "/LfI":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModChatModuleHandlerService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModChatModuleHandler; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("BaYo");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ULAo");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("pHTc");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _components_index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("e1dt");
/* harmony import */ var _chat__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("g4DX");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Handler to support chat modules.
 */
let AddonModChatModuleHandlerService = /*@__PURE__*/ (() => {
    class AddonModChatModuleHandlerService {
        constructor() {
            this.name = 'AddonModChat';
            this.modName = 'chat';
            this.supportedFeatures = {
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GROUPS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GROUPINGS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_MOD_INTRO]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_COMPLETION_TRACKS_VIEWS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GRADE_HAS_GRADE]: false,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GRADE_OUTCOMES]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_BACKUP_MOODLE2]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_SHOW_DESCRIPTION]: true,
            };
        }
        /**
         * @inheritdoc
         */
        isEnabled() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return true;
            });
        }
        /**
         * @inheritdoc
         */
        getData(module) {
            const data = {
                icon: _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourse */ "a"].getModuleIconSrc(this.modName, 'modicon' in module ? module.modicon : undefined),
                title: module.name,
                class: 'addon-mod_chat-handler',
                action(event, module, courseId, options) {
                    options = options || {};
                    options.params = options.params || {};
                    Object.assign(options.params, { module });
                    const routeParams = '/' + courseId + '/' + module.id;
                    _services_navigator__WEBPACK_IMPORTED_MODULE_3__[/* CoreNavigator */ "a"].navigateToSitePath(AddonModChatModuleHandlerService.PAGE_NAME + routeParams, options);
                },
            };
            this.checkDownloadButton(data);
            return data;
        }
        /**
         * Check whether download button should be displayed.
         *
         * @param data Handler data.
         */
        checkDownloadButton(data) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                data.showDownloadButton = yield _chat__WEBPACK_IMPORTED_MODULE_6__[/* AddonModChat */ "a"].areSessionsAvailable();
            });
        }
        /**
         * @inheritdoc
         */
        getMainComponent() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return _components_index__WEBPACK_IMPORTED_MODULE_5__[/* AddonModChatIndexComponent */ "a"];
            });
        }
    }
    AddonModChatModuleHandlerService.PAGE_NAME = 'mod_chat';
    AddonModChatModuleHandlerService.ɵfac = function AddonModChatModuleHandlerService_Factory(t) { return new (t || AddonModChatModuleHandlerService)(); };
    AddonModChatModuleHandlerService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModChatModuleHandlerService, factory: AddonModChatModuleHandlerService.ɵfac, providedIn: 'root' });
    return AddonModChatModuleHandlerService;
})();
const AddonModChatModuleHandler = Object(_singletons__WEBPACK_IMPORTED_MODULE_4__[/* makeSingleton */ "P"])(AddonModChatModuleHandlerService);


/***/ }),

/***/ "/X5v":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Pseudo [x-pseudo]
//! author : Andrew Hood : https://github.com/andrewhood125

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var xPseudo = moment.defineLocale('x-pseudo', {
        months: 'J~áñúá~rý_F~ébrú~árý_~Márc~h_Áp~ríl_~Máý_~Júñé~_Júl~ý_Áú~gúst~_Sép~témb~ér_Ó~ctób~ér_Ñ~óvém~bér_~Décé~mbér'.split(
            '_'
        ),
        monthsShort: 'J~áñ_~Féb_~Már_~Ápr_~Máý_~Júñ_~Júl_~Áúg_~Sép_~Óct_~Ñóv_~Déc'.split(
            '_'
        ),
        monthsParseExact: true,
        weekdays: 'S~úñdá~ý_Mó~ñdáý~_Túé~sdáý~_Wéd~ñésd~áý_T~húrs~dáý_~Fríd~áý_S~átúr~dáý'.split(
            '_'
        ),
        weekdaysShort: 'S~úñ_~Móñ_~Túé_~Wéd_~Thú_~Frí_~Sát'.split('_'),
        weekdaysMin: 'S~ú_Mó~_Tú_~Wé_T~h_Fr~_Sá'.split('_'),
        weekdaysParseExact: true,
        longDateFormat: {
            LT: 'HH:mm',
            L: 'DD/MM/YYYY',
            LL: 'D MMMM YYYY',
            LLL: 'D MMMM YYYY HH:mm',
            LLLL: 'dddd, D MMMM YYYY HH:mm',
        },
        calendar: {
            sameDay: '[T~ódá~ý át] LT',
            nextDay: '[T~ómó~rró~w át] LT',
            nextWeek: 'dddd [át] LT',
            lastDay: '[Ý~ést~érdá~ý át] LT',
            lastWeek: '[L~ást] dddd [át] LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: 'í~ñ %s',
            past: '%s á~gó',
            s: 'á ~féw ~sécó~ñds',
            ss: '%d s~écóñ~ds',
            m: 'á ~míñ~úté',
            mm: '%d m~íñú~tés',
            h: 'á~ñ hó~úr',
            hh: '%d h~óúrs',
            d: 'á ~dáý',
            dd: '%d d~áýs',
            M: 'á ~móñ~th',
            MM: '%d m~óñt~hs',
            y: 'á ~ýéár',
            yy: '%d ý~éárs',
        },
        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
        ordinal: function (number) {
            var b = number % 10,
                output =
                    ~~((number % 100) / 10) === 1
                        ? 'th'
                        : b === 1
                        ? 'st'
                        : b === 2
                        ? 'nd'
                        : b === 3
                        ? 'rd'
                        : 'th';
            return number + output;
        },
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 4, // The week that contains Jan 4th is the first week of the year.
        },
    });

    return xPseudo;

})));


/***/ }),

/***/ "/sJY":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return MediaCapture; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _ionic_native_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("C6fG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");




var MediaCapture = /** @class */ /*@__PURE__*/ (function (_super) {
    Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __extends */ "b"])(MediaCapture, _super);
    function MediaCapture() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MediaCapture.prototype.captureAudio = function (options) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "captureAudio", { "callbackOrder": "reverse" }, arguments); };
    MediaCapture.prototype.captureImage = function (options) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "captureImage", { "callbackOrder": "reverse" }, arguments); };
    MediaCapture.prototype.captureVideo = function (options) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "captureVideo", { "callbackOrder": "reverse" }, arguments); };
    MediaCapture.prototype.onPendingCaptureResult = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "onPendingCaptureResult", { "eventObservable": true, "event": "pendingcaptureresult" }, arguments); };
    MediaCapture.prototype.onPendingCaptureError = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "onPendingCaptureError", { "eventObservable": true, "event": "pendingcaptureerror" }, arguments); };
    Object.defineProperty(MediaCapture.prototype, "supportedImageModes", {
        get: function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordovaPropertyGet */ "e"])(this, "supportedImageModes"); },
        set: function (value) { Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordovaPropertySet */ "f"])(this, "supportedImageModes", value); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MediaCapture.prototype, "supportedAudioModes", {
        get: function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordovaPropertyGet */ "e"])(this, "supportedAudioModes"); },
        set: function (value) { Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordovaPropertySet */ "f"])(this, "supportedAudioModes", value); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MediaCapture.prototype, "supportedVideoModes", {
        get: function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordovaPropertyGet */ "e"])(this, "supportedVideoModes"); },
        set: function (value) { Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordovaPropertySet */ "f"])(this, "supportedVideoModes", value); },
        enumerable: false,
        configurable: true
    });
    MediaCapture.pluginName = "MediaCapture";
    MediaCapture.plugin = "cordova-plugin-media-capture";
    MediaCapture.pluginRef = "navigator.device.capture";
    MediaCapture.repo = "https://github.com/apache/cordova-plugin-media-capture";
    MediaCapture.platforms = ["Android", "Browser", "iOS", "Windows"];
    MediaCapture.ɵfac = function MediaCapture_Factory(t) { return ɵMediaCapture_BaseFactory(t || MediaCapture); };
    MediaCapture.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineInjectable */ "uc"]({ token: MediaCapture, factory: function (t) { return MediaCapture.ɵfac(t); } });
    var ɵMediaCapture_BaseFactory = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵgetInheritedFactory */ "Gc"](MediaCapture);
    return MediaCapture;
}(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* IonicNativePlugin */ "a"]));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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


/***/ }),

/***/ "/spA":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModUrlHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModUrlHelper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _features_contentlinks_services_contentlinks_helper__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("vnm2");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3LXp");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Service that provides helper functions for urls.
 */
let AddonModUrlHelperProvider = /*@__PURE__*/ (() => {
    class AddonModUrlHelperProvider {
        /**
         * Opens a URL.
         *
         * @param url The URL to go to.
         */
        open(url) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showModalLoading();
                try {
                    const treated = yield _features_contentlinks_services_contentlinks_helper__WEBPACK_IMPORTED_MODULE_1__[/* CoreContentLinksHelper */ "a"].handleLink(url, undefined, true, true);
                    if (!treated) {
                        yield ((_a = _services_sites__WEBPACK_IMPORTED_MODULE_2__[/* CoreSites */ "b"].getCurrentSite()) === null || _a === void 0 ? void 0 : _a.openInBrowserWithAutoLoginIfSameSite(url));
                    }
                }
                finally {
                    modal.dismiss();
                }
            });
        }
    }
    AddonModUrlHelperProvider.ɵfac = function AddonModUrlHelperProvider_Factory(t) { return new (t || AddonModUrlHelperProvider)(); };
    AddonModUrlHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_5__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModUrlHelperProvider, factory: AddonModUrlHelperProvider.ɵfac, providedIn: 'root' });
    return AddonModUrlHelperProvider;
})();
const AddonModUrlHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_4__[/* makeSingleton */ "P"])(AddonModUrlHelperProvider);


/***/ }),

/***/ "/uUt":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return distinctUntilChanged; });
/* harmony import */ var _Subscriber__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("7o/Q");

function distinctUntilChanged(compare, keySelector) {
    return (source) => source.lift(new DistinctUntilChangedOperator(compare, keySelector));
}
class DistinctUntilChangedOperator {
    constructor(compare, keySelector) {
        this.compare = compare;
        this.keySelector = keySelector;
    }
    call(subscriber, source) {
        return source.subscribe(new DistinctUntilChangedSubscriber(subscriber, this.compare, this.keySelector));
    }
}
class DistinctUntilChangedSubscriber extends _Subscriber__WEBPACK_IMPORTED_MODULE_0__[/* Subscriber */ "a"] {
    constructor(destination, compare, keySelector) {
        super(destination);
        this.keySelector = keySelector;
        this.hasKey = false;
        if (typeof compare === 'function') {
            this.compare = compare;
        }
    }
    compare(x, y) {
        return x === y;
    }
    _next(value) {
        let key;
        try {
            const { keySelector } = this;
            key = keySelector ? keySelector(value) : value;
        }
        catch (err) {
            return this.destination.error(err);
        }
        let result = false;
        if (this.hasKey) {
            try {
                const { compare } = this;
                result = compare(this.key, key);
            }
            catch (err) {
                return this.destination.error(err);
            }
        }
        else {
            this.hasKey = true;
        }
        if (!result) {
            this.key = key;
            this.destination.next(value);
        }
    }
}
//# sourceMappingURL=distinctUntilChanged.js.map


/***/ }),

/***/ "/wc7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreSharedFilesHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSharedFilesHelper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("n9nU");
/* harmony import */ var _features_fileuploader_services_fileuploader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("hSQQ");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("nvXB");
/* harmony import */ var _services_file__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("EmGO");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("pHTc");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("3LXp");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("j3ag");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("fjkH");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("3j9v");
/* harmony import */ var _components_list_modal_list_modal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("jQTp");
/* harmony import */ var _sharedfiles__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("mWPv");
/* harmony import */ var _sharedfiles_module__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("0Gfa");
/* harmony import */ var _pages_choose_site_choose_site__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("5Ol/");
/* harmony import */ var _classes_errors_error__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("93ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

















/**
 * Helper service to share files with the app.
 */
let CoreSharedFilesHelperProvider = /*@__PURE__*/ (() => {
    class CoreSharedFilesHelperProvider {
        constructor() {
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_10__[/* CoreLogger */ "a"].getInstance('CoreSharedFilesHelperProvider');
        }
        /**
         * Initialize.
         */
        initialize() {
            if (!_services_app__WEBPACK_IMPORTED_MODULE_3__[/* CoreApp */ "a"].isIOS()) {
                return;
            }
            let lastCheck = Date.now();
            // Check if there are new files at app start and when the app is resumed.
            this.searchIOSNewSharedFiles();
            _singletons__WEBPACK_IMPORTED_MODULE_8__[/* Platform */ "C"].resume.subscribe(() => {
                // Wait a bit to make sure that APP_LAUNCHED_URL is treated before this callback.
                setTimeout(() => {
                    if (Date.now() - lastCheck < 1000) {
                        // Last check less than 1s ago, don't do anything.
                        return;
                    }
                    lastCheck = Date.now();
                    this.searchIOSNewSharedFiles();
                }, 200);
            });
            _singletons_events__WEBPACK_IMPORTED_MODULE_9__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_9__[/* CoreEvents */ "b"].APP_LAUNCHED_URL, (data) => {
                if (data.url.indexOf('file://') === 0) {
                    // We received a file in iOS, it's probably a shared file. Treat it.
                    lastCheck = Date.now();
                    this.searchIOSNewSharedFiles(data.url);
                }
            });
        }
        /**
         * Ask a user if he wants to replace a file (using originalName) or rename it (using newName).
         *
         * @param originalName Original name.
         * @param newName New name.
         * @return Promise resolved with the name to use when the user chooses. Rejected if user cancels.
         */
        askRenameReplace(originalName, newName) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const alert = yield _singletons__WEBPACK_IMPORTED_MODULE_8__[/* AlertController */ "b"].create({
                    header: _singletons__WEBPACK_IMPORTED_MODULE_8__[/* Translate */ "L"].instant('core.sharedfiles.sharedfiles'),
                    message: _singletons__WEBPACK_IMPORTED_MODULE_8__[/* Translate */ "L"].instant('core.sharedfiles.chooseactionrepeatedfile', { $a: newName }),
                    buttons: [
                        {
                            text: _singletons__WEBPACK_IMPORTED_MODULE_8__[/* Translate */ "L"].instant('core.sharedfiles.rename'),
                            role: 'rename',
                        },
                        {
                            text: _singletons__WEBPACK_IMPORTED_MODULE_8__[/* Translate */ "L"].instant('core.sharedfiles.replace'),
                            role: 'replace',
                        },
                    ],
                });
                yield alert.present();
                const result = yield alert.onDidDismiss();
                if (result.role == 'rename') {
                    return newName;
                }
                else if (result.role == 'replace') {
                    return originalName;
                }
                else {
                    // Canceled.
                    throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__[/* CoreCanceledError */ "a"]();
                }
            });
        }
        /**
         * Go to the choose site view.
         *
         * @param filePath File path to send to the view.
         * @param isInbox Whether the file is in the Inbox folder.
         */
        goToChooseSite(filePath, isInbox) {
            if (_services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].isLoggedIn()) {
                _services_navigator__WEBPACK_IMPORTED_MODULE_5__[/* CoreNavigator */ "a"].navigateToSitePath(`/${_sharedfiles_module__WEBPACK_IMPORTED_MODULE_13__[/* SHAREDFILES_PAGE_NAME */ "c"]}/choosesite`, {
                    params: { filePath, isInbox },
                });
            }
            else {
                _services_navigator__WEBPACK_IMPORTED_MODULE_5__[/* CoreNavigator */ "a"].navigate(`/${_sharedfiles_module__WEBPACK_IMPORTED_MODULE_13__[/* SHAREDFILES_PAGE_NAME */ "c"]}/choosesite`, {
                    params: { filePath, isInbox },
                });
            }
        }
        /**
         * Whether the user is already choosing a site to store a shared file.
         *
         * @return Whether the user is already choosing a site to store a shared file.
         */
        isChoosingSite() {
            return _services_navigator__WEBPACK_IMPORTED_MODULE_5__[/* CoreNavigator */ "a"].getCurrentRoute({ pageComponent: _pages_choose_site_choose_site__WEBPACK_IMPORTED_MODULE_14__[/* CoreSharedFilesChooseSitePage */ "a"] }) !== null;
        }
        /**
         * Open the view to select a shared file.
         *
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @return Promise resolved when a file is picked, rejected if file picker is closed without selecting a file.
         */
        pickSharedFile(mimetypes) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const file = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_7__[/* CoreDomUtils */ "a"].openModal({
                    component: _components_list_modal_list_modal__WEBPACK_IMPORTED_MODULE_11__[/* CoreSharedFilesListModalComponent */ "a"],
                    cssClass: 'core-modal-fullscreen',
                    componentProps: { mimetypes, pick: true },
                });
                if (!file) {
                    // User cancelled.
                    throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__[/* CoreCanceledError */ "a"]();
                }
                const error = _features_fileuploader_services_fileuploader__WEBPACK_IMPORTED_MODULE_2__[/* CoreFileUploader */ "a"].isInvalidMimetype(mimetypes, file.fullPath);
                if (error) {
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_15__[/* CoreError */ "a"](error);
                }
                return {
                    path: file.fullPath,
                    treated: false,
                };
            });
        }
        /**
         * Delete a shared file.
         *
         * @param fileEntry The file entry to delete.
         * @param isInbox Whether the file is in the Inbox folder.
         * @return Promise resolved when done.
         */
        removeSharedFile(fileEntry, isInbox) {
            if (isInbox) {
                return _sharedfiles__WEBPACK_IMPORTED_MODULE_12__[/* CoreSharedFiles */ "a"].deleteInboxFile(fileEntry);
            }
            else {
                return _services_file__WEBPACK_IMPORTED_MODULE_4__[/* CoreFile */ "a"].removeFileByFileEntry(fileEntry);
            }
        }
        /**
         * Checks if there is a new file received in iOS and move it to the shared folder of current site.
         * If more than one site is found, the user will have to choose the site where to store it in.
         * If more than one file is found, treat only the first one.
         *
         * @param path Path to a file received when launching the app.
         * @return Promise resolved when done.
         */
        searchIOSNewSharedFiles(path) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                try {
                    yield _singletons__WEBPACK_IMPORTED_MODULE_8__[/* ApplicationInit */ "d"].donePromise;
                    if (this.isChoosingSite()) {
                        // We're already treating a shared file. Abort.
                        return;
                    }
                    let fileEntry;
                    if (path) {
                        // The app was launched with the path to the file, get the file.
                        fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_4__[/* CoreFile */ "a"].getExternalFile(path);
                    }
                    else {
                        // No path received, search if there is any file in the Inbox folder.
                        fileEntry = yield _sharedfiles__WEBPACK_IMPORTED_MODULE_12__[/* CoreSharedFiles */ "a"].checkIOSNewFiles();
                    }
                    if (!fileEntry) {
                        return;
                    }
                    const siteIds = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSitesIds();
                    if (!siteIds.length) {
                        // No sites stored, show error and delete the file.
                        _services_utils_dom__WEBPACK_IMPORTED_MODULE_7__[/* CoreDomUtils */ "a"].showErrorModal('core.sharedfiles.errorreceivefilenosites', true);
                        return this.removeSharedFile(fileEntry, !path);
                    }
                    else if (siteIds.length == 1) {
                        return this.storeSharedFileInSite(fileEntry, siteIds[0], !path);
                    }
                    else if (!this.isChoosingSite()) {
                        this.goToChooseSite(fileEntry.toURL(), !path);
                    }
                }
                catch (error) {
                    if (error) {
                        this.logger.error('Error searching iOS new shared files', error, path);
                    }
                }
            });
        }
        /**
         * Store a shared file in a site's shared files folder.
         *
         * @param fileEntry Shared file entry.
         * @param siteId Site ID. If not defined, current site.
         * @param isInbox Whether the file is in the Inbox folder.
         * @return Promise resolved when done.
         */
        storeSharedFileInSite(fileEntry, siteId, isInbox) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
                // First of all check if there's already a file with the same name in the shared files folder.
                const sharedFilesDirPath = _sharedfiles__WEBPACK_IMPORTED_MODULE_12__[/* CoreSharedFiles */ "a"].getSiteSharedFilesDirPath(siteId);
                let newName = yield _services_file__WEBPACK_IMPORTED_MODULE_4__[/* CoreFile */ "a"].getUniqueNameInFolder(sharedFilesDirPath, fileEntry.name);
                if (newName.toLowerCase() != fileEntry.name.toLowerCase()) {
                    // Repeated name. Ask the user what he wants to do.
                    newName = yield this.askRenameReplace(fileEntry.name, newName);
                }
                try {
                    yield _sharedfiles__WEBPACK_IMPORTED_MODULE_12__[/* CoreSharedFiles */ "a"].storeFileInSite(fileEntry, newName, siteId);
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_7__[/* CoreDomUtils */ "a"].showErrorModal(error || 'Error moving file.');
                }
                finally {
                    this.removeSharedFile(fileEntry, isInbox);
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_7__[/* CoreDomUtils */ "a"].showAlertTranslated('core.success', 'core.sharedfiles.successstorefile');
                }
            });
        }
    }
    CoreSharedFilesHelperProvider.ɵfac = function CoreSharedFilesHelperProvider_Factory(t) { return new (t || CoreSharedFilesHelperProvider)(); };
    CoreSharedFilesHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_16__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreSharedFilesHelperProvider, factory: CoreSharedFilesHelperProvider.ɵfac, providedIn: 'root' });
    return CoreSharedFilesHelperProvider;
})();
const CoreSharedFilesHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_8__[/* makeSingleton */ "P"])(CoreSharedFilesHelperProvider);


/***/ }),

/***/ 0:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__("zUnb");


/***/ }),

/***/ "039z":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreGradesMainMenuHandlerService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreGradesMainMenuHandler; });
/* harmony import */ var _features_grades_services_grades__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wo9T");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Handler to inject an option into main menu.
 */
let CoreGradesMainMenuHandlerService = /*@__PURE__*/ (() => {
    class CoreGradesMainMenuHandlerService {
        constructor() {
            this.name = 'CoreGrades';
            this.priority = 600;
        }
        /**
         * Check if the handler is enabled on a site level.
         *
         * @return Whether or not the handler is enabled on a site level.
         */
        isEnabled() {
            return _features_grades_services_grades__WEBPACK_IMPORTED_MODULE_0__[/* CoreGrades */ "a"].isCourseGradesEnabled();
        }
        /**
         * Returns the data needed to render the handler.
         *
         * @return Data needed to render the handler.
         */
        getDisplayData() {
            return {
                icon: 'fas-chart-bar',
                title: 'core.grades.grades',
                page: CoreGradesMainMenuHandlerService.PAGE_NAME,
                class: 'core-grades-coursesgrades-handler',
            };
        }
    }
    CoreGradesMainMenuHandlerService.PAGE_NAME = 'grades';
    CoreGradesMainMenuHandlerService.ɵfac = function CoreGradesMainMenuHandlerService_Factory(t) { return new (t || CoreGradesMainMenuHandlerService)(); };
    CoreGradesMainMenuHandlerService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreGradesMainMenuHandlerService, factory: CoreGradesMainMenuHandlerService.ɵfac, providedIn: 'root' });
    return CoreGradesMainMenuHandlerService;
})();
const CoreGradesMainMenuHandler = Object(_singletons__WEBPACK_IMPORTED_MODULE_1__[/* makeSingleton */ "P"])(CoreGradesMainMenuHandlerService);


/***/ }),

/***/ "03Vu":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreDelegate; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9+EE");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fjkH");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3j9v");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Superclass to help creating delegates
 */
class CoreDelegate {
    /**
     * Constructor of the Delegate.
     *
     * @param delegateName Delegate name used for logging purposes.
     * @param listenSiteEvents Whether to update the handler when a site event occurs (login, site updated, ...).
     */
    constructor(delegateName, listenSiteEvents = true) {
        /**
         * List of registered handlers.
         */
        this.handlers = {};
        /**
         * List of registered handlers enabled for the current site.
         */
        this.enabledHandlers = {};
        /**
         * Time when last updateHandler functions started.
         */
        this.lastUpdateHandlersStart = 0;
        /**
         * Name of the property to be used to index the handlers. By default, the handler's name will be used.
         * If your delegate uses a Moodle component name to identify the handlers, please override this property.
         * E.g. CoreCourseModuleDelegate uses 'modName' to index the handlers.
         */
        this.handlerNameProperty = 'name';
        /**
         * Set of promises to update a handler, to prevent doing the same operation twice.
         */
        this.updatePromises = {};
        /**
         * Whether handlers have been initialized.
         */
        this.handlersInitialized = false;
        this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_3__[/* CoreLogger */ "a"].getInstance(delegateName);
        this.handlersInitPromise = new Promise((resolve) => {
            this.handlersInitResolve = resolve;
        });
        if (listenSiteEvents) {
            // Update handlers on this cases.
            _singletons_events__WEBPACK_IMPORTED_MODULE_2__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_2__[/* CoreEvents */ "b"].LOGIN, this.updateHandlers.bind(this));
            _singletons_events__WEBPACK_IMPORTED_MODULE_2__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_2__[/* CoreEvents */ "b"].SITE_UPDATED, this.updateHandlers.bind(this));
            _singletons_events__WEBPACK_IMPORTED_MODULE_2__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_2__[/* CoreEvents */ "b"].SITE_PLUGINS_LOADED, this.updateHandlers.bind(this));
        }
    }
    /**
     * Execute a certain function in a enabled handler.
     * If the handler isn't found or function isn't defined, call the same function in the default handler.
     *
     * @param handlerName The handler name.
     * @param fnName Name of the function to execute.
     * @param params Parameters to pass to the function.
     * @return Function returned value or default value.
     */
    executeFunctionOnEnabled(handlerName, fnName, params) {
        return this.execute(this.enabledHandlers[handlerName], fnName, params);
    }
    /**
     * Execute a certain function in a handler.
     * If the handler isn't found or function isn't defined, call the same function in the default handler.
     *
     * @param handlerName The handler name.
     * @param fnName Name of the function to execute.
     * @param params Parameters to pass to the function.
     * @return Function returned value or default value.
     */
    executeFunction(handlerName, fnName, params) {
        return this.execute(this.handlers[handlerName], fnName, params);
    }
    /**
     * Execute a certain function in a handler.
     * If the handler isn't found or function isn't defined, call the same function in the default handler.
     *
     * @param handler The handler.
     * @param fnName Name of the function to execute.
     * @param params Parameters to pass to the function.
     * @return Function returned value or default value.
     */
    execute(handler, fnName, params) {
        if (handler && handler[fnName]) {
            return handler[fnName].apply(handler, params);
        }
        else if (this.defaultHandler && this.defaultHandler[fnName]) {
            return this.defaultHandler[fnName].apply(this.defaultHandler, params);
        }
    }
    /**
     * Get a handler.
     *
     * @param handlerName The handler name.
     * @param enabled Only enabled, or any.
     * @return Handler.
     */
    getHandler(handlerName, enabled = false) {
        return enabled ? this.enabledHandlers[handlerName] : this.handlers[handlerName];
    }
    /**
     * Gets the handler full name for a given name. This is useful when the handlerNameProperty is different than "name".
     * E.g. blocks are indexed by blockName. If you call this function passing the blockName it will return the name.
     *
     * @param name Name used to indentify the handler.
     * @return Full name of corresponding handler.
     */
    getHandlerName(name) {
        const handler = this.getHandler(name, true);
        if (!handler) {
            return '';
        }
        return handler.name;
    }
    /**
     * Check if function exists on a handler.
     *
     * @param handlerName The handler name.
     * @param fnName Name of the function to execute.
     * @param onlyEnabled If check only enabled handlers or all.
     * @return Function returned value or default value.
     */
    hasFunction(handlerName, fnName, onlyEnabled = true) {
        const handler = onlyEnabled ? this.enabledHandlers[handlerName] : this.handlers[handlerName];
        return handler && typeof handler[fnName] == 'function';
    }
    /**
     * Check if a handler name has a registered handler (not necessarily enabled).
     *
     * @param name The handler name.
     * @param enabled Only enabled, or any.
     * @return If the handler is registered or not.
     */
    hasHandler(name, enabled = false) {
        return enabled ? typeof this.enabledHandlers[name] !== 'undefined' : typeof this.handlers[name] !== 'undefined';
    }
    /**
     * Check if a time belongs to the last update handlers call.
     * This is to handle the cases where updateHandlers don't finish in the same order as they're called.
     *
     * @param time Time to check.
     * @return Whether it's the last call.
     */
    isLastUpdateCall(time) {
        if (!this.lastUpdateHandlersStart) {
            return true;
        }
        return time == this.lastUpdateHandlersStart;
    }
    /**
     * Register a handler.
     *
     * @param handler The handler delegate object to register.
     * @return True when registered, false if already registered.
     */
    registerHandler(handler) {
        const key = handler[this.handlerNameProperty] || handler.name;
        if (typeof this.handlers[key] !== 'undefined') {
            this.logger.log(`Handler '${handler[this.handlerNameProperty]}' already registered`);
            return false;
        }
        this.logger.log(`Registered handler '${handler[this.handlerNameProperty]}'`);
        this.handlers[key] = handler;
        return true;
    }
    /**
     * Update the handler for the current site.
     *
     * @param handler The handler to check.
     * @param time Time this update process started.
     * @return Resolved when done.
     */
    updateHandler(handler) {
        const siteId = _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getCurrentSiteId();
        const currentSite = _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getCurrentSite();
        let promise;
        if (this.updatePromises[siteId] && this.updatePromises[siteId][handler.name]) {
            // There's already an update ongoing for this handler, return the promise.
            return this.updatePromises[siteId][handler.name];
        }
        else if (!this.updatePromises[siteId]) {
            this.updatePromises[siteId] = {};
        }
        if (!_services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].isLoggedIn() || this.isFeatureDisabled(handler, currentSite)) {
            promise = Promise.resolve(false);
        }
        else {
            promise = Promise.resolve(handler.isEnabled()).catch(() => false);
        }
        // Checks if the handler is enabled.
        this.updatePromises[siteId][handler.name] = promise.then((enabled) => {
            // Check that site hasn't changed since the check started.
            if (_services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getCurrentSiteId() === siteId) {
                const key = handler[this.handlerNameProperty] || handler.name;
                if (enabled) {
                    this.enabledHandlers[key] = handler;
                }
                else {
                    delete this.enabledHandlers[key];
                }
            }
            return;
        }).finally(() => {
            // Update finished, delete the promise.
            delete this.updatePromises[siteId][handler.name];
        });
        return this.updatePromises[siteId][handler.name];
    }
    /**
     * Check if feature is enabled or disabled in the site, depending on the feature prefix and the handler name.
     *
     * @param handler Handler to check.
     * @param site Site to check.
     * @return Whether is enabled or disabled in site.
     */
    isFeatureDisabled(handler, site) {
        return typeof this.featurePrefix != 'undefined' && site.isFeatureDisabled(this.featurePrefix + handler.name);
    }
    /**
     * Update the handlers for the current site.
     *
     * @return Resolved when done.
     */
    updateHandlers() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
            const promises = [];
            const now = Date.now();
            this.logger.debug('Updating handlers for current site.');
            this.lastUpdateHandlersStart = now;
            // Loop over all the handlers.
            for (const name in this.handlers) {
                promises.push(this.updateHandler(this.handlers[name]));
            }
            try {
                yield Promise.all(promises);
            }
            catch (e) {
                // Never reject
            }
            // Verify that this call is the last one that was started.
            if (this.isLastUpdateCall(now)) {
                this.handlersInitialized = true;
                this.handlersInitResolve();
                this.updateData();
            }
        });
    }
    /**
     * Update handlers Data.
     * Override this function to update handlers data.
     */
    updateData() {
        // To be overridden.
    }
}


/***/ }),

/***/ "0EUg":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return concatAll; });
/* harmony import */ var _mergeAll__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bHdf");

function concatAll() {
    return Object(_mergeAll__WEBPACK_IMPORTED_MODULE_0__[/* mergeAll */ "a"])(1);
}
//# sourceMappingURL=concatAll.js.map


/***/ }),

/***/ "0Gfa":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ CORE_SHAREDFILES_SERVICES; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* binding */ SHAREDFILES_PAGE_NAME; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ sharedfiles_module_CoreSharedFilesModule; });

// EXTERNAL MODULE: ./node_modules/tslib/tslib.es6.js
var tslib_es6 = __webpack_require__("mrSG");

// EXTERNAL MODULE: ./src/app/app-routing.module.ts
var app_routing_module = __webpack_require__("vY5A");

// EXTERNAL MODULE: ./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js + 4 modules
var core = __webpack_require__("fXoL");

// EXTERNAL MODULE: ./src/core/features/fileuploader/services/fileuploader-delegate.ts
var fileuploader_delegate = __webpack_require__("2oRL");

// EXTERNAL MODULE: ./src/core/features/mainmenu/mainmenu-tab-routing.module.ts
var mainmenu_tab_routing_module = __webpack_require__("wG2S");

// EXTERNAL MODULE: ./src/core/features/settings/pages/site/site-routing.ts
var site_routing = __webpack_require__("X9cG");

// EXTERNAL MODULE: ./src/core/features/settings/services/settings-delegate.ts
var settings_delegate = __webpack_require__("YEzr");

// EXTERNAL MODULE: ./src/core/features/sharedfiles/components/components.module.ts
var components_module = __webpack_require__("x1oG");

// EXTERNAL MODULE: ./src/core/services/app.ts + 1 modules
var app = __webpack_require__("nvXB");

// EXTERNAL MODULE: ./src/core/singletons/index.ts
var singletons = __webpack_require__("j3ag");

// CONCATENATED MODULE: ./src/core/features/sharedfiles/services/handlers/settings.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Shared files settings handler.
 */
let settings_CoreSharedFilesSettingsHandlerService = /*@__PURE__*/ (() => {
    class CoreSharedFilesSettingsHandlerService {
        constructor() {
            this.name = 'CoreSharedFiles';
            this.priority = 200;
        }
        /**
         * Check if the handler is enabled on a site level.
         *
         * @return Whether or not the handler is enabled on a site level.
         */
        isEnabled() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                return app["a" /* CoreApp */].isIOS();
            });
        }
        /**
         * Returns the data needed to render the handler.
         *
         * @return Data needed to render the handler.
         */
        getDisplayData() {
            return {
                icon: 'fas-folder',
                title: 'core.sharedfiles.sharedfiles',
                page: SHAREDFILES_PAGE_NAME + '/list/root',
                params: { manage: true, hideSitePicker: true },
                class: 'core-sharedfiles-settings-handler',
            };
        }
    }
    CoreSharedFilesSettingsHandlerService.ɵfac = function CoreSharedFilesSettingsHandlerService_Factory(t) { return new (t || CoreSharedFilesSettingsHandlerService)(); };
    CoreSharedFilesSettingsHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: CoreSharedFilesSettingsHandlerService, factory: CoreSharedFilesSettingsHandlerService.ɵfac, providedIn: 'root' });
    return CoreSharedFilesSettingsHandlerService;
})();
const CoreSharedFilesSettingsHandler = Object(singletons["P" /* makeSingleton */])(settings_CoreSharedFilesSettingsHandlerService);

// EXTERNAL MODULE: ./src/core/features/sharedfiles/services/sharedfiles-helper.ts
var sharedfiles_helper = __webpack_require__("/wc7");

// CONCATENATED MODULE: ./src/core/features/sharedfiles/services/handlers/upload.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Handler to upload files from the album.
 */
let upload_CoreSharedFilesUploadHandlerService = /*@__PURE__*/ (() => {
    class CoreSharedFilesUploadHandlerService {
        constructor() {
            this.name = 'CoreSharedFilesUpload';
            this.priority = 1300;
        }
        /**
         * Whether or not the handler is enabled on a site level.
         *
         * @return True or promise resolved with true if enabled.
         */
        isEnabled() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                return app["a" /* CoreApp */].isIOS();
            });
        }
        /**
         * Given a list of mimetypes, return the ones that are supported by the handler.
         *
         * @param mimetypes List of mimetypes.
         * @return Supported mimetypes.
         */
        getSupportedMimetypes(mimetypes) {
            return mimetypes;
        }
        /**
         * Get the data to display the handler.
         *
         * @return Data.
         */
        getData() {
            return {
                title: 'core.sharedfiles.sharedfiles',
                class: 'core-sharedfiles-fileuploader-handler',
                icon: 'folder',
                action: (maxSize, upload, allowOffline, mimetypes) => sharedfiles_helper["a" /* CoreSharedFilesHelper */].pickSharedFile(mimetypes),
            };
        }
    }
    CoreSharedFilesUploadHandlerService.ɵfac = function CoreSharedFilesUploadHandlerService_Factory(t) { return new (t || CoreSharedFilesUploadHandlerService)(); };
    CoreSharedFilesUploadHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: CoreSharedFilesUploadHandlerService, factory: CoreSharedFilesUploadHandlerService.ɵfac, providedIn: 'root' });
    return CoreSharedFilesUploadHandlerService;
})();
const CoreSharedFilesUploadHandler = Object(singletons["P" /* makeSingleton */])(upload_CoreSharedFilesUploadHandlerService);

// EXTERNAL MODULE: ./src/core/features/sharedfiles/services/sharedfiles.ts + 1 modules
var sharedfiles = __webpack_require__("mWPv");

// CONCATENATED MODULE: ./src/core/features/sharedfiles/sharedfiles.module.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.















const CORE_SHAREDFILES_SERVICES = [
    sharedfiles["b" /* CoreSharedFilesProvider */],
    sharedfiles_helper["b" /* CoreSharedFilesHelperProvider */],
];
const SHAREDFILES_PAGE_NAME = 'sharedfiles';
const routes = [
    {
        path: SHAREDFILES_PAGE_NAME,
        loadChildren: () => __webpack_require__.e(/* import() */ 13).then(__webpack_require__.bind(null, "agZB")).then(m => m.CoreSharedFilesLazyModule),
    },
];
let sharedfiles_module_CoreSharedFilesModule = /*@__PURE__*/ (() => {
    class CoreSharedFilesModule {
    }
    CoreSharedFilesModule.ɵmod = core["wc" /* ɵɵdefineNgModule */]({ type: CoreSharedFilesModule });
    CoreSharedFilesModule.ɵinj = core["vc" /* ɵɵdefineInjector */]({ factory: function CoreSharedFilesModule_Factory(t) { return new (t || CoreSharedFilesModule)(); }, providers: [
            {
                provide: core["d" /* APP_INITIALIZER */],
                multi: true,
                useFactory: () => () => Object(tslib_es6["a" /* __awaiter */])(void 0, void 0, void 0, function* () {
                    fileuploader_delegate["a" /* CoreFileUploaderDelegate */].registerHandler(CoreSharedFilesUploadHandler.instance);
                    settings_delegate["a" /* CoreSettingsDelegate */].registerHandler(CoreSharedFilesSettingsHandler.instance);
                    sharedfiles_helper["a" /* CoreSharedFilesHelper */].initialize();
                    yield sharedfiles["a" /* CoreSharedFiles */].initializeDatabase();
                }),
            },
        ], imports: [[
                app_routing_module["a" /* AppRoutingModule */].forChild(routes),
                mainmenu_tab_routing_module["a" /* CoreMainMenuTabRoutingModule */].forChild(routes),
                site_routing["a" /* CoreSitePreferencesRoutingModule */].forChild(routes),
                components_module["a" /* CoreSharedFilesComponentsModule */],
            ]] });
    return CoreSharedFilesModule;
})();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && core["ld" /* ɵɵsetNgModuleScope */](sharedfiles_module_CoreSharedFilesModule, { imports: [app_routing_module["a" /* AppRoutingModule */], mainmenu_tab_routing_module["a" /* CoreMainMenuTabRoutingModule */], site_routing["a" /* CoreSitePreferencesRoutingModule */], components_module["a" /* CoreSharedFilesComponentsModule */]] }); })();


/***/ }),

/***/ "0Gvy":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModFeedbackModuleHandlerService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModFeedbackModuleHandler; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("BaYo");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ULAo");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("pHTc");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _feedback__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("MNPK");
/* harmony import */ var _components_index__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("hYz8");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Handler to support feedback modules.
 */
let AddonModFeedbackModuleHandlerService = /*@__PURE__*/ (() => {
    class AddonModFeedbackModuleHandlerService {
        constructor() {
            this.name = 'AddonModFeedback';
            this.modName = 'feedback';
            this.supportedFeatures = {
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GROUPS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GROUPINGS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_MOD_INTRO]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_COMPLETION_TRACKS_VIEWS]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_COMPLETION_HAS_RULES]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GRADE_HAS_GRADE]: false,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_GRADE_OUTCOMES]: false,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_BACKUP_MOODLE2]: true,
                [_core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].FEATURE_SHOW_DESCRIPTION]: true,
            };
        }
        /**
         * @inheritdoc
         */
        isEnabled() {
            return _feedback__WEBPACK_IMPORTED_MODULE_5__[/* AddonModFeedback */ "a"].isPluginEnabled();
        }
        /**
         * @inheritdoc
         */
        getData(module) {
            return {
                icon: _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourse */ "a"].getModuleIconSrc(this.modName, 'modicon' in module ? module.modicon : undefined),
                title: module.name,
                class: 'addon-mod_feedback-handler',
                showDownloadButton: true,
                action(event, module, courseId, options) {
                    options = options || {};
                    options.params = options.params || {};
                    Object.assign(options.params, { module });
                    const routeParams = '/' + courseId + '/' + module.id;
                    _services_navigator__WEBPACK_IMPORTED_MODULE_3__[/* CoreNavigator */ "a"].navigateToSitePath(AddonModFeedbackModuleHandlerService.PAGE_NAME + routeParams, options);
                },
            };
        }
        /**
         * @inheritdoc
         */
        getMainComponent() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return _components_index__WEBPACK_IMPORTED_MODULE_6__[/* AddonModFeedbackIndexComponent */ "a"];
            });
        }
    }
    AddonModFeedbackModuleHandlerService.PAGE_NAME = 'mod_feedback';
    AddonModFeedbackModuleHandlerService.ɵfac = function AddonModFeedbackModuleHandlerService_Factory(t) { return new (t || AddonModFeedbackModuleHandlerService)(); };
    AddonModFeedbackModuleHandlerService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModFeedbackModuleHandlerService, factory: AddonModFeedbackModuleHandlerService.ɵfac, providedIn: 'root' });
    return AddonModFeedbackModuleHandlerService;
})();
const AddonModFeedbackModuleHandler = Object(_singletons__WEBPACK_IMPORTED_MODULE_4__[/* makeSingleton */ "P"])(AddonModFeedbackModuleHandlerService);


/***/ }),

/***/ "0NpS":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreBlockHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreBlockHelper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("ULAo");
/* harmony import */ var _block_delegate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("6akD");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Service that provides helper functions for blocks.
 */
let CoreBlockHelperProvider = /*@__PURE__*/ (() => {
    class CoreBlockHelperProvider {
        /**
         * Return if it get course blocks options is enabled for the current site.
         *
         * @return true if enabled, false otherwise.
         */
        canGetCourseBlocks() {
            return _features_course_services_course__WEBPACK_IMPORTED_MODULE_1__[/* CoreCourse */ "a"].canGetCourseBlocks() && !_block_delegate__WEBPACK_IMPORTED_MODULE_2__[/* CoreBlockDelegate */ "a"].areBlocksDisabledInCourses();
        }
        /**
         * Returns the list of blocks for the selected course.
         *
         * @param courseId Course ID.
         * @return List of supported blocks.
         */
        getCourseBlocks(courseId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const canGetBlocks = this.canGetCourseBlocks();
                if (!canGetBlocks) {
                    return [];
                }
                const blocks = yield _features_course_services_course__WEBPACK_IMPORTED_MODULE_1__[/* CoreCourse */ "a"].getCourseBlocks(courseId);
                const hasSupportedBlock = _block_delegate__WEBPACK_IMPORTED_MODULE_2__[/* CoreBlockDelegate */ "a"].hasSupportedBlock(blocks);
                if (!hasSupportedBlock) {
                    return [];
                }
                return blocks;
            });
        }
    }
    CoreBlockHelperProvider.ɵfac = function CoreBlockHelperProvider_Factory(t) { return new (t || CoreBlockHelperProvider)(); };
    CoreBlockHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_4__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreBlockHelperProvider, factory: CoreBlockHelperProvider.ɵfac, providedIn: 'root' });
    return CoreBlockHelperProvider;
})();
const CoreBlockHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_3__[/* makeSingleton */ "P"])(CoreBlockHelperProvider);


/***/ }),

/***/ "0QZc":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreContextMenuPopoverComponent; });
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("BaYo");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("TEn/");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("ofXK");
/* harmony import */ var _directives_link__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("iSJP");
/* harmony import */ var _directives_format_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("hMzs");
/* harmony import */ var _directives_fa_icon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("3CSS");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("sYmb");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.










function CoreContextMenuPopoverComponent_ion_list_header_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-list-header");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate */ "qd"](ctx_r0.title);
    }
}
function CoreContextMenuPopoverComponent_ion_item_2_ion_icon_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 10);
    }
    if (rf & 2) {
        const item_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]().$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("name", item_r2.iconDescription);
    }
}
function CoreContextMenuPopoverComponent_ion_item_2_ion_icon_5_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 11);
    }
    if (rf & 2) {
        const item_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]().$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵclassProp */ "qc"]("icon-slash", item_r2.iconSlash);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("name", item_r2.iconAction);
    }
}
function CoreContextMenuPopoverComponent_ion_item_2_ion_spinner_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-spinner", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](1, "translate");
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "core.loading"));
    }
}
const _c0 = function (a0) { return { $a: a0 }; };
function CoreContextMenuPopoverComponent_ion_item_2_ion_badge_7_span_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "span", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const item_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"](2).$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind2 */ "Rc"](2, 1, item_r2.badgeA11yText, _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpureFunction1 */ "ad"](4, _c0, item_r2.badge)), " ");
    }
}
function CoreContextMenuPopoverComponent_ion_item_2_ion_badge_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-badge", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](1, "span");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](3, CoreContextMenuPopoverComponent_ion_item_2_ion_badge_7_span_3_Template, 3, 6, "span", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const item_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]().$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵclassMap */ "nc"](item_r2.badgeClass);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("ara-hidden", !!item_r2.badgeA11yText);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate */ "qd"](item_r2.badge);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", item_r2.badgeA11yText);
    }
}
function CoreContextMenuPopoverComponent_ion_item_2_Template(rf, ctx) {
    if (rf & 1) {
        const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵlistener */ "Mc"]("click", function CoreContextMenuPopoverComponent_ion_item_2_Template_ion_item_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵrestoreView */ "gd"](_r13); const item_r2 = ctx.$implicit; const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"](); return ctx_r12.itemClicked($event, item_r2); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](1, CoreContextMenuPopoverComponent_ion_item_2_ion_icon_1_Template, 1, 1, "ion-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](3, "p", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](4, "core-format-text", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](5, CoreContextMenuPopoverComponent_ion_item_2_ion_icon_5_Template, 1, 3, "ion-icon", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](6, CoreContextMenuPopoverComponent_ion_item_2_ion_spinner_6_Template, 2, 3, "ion-spinner", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](7, CoreContextMenuPopoverComponent_ion_item_2_ion_badge_7_Template, 4, 6, "ion-badge", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const item_r2 = ctx.$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("capture", item_r2.captureLink)("autoLogin", item_r2.autoLogin)("href", item_r2.href)("hidden", item_r2.hidden)("detail", item_r2.href && !item_r2.iconAction || null)("button", item_r2.href && !item_r2.iconAction);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", item_r2.ariaAction);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", item_r2.iconDescription);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("clean", true)("text", item_r2.content)("filter", false);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", (item_r2.href || item_r2.action) && item_r2.iconAction && item_r2.iconAction != "spinner");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", (item_r2.href || item_r2.action) && item_r2.iconAction == "spinner");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", item_r2.badge);
    }
}
/**
 * Component to display a list of items received by param in a popover.
 */
let CoreContextMenuPopoverComponent = /*@__PURE__*/ (() => {
    class CoreContextMenuPopoverComponent {
        constructor(navParams) {
            this.title = navParams.get('title');
            this.items = navParams.get('items') || [];
            this.uniqueId = navParams.get('id');
        }
        /**
         * Close the popover.
         */
        closeMenu(item) {
            _singletons__WEBPACK_IMPORTED_MODULE_1__[/* PopoverController */ "D"].dismiss(item);
        }
        /**
         * Function called when an item is clicked.
         *
         * @param event Click event.
         * @param item Item clicked.
         * @return Return true if success, false if error.
         */
        itemClicked(event, item) {
            if (!!item.action && item.action.observers.length > 0) {
                event.preventDefault();
                event.stopPropagation();
                if (item.iconAction == _core_constants__WEBPACK_IMPORTED_MODULE_0__[/* CoreConstants */ "a"].ICON_LOADING) {
                    return false;
                }
                if (item.closeOnClick) {
                    this.closeMenu(item);
                }
                item.action.emit(this.closeMenu.bind(this, item));
            }
            else if (item.closeOnClick && (item.href || (!!item.onClosed && item.onClosed.observers.length > 0))) {
                this.closeMenu(item);
            }
            return true;
        }
    }
    CoreContextMenuPopoverComponent.ɵfac = function CoreContextMenuPopoverComponent_Factory(t) { return new (t || CoreContextMenuPopoverComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdirectiveInject */ "yc"](_ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* NavParams */ "Hb"])); };
    CoreContextMenuPopoverComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineComponent */ "sc"]({ type: CoreContextMenuPopoverComponent, selectors: [["core-context-menu-popover"]], decls: 3, vars: 3, consts: [["role", "menu", 3, "id"], [4, "ngIf"], ["class", "ion-text-wrap", "core-link", "", "role", "menuitem", 3, "capture", "autoLogin", "href", "hidden", "detail", "button", "click", 4, "ngFor", "ngForOf"], ["core-link", "", "role", "menuitem", 1, "ion-text-wrap", 3, "capture", "autoLogin", "href", "hidden", "detail", "button", "click"], ["aria-hidden", "true", "slot", "start", 3, "name", 4, "ngIf"], [1, "item-heading"], [3, "clean", "text", "filter"], ["slot", "end", "aria-hidden", "true", 3, "name", "icon-slash", 4, "ngIf"], ["slot", "end", 4, "ngIf"], ["slot", "end", 3, "class", 4, "ngIf"], ["aria-hidden", "true", "slot", "start", 3, "name"], ["slot", "end", "aria-hidden", "true", 3, "name"], ["slot", "end"], ["class", "sr-only", 4, "ngIf"], [1, "sr-only"]], template: function CoreContextMenuPopoverComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-list", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](1, CoreContextMenuPopoverComponent_ion_list_header_1_Template, 3, 1, "ion-list-header", 1);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](2, CoreContextMenuPopoverComponent_ion_item_2_Template, 8, 14, "ion-item", 2);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("id", ctx.uniqueId);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.title);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx.items);
            }
        }, directives: [_ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonList */ "O"], _angular_common__WEBPACK_IMPORTED_MODULE_4__[/* NgIf */ "t"], _angular_common__WEBPACK_IMPORTED_MODULE_4__[/* NgForOf */ "s"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonListHeader */ "P"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonLabel */ "N"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonItem */ "H"], _directives_link__WEBPACK_IMPORTED_MODULE_5__[/* CoreLinkDirective */ "a"], _directives_format_text__WEBPACK_IMPORTED_MODULE_6__[/* CoreFormatTextDirective */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonIcon */ "C"], _directives_fa_icon__WEBPACK_IMPORTED_MODULE_7__[/* CoreFaIconDirective */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonSpinner */ "pb"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonBadge */ "j"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_8__[/* TranslatePipe */ "d"]], styles: ["ion-list[_ngcontent-%COMP%]{padding:0}ion-icon[slot=start][_ngcontent-%COMP%]{margin-left:0;margin-right:10px;width:.8em;height:.8em}@supports ((-webkit-margin-start:0) or (margin-inline-start:0)) or (-webkit-margin-start:0){ion-icon[slot=start][_ngcontent-%COMP%]{margin-left:unset;margin-right:unset;-webkit-margin-start:0;margin-inline-start:0;-webkit-margin-end:10px;margin-inline-end:10px}}"] });
    return CoreContextMenuPopoverComponent;
})();


/***/ }),

/***/ "0Ukm":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModForumDiscussionOptionsMenuComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("3LXp");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("j3ag");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fjkH");
/* harmony import */ var _services_forum__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ZCW2");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("ofXK");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("TEn/");
/* harmony import */ var _core_directives_fa_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("3CSS");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("sYmb");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.











function AddonModForumDiscussionOptionsMenuComponent_ion_item_0_Template(rf, ctx) {
    if (rf & 1) {
        const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵlistener */ "Mc"]("click", function AddonModForumDiscussionOptionsMenuComponent_ion_item_0_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵrestoreView */ "gd"](_r7); const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵnextContext */ "Oc"](); return ctx_r6.setLockState(true); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelement */ "zc"](1, "ion-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](3, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipeBind1 */ "Qc"](5, 1, "addon.mod_forum.lockdiscussion"));
    }
}
function AddonModForumDiscussionOptionsMenuComponent_ion_item_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r9 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵlistener */ "Mc"]("click", function AddonModForumDiscussionOptionsMenuComponent_ion_item_1_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵrestoreView */ "gd"](_r9); const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵnextContext */ "Oc"](); return ctx_r8.setLockState(false); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelement */ "zc"](1, "ion-icon", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](3, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipeBind1 */ "Qc"](5, 1, "addon.mod_forum.unlockdiscussion"));
    }
}
function AddonModForumDiscussionOptionsMenuComponent_ion_item_2_Template(rf, ctx) {
    if (rf & 1) {
        const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵlistener */ "Mc"]("click", function AddonModForumDiscussionOptionsMenuComponent_ion_item_2_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵrestoreView */ "gd"](_r11); const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵnextContext */ "Oc"](); return ctx_r10.setPinState(true); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelement */ "zc"](1, "ion-icon", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](3, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipeBind1 */ "Qc"](5, 1, "addon.mod_forum.pindiscussion"));
    }
}
function AddonModForumDiscussionOptionsMenuComponent_ion_item_3_Template(rf, ctx) {
    if (rf & 1) {
        const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵlistener */ "Mc"]("click", function AddonModForumDiscussionOptionsMenuComponent_ion_item_3_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵrestoreView */ "gd"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵnextContext */ "Oc"](); return ctx_r12.setPinState(false); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelement */ "zc"](1, "ion-icon", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](3, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipeBind1 */ "Qc"](5, 1, "addon.mod_forum.unpindiscussion"));
    }
}
function AddonModForumDiscussionOptionsMenuComponent_ion_item_4_Template(rf, ctx) {
    if (rf & 1) {
        const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵlistener */ "Mc"]("click", function AddonModForumDiscussionOptionsMenuComponent_ion_item_4_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵrestoreView */ "gd"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵnextContext */ "Oc"](); return ctx_r14.toggleFavouriteState(true); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelement */ "zc"](1, "ion-icon", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](3, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipeBind1 */ "Qc"](5, 1, "addon.mod_forum.addtofavourites"));
    }
}
function AddonModForumDiscussionOptionsMenuComponent_ion_item_5_Template(rf, ctx) {
    if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵlistener */ "Mc"]("click", function AddonModForumDiscussionOptionsMenuComponent_ion_item_5_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵrestoreView */ "gd"](_r17); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵnextContext */ "Oc"](); return ctx_r16.toggleFavouriteState(false); });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelement */ "zc"](1, "ion-icon", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementStart */ "Ec"](3, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵpipeBind1 */ "Qc"](5, 1, "addon.mod_forum.removefromfavourites"));
    }
}
/**
 * This component is meant to display a popover with the discussion options.
 */
let AddonModForumDiscussionOptionsMenuComponent = /*@__PURE__*/ (() => {
    class AddonModForumDiscussionOptionsMenuComponent {
        constructor() {
            this.canPin = false;
        }
        /**
         * Component being initialized.
         */
        ngOnInit() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!_services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForum */ "a"].isSetPinStateAvailableForSite()) {
                    this.canPin = false;
                    return;
                }
                // Use the canAddDiscussion WS to check if the user can pin discussions.
                try {
                    const response = yield _services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForum */ "a"].canAddDiscussionToAll(this.forumId, { cmId: this.cmId });
                    this.canPin = !!response.canpindiscussions;
                }
                catch (error) {
                    this.canPin = false;
                }
            });
        }
        /**
         * Lock or unlock the discussion.
         *
         * @param locked True to lock the discussion, false to unlock.
         */
        setLockState(locked) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showModalLoading('core.sending', true);
                try {
                    const response = yield _services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForum */ "a"].setLockState(this.forumId, this.discussion.discussion, locked);
                    const data = {
                        forumId: this.forumId,
                        discussionId: this.discussion.discussion,
                        cmId: this.cmId,
                        locked: response.locked,
                    };
                    _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].trigger(_services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForumProvider */ "b"].CHANGE_DISCUSSION_EVENT, data, _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getCurrentSiteId());
                    _singletons__WEBPACK_IMPORTED_MODULE_3__[/* PopoverController */ "D"].dismiss({ action: 'lock', value: locked });
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showToast('addon.mod_forum.lockupdated', true);
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showErrorModal(error);
                    _singletons__WEBPACK_IMPORTED_MODULE_3__[/* PopoverController */ "D"].dismiss();
                }
                finally {
                    modal.dismiss();
                }
            });
        }
        /**
         * Pin or unpin the discussion.
         *
         * @param pinned True to pin the discussion, false to unpin it.
         */
        setPinState(pinned) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showModalLoading('core.sending', true);
                try {
                    yield _services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForum */ "a"].setPinState(this.discussion.discussion, pinned);
                    const data = {
                        forumId: this.forumId,
                        discussionId: this.discussion.discussion,
                        cmId: this.cmId,
                        pinned: pinned,
                    };
                    _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].trigger(_services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForumProvider */ "b"].CHANGE_DISCUSSION_EVENT, data, _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getCurrentSiteId());
                    _singletons__WEBPACK_IMPORTED_MODULE_3__[/* PopoverController */ "D"].dismiss({ action: 'pin', value: pinned });
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showToast('addon.mod_forum.pinupdated', true);
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showErrorModal(error);
                    _singletons__WEBPACK_IMPORTED_MODULE_3__[/* PopoverController */ "D"].dismiss();
                }
                finally {
                    modal.dismiss();
                }
            });
        }
        /**
         * Star or unstar the discussion.
         *
         * @param starred True to star the discussion, false to unstar it.
         */
        toggleFavouriteState(starred) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showModalLoading('core.sending', true);
                try {
                    yield _services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForum */ "a"].toggleFavouriteState(this.discussion.discussion, starred);
                    const data = {
                        forumId: this.forumId,
                        discussionId: this.discussion.discussion,
                        cmId: this.cmId,
                        starred: starred,
                    };
                    _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].trigger(_services_forum__WEBPACK_IMPORTED_MODULE_5__[/* AddonModForumProvider */ "b"].CHANGE_DISCUSSION_EVENT, data, _services_sites__WEBPACK_IMPORTED_MODULE_1__[/* CoreSites */ "b"].getCurrentSiteId());
                    _singletons__WEBPACK_IMPORTED_MODULE_3__[/* PopoverController */ "D"].dismiss({ action: 'star', value: starred });
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showToast('addon.mod_forum.favouriteupdated', true);
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showErrorModal(error);
                    _singletons__WEBPACK_IMPORTED_MODULE_3__[/* PopoverController */ "D"].dismiss();
                }
                finally {
                    modal.dismiss();
                }
            });
        }
    }
    AddonModForumDiscussionOptionsMenuComponent.ɵfac = function AddonModForumDiscussionOptionsMenuComponent_Factory(t) { return new (t || AddonModForumDiscussionOptionsMenuComponent)(); };
    AddonModForumDiscussionOptionsMenuComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵdefineComponent */ "sc"]({ type: AddonModForumDiscussionOptionsMenuComponent, selectors: [["addon-forum-discussion-options-menu"]], inputs: { discussion: "discussion", forumId: "forumId", cmId: "cmId" }, decls: 6, vars: 6, consts: [["button", "", "class", "ion-text-wrap", "detail", "false", 3, "click", 4, "ngIf"], ["button", "", "detail", "false", 1, "ion-text-wrap", 3, "click"], ["name", "fas-lock", "slot", "start", "aria-hidden", "true"], [1, "item-heading"], ["name", "fas-unlock", "slot", "start", "aria-hidden", "true"], ["name", "fas-map-pin", "slot", "start", "aria-hidden", "true"], ["name", "fas-map-pin", "slot", "start", "aria-hidden", "true", 1, "icon-slash"], ["name", "fas-star", "slot", "start", "aria-hidden", "true"], ["name", "fas-star", "slot", "start", "aria-hidden", "true", 1, "icon-slash"]], template: function AddonModForumDiscussionOptionsMenuComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtemplate */ "nd"](0, AddonModForumDiscussionOptionsMenuComponent_ion_item_0_Template, 6, 3, "ion-item", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtemplate */ "nd"](1, AddonModForumDiscussionOptionsMenuComponent_ion_item_1_Template, 6, 3, "ion-item", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtemplate */ "nd"](2, AddonModForumDiscussionOptionsMenuComponent_ion_item_2_Template, 6, 3, "ion-item", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtemplate */ "nd"](3, AddonModForumDiscussionOptionsMenuComponent_ion_item_3_Template, 6, 3, "ion-item", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtemplate */ "nd"](4, AddonModForumDiscussionOptionsMenuComponent_ion_item_4_Template, 6, 3, "ion-item", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵtemplate */ "nd"](5, AddonModForumDiscussionOptionsMenuComponent_ion_item_5_Template, 6, 3, "ion-item", 0);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.discussion.canlock && !ctx.discussion.locked);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.discussion.canlock && ctx.discussion.locked);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.canPin && !ctx.discussion.pinned);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.canPin && ctx.discussion.pinned);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.discussion.canfavourite && !ctx.discussion.starred);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.discussion.canfavourite && ctx.discussion.starred);
            }
        }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_7__[/* NgIf */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_8__[/* IonItem */ "H"], _ionic_angular__WEBPACK_IMPORTED_MODULE_8__[/* IonIcon */ "C"], _core_directives_fa_icon__WEBPACK_IMPORTED_MODULE_9__[/* CoreFaIconDirective */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_8__[/* IonLabel */ "N"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__[/* TranslatePipe */ "d"]], encapsulation: 2 });
    return AddonModForumDiscussionOptionsMenuComponent;
})();


/***/ }),

/***/ "0Y/d":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreBlockBaseComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("3j9v");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("bFG1");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("vuGA");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Template class to easily create components for blocks.
 */
let CoreBlockBaseComponent = /*@__PURE__*/ (() => {
    class CoreBlockBaseComponent {
        constructor(loggerName = 'AddonBlockComponent') {
            this.loaded = false; // If the component has been loaded.
            this.fetchContentDefaultError = ''; // Default error to show when loading contents.
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_1__[/* CoreLogger */ "a"].getInstance(loggerName);
        }
        /**
         * Component being initialized.
         */
        ngOnInit() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.block.configs && this.block.configs.length > 0) {
                    this.block.configs.map((config) => {
                        config.value = _services_utils_text__WEBPACK_IMPORTED_MODULE_4__[/* CoreTextUtils */ "a"].parseJSON(config.value);
                        return config;
                    });
                    this.block.configsRecord = _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__[/* CoreUtils */ "a"].arrayToObject(this.block.configs, 'name');
                }
                yield this.loadContent();
            });
        }
        /**
         * Refresh the data.
         *
         * @param refresher Refresher.
         * @param done Function to call when done.
         * @param showErrors If show errors to the user of hide them.
         * @return Promise resolved when done.
         */
        doRefresh(refresher, done, showErrors = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.loaded) {
                    return this.refreshContent(showErrors).finally(() => {
                        refresher === null || refresher === void 0 ? void 0 : refresher.complete();
                        done && done();
                    });
                }
            });
        }
        /**
         * Perform the refresh content function.
         *
         * @param showErrors Wether to show errors to the user or hide them.
         * @return Resolved when done.
         */
        refreshContent(showErrors = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Wrap the call in a try/catch so the workflow isn't interrupted if an error occurs.
                try {
                    yield this.invalidateContent();
                }
                catch (ex) {
                    // An error ocurred in the function, log the error and just resolve the promise so the workflow continues.
                    this.logger.error(ex);
                }
                yield this.loadContent(true, showErrors);
            });
        }
        /**
         * Perform the invalidate content function.
         *
         * @return Resolved when done.
         */
        invalidateContent() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return;
            });
        }
        /**
         * Loads the component contents and shows the corresponding error.
         *
         * @param refresh Whether we're refreshing data.
         * @param showErrors Wether to show errors to the user or hide them.
         * @return Promise resolved when done.
         */
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        loadContent(refresh, showErrors = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Wrap the call in a try/catch so the workflow isn't interrupted if an error occurs.
                try {
                    yield this.fetchContent(refresh);
                }
                catch (error) {
                    // An error ocurred in the function, log the error and just resolve the promise so the workflow continues.
                    this.logger.error(error);
                    // Error getting data, fail.
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, this.fetchContentDefaultError, true);
                }
                this.loaded = true;
            });
        }
        /**
         * Download the component contents.
         *
         * @param refresh Whether we're refreshing data.
         * @return Promise resolved when done.
         */
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        fetchContent(refresh = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return;
            });
        }
    }
    CoreBlockBaseComponent.ɵfac = function CoreBlockBaseComponent_Factory(t) { return new (t || CoreBlockBaseComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__[/* ɵɵdirectiveInject */ "yc"]('', 8)); };
    CoreBlockBaseComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_5__[/* ɵɵdefineComponent */ "sc"]({ type: CoreBlockBaseComponent, selectors: [["ng-component"]], inputs: { title: "title", block: "block", contextLevel: "contextLevel", instanceId: "instanceId", link: "link", linkParams: "linkParams", navOptions: "navOptions" }, decls: 0, vars: 0, template: function CoreBlockBaseComponent_Template(rf, ctx) { }, encapsulation: 2 });
    return CoreBlockBaseComponent;
})();


/***/ }),

/***/ "0Zvo":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ directives_module_CoreSitePluginsDirectivesModule; });

// EXTERNAL MODULE: ./node_modules/tslib/tslib.es6.js
var tslib_es6 = __webpack_require__("mrSG");

// EXTERNAL MODULE: ./src/core/singletons/index.ts
var singletons = __webpack_require__("j3ag");

// EXTERNAL MODULE: ./src/core/services/utils/dom.ts + 2 modules
var dom = __webpack_require__("3LXp");

// EXTERNAL MODULE: ./src/core/services/utils/utils.ts
var utils = __webpack_require__("bFG1");

// EXTERNAL MODULE: ./src/core/services/navigator.ts
var services_navigator = __webpack_require__("pHTc");

// EXTERNAL MODULE: ./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js + 4 modules
var core = __webpack_require__("fXoL");

// EXTERNAL MODULE: ./src/core/features/siteplugins/services/siteplugins.ts
var siteplugins = __webpack_require__("TSsE");

// EXTERNAL MODULE: ./src/core/singletons/logger.ts + 1 modules
var logger = __webpack_require__("3j9v");

// EXTERNAL MODULE: ./src/core/singletons/form.ts
var singletons_form = __webpack_require__("4reR");

// EXTERNAL MODULE: ./src/core/features/siteplugins/components/plugin-content/plugin-content.ts
var plugin_content = __webpack_require__("BTA1");

// CONCATENATED MODULE: ./src/core/features/siteplugins/classes/call-ws-directive.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Base class for directives that need to call a WS.
 */
let call_ws_directive_CoreSitePluginsCallWSBaseDirective = /*@__PURE__*/ (() => {
    class CoreSitePluginsCallWSBaseDirective {
        constructor(element, parentContent) {
            this.parentContent = parentContent;
            this.onSuccess = new core["t" /* EventEmitter */](); // Sends the result when the WS call succeeds.
            this.onError = new core["t" /* EventEmitter */](); // Sends the error when the WS call fails.
            this.onDone = new core["t" /* EventEmitter */](); // Notifies when the WS call is done (either success or fail).
            this.element = element.nativeElement || element;
            this.logger = logger["a" /* CoreLogger */].getInstance('CoreSitePluginsCallWS');
        }
        /**
         * @inheritdoc
         */
        ngOnInit() {
            var _a;
            if (!((_a = this.parentContent) === null || _a === void 0 ? void 0 : _a.invalidateObservable)) {
                return;
            }
            this.invalidateObserver = this.parentContent.invalidateObservable.subscribe(() => {
                this.invalidate();
            });
        }
        /**
         * Call a WS.
         *
         * @return Promise resolved when done.
         */
        callWS() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                try {
                    const params = this.getParamsForWS();
                    const result = yield siteplugins["a" /* CoreSitePlugins */].callWS(this.name, params, this.preSets);
                    this.onSuccess.emit(result);
                    // Don't block the promise with the success function.
                    this.wsCallSuccess(result);
                }
                catch (error) {
                    this.onError.emit(error);
                    this.logger.error(`Error calling WS ${this.name}`, error);
                    throw error;
                }
                finally {
                    this.onDone.emit();
                }
            });
        }
        /**
         * Get the params for the WS call.
         *
         * @return Params.
         */
        getParamsForWS() {
            let params = this.params || {};
            if (this.parentContent) {
                params = siteplugins["a" /* CoreSitePlugins */].loadOtherDataInArgs(params, this.parentContent.otherData, this.useOtherDataForWS);
            }
            if (this.form && document.forms[this.form]) {
                params = Object.assign(params, singletons_form["a" /* CoreForms */].getDataFromForm(document.forms[this.form]));
            }
            return params;
        }
        /**
         * Function called when the WS call is successful.
         *
         * @param result Result of the WS call.
         * @return If async, promise resolved when done.
         */
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        wsCallSuccess(result) {
            // Function to be overridden.
        }
        /**
         * Invalidate the WS call.
         *
         * @return Promise resolved when done.
         */
        invalidate() {
            const params = this.getParamsForWS();
            return siteplugins["a" /* CoreSitePlugins */].instance.invalidateCallWS(this.name, params, this.preSets);
        }
        /**
         * Directive destroyed.
         */
        ngOnDestroy() {
            var _a;
            (_a = this.invalidateObserver) === null || _a === void 0 ? void 0 : _a.unsubscribe();
        }
    }
    CoreSitePluginsCallWSBaseDirective.ɵfac = function CoreSitePluginsCallWSBaseDirective_Factory(t) { return new (t || CoreSitePluginsCallWSBaseDirective)(core["yc" /* ɵɵdirectiveInject */](core["r" /* ElementRef */]), core["yc" /* ɵɵdirectiveInject */](plugin_content["a" /* CoreSitePluginsPluginContentComponent */])); };
    CoreSitePluginsCallWSBaseDirective.ɵdir = core["tc" /* ɵɵdefineDirective */]({ type: CoreSitePluginsCallWSBaseDirective, inputs: { name: "name", params: "params", preSets: "preSets", useOtherDataForWS: "useOtherDataForWS", form: "form" }, outputs: { onSuccess: "onSuccess", onError: "onError", onDone: "onDone" } });
    return CoreSitePluginsCallWSBaseDirective;
})();

// CONCATENATED MODULE: ./src/core/features/siteplugins/classes/call-ws-click-directive.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.







/**
 * Base class for directives to call a WS when the element is clicked.
 *
 * The directives that inherit from this class will call a WS method when the element is clicked.
 */
let call_ws_click_directive_CoreSitePluginsCallWSOnClickBaseDirective = /*@__PURE__*/ (() => {
    class CoreSitePluginsCallWSOnClickBaseDirective extends call_ws_directive_CoreSitePluginsCallWSBaseDirective {
        constructor(element, parentContent) {
            super(element, parentContent);
        }
        /**
         * @inheritdoc
         */
        ngOnInit() {
            super.ngOnInit();
            this.element.addEventListener('click', (ev) => Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                ev.preventDefault();
                ev.stopPropagation();
                if (typeof this.confirmMessage != 'undefined') {
                    // Ask for confirm.
                    try {
                        yield dom["a" /* CoreDomUtils */].showConfirm(this.confirmMessage || singletons["L" /* Translate */].instant('core.areyousure'));
                    }
                    catch (_a) {
                        // User cancelled, stop.
                        return;
                    }
                }
                this.callWS();
            }));
        }
        /**
         * @inheritdoc
         */
        callWS() {
            const _super = Object.create(null, {
                callWS: { get: () => super.callWS }
            });
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const modal = yield dom["a" /* CoreDomUtils */].showModalLoading();
                try {
                    yield _super.callWS.call(this);
                }
                catch (error) {
                    if (typeof this.showError == 'undefined' || utils["a" /* CoreUtils */].isTrueOrOne(this.showError)) {
                        dom["a" /* CoreDomUtils */].showErrorModalDefault(error, 'core.serverconnection', true);
                    }
                }
                finally {
                    modal.dismiss();
                }
            });
        }
    }
    CoreSitePluginsCallWSOnClickBaseDirective.ɵfac = function CoreSitePluginsCallWSOnClickBaseDirective_Factory(t) { return new (t || CoreSitePluginsCallWSOnClickBaseDirective)(core["yc" /* ɵɵdirectiveInject */](core["r" /* ElementRef */]), core["yc" /* ɵɵdirectiveInject */](plugin_content["a" /* CoreSitePluginsPluginContentComponent */])); };
    CoreSitePluginsCallWSOnClickBaseDirective.ɵdir = core["tc" /* ɵɵdefineDirective */]({ type: CoreSitePluginsCallWSOnClickBaseDirective, inputs: { confirmMessage: "confirmMessage", showError: "showError" }, features: [core["ic" /* ɵɵInheritDefinitionFeature */]] });
    return CoreSitePluginsCallWSOnClickBaseDirective;
})();

// CONCATENATED MODULE: ./src/core/features/siteplugins/directives/call-ws.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Directive to call a WS when the element is clicked. The action to do when the WS call is successful depends on the input data:
 * display a message, go back or refresh current view.
 *
 * If you want to load a new content when the WS call is done, @see CoreSitePluginsCallWSNewContentDirective.
 *
 * @see CoreSitePluginsCallWSOnClickBaseDirective.
 *
 * Example usages:
 *
 * A button to send some data to the server without using cache, displaying default messages and refreshing on success:
 *
 * <ion-button core-site-plugins-call-ws name="mod_certificate_view_certificate"
 *             [params]="{certificateid: <% certificate.id %>}" [preSets]="{getFromCache: 0, saveToCache: 0}" confirmMessage
 *             successMessage refreshOnSuccess="true">
 *     {{ 'plugin.mod_certificate_coursecertificate.senddata' | translate }}
 * </ion-button>
 *
 * A button to send some data to the server using cache, without confirm, going back on success and using userid from otherdata:
 *
 * <ion-button core-site-plugins-call-ws name="mod_certificate_view_certificate"
 *             [params]="{certificateid: <% certificate.id %>}" goBackOnSuccess="true" [useOtherData]="['userid']">
 *     {{ 'plugin.mod_certificate_coursecertificate.senddata' | translate }}
 * </ion-button>
 */
let call_ws_CoreSitePluginsCallWSDirective = /*@__PURE__*/ (() => {
    class CoreSitePluginsCallWSDirective extends call_ws_click_directive_CoreSitePluginsCallWSOnClickBaseDirective {
        constructor(element, parentContent) {
            super(element, parentContent);
        }
        /**
         * @inheritdoc
         */
        wsCallSuccess() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (utils["a" /* CoreUtils */].isTrueOrOne(this.goBackOnSuccess)) {
                    yield services_navigator["a" /* CoreNavigator */].back();
                }
                else if (utils["a" /* CoreUtils */].isTrueOrOne(this.refreshOnSuccess) && this.parentContent) {
                    this.parentContent.refreshContent(true);
                }
                if (typeof this.successMessage != 'undefined') {
                    // Display the success message.
                    dom["a" /* CoreDomUtils */].showToast(this.successMessage || singletons["L" /* Translate */].instant('core.success'));
                }
            });
        }
    }
    CoreSitePluginsCallWSDirective.ɵfac = function CoreSitePluginsCallWSDirective_Factory(t) { return new (t || CoreSitePluginsCallWSDirective)(core["yc" /* ɵɵdirectiveInject */](core["r" /* ElementRef */]), core["yc" /* ɵɵdirectiveInject */](plugin_content["a" /* CoreSitePluginsPluginContentComponent */], 8)); };
    CoreSitePluginsCallWSDirective.ɵdir = core["tc" /* ɵɵdefineDirective */]({ type: CoreSitePluginsCallWSDirective, selectors: [["", "core-site-plugins-call-ws", ""]], inputs: { successMessage: "successMessage", goBackOnSuccess: "goBackOnSuccess", refreshOnSuccess: "refreshOnSuccess" }, features: [core["ic" /* ɵɵInheritDefinitionFeature */]] });
    return CoreSitePluginsCallWSDirective;
})();

// EXTERNAL MODULE: ./node_modules/ts-md5/dist/md5.js
var md5 = __webpack_require__("kScs");

// CONCATENATED MODULE: ./src/core/features/siteplugins/directives/call-ws-new-content.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Directive to call a WS when the element is clicked and load a new content passing the WS result as args. This new content
 * can be displayed in a new page or in the same page (only if current page is already displaying a site plugin content).
 *
 * If you don't need to load some new content when done, @see CoreSitePluginsCallWSDirective.
 *
 * @see CoreSitePluginsCallWSOnClickBaseDirective.
 *
 * Example usages:
 *
 * A button to get some data from the server without using cache, showing default confirm and displaying a new page:
 *
 * <ion-button core-site-plugins-call-ws-new-content name="mod_certificate_get_issued_certificates"
 *             [params]="{certificateid: <% certificate.id %>}" [preSets]="{getFromCache: 0, saveToCache: 0}" confirmMessage
 *             title="<% certificate.name %>" component="mod_certificate" method="mobile_issues_view"
 *             [args]="{cmid: <% cmid %>, courseid: <% courseid %>}">
 *     {{ 'plugin.mod_certificate_coursecertificate.getissued' | translate }}
 * </ion-button>
 *
 * A button to get some data from the server using cache, without confirm, displaying new content in same page and using
 * userid from otherdata:
 *
 * <ion-button core-site-plugins-call-ws-new-content name="mod_certificate_get_issued_certificates"
 *             [params]="{certificateid: <% certificate.id %>}" component="mod_certificate" method="mobile_issues_view"
 *             [args]="{cmid: <% cmid %>, courseid: <% courseid %>}" samePage="true" [useOtherData]="['userid']">
 *     {{ 'plugin.mod_certificate_coursecertificate.getissued' | translate }}
 * </ion-button>
 */
let call_ws_new_content_CoreSitePluginsCallWSNewContentDirective = /*@__PURE__*/ (() => {
    class CoreSitePluginsCallWSNewContentDirective extends call_ws_click_directive_CoreSitePluginsCallWSOnClickBaseDirective {
        constructor(element, parentContent) {
            super(element, parentContent);
        }
        /**
         * Function called when the WS call is successful.
         *
         * @param result Result of the WS call.
         */
        wsCallSuccess(result) {
            var _a, _b, _c, _d, _e, _f;
            let args = this.args || {};
            if (this.parentContent) {
                args = siteplugins["a" /* CoreSitePlugins */].loadOtherDataInArgs(this.args, this.parentContent.otherData, this.useOtherData);
            }
            // Add the properties from the WS call result to the args.
            args = Object.assign(args, result);
            let jsData = this.jsData || {};
            if (jsData === true) {
                jsData = ((_a = this.parentContent) === null || _a === void 0 ? void 0 : _a.data) || {};
            }
            if (utils["a" /* CoreUtils */].isTrueOrOne(this.samePage)) {
                // Update the parent content (if it exists).
                (_b = this.parentContent) === null || _b === void 0 ? void 0 : _b.updateContent(args, this.component, this.method, jsData, this.newContentPreSets);
            }
            else {
                const component = this.component || ((_c = this.parentContent) === null || _c === void 0 ? void 0 : _c.component);
                const method = this.method || ((_d = this.parentContent) === null || _d === void 0 ? void 0 : _d.method);
                const hash = md5["Md5"].hashAsciiStr(JSON.stringify(args));
                services_navigator["a" /* CoreNavigator */].navigateToSitePath(`siteplugins/content/${component}/${method}/${hash}`, {
                    params: {
                        title: this.title || ((_e = this.parentContent) === null || _e === void 0 ? void 0 : _e.pageTitle),
                        args,
                        initResult: (_f = this.parentContent) === null || _f === void 0 ? void 0 : _f.initResult,
                        jsData,
                        preSets: this.newContentPreSets,
                        ptrEnabled: this.ptrEnabled,
                    },
                });
            }
        }
    }
    CoreSitePluginsCallWSNewContentDirective.ɵfac = function CoreSitePluginsCallWSNewContentDirective_Factory(t) { return new (t || CoreSitePluginsCallWSNewContentDirective)(core["yc" /* ɵɵdirectiveInject */](core["r" /* ElementRef */]), core["yc" /* ɵɵdirectiveInject */](plugin_content["a" /* CoreSitePluginsPluginContentComponent */], 8)); };
    CoreSitePluginsCallWSNewContentDirective.ɵdir = core["tc" /* ɵɵdefineDirective */]({ type: CoreSitePluginsCallWSNewContentDirective, selectors: [["", "core-site-plugins-call-ws-new-content", ""]], inputs: { component: "component", method: "method", args: "args", title: "title", samePage: "samePage", useOtherData: "useOtherData", form: "form", jsData: "jsData", newContentPreSets: "newContentPreSets", ptrEnabled: "ptrEnabled" }, features: [core["ic" /* ɵɵInheritDefinitionFeature */]] });
    return CoreSitePluginsCallWSNewContentDirective;
})();

// CONCATENATED MODULE: ./src/core/features/siteplugins/directives/call-ws-on-load.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Directive to call a WS as soon as its loaded.
 * This directive is meant for actions to do in the background, like calling logging WebServices.
 *
 * If you want to call a WS when the user clicks on a certain element, @see CoreSitePluginsCallWSDirective.
 *
 * @see CoreSitePluginsCallWSBaseDirective.
 *
 * Example usage:
 *
 * <span core-site-plugins-call-ws-on-load name="mod_certificate_view_certificate" [params]="{certificateid: <% certificate.id %>}"
 *     [preSets]="{getFromCache: 0, saveToCache: 0}"></span>
 */
let call_ws_on_load_CoreSitePluginsCallWSOnLoadDirective = /*@__PURE__*/ (() => {
    class CoreSitePluginsCallWSOnLoadDirective extends call_ws_directive_CoreSitePluginsCallWSBaseDirective {
        constructor(element, parentContent) {
            super(element, parentContent);
        }
        /**
         * @inheritdoc
         */
        ngOnInit() {
            super.ngOnInit();
            // Call the WS immediately.
            this.callWS().catch(() => {
                // Ignore errors.
            });
        }
    }
    CoreSitePluginsCallWSOnLoadDirective.ɵfac = function CoreSitePluginsCallWSOnLoadDirective_Factory(t) { return new (t || CoreSitePluginsCallWSOnLoadDirective)(core["yc" /* ɵɵdirectiveInject */](core["r" /* ElementRef */]), core["yc" /* ɵɵdirectiveInject */](plugin_content["a" /* CoreSitePluginsPluginContentComponent */], 8)); };
    CoreSitePluginsCallWSOnLoadDirective.ɵdir = core["tc" /* ɵɵdefineDirective */]({ type: CoreSitePluginsCallWSOnLoadDirective, selectors: [["", "core-site-plugins-call-ws-on-load", ""]], features: [core["ic" /* ɵɵInheritDefinitionFeature */]] });
    return CoreSitePluginsCallWSOnLoadDirective;
})();

// CONCATENATED MODULE: ./src/core/features/siteplugins/directives/new-content.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Directive to display a new site plugin content when clicked. This new content can be displayed in a new page or in the
 * current page (only if the current page is already displaying a site plugin content).
 *
 * Example usages:
 *
 * A button to go to a new content page:
 *
 * <ion-button core-site-plugins-new-content title="<% certificate.name %>" component="mod_certificate"
 *             method="mobile_issues_view" [args]="{cmid: <% cmid %>, courseid: <% courseid %>}">
 *     {{ 'plugin.mod_certificate_coursecertificate.viewissued' | translate }}
 * </ion-button>
 *
 * A button to load new content in current page using a param from otherdata:
 *
 * <ion-button core-site-plugins-new-content component="mod_certificate" method="mobile_issues_view"
 *         [args]="{cmid: <% cmid %>, courseid: <% courseid %>}" samePage="true" [useOtherData]="['userid']">
 *     {{ 'plugin.mod_certificate_coursecertificate.viewissued' | translate }}
 * </ion-button>
 */
let new_content_CoreSitePluginsNewContentDirective = /*@__PURE__*/ (() => {
    class CoreSitePluginsNewContentDirective {
        constructor(element, parentContent) {
            this.parentContent = parentContent;
            this.element = element.nativeElement || element;
        }
        /**
         * Component being initialized.
         */
        ngOnInit() {
            this.element.addEventListener('click', (ev) => {
                var _a, _b, _c, _d, _e, _f;
                ev.preventDefault();
                ev.stopPropagation();
                let args = this.args || {};
                if (this.parentContent) {
                    args = siteplugins["a" /* CoreSitePlugins */].loadOtherDataInArgs(this.args, this.parentContent.otherData, this.useOtherData);
                }
                if (this.form && document.forms[this.form]) {
                    args = Object.assign(args, singletons_form["a" /* CoreForms */].getDataFromForm(document.forms[this.form]));
                }
                let jsData = this.jsData || {};
                if (jsData === true) {
                    jsData = ((_a = this.parentContent) === null || _a === void 0 ? void 0 : _a.data) || {};
                }
                if (utils["a" /* CoreUtils */].isTrueOrOne(this.samePage)) {
                    // Update the parent content (if it exists).
                    (_b = this.parentContent) === null || _b === void 0 ? void 0 : _b.updateContent(args, this.component, this.method, jsData, this.preSets);
                }
                else {
                    const component = this.component || ((_c = this.parentContent) === null || _c === void 0 ? void 0 : _c.component);
                    const method = this.method || ((_d = this.parentContent) === null || _d === void 0 ? void 0 : _d.method);
                    const hash = md5["Md5"].hashAsciiStr(JSON.stringify(args));
                    services_navigator["a" /* CoreNavigator */].navigateToSitePath(`siteplugins/content/${component}/${method}/${hash}`, {
                        params: {
                            title: this.title || ((_e = this.parentContent) === null || _e === void 0 ? void 0 : _e.pageTitle),
                            args,
                            initResult: (_f = this.parentContent) === null || _f === void 0 ? void 0 : _f.initResult,
                            jsData,
                            preSets: this.preSets,
                            ptrEnabled: this.ptrEnabled,
                        },
                    });
                }
            });
        }
    }
    CoreSitePluginsNewContentDirective.ɵfac = function CoreSitePluginsNewContentDirective_Factory(t) { return new (t || CoreSitePluginsNewContentDirective)(core["yc" /* ɵɵdirectiveInject */](core["r" /* ElementRef */]), core["yc" /* ɵɵdirectiveInject */](plugin_content["a" /* CoreSitePluginsPluginContentComponent */], 8)); };
    CoreSitePluginsNewContentDirective.ɵdir = core["tc" /* ɵɵdefineDirective */]({ type: CoreSitePluginsNewContentDirective, selectors: [["", "core-site-plugins-new-content", ""]], inputs: { component: "component", method: "method", args: "args", title: "title", samePage: "samePage", useOtherData: "useOtherData", form: "form", jsData: "jsData", preSets: "preSets", ptrEnabled: "ptrEnabled" } });
    return CoreSitePluginsNewContentDirective;
})();

// CONCATENATED MODULE: ./src/core/features/siteplugins/directives/directives.module.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






let directives_module_CoreSitePluginsDirectivesModule = /*@__PURE__*/ (() => {
    class CoreSitePluginsDirectivesModule {
    }
    CoreSitePluginsDirectivesModule.ɵmod = core["wc" /* ɵɵdefineNgModule */]({ type: CoreSitePluginsDirectivesModule });
    CoreSitePluginsDirectivesModule.ɵinj = core["vc" /* ɵɵdefineInjector */]({ factory: function CoreSitePluginsDirectivesModule_Factory(t) { return new (t || CoreSitePluginsDirectivesModule)(); } });
    return CoreSitePluginsDirectivesModule;
})();
(function () {
    (typeof ngJitMode === "undefined" || ngJitMode) && core["ld" /* ɵɵsetNgModuleScope */](directives_module_CoreSitePluginsDirectivesModule, { declarations: [call_ws_CoreSitePluginsCallWSDirective,
            call_ws_new_content_CoreSitePluginsCallWSNewContentDirective,
            call_ws_on_load_CoreSitePluginsCallWSOnLoadDirective,
            new_content_CoreSitePluginsNewContentDirective], exports: [call_ws_CoreSitePluginsCallWSDirective,
            call_ws_new_content_CoreSitePluginsCallWSNewContentDirective,
            call_ws_on_load_CoreSitePluginsCallWSOnLoadDirective,
            new_content_CoreSitePluginsNewContentDirective] });
})();


/***/ }),

/***/ "0iff":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModChoiceSyncProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModChoiceSync; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _classes_errors_network_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("+mW7");
/* harmony import */ var _features_course_classes_activity_sync__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("F9Zh");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("ULAo");
/* harmony import */ var _features_course_services_log_helper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("TmfO");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("nvXB");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("j3ag");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("fjkH");
/* harmony import */ var _choice__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("xRWB");
/* harmony import */ var _choice_offline__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("iRUP");
/* harmony import */ var _handlers_prefetch__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("qYMx");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.














/**
 * Service to sync choices.
 */
let AddonModChoiceSyncProvider = /*@__PURE__*/ (() => {
    class AddonModChoiceSyncProvider extends _features_course_classes_activity_sync__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseActivitySyncBaseProvider */ "a"] {
        constructor() {
            super('AddonModChoiceSyncProvider');
            this.componentTranslatableString = 'choice';
        }
        /**
         * Get the ID of a choice sync.
         *
         * @param choiceId Choice ID.
         * @param userId User the responses belong to.
         * @return Sync ID.
         */
        getSyncId(choiceId, userId) {
            return choiceId + '#' + userId;
        }
        /**
         * Try to synchronize all the choices in a certain site or in all sites.
         *
         * @param siteId Site ID to sync. If not defined, sync all sites.
         * @param force Wether to force sync not depending on last execution.
         * @return Promise resolved if sync is successful, rejected if sync fails.
         */
        syncAllChoices(siteId, force) {
            return this.syncOnSites('all choices', this.syncAllChoicesFunc.bind(this, !!force), siteId);
        }
        /**
         * Sync all pending choices on a site.
         *
         * @param force Wether to force sync not depending on last execution.
         * @param siteId Site ID to sync.
         * @return Promise resolved if sync is successful, rejected if sync fails.
         */
        syncAllChoicesFunc(force, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const responses = yield _choice_offline__WEBPACK_IMPORTED_MODULE_11__[/* AddonModChoiceOffline */ "a"].getResponses(siteId);
                // Sync all responses.
                yield Promise.all(responses.map((response) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    const result = force ?
                        yield this.syncChoice(response.choiceid, response.userid, siteId) :
                        yield this.syncChoiceIfNeeded(response.choiceid, response.userid, siteId);
                    if (result === null || result === void 0 ? void 0 : result.updated) {
                        // Sync successful, send event.
                        _singletons_events__WEBPACK_IMPORTED_MODULE_9__[/* CoreEvents */ "b"].trigger(AddonModChoiceSyncProvider.AUTO_SYNCED, {
                            choiceId: response.choiceid,
                            userId: response.userid,
                            warnings: result.warnings,
                        }, siteId);
                    }
                })));
            });
        }
        /**
         * Sync an choice only if a certain time has passed since the last time.
         *
         * @param choiceId Choice ID to be synced.
         * @param userId User the answers belong to.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the choice is synced or it doesn't need to be synced.
         */
        syncChoiceIfNeeded(choiceId, userId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const syncId = this.getSyncId(choiceId, userId);
                const needed = yield this.isSyncNeeded(syncId, siteId);
                if (needed) {
                    return this.syncChoice(choiceId, userId, siteId);
                }
            });
        }
        /**
         * Synchronize a choice.
         *
         * @param choiceId Choice ID to be synced.
         * @param userId User the answers belong to.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if sync is successful, rejected otherwise.
         */
        syncChoice(choiceId, userId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                userId = userId || site.getUserId();
                siteId = site.getId();
                const syncId = this.getSyncId(choiceId, userId);
                if (this.isSyncing(syncId, siteId)) {
                    // There's already a sync ongoing for this discussion, return the promise.
                    return this.getOngoingSync(syncId, siteId);
                }
                this.logger.debug(`Try to sync choice '${choiceId}' for user '${userId}'`);
                return this.addOngoingSync(syncId, this.performSync(choiceId, userId, siteId), siteId);
            });
        }
        /**
         * Synchronize a choice.
         *
         * @param choiceId Choice ID to be synced.
         * @param userId User the answers belong to.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if sync is successful, rejected otherwise.
         */
        performSync(choiceId, userId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const syncId = this.getSyncId(choiceId, userId);
                const result = {
                    warnings: [],
                    updated: false,
                };
                // Sync offline logs.
                yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].ignoreErrors(_features_course_services_log_helper__WEBPACK_IMPORTED_MODULE_4__[/* CoreCourseLogHelper */ "a"].syncActivity(_choice__WEBPACK_IMPORTED_MODULE_10__[/* AddonModChoiceProvider */ "b"].COMPONENT, choiceId, siteId));
                const data = yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].ignoreErrors(_choice_offline__WEBPACK_IMPORTED_MODULE_11__[/* AddonModChoiceOffline */ "a"].getResponse(choiceId, siteId, userId));
                if (!data || !data.choiceid) {
                    // Nothing to sync. Set sync time.
                    yield this.setSyncTime(syncId, siteId);
                    return result;
                }
                if (!_services_app__WEBPACK_IMPORTED_MODULE_5__[/* CoreApp */ "a"].isOnline()) {
                    // Cannot sync in offline.
                    throw new _classes_errors_network_error__WEBPACK_IMPORTED_MODULE_1__[/* CoreNetworkError */ "a"]();
                }
                const courseId = data.courseid;
                try {
                    // Send the responses.
                    if (data.deleting) {
                        // A user has deleted some responses.
                        yield _choice__WEBPACK_IMPORTED_MODULE_10__[/* AddonModChoice */ "a"].deleteResponsesOnline(choiceId, data.responses, siteId);
                    }
                    else {
                        // A user has added some responses.
                        yield _choice__WEBPACK_IMPORTED_MODULE_10__[/* AddonModChoice */ "a"].submitResponseOnline(choiceId, data.responses, siteId);
                    }
                    result.updated = true;
                    yield _choice_offline__WEBPACK_IMPORTED_MODULE_11__[/* AddonModChoiceOffline */ "a"].deleteResponse(choiceId, siteId, userId);
                }
                catch (error) {
                    if (!_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // Couldn't connect to server, reject.
                        throw error;
                    }
                    // The WebService has thrown an error, this means that responses cannot be submitted. Delete them.
                    result.updated = true;
                    yield _choice_offline__WEBPACK_IMPORTED_MODULE_11__[/* AddonModChoiceOffline */ "a"].deleteResponse(choiceId, siteId, userId);
                    // Responses deleted, add a warning.
                    this.addOfflineDataDeletedWarning(result.warnings, data.name, error);
                }
                // Data has been sent to server, prefetch choice if needed.
                try {
                    const module = yield _features_course_services_course__WEBPACK_IMPORTED_MODULE_3__[/* CoreCourse */ "a"].getModuleBasicInfoByInstance(choiceId, 'choice', siteId);
                    yield this.prefetchAfterUpdate(_handlers_prefetch__WEBPACK_IMPORTED_MODULE_12__[/* AddonModChoicePrefetchHandler */ "a"].instance, module, courseId, undefined, siteId);
                }
                catch (_a) {
                    // Ignore errors.
                }
                // Sync finished, set sync time.
                yield this.setSyncTime(syncId, siteId);
                return result;
            });
        }
    }
    AddonModChoiceSyncProvider.AUTO_SYNCED = 'addon_mod_choice_autom_synced';
    AddonModChoiceSyncProvider.ɵfac = function AddonModChoiceSyncProvider_Factory(t) { return new (t || AddonModChoiceSyncProvider)(); };
    AddonModChoiceSyncProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_13__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModChoiceSyncProvider, factory: AddonModChoiceSyncProvider.ɵfac, providedIn: 'root' });
    return AddonModChoiceSyncProvider;
})();
const AddonModChoiceSync = Object(_singletons__WEBPACK_IMPORTED_MODULE_8__[/* makeSingleton */ "P"])(AddonModChoiceSyncProvider);


/***/ }),

/***/ "0mo+":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Tibetan [bo]
//! author : Thupten N. Chakrishar : https://github.com/vajradog

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var symbolMap = {
            1: '༡',
            2: '༢',
            3: '༣',
            4: '༤',
            5: '༥',
            6: '༦',
            7: '༧',
            8: '༨',
            9: '༩',
            0: '༠',
        },
        numberMap = {
            '༡': '1',
            '༢': '2',
            '༣': '3',
            '༤': '4',
            '༥': '5',
            '༦': '6',
            '༧': '7',
            '༨': '8',
            '༩': '9',
            '༠': '0',
        };

    var bo = moment.defineLocale('bo', {
        months: 'ཟླ་བ་དང་པོ_ཟླ་བ་གཉིས་པ_ཟླ་བ་གསུམ་པ_ཟླ་བ་བཞི་པ_ཟླ་བ་ལྔ་པ_ཟླ་བ་དྲུག་པ_ཟླ་བ་བདུན་པ_ཟླ་བ་བརྒྱད་པ_ཟླ་བ་དགུ་པ_ཟླ་བ་བཅུ་པ_ཟླ་བ་བཅུ་གཅིག་པ_ཟླ་བ་བཅུ་གཉིས་པ'.split(
            '_'
        ),
        monthsShort: 'ཟླ་1_ཟླ་2_ཟླ་3_ཟླ་4_ཟླ་5_ཟླ་6_ཟླ་7_ཟླ་8_ཟླ་9_ཟླ་10_ཟླ་11_ཟླ་12'.split(
            '_'
        ),
        monthsShortRegex: /^(ཟླ་\d{1,2})/,
        monthsParseExact: true,
        weekdays: 'གཟའ་ཉི་མ་_གཟའ་ཟླ་བ་_གཟའ་མིག་དམར་_གཟའ་ལྷག་པ་_གཟའ་ཕུར་བུ_གཟའ་པ་སངས་_གཟའ་སྤེན་པ་'.split(
            '_'
        ),
        weekdaysShort: 'ཉི་མ་_ཟླ་བ་_མིག་དམར་_ལྷག་པ་_ཕུར་བུ_པ་སངས་_སྤེན་པ་'.split(
            '_'
        ),
        weekdaysMin: 'ཉི_ཟླ_མིག_ལྷག_ཕུར_སངས_སྤེན'.split('_'),
        longDateFormat: {
            LT: 'A h:mm',
            LTS: 'A h:mm:ss',
            L: 'DD/MM/YYYY',
            LL: 'D MMMM YYYY',
            LLL: 'D MMMM YYYY, A h:mm',
            LLLL: 'dddd, D MMMM YYYY, A h:mm',
        },
        calendar: {
            sameDay: '[དི་རིང] LT',
            nextDay: '[སང་ཉིན] LT',
            nextWeek: '[བདུན་ཕྲག་རྗེས་མ], LT',
            lastDay: '[ཁ་སང] LT',
            lastWeek: '[བདུན་ཕྲག་མཐའ་མ] dddd, LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: '%s ལ་',
            past: '%s སྔན་ལ',
            s: 'ལམ་སང',
            ss: '%d སྐར་ཆ།',
            m: 'སྐར་མ་གཅིག',
            mm: '%d སྐར་མ',
            h: 'ཆུ་ཚོད་གཅིག',
            hh: '%d ཆུ་ཚོད',
            d: 'ཉིན་གཅིག',
            dd: '%d ཉིན་',
            M: 'ཟླ་བ་གཅིག',
            MM: '%d ཟླ་བ',
            y: 'ལོ་གཅིག',
            yy: '%d ལོ',
        },
        preparse: function (string) {
            return string.replace(/[༡༢༣༤༥༦༧༨༩༠]/g, function (match) {
                return numberMap[match];
            });
        },
        postformat: function (string) {
            return string.replace(/\d/g, function (match) {
                return symbolMap[match];
            });
        },
        meridiemParse: /མཚན་མོ|ཞོགས་ཀས|ཉིན་གུང|དགོང་དག|མཚན་མོ/,
        meridiemHour: function (hour, meridiem) {
            if (hour === 12) {
                hour = 0;
            }
            if (
                (meridiem === 'མཚན་མོ' && hour >= 4) ||
                (meridiem === 'ཉིན་གུང' && hour < 5) ||
                meridiem === 'དགོང་དག'
            ) {
                return hour + 12;
            } else {
                return hour;
            }
        },
        meridiem: function (hour, minute, isLower) {
            if (hour < 4) {
                return 'མཚན་མོ';
            } else if (hour < 10) {
                return 'ཞོགས་ཀས';
            } else if (hour < 17) {
                return 'ཉིན་གུང';
            } else if (hour < 20) {
                return 'དགོང་དག';
            } else {
                return 'མཚན་མོ';
            }
        },
        week: {
            dow: 0, // Sunday is the first day of the week.
            doy: 6, // The week that contains Jan 6th is the first week of the year.
        },
    });

    return bo;

})));


/***/ }),

/***/ "0oRe":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseFormatSingleActivityComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fXoL");
/* harmony import */ var _features_course_services_module_delegate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("yQ+R");
/* harmony import */ var _features_course_components_unsupported_module_unsupported_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("5Yqf");
/* harmony import */ var _components_dynamic_component_dynamic_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("w+Pn");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






/**
 * Component to display single activity format. It will determine the right component to use and instantiate it.
 *
 * The instantiated component will receive the course and the module as inputs.
 */
let CoreCourseFormatSingleActivityComponent = /*@__PURE__*/ (() => {
    class CoreCourseFormatSingleActivityComponent {
        constructor() {
            this.completionChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"](); // Notify when any module completion changes.
            this.data = {}; // Data to pass to the component.
        }
        /**
         * Detect changes on input properties.
         */
        ngOnChanges(changes) {
            var _a, _b;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!changes.course || !changes.sections) {
                    return;
                }
                if (!this.course || !this.sections || !this.sections.length) {
                    return;
                }
                // In single activity the module should only have 1 section and 1 module. Get the module.
                const module = (_b = (_a = this.sections) === null || _a === void 0 ? void 0 : _a[0].modules) === null || _b === void 0 ? void 0 : _b[0];
                this.data.courseId = this.course.id;
                this.data.module = module;
                if (module && !this.componentClass) {
                    // We haven't obtained the class yet. Get it now.
                    const component = yield _features_course_services_module_delegate__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseModuleDelegate */ "a"].getMainComponent(this.course, module);
                    this.componentClass = component || _features_course_components_unsupported_module_unsupported_module__WEBPACK_IMPORTED_MODULE_3__[/* CoreCourseUnsupportedModuleComponent */ "a"];
                }
            });
        }
        /**
         * Refresh the data.
         *
         * @param refresher Refresher.
         * @param done Function to call when done.
         * @param afterCompletionChange Whether the refresh is due to a completion change.
         * @return Promise resolved when done.
         */
        doRefresh(refresher, done, afterCompletionChange) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (afterCompletionChange) {
                    // Don't refresh the view after a completion change since completion isn't displayed.
                    return;
                }
                yield ((_a = this.dynamicComponent) === null || _a === void 0 ? void 0 : _a.callComponentFunction('doRefresh', [refresher, done]));
            });
        }
        /**
         * User entered the page that contains the component.
         */
        ionViewDidEnter() {
            var _a;
            (_a = this.dynamicComponent) === null || _a === void 0 ? void 0 : _a.callComponentFunction('ionViewDidEnter');
        }
        /**
         * User left the page that contains the component.
         */
        ionViewDidLeave() {
            var _a;
            (_a = this.dynamicComponent) === null || _a === void 0 ? void 0 : _a.callComponentFunction('ionViewDidLeave');
        }
    }
    CoreCourseFormatSingleActivityComponent.ɵfac = function CoreCourseFormatSingleActivityComponent_Factory(t) { return new (t || CoreCourseFormatSingleActivityComponent)(); };
    CoreCourseFormatSingleActivityComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵdefineComponent */ "sc"]({ type: CoreCourseFormatSingleActivityComponent, selectors: [["core-course-format-single-activity"]], viewQuery: function CoreCourseFormatSingleActivityComponent_Query(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵviewQuery */ "ud"](_components_dynamic_component_dynamic_component__WEBPACK_IMPORTED_MODULE_4__[/* CoreDynamicComponent */ "a"], true);
            }
            if (rf & 2) {
                var _t;
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵqueryRefresh */ "ed"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵloadQuery */ "Nc"]()) && (ctx.dynamicComponent = _t.first);
            }
        }, inputs: { course: "course", sections: "sections", downloadEnabled: "downloadEnabled", initialSectionId: "initialSectionId", initialSectionNumber: "initialSectionNumber", moduleId: "moduleId" }, outputs: { completionChanged: "completionChanged" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵNgOnChangesFeature */ "jc"]], decls: 1, vars: 2, consts: [[3, "component", "data"]], template: function CoreCourseFormatSingleActivityComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](0, "core-dynamic-component", 0);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("component", ctx.componentClass)("data", ctx.data);
            }
        }, directives: [_components_dynamic_component_dynamic_component__WEBPACK_IMPORTED_MODULE_4__[/* CoreDynamicComponent */ "a"]], encapsulation: 2 });
    return CoreCourseFormatSingleActivityComponent;
})();


/***/ }),

/***/ "0tRk":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Portuguese (Brazil) [pt-br]
//! author : Caio Ribeiro Pereira : https://github.com/caio-ribeiro-pereira

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var ptBr = moment.defineLocale('pt-br', {
        months: 'janeiro_fevereiro_março_abril_maio_junho_julho_agosto_setembro_outubro_novembro_dezembro'.split(
            '_'
        ),
        monthsShort: 'jan_fev_mar_abr_mai_jun_jul_ago_set_out_nov_dez'.split('_'),
        weekdays: 'domingo_segunda-feira_terça-feira_quarta-feira_quinta-feira_sexta-feira_sábado'.split(
            '_'
        ),
        weekdaysShort: 'dom_seg_ter_qua_qui_sex_sáb'.split('_'),
        weekdaysMin: 'do_2ª_3ª_4ª_5ª_6ª_sá'.split('_'),
        weekdaysParseExact: true,
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'DD/MM/YYYY',
            LL: 'D [de] MMMM [de] YYYY',
            LLL: 'D [de] MMMM [de] YYYY [às] HH:mm',
            LLLL: 'dddd, D [de] MMMM [de] YYYY [às] HH:mm',
        },
        calendar: {
            sameDay: '[Hoje às] LT',
            nextDay: '[Amanhã às] LT',
            nextWeek: 'dddd [às] LT',
            lastDay: '[Ontem às] LT',
            lastWeek: function () {
                return this.day() === 0 || this.day() === 6
                    ? '[Último] dddd [às] LT' // Saturday + Sunday
                    : '[Última] dddd [às] LT'; // Monday - Friday
            },
            sameElse: 'L',
        },
        relativeTime: {
            future: 'em %s',
            past: 'há %s',
            s: 'poucos segundos',
            ss: '%d segundos',
            m: 'um minuto',
            mm: '%d minutos',
            h: 'uma hora',
            hh: '%d horas',
            d: 'um dia',
            dd: '%d dias',
            M: 'um mês',
            MM: '%d meses',
            y: 'um ano',
            yy: '%d anos',
        },
        dayOfMonthOrdinalParse: /\d{1,2}º/,
        ordinal: '%dº',
        invalidDate: 'Data inválida',
    });

    return ptBr;

})));


/***/ }),

/***/ "0w4i":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModWorkshopPhaseInfoComponent; });
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("TEn/");
/* harmony import */ var _core_directives_fa_icon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("3CSS");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ofXK");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("sYmb");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








function AddonModWorkshopPhaseInfoComponent_ng_container_14_p_5_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "p", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "addon.mod_workshop.userplancurrentphase"), " ");
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](1, "ion-icon", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](3, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](6, "ion-icon", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const phase_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]().$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("href", phase_r1.switchUrl);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](5, 2, "addon.mod_workshop.switchphase" + phase_r1.code));
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](1, "translate");
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "addon.mod_workshop.tasktodo"));
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](1, "translate");
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "addon.mod_workshop.taskfail"));
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](1, "translate");
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "addon.mod_workshop.taskinfo"));
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](1, "translate");
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](1, 1, "addon.mod_workshop.taskdone"));
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_p_8_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "p", 24);
    }
    if (rf & 2) {
        const task_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]().$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("innerHTML", task_r6.details, _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵsanitizeHtml */ "hd"]);
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_9_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](0, "ion-icon", 12);
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_Template(rf, ctx) {
    if (rf & 1) {
        const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵrestoreView */ "gd"](_r15); const task_r6 = ctx.$implicit; const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"](2); return ctx_r14.runTask(task_r6); });
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_1_Template, 2, 3, "ion-icon", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_2_Template, 2, 3, "ion-icon", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_3_Template, 2, 3, "ion-icon", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](4, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_4_Template, 2, 3, "ion-icon", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](5, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](6, "h2", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](8, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_p_8_Template, 1, 1, "p", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](9, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_ion_icon_9_Template, 1, 0, "ion-icon", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const task_r6 = ctx.$implicit;
        const phase_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]().$implicit;
        const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵclassProp */ "qc"]("item-dimmed", phase_r1.code != ctx_r4.workshopPhase || task_r6.code == "submit" && !ctx_r4.showSubmit);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", task_r6.completed == null);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", task_r6.completed == "");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", task_r6.completed == "info");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", task_r6.completed == "1");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate */ "qd"](task_r6.title);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", task_r6.details);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", task_r6.link && task_r6.code != "submit");
    }
}
function AddonModWorkshopPhaseInfoComponent_ng_container_14_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](1, "ion-item-divider");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopPhaseInfoComponent_ng_container_14_p_5_Template, 3, 3, "p", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_6_Template, 7, 4, "ion-item", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](7, AddonModWorkshopPhaseInfoComponent_ng_container_14_ion_item_7_Template, 10, 9, "ion-item", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const phase_r1 = ctx.$implicit;
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-current", ctx_r0.workshopPhase == phase_r1.code ? "page" : "false");
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate */ "qd"](phase_r1.title);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r0.workshopPhase == phase_r1.code);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngIf", phase_r1.switchUrl);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngForOf", phase_r1.tasks);
    }
}
/**
 * Page that displays the phase info modal.
 */
let AddonModWorkshopPhaseInfoComponent = /*@__PURE__*/ (() => {
    class AddonModWorkshopPhaseInfoComponent {
        constructor() {
            this.showSubmit = false;
        }
        ngOnInit() {
            // Treat phases.
            for (const x in this.phases) {
                this.phases[x].tasks.forEach((task) => {
                    if (!task.link && (task.code == 'examples' || task.code == 'prepareexamples')) {
                        // Add links to manage examples.
                        task.link = this.externalUrl;
                    }
                });
                const action = this.phases[x].actions.find((action) => action.url && action.type == 'switchphase');
                this.phases[x].switchUrl = action ? action.url : '';
            }
        }
        /**
         * Close modal.
         */
        closeModal() {
            _singletons__WEBPACK_IMPORTED_MODULE_1__[/* ModalController */ "x"].dismiss();
        }
        /**
         * Open task.
         *
         * @param task Task to be done.
         */
        runTask(task) {
            if (task.code == 'submit') {
                // This will close the modal and go to the submit.
                _singletons__WEBPACK_IMPORTED_MODULE_1__[/* ModalController */ "x"].dismiss(true);
            }
            else if (task.link) {
                _services_utils_utils__WEBPACK_IMPORTED_MODULE_0__[/* CoreUtils */ "a"].openInBrowser(task.link);
            }
        }
    }
    AddonModWorkshopPhaseInfoComponent.ɵfac = function AddonModWorkshopPhaseInfoComponent_Factory(t) { return new (t || AddonModWorkshopPhaseInfoComponent)(); };
    AddonModWorkshopPhaseInfoComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineComponent */ "sc"]({ type: AddonModWorkshopPhaseInfoComponent, selectors: [["ng-component"]], inputs: { phases: "phases", workshopPhase: "workshopPhase", showSubmit: "showSubmit", externalUrl: "externalUrl" }, decls: 15, vars: 10, consts: [["slot", "start"], [3, "text"], ["slot", "end"], ["fill", "clear", 3, "click"], ["name", "fas-times", "slot", "icon-only", "aria-hidden", "true"], [4, "ngFor", "ngForOf"], ["class", "ion-text-wrap", 4, "ngIf"], ["class", "ion-text-wrap", "detail", "false", 3, "href", 4, "ngIf"], ["class", "ion-text-wrap", "detail", "false", "button", "", 3, "item-dimmed", "click", 4, "ngFor", "ngForOf"], [1, "ion-text-wrap"], ["detail", "false", 1, "ion-text-wrap", 3, "href"], ["slot", "start", "name", "fas-exchange-alt", "aria-hidden", "true"], ["slot", "end", "name", "fas-external-link-alt", "aria-hidden", "true"], ["detail", "false", "button", "", 1, "ion-text-wrap", 3, "click"], ["slot", "start", "name", "far-circle", 4, "ngIf"], ["slot", "start", "name", "fas-times-circle", "color", "danger", 4, "ngIf"], ["slot", "start", "name", "fas-info-circle", "color", "info", 4, "ngIf"], ["slot", "start", "name", "fas-check-circle", "color", "success", 4, "ngIf"], [3, "innerHTML", 4, "ngIf"], ["slot", "end", "name", "fas-external-link-alt", "aria-hidden", "true", 4, "ngIf"], ["slot", "start", "name", "far-circle"], ["slot", "start", "name", "fas-times-circle", "color", "danger"], ["slot", "start", "name", "fas-info-circle", "color", "info"], ["slot", "start", "name", "fas-check-circle", "color", "success"], [3, "innerHTML"]], template: function AddonModWorkshopPhaseInfoComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](0, "ion-header");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](1, "ion-toolbar");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](2, "ion-buttons", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](3, "ion-back-button", 1);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](4, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](5, "h2");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtext */ "pd"](6);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](7, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](8, "ion-buttons", 2);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](9, "ion-button", 3);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopPhaseInfoComponent_Template_ion_button_click_9_listener() { return ctx.closeModal(); });
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipe */ "Pc"](10, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelement */ "zc"](11, "ion-icon", 4);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](12, "ion-content");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementStart */ "Ec"](13, "ion-list");
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtemplate */ "nd"](14, AddonModWorkshopPhaseInfoComponent_ng_container_14_Template, 8, 5, "ng-container", 5);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵelementEnd */ "Dc"]();
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](3);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("text", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](4, 4, "core.back"));
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](3);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](7, 6, "addon.mod_workshop.userplan"));
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](3);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵpipeBind1 */ "Qc"](10, 8, "core.close"));
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵadvance */ "lc"](5);
                _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx.phases);
            }
        }, directives: [_ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonHeader */ "B"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonToolbar */ "zb"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonButtons */ "l"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonBackButton */ "g"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonBackButtonDelegate */ "h"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonButton */ "k"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonIcon */ "C"], _core_directives_fa_icon__WEBPACK_IMPORTED_MODULE_4__[/* CoreFaIconDirective */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonContent */ "u"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonList */ "O"], _angular_common__WEBPACK_IMPORTED_MODULE_5__[/* NgForOf */ "s"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonItemDivider */ "I"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonLabel */ "N"], _angular_common__WEBPACK_IMPORTED_MODULE_5__[/* NgIf */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_3__[/* IonItem */ "H"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_6__[/* TranslatePipe */ "d"]], encapsulation: 2 });
    return AddonModWorkshopPhaseInfoComponent;
})();


/***/ }),

/***/ "1ArG":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreToLocaleStringPipe; });
/* harmony import */ var _services_utils_time__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("Q98t");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("3j9v");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Filter to format a timestamp to a locale string. Timestamp can be in seconds or milliseconds.
 *
 * @deprecated since 3.6. Use coreFormatDate instead.
 */
let CoreToLocaleStringPipe = /*@__PURE__*/ (() => {
    class CoreToLocaleStringPipe {
        constructor() {
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_1__[/* CoreLogger */ "a"].getInstance('CoreToLocaleStringPipe');
        }
        /**
         * Format a timestamp to a locale string.
         *
         * @param timestamp The timestamp (can be in seconds or milliseconds).
         * @return Formatted time.
         */
        transform(timestamp) {
            if (typeof timestamp == 'string') {
                // Convert the value to a number.
                const numberTimestamp = parseInt(timestamp, 10);
                if (isNaN(numberTimestamp)) {
                    this.logger.error('Invalid value received', timestamp);
                    return timestamp;
                }
                timestamp = numberTimestamp;
            }
            if (timestamp < 0) {
                // Date not valid.
                return '';
            }
            if (timestamp < 100000000000) {
                // Timestamp is in seconds, convert it to milliseconds.
                timestamp = timestamp * 1000;
            }
            return _services_utils_time__WEBPACK_IMPORTED_MODULE_0__[/* CoreTimeUtils */ "a"].userDate(timestamp, 'core.strftimedatetimeshort');
        }
    }
    CoreToLocaleStringPipe.ɵfac = function CoreToLocaleStringPipe_Factory(t) { return new (t || CoreToLocaleStringPipe)(); };
    CoreToLocaleStringPipe.ɵpipe = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefinePipe */ "xc"]({ name: "coreToLocaleString", type: CoreToLocaleStringPipe, pure: true });
    return CoreToLocaleStringPipe;
})();


/***/ }),

/***/ "1Bn7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return getMode; });
/* unused harmony export setupConfig */
/* harmony import */ var _animation_096c6391_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("meiF");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "i", function() { return _animation_096c6391_js__WEBPACK_IMPORTED_MODULE_0__["a"]; });

/* harmony import */ var _ios_transition_48010460_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("lTIg");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "n", function() { return _ios_transition_48010460_js__WEBPACK_IMPORTED_MODULE_1__["iosTransitionAnimation"]; });

/* harmony import */ var _md_transition_464fd4a8_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("RQGG");
/* harmony import */ var _cubic_bezier_eea9a7a9_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("bC4P");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "m", function() { return _cubic_bezier_eea9a7a9_js__WEBPACK_IMPORTED_MODULE_3__["a"]; });

/* harmony import */ var _index_f49d994d_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("iWo5");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "j", function() { return _index_f49d994d_js__WEBPACK_IMPORTED_MODULE_4__["createGesture"]; });

/* harmony import */ var _ionic_global_63a97a32_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("E/Mt");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "l", function() { return _ionic_global_63a97a32_js__WEBPACK_IMPORTED_MODULE_5__["d"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "o", function() { return _ionic_global_63a97a32_js__WEBPACK_IMPORTED_MODULE_5__["a"]; });

/* harmony import */ var _helpers_dd7e4b7b_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("1vRN");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "h", function() { return _helpers_dd7e4b7b_js__WEBPACK_IMPORTED_MODULE_6__["c"]; });

/* harmony import */ var _index_9e3fe806_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("39oe");
/* harmony import */ var _index_c3ff7f2e_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("k4ps");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "a", function() { return _index_c3ff7f2e_js__WEBPACK_IMPORTED_MODULE_8__["b"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "b", function() { return _index_c3ff7f2e_js__WEBPACK_IMPORTED_MODULE_8__["d"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "c", function() { return _index_c3ff7f2e_js__WEBPACK_IMPORTED_MODULE_8__["a"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "d", function() { return _index_c3ff7f2e_js__WEBPACK_IMPORTED_MODULE_8__["c"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "e", function() { return _index_c3ff7f2e_js__WEBPACK_IMPORTED_MODULE_8__["e"]; });

/* harmony import */ var _index_0d58a5bf_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("r7QR");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "q", function() { return _index_0d58a5bf_js__WEBPACK_IMPORTED_MODULE_9__["a"]; });

/* harmony import */ var _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("7OTs");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "f", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["c"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "g", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["b"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "p", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["k"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "r", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["l"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "s", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["m"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "t", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["d"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "u", function() { return _overlays_28c23c35_js__WEBPACK_IMPORTED_MODULE_10__["o"]; });

/* harmony import */ var _gesture_controller_31cb6bb9_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("y08P");
/* harmony import */ var _index_7a8b7a1c_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("wEJo");
/* harmony import */ var _hardware_back_button_4a6b37fb_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("B4Jq");















const setupConfig = (config) => {
  const win = window;
  const Ionic = win.Ionic;
  if (Ionic && Ionic.config && Ionic.config.constructor.name !== 'Object') {
    console.error('ionic config was already initialized');
    return;
  }
  win.Ionic = win.Ionic || {};
  win.Ionic.config = Object.assign(Object.assign({}, win.Ionic.config), config);
  return win.Ionic.config;
};
const getMode = () => {
  const win = window;
  const config = win && win.Ionic && win.Ionic.config;
  if (config) {
    if (config.mode) {
      return config.mode;
    }
    else {
      return config.get('mode');
    }
  }
  return 'md';
};




/***/ }),

/***/ "1IpS":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModFeedbackComponentsModule; });
/* harmony import */ var _core_shared_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("L3Fv");
/* harmony import */ var _features_course_components_components_module__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Fjfc");
/* harmony import */ var _index_index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("hYz8");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





let AddonModFeedbackComponentsModule = /*@__PURE__*/ (() => {
    class AddonModFeedbackComponentsModule {
    }
    AddonModFeedbackComponentsModule.ɵmod = _angular_core__WEBPACK_IMPORTED_MODULE_3__[/* ɵɵdefineNgModule */ "wc"]({ type: AddonModFeedbackComponentsModule });
    AddonModFeedbackComponentsModule.ɵinj = _angular_core__WEBPACK_IMPORTED_MODULE_3__[/* ɵɵdefineInjector */ "vc"]({ factory: function AddonModFeedbackComponentsModule_Factory(t) { return new (t || AddonModFeedbackComponentsModule)(); }, providers: [], imports: [[
                _core_shared_module__WEBPACK_IMPORTED_MODULE_0__[/* CoreSharedModule */ "a"],
                _features_course_components_components_module__WEBPACK_IMPORTED_MODULE_1__[/* CoreCourseComponentsModule */ "a"],
            ]] });
    return AddonModFeedbackComponentsModule;
})();
(function () {
    (typeof ngJitMode === "undefined" || ngJitMode) && _angular_core__WEBPACK_IMPORTED_MODULE_3__[/* ɵɵsetNgModuleScope */ "ld"](AddonModFeedbackComponentsModule, { declarations: [_index_index__WEBPACK_IMPORTED_MODULE_2__[/* AddonModFeedbackIndexComponent */ "a"]], imports: [_core_shared_module__WEBPACK_IMPORTED_MODULE_0__[/* CoreSharedModule */ "a"],
            _features_course_components_components_module__WEBPACK_IMPORTED_MODULE_1__[/* CoreCourseComponentsModule */ "a"]], exports: [_index_index__WEBPACK_IMPORTED_MODULE_2__[/* AddonModFeedbackIndexComponent */ "a"]] });
})();


/***/ }),

/***/ "1Rj0":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCommentsCommentsComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fXoL");
/* harmony import */ var _services_comments__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("5pQw");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fjkH");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("9+EE");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("pHTc");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("bFG1");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("ofXK");
/* harmony import */ var _components_loading_loading__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("PgjG");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("TEn/");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("sYmb");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.











const _c0 = function (a0) { return { "$a": a0 }; };
function CoreCommentsCommentsComponent_ng_container_0_core_loading_1_button_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "button", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreCommentsCommentsComponent_ng_container_0_core_loading_1_button_1_Template_button_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r6); const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3); return ctx_r5.openComments($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind2 */ "Rc"](2, 1, "core.comments.commentscount", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction1 */ "ad"](4, _c0, ctx_r3.commentsCount)), " ");
    }
}
function CoreCommentsCommentsComponent_ng_container_0_core_loading_1_div_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.comments.commentsnotworking"), " ");
    }
}
function CoreCommentsCommentsComponent_ng_container_0_core_loading_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "core-loading", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](1, CoreCommentsCommentsComponent_ng_container_0_core_loading_1_button_1_Template, 3, 6, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](2, CoreCommentsCommentsComponent_ng_container_0_core_loading_1_div_2_Template, 3, 3, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("hideUntil", ctx_r1.commentsLoaded)("fullscreen", false);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r1.countError);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.countError);
    }
}
function CoreCommentsCommentsComponent_ng_container_0_ion_item_2_p_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "p", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind2 */ "Rc"](2, 1, "core.comments.commentscount", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction1 */ "ad"](4, _c0, ctx_r7.commentsCount)), " ");
    }
}
function CoreCommentsCommentsComponent_ng_container_0_ion_item_2_p_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.comments.commentsnotworking"), " ");
    }
}
function CoreCommentsCommentsComponent_ng_container_0_ion_item_2_Template(rf, ctx) {
    if (rf & 1) {
        const _r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreCommentsCommentsComponent_ng_container_0_ion_item_2_Template_ion_item_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r10); const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2); return ctx_r9.openComments($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](2, "core-loading", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](3, CoreCommentsCommentsComponent_ng_container_0_ion_item_2_p_3_Template, 3, 6, "p", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](4, CoreCommentsCommentsComponent_ng_container_0_ion_item_2_p_4_Template, 3, 3, "p", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("detail", !ctx_r2.countError && ctx_r2.commentsLoaded)("disabled", ctx_r2.countError);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("hideUntil", ctx_r2.commentsLoaded)("fullscreen", false);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r2.countError);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r2.countError);
    }
}
function CoreCommentsCommentsComponent_ng_container_0_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](1, CoreCommentsCommentsComponent_ng_container_0_core_loading_1_Template, 3, 4, "core-loading", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](2, CoreCommentsCommentsComponent_ng_container_0_ion_item_2_Template, 5, 6, "ion-item", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r0.showItem);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r0.showItem);
    }
}
/**
 * Component that displays the count of comments.
 */
let CoreCommentsCommentsComponent = /*@__PURE__*/ (() => {
    class CoreCommentsCommentsComponent {
        constructor() {
            this.area = '';
            this.showItem = false; // Show button as an item.
            this.commentsLoaded = false;
            this.commentsCount = '';
            this.countError = false;
            this.disabled = false;
            this.onLoading = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"]();
            this.disabled = _services_comments__WEBPACK_IMPORTED_MODULE_2__[/* CoreComments */ "a"].areCommentsDisabledInSite();
            // Update visibility if current site info is updated.
            this.updateSiteObserver = _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].SITE_UPDATED, () => {
                const wasDisabled = this.disabled;
                this.disabled = _services_comments__WEBPACK_IMPORTED_MODULE_2__[/* CoreComments */ "a"].areCommentsDisabledInSite();
                if (wasDisabled && !this.disabled) {
                    this.fetchData();
                }
            }, _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId());
            // Refresh comments if event received.
            this.refreshCommentsObserver = _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].on(_services_comments__WEBPACK_IMPORTED_MODULE_2__[/* CoreCommentsProvider */ "b"].REFRESH_COMMENTS_EVENT, (data) => {
                // Verify these comments need to be updated.
                if (this.undefinedOrEqual(data, 'contextLevel') && this.undefinedOrEqual(data, 'instanceId') &&
                    this.undefinedOrEqual(data, 'component') && this.undefinedOrEqual(data, 'itemId') &&
                    this.undefinedOrEqual(data, 'area')) {
                    _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].ignoreErrors(this.doRefresh());
                }
            }, _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId());
            // Refresh comments count if event received.
            this.commentsCountObserver = _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].on(_services_comments__WEBPACK_IMPORTED_MODULE_2__[/* CoreCommentsProvider */ "b"].COMMENTS_COUNT_CHANGED_EVENT, (data) => {
                // Verify these comments need to be updated.
                if (!this.commentsCount.endsWith('+') && this.undefinedOrEqual(data, 'contextLevel') &&
                    this.undefinedOrEqual(data, 'instanceId') && this.undefinedOrEqual(data, 'component') &&
                    this.undefinedOrEqual(data, 'itemId') && this.undefinedOrEqual(data, 'area') && !this.countError) {
                    let newNumber = parseInt(this.commentsCount, 10) + data.countChange;
                    newNumber = newNumber >= 0 ? newNumber : 0;
                    // Parse and unparse string.
                    this.commentsCount = newNumber + '';
                }
            }, _services_sites__WEBPACK_IMPORTED_MODULE_4__[/* CoreSites */ "b"].getCurrentSiteId());
        }
        /**
         * View loaded.
         */
        ngOnInit() {
            this.fetchData();
        }
        /**
         * Listen to changes.
         */
        ngOnChanges(changes) {
            // If something change, update the fields.
            if (changes && this.commentsLoaded) {
                this.fetchData();
            }
        }
        /**
         * Fetch comments data.
         */
        fetchData() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.disabled) {
                    return;
                }
                this.commentsLoaded = false;
                this.onLoading.emit(true);
                const commentsCount = yield _services_comments__WEBPACK_IMPORTED_MODULE_2__[/* CoreComments */ "a"].getCommentsCount(this.contextLevel, this.instanceId, this.component, this.itemId, this.area);
                this.commentsCount = commentsCount;
                this.countError = parseInt(this.commentsCount, 10) < 0;
                this.commentsLoaded = true;
                this.onLoading.emit(false);
            });
        }
        /**
         * Refresh comments.
         *
         * @return Promise resolved when done.
         */
        doRefresh() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                yield this.invalidateComments();
                yield this.fetchData();
            });
        }
        /**
         * Invalidate comments data.
         *
         * @return Promise resolved when done.
         */
        invalidateComments() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                yield _services_comments__WEBPACK_IMPORTED_MODULE_2__[/* CoreComments */ "a"].invalidateCommentsData(this.contextLevel, this.instanceId, this.component, this.itemId, this.area);
            });
        }
        /**
         * Opens the comments page.
         */
        openComments(e) {
            if (e) {
                e.preventDefault();
                e.stopPropagation();
            }
            if (this.disabled || this.countError) {
                return;
            }
            _services_navigator__WEBPACK_IMPORTED_MODULE_5__[/* CoreNavigator */ "a"].navigateToSitePath('comments/' + this.contextLevel + '/' + this.instanceId + '/' + this.component + '/' + this.itemId + '/', {
                params: {
                    area: this.area,
                    title: this.title,
                    courseId: this.courseId,
                },
            });
        }
        /**
         * Component destroyed.
         */
        ngOnDestroy() {
            var _a, _b, _c;
            (_a = this.updateSiteObserver) === null || _a === void 0 ? void 0 : _a.off();
            (_b = this.refreshCommentsObserver) === null || _b === void 0 ? void 0 : _b.off();
            (_c = this.commentsCountObserver) === null || _c === void 0 ? void 0 : _c.off();
        }
        /**
         * Check if a certain value in data is undefined or equal to this instance value.
         *
         * @param data Data object.
         * @param name Name of the property to check.
         * @return Whether it's undefined or equal.
         */
        undefinedOrEqual(data, name) {
            return typeof data[name] == 'undefined' || data[name] == this[name];
        }
    }
    CoreCommentsCommentsComponent.ɵfac = function CoreCommentsCommentsComponent_Factory(t) { return new (t || CoreCommentsCommentsComponent)(); };
    CoreCommentsCommentsComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵdefineComponent */ "sc"]({ type: CoreCommentsCommentsComponent, selectors: [["core-comments"]], inputs: { contextLevel: "contextLevel", instanceId: "instanceId", component: "component", itemId: "itemId", area: "area", title: "title", courseId: "courseId", showItem: "showItem" }, outputs: { onLoading: "onLoading" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵNgOnChangesFeature */ "jc"]], decls: 1, vars: 1, consts: [[4, "ngIf"], ["class", "margin", 3, "hideUntil", "fullscreen", 4, "ngIf"], ["button", "", 3, "detail", "disabled", "click", 4, "ngIf"], [1, "margin", 3, "hideUntil", "fullscreen"], ["class", "as-link", 3, "click", 4, "ngIf"], [1, "as-link", 3, "click"], ["button", "", 3, "detail", "disabled", "click"], [3, "hideUntil", "fullscreen"], ["class", "item-heading", 4, "ngIf"], [1, "item-heading"]], template: function CoreCommentsCommentsComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](0, CoreCommentsCommentsComponent_ng_container_0_Template, 3, 2, "ng-container", 0);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx.disabled);
            }
        }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_7__[/* NgIf */ "t"], _components_loading_loading__WEBPACK_IMPORTED_MODULE_8__[/* CoreLoadingComponent */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_9__[/* IonItem */ "H"], _ionic_angular__WEBPACK_IMPORTED_MODULE_9__[/* IonLabel */ "N"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_10__[/* TranslatePipe */ "d"]], encapsulation: 2 });
    return CoreCommentsCommentsComponent;
})();


/***/ }),

/***/ "1Y1L":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseModuleComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fXoL");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3LXp");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fjkH");
/* harmony import */ var _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("GBcW");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("ULAo");
/* harmony import */ var _features_course_services_module_delegate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("yQ+R");
/* harmony import */ var _features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("zbKZ");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("ofXK");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("TEn/");
/* harmony import */ var _directives_format_text__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("hMzs");
/* harmony import */ var _components_download_refresh_download_refresh__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("uHIS");
/* harmony import */ var _module_completion_legacy_module_completion_legacy__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("2D5N");
/* harmony import */ var _directives_fa_icon__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("3CSS");
/* harmony import */ var _module_completion_module_completion__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("P6fW");
/* harmony import */ var _ngx_translate_core__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("sYmb");
/* harmony import */ var _pipes_format_date__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("uYHD");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


















function CoreCourseModuleComponent_ng_container_0_ng_container_1_img_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](0, "img", 13);
    }
    if (rf & 2) {
        const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("src", ctx_r3.module.handlerData.icon, _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵsanitizeUrl */ "jd"])("alt", ctx_r3.modNameTranslated);
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-badge", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](1, "span", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("color", ctx_r4.module.handlerData.extraBadgeColor);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("innerHTML", ctx_r4.module.handlerData.extraBadge, _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵsanitizeHtml */ "hd"]);
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-badge", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.course.hiddenfromstudents"), " ");
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_8_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-badge", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.course.hiddenoncoursepage"), " ");
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_9_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "div", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](1, "ion-badge", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](4, "core-format-text", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](3, 4, "core.restricted"));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("text", ctx_r7.module.availabilityinfo)("contextInstanceId", ctx_r7.module.id)("courseId", ctx_r7.courseId);
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_10_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-badge", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.course.manualcompletionnotsynced"), " ");
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_core_course_module_completion_legacy_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "core-course-module-completion-legacy", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("completionChanged", function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_core_course_module_completion_legacy_1_Template_core_course_module_completion_legacy_completionChanged_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r14); const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4); return ctx_r13.completionChanged.emit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("completion", ctx_r11.module.completiondata)("moduleName", ctx_r11.module.name)("moduleId", ctx_r11.module.id);
    }
}
const _c0 = function (a0) { return { $a: a0 }; };
function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_ion_button_4_Template(rf, ctx) {
    if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_ion_button_4_Template_ion_button_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r17); const button_r15 = ctx.$implicit; const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4); return ctx_r16.buttonClicked($event, button_r15); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](2, "ion-icon", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const button_r15 = ctx.$implicit;
        const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("hidden", button_r15.hidden || ctx_r12.spinner || ctx_r12.module.handlerData.spinner);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind2 */ "Rc"](1, 3, button_r15.label, _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction1 */ "ad"](6, _c0, ctx_r12.module.handlerData.title)));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("name", button_r15.icon);
    }
}
const _c1 = function (a0) { return { "core-button-completion": a0 }; };
function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_Template(rf, ctx) {
    if (rf & 1) {
        const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "div", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](1, CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_core_course_module_completion_legacy_1_Template, 1, 3, "core-course-module-completion-legacy", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](2, "div", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](3, "core-download-refresh", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("action", function CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_Template_core_download_refresh_action_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3); return ctx_r18.download($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](4, CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_ion_button_4_Template, 3, 8, "ion-button", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction1 */ "ad"](7, _c1, ctx_r9.module.completiondata && ctx_r9.showLegacyCompletion));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r9.module.completiondata && ctx_r9.showLegacyCompletion);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("status", ctx_r9.downloadStatus)("enabled", ctx_r9.downloadEnabled)("canTrustDownload", ctx_r9.canCheckUpdates)("loading", ctx_r9.spinner || ctx_r9.module.handlerData.spinner);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r9.module.handlerData.buttons);
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_div_2_p_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](1, "strong");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtext */ "pd"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](4, "coreFormatDate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const date_r24 = ctx.$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate */ "qd"](date_r24.label);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind2 */ "Rc"](4, 2, date_r24.timestamp * 1000, "strftimedatetime"), " ");
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_div_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "div", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](1, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_div_2_p_1_Template, 5, 5, "p", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r20.module.dates);
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_core_course_module_completion_3_Template(rf, ctx) {
    if (rf & 1) {
        const _r26 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "core-course-module-completion", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("completionChanged", function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_core_course_module_completion_3_Template_core_course_module_completion_completionChanged_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r26); const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4); return ctx_r25.completionChanged.emit($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("completion", ctx_r21.module.completiondata)("moduleName", ctx_r21.module.name)("moduleId", ctx_r21.module.id)("showCompletionConditions", ctx_r21.showCompletionConditions)("showManualCompletion", ctx_r21.showManualCompletion);
    }
}
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_core_format_text_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](0, "core-format-text", 35);
    }
    if (rf & 2) {
        const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("text", ctx_r22.module.description)("contextInstanceId", ctx_r22.module.id)("courseId", ctx_r22.courseId);
    }
}
const _c2 = function (a0, a1) { return { "item-media": a0, "item-dimmed": a1 }; };
function CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](2, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_div_2_Template, 2, 1, "div", 29);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](3, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_core_course_module_completion_3_Template, 1, 5, "core-course-module-completion", 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](4, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_core_format_text_4_Template, 1, 3, "core-format-text", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵclassMapInterpolate1 */ "oc"]("ion-text-wrap core-course-module-handler core-module-module-info ", ctx_r10.module.handlerData.class, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpropertyInterpolate1 */ "Xc"]("id", "core-course-module-", ctx_r10.module.id, "-info");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction2 */ "bd"](8, _c2, ctx_r10.module.handlerData.icon, ctx_r10.module.visible === 0 || ctx_r10.module.uservisible === false));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r10.showActivityDates && ctx_r10.module.dates && ctx_r10.module.dates.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r10.module.completiondata);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r10.module.description);
    }
}
const _c3 = function (a0, a1, a2) { return { "has-module-info": a0, "item-media": a1, "item-dimmed": a2 }; };
function CoreCourseModuleComponent_ng_container_0_ng_container_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r28 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](1, "ion-item", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵlistener */ "Mc"]("click", function CoreCourseModuleComponent_ng_container_0_ng_container_1_Template_ion_item_click_1_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵrestoreView */ "gd"](_r28); const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2); return ctx_r27.moduleClicked($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](2, CoreCourseModuleComponent_ng_container_0_ng_container_1_img_2_Template, 1, 2, "img", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](3, "ion-label", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](4, "p", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](5, "core-format-text", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](6, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_6_Template, 2, 2, "ion-badge", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](7, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_7_Template, 3, 3, "ion-badge", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](8, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_8_Template, 3, 3, "ion-badge", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](9, CoreCourseModuleComponent_ng_container_0_ng_container_1_div_9_Template, 5, 6, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](10, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_badge_10_Template, 3, 3, "ion-badge", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](11, CoreCourseModuleComponent_ng_container_0_ng_container_1_div_11_Template, 5, 9, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](12, CoreCourseModuleComponent_ng_container_0_ng_container_1_ion_item_12_Template, 5, 11, "ion-item", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵclassMapInterpolate1 */ "oc"]("ion-text-wrap core-course-module-handler core-module-main-item ", ctx_r1.module.handlerData.class, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpropertyInterpolate1 */ "Xc"]("id", "core-course-module-", ctx_r1.module.id, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction3 */ "cd"](19, _c3, ctx_r1.hasInfo, ctx_r1.module.handlerData.icon, ctx_r1.module.visible === 0 || ctx_r1.module.uservisible === false))("button", ctx_r1.module.handlerData.action && ctx_r1.module.uservisible);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", ctx_r1.module.handlerData.a11yTitle);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.handlerData.icon);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("text", ctx_r1.module.handlerData.title)("contextInstanceId", ctx_r1.module.id)("courseId", ctx_r1.courseId);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", ctx_r1.module.handlerData.a11yTitle + ", " + ctx_r1.modNameTranslated);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.handlerData.extraBadge);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.visible === 0 && (!ctx_r1.section || ctx_r1.section.visible));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.visible !== 0 && ctx_r1.module.isStealth);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.availabilityinfo);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.completiondata == null ? null : ctx_r1.module.completiondata.offline);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.module.uservisible !== false);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r1.hasInfo);
    }
}
const _c4 = function (a2) { return ["core-course-module-handler", "core-module-loading", a2]; };
function CoreCourseModuleComponent_ng_container_0_ion_item_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelement */ "zc"](2, "ion-spinner");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipe */ "Pc"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpropertyInterpolate1 */ "Xc"]("id", "core-course-module-", ctx_r2.module.id, "");
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngClass", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpureFunction1 */ "ad"](6, _c4, ctx_r2.module.handlerData.class));
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", ctx_r2.module.handlerData.a11yTitle);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵattribute */ "mc"]("aria-label", _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵpipeBind1 */ "Qc"](3, 4, "core.loading"));
    }
}
function CoreCourseModuleComponent_ng_container_0_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](1, CoreCourseModuleComponent_ng_container_0_ng_container_1_Template, 13, 23, "ng-container", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](2, CoreCourseModuleComponent_ng_container_0_ion_item_2_Template, 4, 8, "ion-item", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r0.module.handlerData.loading);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r0.module.handlerData.loading);
    }
}
/**
 * Component to display a module entry in a list of modules.
 *
 * Example usage:
 *
 * <core-course-module [module]="module" [courseId]="courseId" (completionChanged)="onCompletionChange()"></core-course-module>
 */
let CoreCourseModuleComponent = /*@__PURE__*/ (() => {
    class CoreCourseModuleComponent {
        constructor() {
            this.showActivityDates = false; // Whether to show activity dates.
            this.showCompletionConditions = false; // Whether to show activity completion conditions.
            this.completionChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"](); // Notify when module completion changes.
            this.statusChanged = new _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* EventEmitter */ "t"](); // Notify when the download status changes.
            this.modNameTranslated = '';
            this.hasInfo = false;
            this.showLegacyCompletion = false; // Whether to show module completion in the old format.
            this.showManualCompletion = false; // Whether to show manual completion when completion conditions are disabled.
            this.statusCalculated = false;
            this.isDestroyed = false;
        }
        // eslint-disable-next-line @angular-eslint/no-input-rename
        set enabled(value) {
            var _a;
            this.downloadEnabled = value;
            if (!((_a = this.module.handlerData) === null || _a === void 0 ? void 0 : _a.showDownloadButton) || !this.downloadEnabled || this.statusCalculated) {
                return;
            }
            // First time that the download is enabled. Initialize the data.
            this.statusCalculated = true;
            this.spinner = true; // Show spinner while calculating the status.
            // Get current status to decide which icon should be shown.
            this.calculateAndShowStatus();
        }
        /**
         * Component being initialized.
         */
        ngOnInit() {
            var _a, _b;
            this.courseId = this.courseId || this.module.course;
            this.modNameTranslated = _features_course_services_course__WEBPACK_IMPORTED_MODULE_6__[/* CoreCourse */ "a"].translateModuleName(this.module.modname) || '';
            this.showLegacyCompletion = !((_a = _services_sites__WEBPACK_IMPORTED_MODULE_2__[/* CoreSites */ "b"].getCurrentSite()) === null || _a === void 0 ? void 0 : _a.isVersionGreaterEqualThan('3.11'));
            this.checkShowManualCompletion();
            if (!this.module.handlerData) {
                return;
            }
            this.module.handlerData.a11yTitle = (_b = this.module.handlerData.a11yTitle) !== null && _b !== void 0 ? _b : this.module.handlerData.title;
            this.hasInfo = !!(this.module.description ||
                (this.showActivityDates && this.module.dates && this.module.dates.length) ||
                (this.module.completiondata &&
                    ((this.showManualCompletion && !this.module.completiondata.isautomatic) ||
                        (this.showCompletionConditions && this.module.completiondata.isautomatic))));
            if (this.module.handlerData.showDownloadButton) {
                // Listen for changes on this module status, even if download isn't enabled.
                this.prefetchHandler = _features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_8__[/* CoreCourseModulePrefetchDelegate */ "a"].getPrefetchHandlerFor(this.module);
                this.canCheckUpdates = _features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_8__[/* CoreCourseModulePrefetchDelegate */ "a"].canCheckUpdates();
                this.statusObserver = _singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_4__[/* CoreEvents */ "b"].PACKAGE_STATUS_CHANGED, (data) => {
                    var _a;
                    if (!this.module || data.componentId != this.module.id || !this.prefetchHandler ||
                        data.component != this.prefetchHandler.component) {
                        return;
                    }
                    // Call determineModuleStatus to get the right status to display.
                    const status = _features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_8__[/* CoreCourseModulePrefetchDelegate */ "a"].determineModuleStatus(this.module, data.status);
                    if (this.downloadEnabled) {
                        // Download is enabled, show the status.
                        this.showStatus(status);
                    }
                    else if ((_a = this.module.handlerData) === null || _a === void 0 ? void 0 : _a.updateStatus) {
                        // Download isn't enabled but the handler defines a updateStatus function, call it anyway.
                        this.module.handlerData.updateStatus(status);
                    }
                }, _services_sites__WEBPACK_IMPORTED_MODULE_2__[/* CoreSites */ "b"].getCurrentSiteId());
            }
        }
        /**
         * Check whether manual completion should be shown.
         */
        checkShowManualCompletion() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                this.showManualCompletion = this.showCompletionConditions ||
                    (yield _features_course_services_module_delegate__WEBPACK_IMPORTED_MODULE_7__[/* CoreCourseModuleDelegate */ "a"].manualCompletionAlwaysShown(this.module));
            });
        }
        /**
         * Function called when the module is clicked.
         *
         * @param event Click event.
         */
        moduleClicked(event) {
            var _a;
            if (this.module.uservisible !== false && ((_a = this.module.handlerData) === null || _a === void 0 ? void 0 : _a.action)) {
                this.module.handlerData.action(event, this.module, this.courseId);
            }
        }
        /**
         * Function called when a button is clicked.
         *
         * @param event Click event.
         * @param button The clicked button.
         */
        buttonClicked(event, button) {
            if (!button || !button.action) {
                return;
            }
            event.preventDefault();
            event.stopPropagation();
            button.action(event, this.module, this.courseId);
        }
        /**
         * Download the module.
         *
         * @param refresh Whether it's refreshing.
         * @return Promise resolved when done.
         */
        download(refresh) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!this.prefetchHandler || !this.module) {
                    return;
                }
                // Show spinner since this operation might take a while.
                this.spinner = true;
                try {
                    // Get download size to ask for confirm if it's high.
                    const size = yield this.prefetchHandler.getDownloadSize(this.module, this.courseId, true);
                    yield _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_5__[/* CoreCourseHelper */ "a"].prefetchModule(this.prefetchHandler, this.module, size, this.courseId, refresh);
                    const eventData = {
                        sectionId: (_a = this.section) === null || _a === void 0 ? void 0 : _a.id,
                        moduleId: this.module.id,
                        courseId: this.courseId,
                    };
                    this.statusChanged.emit(eventData);
                }
                catch (error) {
                    // Error, hide spinner.
                    this.spinner = false;
                    if (!this.isDestroyed) {
                        _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, 'core.errordownloading', true);
                    }
                }
            });
        }
        /**
         * Show download buttons according to module status.
         *
         * @param status Module status.
         */
        showStatus(status) {
            var _a, _b;
            if (!status) {
                return;
            }
            this.spinner = false;
            this.downloadStatus = status;
            (_b = (_a = this.module.handlerData) === null || _a === void 0 ? void 0 : _a.updateStatus) === null || _b === void 0 ? void 0 : _b.call(_a, status);
        }
        /**
         * Calculate and show module status.
         *
         * @return Promise resolved when done.
         */
        calculateAndShowStatus() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!this.module || !this.courseId) {
                    return;
                }
                const status = yield _features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_8__[/* CoreCourseModulePrefetchDelegate */ "a"].getModuleStatus(this.module, this.courseId);
                this.showStatus(status);
            });
        }
        /**
         * Component destroyed.
         */
        ngOnDestroy() {
            var _a, _b;
            // this.statusObserver?.off();
            (_b = (_a = this.module.handlerData) === null || _a === void 0 ? void 0 : _a.onDestroy) === null || _b === void 0 ? void 0 : _b.call(_a);
            this.isDestroyed = true;
        }
    }
    CoreCourseModuleComponent.ɵfac = function CoreCourseModuleComponent_Factory(t) { return new (t || CoreCourseModuleComponent)(); };
    CoreCourseModuleComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵdefineComponent */ "sc"]({ type: CoreCourseModuleComponent, selectors: [["core-course-module"]], inputs: { module: "module", courseId: "courseId", section: "section", showActivityDates: "showActivityDates", showCompletionConditions: "showCompletionConditions", enabled: ["downloadEnabled", "enabled"] }, outputs: { completionChanged: "completionChanged", statusChanged: "statusChanged" }, decls: 1, vars: 1, consts: [[4, "ngIf"], ["role", "status", "class", "ion-text-wrap", "detail", "false", 3, "id", "ngClass", 4, "ngIf"], ["detail", "false", 3, "id", "ngClass", "button", "click"], ["slot", "start", "class", "core-module-icon", 3, "src", "alt", 4, "ngIf"], [1, "core-module-title"], [1, "item-heading"], ["contextLevel", "module", 3, "text", "contextInstanceId", "courseId"], ["class", "ion-text-wrap ion-text-start", 3, "color", 4, "ngIf"], ["class", "ion-text-wrap", 4, "ngIf"], ["class", "core-module-availabilityinfo", 4, "ngIf"], ["color", "warning", "class", "ion-text-wrap", 4, "ngIf"], ["slot", "end", "class", "buttons core-module-buttons", 3, "ngClass", 4, "ngIf"], ["detail", "false", 3, "id", "class", "ngClass", 4, "ngIf"], ["slot", "start", 1, "core-module-icon", 3, "src", "alt"], [1, "ion-text-wrap", "ion-text-start", 3, "color"], [3, "innerHTML"], [1, "ion-text-wrap"], [1, "core-module-availabilityinfo"], ["contextLevel", "module", 1, "ion-text-wrap", 3, "text", "contextInstanceId", "courseId"], ["color", "warning", 1, "ion-text-wrap"], ["slot", "end", 1, "buttons", "core-module-buttons", 3, "ngClass"], [3, "completion", "moduleName", "moduleId", "completionChanged", 4, "ngIf"], [1, "core-module-buttons-more"], ["size", "small", 3, "status", "enabled", "canTrustDownload", "loading", "action"], ["fill", "clear", "color", "dark", "size", "small", "class", "core-animate-show-hide", 3, "hidden", "click", 4, "ngFor", "ngForOf"], [3, "completion", "moduleName", "moduleId", "completionChanged"], ["fill", "clear", "color", "dark", "size", "small", 1, "core-animate-show-hide", 3, "hidden", "click"], ["slot", "icon-only", "aria-hidden", "true", 3, "name"], ["detail", "false", 3, "id", "ngClass"], ["class", "core-module-dates", 4, "ngIf"], [3, "completion", "moduleName", "moduleId", "showCompletionConditions", "showManualCompletion", "completionChanged", 4, "ngIf"], ["class", "core-module-description", "maxHeight", "80", "contextLevel", "module", 3, "text", "contextInstanceId", "courseId", 4, "ngIf"], [1, "core-module-dates"], [4, "ngFor", "ngForOf"], [3, "completion", "moduleName", "moduleId", "showCompletionConditions", "showManualCompletion", "completionChanged"], ["maxHeight", "80", "contextLevel", "module", 1, "core-module-description", 3, "text", "contextInstanceId", "courseId"], ["role", "status", "detail", "false", 1, "ion-text-wrap", 3, "id", "ngClass"]], template: function CoreCourseModuleComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵtemplate */ "nd"](0, CoreCourseModuleComponent_ng_container_0_Template, 3, 2, "ng-container", 0);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_1__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.module.handlerData && ctx.module.visibleoncoursepage !== 0);
            }
        }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_9__[/* NgIf */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_10__[/* IonItem */ "H"], _angular_common__WEBPACK_IMPORTED_MODULE_9__[/* NgClass */ "q"], _ionic_angular__WEBPACK_IMPORTED_MODULE_10__[/* IonLabel */ "N"], _directives_format_text__WEBPACK_IMPORTED_MODULE_11__[/* CoreFormatTextDirective */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_10__[/* IonBadge */ "j"], _components_download_refresh_download_refresh__WEBPACK_IMPORTED_MODULE_12__[/* CoreDownloadRefreshComponent */ "a"], _angular_common__WEBPACK_IMPORTED_MODULE_9__[/* NgForOf */ "s"], _module_completion_legacy_module_completion_legacy__WEBPACK_IMPORTED_MODULE_13__[/* CoreCourseModuleCompletionLegacyComponent */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_10__[/* IonButton */ "k"], _ionic_angular__WEBPACK_IMPORTED_MODULE_10__[/* IonIcon */ "C"], _directives_fa_icon__WEBPACK_IMPORTED_MODULE_14__[/* CoreFaIconDirective */ "a"], _module_completion_module_completion__WEBPACK_IMPORTED_MODULE_15__[/* CoreCourseModuleCompletionComponent */ "a"], _ionic_angular__WEBPACK_IMPORTED_MODULE_10__[/* IonSpinner */ "pb"]], pipes: [_ngx_translate_core__WEBPACK_IMPORTED_MODULE_16__[/* TranslatePipe */ "d"], _pipes_format_date__WEBPACK_IMPORTED_MODULE_17__[/* CoreFormatDatePipe */ "a"]], styles: ["[_nghost-%COMP%]   .item.core-module-main-item[_ngcontent-%COMP%]{--min-height:52px}[_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .buttons.core-module-buttons[_ngcontent-%COMP%], [_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .core-module-buttons[_ngcontent-%COMP%]{margin:0}[_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .core-module-buttons[_ngcontent-%COMP%], [_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .core-module-buttons-more[_ngcontent-%COMP%]{display:flex;flex-flow:row;align-items:center;z-index:1;justify-content:space-around;align-content:center}[_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .core-module-buttons-more[_ngcontent-%COMP%]   button[_ngcontent-%COMP%], [_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .core-module-buttons[_ngcontent-%COMP%]   core-course-module-completion[_ngcontent-%COMP%]{cursor:pointer;pointer-events:auto}[_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%]   .core-module-buttons[_ngcontent-%COMP%]   core-course-module-completion[_ngcontent-%COMP%]{text-align:center}[_nghost-%COMP%]   .core-module-module-info[_ngcontent-%COMP%]   ion-badge[_ngcontent-%COMP%]{text-align:start}[_nghost-%COMP%]   .core-module-module-info[_ngcontent-%COMP%]   .core-module-availabilityinfo[_ngcontent-%COMP%]{font-size:90%}[_nghost-%COMP%]   .core-module-module-info[_ngcontent-%COMP%]   .core-module-availabilityinfo[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%]{-webkit-margin-before:.5em;margin-block-start:.5em}[_nghost-%COMP%]   .core-module-loading[_ngcontent-%COMP%]{width:100%;text-align:center;padding-top:10px;clear:both}[_nghost-%COMP%]   .core-module-main-item[_ngcontent-%COMP%] + .core-module-module-info[_ngcontent-%COMP%]   ion-label[_ngcontent-%COMP%]{margin-top:0}[_nghost-%COMP%]   .core-module-main-item.has-module-info[_ngcontent-%COMP%]{--inner-border-width:0}[_nghost-%COMP%]   .core-module-module-info[_ngcontent-%COMP%]   ion-label[_ngcontent-%COMP%]{-webkit-margin-start:50px;margin-inline-start:50px}"] });
    return CoreCourseModuleComponent;
})();


/***/ }),

/***/ "1gmh":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreSettingsHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSettingsHelper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("nvXB");
/* harmony import */ var _services_cron__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("DtaS");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fjkH");
/* harmony import */ var _services_filepool__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("ozqY");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("bFG1");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("BaYo");
/* harmony import */ var _services_config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("BBqZ");
/* harmony import */ var _features_filter_services_filter__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("tS8V");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("3LXp");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("ULAo");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("j3ag");
/* harmony import */ var _classes_errors_error__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("93ts");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.















/**
 * Settings helper service.
 */
let CoreSettingsHelperProvider = /*@__PURE__*/ (() => {
    class CoreSettingsHelperProvider {
        constructor() {
            this.syncPromises = {};
            this.colorSchemes = [];
            this.currentColorScheme = "light" /* LIGHT */;
            this.prefersDark = window.matchMedia('(prefers-color-scheme: dark)');
            if (!_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.forceColorScheme) {
                // Update color scheme when a user enters or leaves a site, or when the site info is updated.
                const applySiteScheme = () => {
                    if (this.isColorSchemeDisabledInSite()) {
                        // Dark mode is disabled, force light mode.
                        this.setColorScheme("light" /* LIGHT */);
                    }
                    else {
                        // Reset color scheme settings.
                        this.initColorScheme();
                    }
                };
                _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].LOGIN, applySiteScheme.bind(this));
                _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].SITE_UPDATED, applySiteScheme.bind(this));
                _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].LOGOUT, () => {
                    // Reset color scheme settings.
                    this.initColorScheme();
                });
            }
            else {
                this.initColorScheme();
            }
            // Listen for changes to the prefers-color-scheme media query.
            this.prefersDark.addEventListener && this.prefersDark.addEventListener('change', this.toggleDarkModeListener.bind(this));
        }
        /**
         * Deletes files of a site and the tables that can be cleared.
         *
         * @param siteName Site Name.
         * @param siteId: Site ID.
         * @return Resolved with detailed new info when done.
         */
        deleteSiteStorage(siteName, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const siteInfo = {
                    cacheEntries: 0,
                    spaceUsage: 0,
                };
                siteName = yield _features_filter_services_filter__WEBPACK_IMPORTED_MODULE_9__[/* CoreFilter */ "a"].formatText(siteName, { clean: true, singleLine: true, filter: false }, [], siteId);
                const title = _singletons__WEBPACK_IMPORTED_MODULE_12__[/* Translate */ "L"].instant('core.settings.deletesitefilestitle');
                const message = _singletons__WEBPACK_IMPORTED_MODULE_12__[/* Translate */ "L"].instant('core.settings.deletesitefiles', { sitename: siteName });
                yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_10__[/* CoreDomUtils */ "a"].showConfirm(message, title);
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getSite(siteId);
                // Clear cache tables.
                const cleanSchemas = _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getSiteTableSchemasToClear(site);
                const promises = cleanSchemas.map((name) => site.getDb().deleteRecords(name));
                const filepoolService = _services_filepool__WEBPACK_IMPORTED_MODULE_4__[/* CoreFilepool */ "a"].instance;
                promises.push(site.deleteFolder().then(() => {
                    filepoolService.clearAllPackagesStatus(siteId);
                    filepoolService.clearFilepool(siteId);
                    _features_course_services_course__WEBPACK_IMPORTED_MODULE_11__[/* CoreCourse */ "a"].clearAllCoursesStatus(siteId);
                    siteInfo.spaceUsage = 0;
                    return;
                }).catch((error) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    if (error && error.code === FileError.NOT_FOUND_ERR) {
                        // Not found, set size 0.
                        filepoolService.clearAllPackagesStatus(siteId);
                        siteInfo.spaceUsage = 0;
                    }
                    else {
                        // Error, recalculate the site usage.
                        _services_utils_dom__WEBPACK_IMPORTED_MODULE_10__[/* CoreDomUtils */ "a"].showErrorModal('core.settings.errordeletesitefiles', true);
                        siteInfo.spaceUsage = yield site.getSpaceUsage();
                    }
                })).then(() => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].trigger(_singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].SITE_STORAGE_DELETED, {}, siteId);
                    siteInfo.cacheEntries = yield this.calcSiteClearRows(site);
                    return;
                })));
                yield Promise.all(promises);
                return siteInfo;
            });
        }
        /**
         * Calculates each site's usage, and the total usage.
         *
         * @param siteId ID of the site. Current site if undefined.
         * @return Resolved with detailed info when done.
         */
        getSiteSpaceUsage(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getSite(siteId);
                // Get space usage.
                const siteInfo = {
                    cacheEntries: 0,
                    spaceUsage: 0,
                };
                siteInfo.cacheEntries = yield this.calcSiteClearRows(site);
                siteInfo.spaceUsage = yield site.getTotalUsage();
                return siteInfo;
            });
        }
        /**
         * Calculate the number of rows to be deleted on a site.
         *
         * @param site Site object.
         * @return If there are rows to delete or not.
         */
        calcSiteClearRows(site) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const clearTables = _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getSiteTableSchemasToClear(site);
                let totalEntries = 0;
                yield Promise.all(clearTables.map((name) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () { return totalEntries = (yield site.getDb().countRecords(name)) + totalEntries; })));
                return totalEntries;
            });
        }
        /**
         * Get a certain processor from a list of processors.
         *
         * @param processors List of processors.
         * @param name Name of the processor to get.
         * @param fallback True to return first processor if not found, false to not return any. Defaults to true.
         * @return Processor.
         * @deprecated since 3.9.5. This function has been moved to AddonNotificationsHelperProvider.
         */
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        getProcessor(processors, name, fallback = true) {
            return;
        }
        /**
         * Return the components and notifications that have a certain processor.
         *
         * @param processorName Name of the processor to filter.
         * @param components Array of components.
         * @return Filtered components.
         * @deprecated since 3.9.5. This function has been moved to AddonNotificationsHelperProvider.
         */
        getProcessorComponents(processorName, components) {
            return components;
        }
        /**
         * Get the synchronization promise of a site.
         *
         * @param siteId ID of the site.
         * @return Sync promise or null if site is not being syncrhonized.
         */
        getSiteSyncPromise(siteId) {
            if (this.syncPromises[siteId]) {
                return this.syncPromises[siteId];
            }
        }
        /**
         * Synchronize a site.
         *
         * @param syncOnlyOnWifi True to sync only on wifi, false otherwise.
         * @param siteId ID of the site to synchronize.
         * @return Promise resolved when synchronized, rejected if failure.
         */
        synchronizeSite(syncOnlyOnWifi, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.syncPromises[siteId]) {
                    // There's already a sync ongoing for this site, return the promise.
                    return this.syncPromises[siteId];
                }
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getSite(siteId);
                const hasSyncHandlers = _services_cron__WEBPACK_IMPORTED_MODULE_2__[/* CoreCronDelegate */ "a"].hasManualSyncHandlers();
                if (site.isLoggedOut()) {
                    // Cannot sync logged out sites.
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_13__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_12__[/* Translate */ "L"].instant('core.settings.cannotsyncloggedout'));
                }
                else if (hasSyncHandlers && !_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isOnline()) {
                    // We need connection to execute sync.
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_13__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_12__[/* Translate */ "L"].instant('core.settings.cannotsyncoffline'));
                }
                else if (hasSyncHandlers && syncOnlyOnWifi && _services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isNetworkAccessLimited()) {
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_13__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_12__[/* Translate */ "L"].instant('core.settings.cannotsyncwithoutwifi'));
                }
                const syncPromise = Promise.all([
                    // Invalidate all the site files so they are re-downloaded.
                    _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].ignoreErrors(_services_filepool__WEBPACK_IMPORTED_MODULE_4__[/* CoreFilepool */ "a"].invalidateAllFiles(siteId)),
                    // Invalidate and synchronize site data.
                    site.invalidateWsCache(),
                    this.checkSiteLocalMobile(site),
                    _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].updateSiteInfo(site.getId()),
                    _services_cron__WEBPACK_IMPORTED_MODULE_2__[/* CoreCronDelegate */ "a"].forceSyncExecution(site.getId()),
                ]).then(() => {
                    return;
                });
                this.syncPromises[siteId] = syncPromise;
                try {
                    yield syncPromise;
                }
                finally {
                    delete this.syncPromises[siteId];
                }
            });
        }
        /**
         * Check if local_mobile was added to the site.
         *
         * @param site Site to check.
         * @return Promise resolved if no action needed.
         */
        checkSiteLocalMobile(site) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                try {
                    // Check if local_mobile was installed in Moodle.
                    yield site.checkIfLocalMobileInstalledAndNotUsed();
                }
                catch (_a) {
                    // Not added, nothing to do.
                    return;
                }
                // Local mobile was added. Throw invalid session to force reconnect and create a new token.
                _singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].trigger(_singletons_events__WEBPACK_IMPORTED_MODULE_3__[/* CoreEvents */ "b"].SESSION_EXPIRED, {}, site.getId());
                throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_13__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_12__[/* Translate */ "L"].instant('core.lostconnection'));
            });
        }
        /**
         * Upgrades from Font size to new zoom level.
         */
        upgradeZoomLevel() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Check old setting and update the new.
                try {
                    const fontSize = yield _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].get('CoreSettingsFontSize');
                    if (typeof fontSize == 'undefined') {
                        // Already upgraded.
                        return;
                    }
                    // Reset the value to solve edge cases.
                    _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].set(_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].SETTINGS_ZOOM_LEVEL, "normal" /* NORMAL */);
                    if (fontSize < 100) {
                        if (fontSize > 90) {
                            _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].set(_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].SETTINGS_ZOOM_LEVEL, "high" /* HIGH */);
                        }
                        else if (fontSize > 70) {
                            _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].set(_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].SETTINGS_ZOOM_LEVEL, "low" /* LOW */);
                        }
                    }
                    _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].delete('CoreSettingsFontSize');
                }
                catch (_a) {
                    // Already upgraded.
                    return;
                }
            });
        }
        /**
         * Get saved Zoom Level setting.
         *
         * @return The saved zoom Level option.
         */
        getZoomLevel() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].get(_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].SETTINGS_ZOOM_LEVEL, "normal" /* NORMAL */);
            });
        }
        /**
         * Get saved zoom level value.
         *
         * @return The saved zoom level value in %.
         */
        getZoom() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const zoomLevel = yield this.getZoomLevel();
                return _core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.zoomlevels[zoomLevel];
            });
        }
        /**
         * Init Settings related to DOM.
         */
        initDomSettings() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Set the font size based on user preference.
                const zoomLevel = yield this.getZoomLevel();
                this.applyZoomLevel(zoomLevel);
                this.initColorScheme();
            });
        }
        /**
         * Init the color scheme.
         */
        initColorScheme() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.forceColorScheme) {
                    this.setColorScheme(_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.forceColorScheme);
                }
                else {
                    const scheme = yield _services_config__WEBPACK_IMPORTED_MODULE_8__[/* CoreConfig */ "a"].get(_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].SETTINGS_COLOR_SCHEME, "light" /* LIGHT */);
                    this.setColorScheme(scheme);
                }
            });
        }
        /**
         * Check if color scheme is disabled in a site.
         *
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with whether color scheme is disabled.
         */
        isColorSchemeDisabled(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getSite(siteId);
                return this.isColorSchemeDisabledInSite(site);
            });
        }
        /**
         * Check if color scheme is disabled in a site.
         *
         * @param site Site instance. If not defined, current site.
         * @return Whether color scheme is disabled.
         */
        isColorSchemeDisabledInSite(site) {
            site = site || _services_sites__WEBPACK_IMPORTED_MODULE_5__[/* CoreSites */ "b"].getCurrentSite();
            return site ? site.isFeatureDisabled('NoDelegate_DarkMode') : false;
        }
        /**
         * Set document default font size.
         *
         * @param zoomLevel Zoom Level.
         */
        applyZoomLevel(zoomLevel) {
            const zoom = _core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.zoomlevels[zoomLevel];
            // @todo Since zoom is deprecated and fontSize is not working, we should do some research here.
            document.documentElement.style.zoom = zoom + '%';
        }
        /**
         * Get system allowed color schemes.
         *
         * @return Allowed color schemes.
         */
        getAllowedColorSchemes() {
            if (this.colorSchemes.length > 0) {
                return this.colorSchemes;
            }
            if (!_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.forceColorScheme) {
                this.colorSchemes.push("light" /* LIGHT */);
                this.colorSchemes.push("dark" /* DARK */);
                if (this.canIUsePrefersColorScheme()) {
                    this.colorSchemes.push("system" /* SYSTEM */);
                }
            }
            else {
                this.colorSchemes = [_core_constants__WEBPACK_IMPORTED_MODULE_7__[/* CoreConstants */ "a"].CONFIG.forceColorScheme];
            }
            return this.colorSchemes;
        }
        /**
         * Set body color scheme.
         *
         * @param colorScheme Name of the color scheme.
         */
        setColorScheme(colorScheme) {
            this.currentColorScheme = colorScheme;
            if (colorScheme == "system" /* SYSTEM */ && this.prefersDark) {
                this.toggleDarkMode(this.prefersDark.matches);
            }
            else {
                this.toggleDarkMode(colorScheme == "dark" /* DARK */);
            }
        }
        /**
         * Check if device can detect color scheme system preference.
         * https://caniuse.com/prefers-color-scheme
         *
         * @returns if the color scheme system preference is available.
         */
        canIUsePrefersColorScheme() {
            // The following check will check browser support but system may differ from that.
            return window.matchMedia('(prefers-color-scheme)').media !== 'not all';
        }
        /**
         * Listener function to toggle dark mode.
         */
        toggleDarkModeListener() {
            this.setColorScheme(this.currentColorScheme);
        }
        ;
        /**
         * Toggles dark mode based on enabled boolean.
         *
         * @param enable True to enable dark mode, false to disable.
         */
        toggleDarkMode(enable = false) {
            document.body.classList.toggle('dark', enable);
            _services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].setStatusBarColor();
        }
    }
    CoreSettingsHelperProvider.ɵfac = function CoreSettingsHelperProvider_Factory(t) { return new (t || CoreSettingsHelperProvider)(); };
    CoreSettingsHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_14__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreSettingsHelperProvider, factory: CoreSettingsHelperProvider.ɵfac, providedIn: 'root' });
    return CoreSettingsHelperProvider;
})();
const CoreSettingsHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_12__[/* makeSingleton */ "P"])(CoreSettingsHelperProvider);


/***/ }),

/***/ "1iFe":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreBytesToSizePipe; });
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("3j9v");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("vuGA");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Pipe to turn a number in bytes to a human readable size (e.g. 5,25 MB).
 */
let CoreBytesToSizePipe = /*@__PURE__*/ (() => {
    class CoreBytesToSizePipe {
        constructor() {
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_0__[/* CoreLogger */ "a"].getInstance('CoreBytesToSizePipe');
        }
        /**
         * Takes a number and turns it to a human readable size.
         *
         * @param value The bytes to convert.
         * @return Readable bytes.
         */
        transform(value) {
            if (typeof value == 'string') {
                // Convert the value to a number.
                const numberValue = parseInt(value, 10);
                if (isNaN(numberValue)) {
                    this.logger.error('Invalid value received', value);
                    return value;
                }
                value = numberValue;
            }
            return _services_utils_text__WEBPACK_IMPORTED_MODULE_1__[/* CoreTextUtils */ "a"].bytesToSize(value);
        }
    }
    CoreBytesToSizePipe.ɵfac = function CoreBytesToSizePipe_Factory(t) { return new (t || CoreBytesToSizePipe)(); };
    CoreBytesToSizePipe.ɵpipe = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefinePipe */ "xc"]({ name: "coreBytesToSize", type: CoreBytesToSizePipe, pure: true });
    return CoreBytesToSizePipe;
})();


/***/ }),

/***/ "1ppg":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Filipino [fil]
//! author : Dan Hagman : https://github.com/hagmandan
//! author : Matthew Co : https://github.com/matthewdeeco

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var fil = moment.defineLocale('fil', {
        months: 'Enero_Pebrero_Marso_Abril_Mayo_Hunyo_Hulyo_Agosto_Setyembre_Oktubre_Nobyembre_Disyembre'.split(
            '_'
        ),
        monthsShort: 'Ene_Peb_Mar_Abr_May_Hun_Hul_Ago_Set_Okt_Nob_Dis'.split('_'),
        weekdays: 'Linggo_Lunes_Martes_Miyerkules_Huwebes_Biyernes_Sabado'.split(
            '_'
        ),
        weekdaysShort: 'Lin_Lun_Mar_Miy_Huw_Biy_Sab'.split('_'),
        weekdaysMin: 'Li_Lu_Ma_Mi_Hu_Bi_Sab'.split('_'),
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'MM/D/YYYY',
            LL: 'MMMM D, YYYY',
            LLL: 'MMMM D, YYYY HH:mm',
            LLLL: 'dddd, MMMM DD, YYYY HH:mm',
        },
        calendar: {
            sameDay: 'LT [ngayong araw]',
            nextDay: '[Bukas ng] LT',
            nextWeek: 'LT [sa susunod na] dddd',
            lastDay: 'LT [kahapon]',
            lastWeek: 'LT [noong nakaraang] dddd',
            sameElse: 'L',
        },
        relativeTime: {
            future: 'sa loob ng %s',
            past: '%s ang nakalipas',
            s: 'ilang segundo',
            ss: '%d segundo',
            m: 'isang minuto',
            mm: '%d minuto',
            h: 'isang oras',
            hh: '%d oras',
            d: 'isang araw',
            dd: '%d araw',
            M: 'isang buwan',
            MM: '%d buwan',
            y: 'isang taon',
            yy: '%d taon',
        },
        dayOfMonthOrdinalParse: /\d{1,2}/,
        ordinal: function (number) {
            return number;
        },
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 4, // The week that contains Jan 4th is the first week of the year.
        },
    });

    return fil;

})));


/***/ }),

/***/ "1rYy":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Armenian [hy-am]
//! author : Armendarabyan : https://github.com/armendarabyan

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var hyAm = moment.defineLocale('hy-am', {
        months: {
            format: 'հունվարի_փետրվարի_մարտի_ապրիլի_մայիսի_հունիսի_հուլիսի_օգոստոսի_սեպտեմբերի_հոկտեմբերի_նոյեմբերի_դեկտեմբերի'.split(
                '_'
            ),
            standalone: 'հունվար_փետրվար_մարտ_ապրիլ_մայիս_հունիս_հուլիս_օգոստոս_սեպտեմբեր_հոկտեմբեր_նոյեմբեր_դեկտեմբեր'.split(
                '_'
            ),
        },
        monthsShort: 'հնվ_փտր_մրտ_ապր_մյս_հնս_հլս_օգս_սպտ_հկտ_նմբ_դկտ'.split('_'),
        weekdays: 'կիրակի_երկուշաբթի_երեքշաբթի_չորեքշաբթի_հինգշաբթի_ուրբաթ_շաբաթ'.split(
            '_'
        ),
        weekdaysShort: 'կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ'.split('_'),
        weekdaysMin: 'կրկ_երկ_երք_չրք_հնգ_ուրբ_շբթ'.split('_'),
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'DD.MM.YYYY',
            LL: 'D MMMM YYYY թ.',
            LLL: 'D MMMM YYYY թ., HH:mm',
            LLLL: 'dddd, D MMMM YYYY թ., HH:mm',
        },
        calendar: {
            sameDay: '[այսօր] LT',
            nextDay: '[վաղը] LT',
            lastDay: '[երեկ] LT',
            nextWeek: function () {
                return 'dddd [օրը ժամը] LT';
            },
            lastWeek: function () {
                return '[անցած] dddd [օրը ժամը] LT';
            },
            sameElse: 'L',
        },
        relativeTime: {
            future: '%s հետո',
            past: '%s առաջ',
            s: 'մի քանի վայրկյան',
            ss: '%d վայրկյան',
            m: 'րոպե',
            mm: '%d րոպե',
            h: 'ժամ',
            hh: '%d ժամ',
            d: 'օր',
            dd: '%d օր',
            M: 'ամիս',
            MM: '%d ամիս',
            y: 'տարի',
            yy: '%d տարի',
        },
        meridiemParse: /գիշերվա|առավոտվա|ցերեկվա|երեկոյան/,
        isPM: function (input) {
            return /^(ցերեկվա|երեկոյան)$/.test(input);
        },
        meridiem: function (hour) {
            if (hour < 4) {
                return 'գիշերվա';
            } else if (hour < 12) {
                return 'առավոտվա';
            } else if (hour < 17) {
                return 'ցերեկվա';
            } else {
                return 'երեկոյան';
            }
        },
        dayOfMonthOrdinalParse: /\d{1,2}|\d{1,2}-(ին|րդ)/,
        ordinal: function (number, period) {
            switch (period) {
                case 'DDD':
                case 'w':
                case 'W':
                case 'DDDo':
                    if (number === 1) {
                        return number + '-ին';
                    }
                    return number + '-րդ';
                default:
                    return number;
            }
        },
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 7, // The week that contains Jan 7th is the first week of the year.
        },
    });

    return hyAm;

})));


/***/ }),

/***/ "1vRN":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return addEventListener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return removeEventListener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return componentOnReady; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return getAriaLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return renderHiddenInput; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return debounceEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return getElementRoot; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return findItemLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return inheritAttributes; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return clamp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return hasShadowDom; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return assert; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return isEndSide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return debounce; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return now; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return pointerCoord; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return raf; });
/**
 * Waits for a component to be ready for
 * both custom element and non-custom element builds.
 * If non-custom element build, el.componentOnReady
 * will be used.
 * For custom element builds, we wait a frame
 * so that the inner contents of the component
 * have a chance to render.
 *
 * Use this utility rather than calling
 * el.componentOnReady yourself.
 */
const componentOnReady = (el, callback) => {
  if (el.componentOnReady) {
    el.componentOnReady().then((resolvedEl) => callback(resolvedEl));
  }
  else {
    raf(() => callback(el));
  }
};
/**
 * Elements inside of web components sometimes need to inherit global attributes
 * set on the host. For example, the inner input in `ion-input` should inherit
 * the `title` attribute that developers set directly on `ion-input`. This
 * helper function should be called in componentWillLoad and assigned to a variable
 * that is later used in the render function.
 *
 * This does not need to be reactive as changing attributes on the host element
 * does not trigger a re-render.
 */
const inheritAttributes = (el, attributes = []) => {
  const attributeObject = {};
  attributes.forEach(attr => {
    if (el.hasAttribute(attr)) {
      const value = el.getAttribute(attr);
      if (value !== null) {
        attributeObject[attr] = el.getAttribute(attr);
      }
      el.removeAttribute(attr);
    }
  });
  return attributeObject;
};
const addEventListener = (el, eventName, callback, opts) => {
  if (typeof window !== 'undefined') {
    const win = window;
    const config = win && win.Ionic && win.Ionic.config;
    if (config) {
      const ael = config.get('_ael');
      if (ael) {
        return ael(el, eventName, callback, opts);
      }
      else if (config._ael) {
        return config._ael(el, eventName, callback, opts);
      }
    }
  }
  return el.addEventListener(eventName, callback, opts);
};
const removeEventListener = (el, eventName, callback, opts) => {
  if (typeof window !== 'undefined') {
    const win = window;
    const config = win && win.Ionic && win.Ionic.config;
    if (config) {
      const rel = config.get('_rel');
      if (rel) {
        return rel(el, eventName, callback, opts);
      }
      else if (config._rel) {
        return config._rel(el, eventName, callback, opts);
      }
    }
  }
  return el.removeEventListener(eventName, callback, opts);
};
/**
 * Gets the root context of a shadow dom element
 * On newer browsers this will be the shadowRoot,
 * but for older browser this may just be the
 * element itself.
 *
 * Useful for whenever you need to explicitly
 * do "myElement.shadowRoot!.querySelector(...)".
 */
const getElementRoot = (el, fallback = el) => {
  return el.shadowRoot || fallback;
};
/**
 * Patched version of requestAnimationFrame that avoids ngzone
 * Use only when you know ngzone should not run
 */
const raf = (h) => {
  if (typeof __zone_symbol__requestAnimationFrame === 'function') {
    return __zone_symbol__requestAnimationFrame(h);
  }
  if (typeof requestAnimationFrame === 'function') {
    return requestAnimationFrame(h);
  }
  return setTimeout(h);
};
const hasShadowDom = (el) => {
  return !!el.shadowRoot && !!el.attachShadow;
};
const findItemLabel = (componentEl) => {
  const itemEl = componentEl.closest('ion-item');
  if (itemEl) {
    return itemEl.querySelector('ion-label');
  }
  return null;
};
/**
 * This method is used for Ionic's input components that use Shadow DOM. In
 * order to properly label the inputs to work with screen readers, we need
 * to get the text content of the label outside of the shadow root and pass
 * it to the input inside of the shadow root.
 *
 * Referencing label elements by id from outside of the component is
 * impossible due to the shadow boundary, read more here:
 * https://developer.salesforce.com/blogs/2020/01/accessibility-for-web-components.html
 *
 * @param componentEl The shadow element that needs the aria label
 * @param inputId The unique identifier for the input
 */
const getAriaLabel = (componentEl, inputId) => {
  let labelText;
  // If the user provides their own label via the aria-labelledby attr
  // we should use that instead of looking for an ion-label
  const labelledBy = componentEl.getAttribute('aria-labelledby');
  // Grab the id off of the component in case they are using
  // a custom label using the label element
  const componentId = componentEl.id;
  let labelId = labelledBy !== null && labelledBy.trim() !== ''
    ? labelledBy
    : inputId + '-lbl';
  let label = labelledBy !== null && labelledBy.trim() !== ''
    ? document.getElementById(labelledBy)
    : findItemLabel(componentEl);
  if (label) {
    if (labelledBy === null) {
      label.id = labelId;
    }
    labelText = label.textContent;
    label.setAttribute('aria-hidden', 'true');
    // if there is no label, check to see if the user has provided
    // one by setting an id on the component and using the label element
  }
  else if (componentId.trim() !== '') {
    label = document.querySelector(`label[for="${componentId}"]`);
    if (label) {
      if (label.id !== '') {
        labelId = label.id;
      }
      else {
        label.id = labelId = `${componentId}-lbl`;
      }
      labelText = label.textContent;
    }
  }
  return { label, labelId, labelText };
};
/**
 * This method is used to add a hidden input to a host element that contains
 * a Shadow DOM. It does not add the input inside of the Shadow root which
 * allows it to be picked up inside of forms. It should contain the same
 * values as the host element.
 *
 * @param always Add a hidden input even if the container does not use Shadow
 * @param container The element where the input will be added
 * @param name The name of the input
 * @param value The value of the input
 * @param disabled If true, the input is disabled
 */
const renderHiddenInput = (always, container, name, value, disabled) => {
  if (always || hasShadowDom(container)) {
    let input = container.querySelector('input.aux-input');
    if (!input) {
      input = container.ownerDocument.createElement('input');
      input.type = 'hidden';
      input.classList.add('aux-input');
      container.appendChild(input);
    }
    input.disabled = disabled;
    input.name = name;
    input.value = value || '';
  }
};
const clamp = (min, n, max) => {
  return Math.max(min, Math.min(n, max));
};
const assert = (actual, reason) => {
  if (!actual) {
    const message = 'ASSERT: ' + reason;
    console.error(message);
    debugger; // tslint:disable-line
    throw new Error(message);
  }
};
const now = (ev) => {
  return ev.timeStamp || Date.now();
};
const pointerCoord = (ev) => {
  // get X coordinates for either a mouse click
  // or a touch depending on the given event
  if (ev) {
    const changedTouches = ev.changedTouches;
    if (changedTouches && changedTouches.length > 0) {
      const touch = changedTouches[0];
      return { x: touch.clientX, y: touch.clientY };
    }
    if (ev.pageX !== undefined) {
      return { x: ev.pageX, y: ev.pageY };
    }
  }
  return { x: 0, y: 0 };
};
/**
 * @hidden
 * Given a side, return if it should be on the end
 * based on the value of dir
 * @param side the side
 * @param isRTL whether the application dir is rtl
 */
const isEndSide = (side) => {
  const isRTL = document.dir === 'rtl';
  switch (side) {
    case 'start': return isRTL;
    case 'end': return !isRTL;
    default:
      throw new Error(`"${side}" is not a valid value for [side]. Use "start" or "end" instead.`);
  }
};
const debounceEvent = (event, wait) => {
  const original = event._original || event;
  return {
    _original: event,
    emit: debounce(original.emit.bind(original), wait)
  };
};
const debounce = (func, wait = 0) => {
  let timer;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(func, wait, ...args);
  };
};




/***/ }),

/***/ "1xZ4":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Catalan [ca]
//! author : Juan G. Hurtado : https://github.com/juanghurtado

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var ca = moment.defineLocale('ca', {
        months: {
            standalone: 'gener_febrer_març_abril_maig_juny_juliol_agost_setembre_octubre_novembre_desembre'.split(
                '_'
            ),
            format: "de gener_de febrer_de març_d'abril_de maig_de juny_de juliol_d'agost_de setembre_d'octubre_de novembre_de desembre".split(
                '_'
            ),
            isFormat: /D[oD]?(\s)+MMMM/,
        },
        monthsShort: 'gen._febr._març_abr._maig_juny_jul._ag._set._oct._nov._des.'.split(
            '_'
        ),
        monthsParseExact: true,
        weekdays: 'diumenge_dilluns_dimarts_dimecres_dijous_divendres_dissabte'.split(
            '_'
        ),
        weekdaysShort: 'dg._dl._dt._dc._dj._dv._ds.'.split('_'),
        weekdaysMin: 'dg_dl_dt_dc_dj_dv_ds'.split('_'),
        weekdaysParseExact: true,
        longDateFormat: {
            LT: 'H:mm',
            LTS: 'H:mm:ss',
            L: 'DD/MM/YYYY',
            LL: 'D MMMM [de] YYYY',
            ll: 'D MMM YYYY',
            LLL: 'D MMMM [de] YYYY [a les] H:mm',
            lll: 'D MMM YYYY, H:mm',
            LLLL: 'dddd D MMMM [de] YYYY [a les] H:mm',
            llll: 'ddd D MMM YYYY, H:mm',
        },
        calendar: {
            sameDay: function () {
                return '[avui a ' + (this.hours() !== 1 ? 'les' : 'la') + '] LT';
            },
            nextDay: function () {
                return '[demà a ' + (this.hours() !== 1 ? 'les' : 'la') + '] LT';
            },
            nextWeek: function () {
                return 'dddd [a ' + (this.hours() !== 1 ? 'les' : 'la') + '] LT';
            },
            lastDay: function () {
                return '[ahir a ' + (this.hours() !== 1 ? 'les' : 'la') + '] LT';
            },
            lastWeek: function () {
                return (
                    '[el] dddd [passat a ' +
                    (this.hours() !== 1 ? 'les' : 'la') +
                    '] LT'
                );
            },
            sameElse: 'L',
        },
        relativeTime: {
            future: "d'aquí %s",
            past: 'fa %s',
            s: 'uns segons',
            ss: '%d segons',
            m: 'un minut',
            mm: '%d minuts',
            h: 'una hora',
            hh: '%d hores',
            d: 'un dia',
            dd: '%d dies',
            M: 'un mes',
            MM: '%d mesos',
            y: 'un any',
            yy: '%d anys',
        },
        dayOfMonthOrdinalParse: /\d{1,2}(r|n|t|è|a)/,
        ordinal: function (number, period) {
            var output =
                number === 1
                    ? 'r'
                    : number === 2
                    ? 'n'
                    : number === 3
                    ? 'r'
                    : number === 4
                    ? 't'
                    : 'è';
            if (period === 'w' || period === 'W') {
                output = 'a';
            }
            return number + output;
        },
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 4, // The week that contains Jan 4th is the first week of the year.
        },
    });

    return ca;

})));


/***/ }),

/***/ "2/Bq":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export AddonModLessonPrefetchHandlerService */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModLessonPrefetchHandler; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("n9nU");
/* harmony import */ var _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("93ts");
/* harmony import */ var _features_course_classes_activity_prefetch_handler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("9d8J");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("ULAo");
/* harmony import */ var _services_filepool__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ozqY");
/* harmony import */ var _services_groups__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("mWdr");
/* harmony import */ var _services_plugin_file_delegate__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("js7F");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("j3ag");
/* harmony import */ var _components_password_modal_password_modal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("8+JY");
/* harmony import */ var _lesson__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("ovS5");
/* harmony import */ var _lesson_sync__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("UkMa");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
















/**
 * Handler to prefetch lessons.
 */
let AddonModLessonPrefetchHandlerService = /*@__PURE__*/ (() => {
    class AddonModLessonPrefetchHandlerService extends _features_course_classes_activity_prefetch_handler__WEBPACK_IMPORTED_MODULE_3__[/* CoreCourseActivityPrefetchHandlerBase */ "a"] {
        constructor() {
            super(...arguments);
            this.name = 'AddonModLesson';
            this.modName = 'lesson';
            this.component = _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLessonProvider */ "b"].COMPONENT;
            // Don't check timers to decrease positives. If a user performs some action it will be reflected in other items.
            this.updatesNames = /^configuration$|^.*files$|^grades$|^gradeitems$|^pages$|^answers$|^questionattempts$|^pagesviewed$/;
        }
        /**
         * Ask password.
         *
         * @return Promise resolved with the password.
         */
        askUserPassword() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Create and show the modal.
                const modalData = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_9__[/* CoreDomUtils */ "a"].openModal({
                    component: _components_password_modal_password_modal__WEBPACK_IMPORTED_MODULE_12__[/* AddonModLessonPasswordModalComponent */ "a"],
                });
                if (typeof modalData != 'string') {
                    throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_1__[/* CoreCanceledError */ "a"]();
                }
                return modalData;
            });
        }
        /**
         * Get the download size of a module.
         *
         * @param module Module.
         * @param courseId Course ID the module belongs to.
         * @param single True if we're downloading a single module, false if we're downloading a whole section.
         * @return Promise resolved with the size.
         */
        getDownloadSize(module, courseId, single) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const siteId = _services_sites__WEBPACK_IMPORTED_MODULE_8__[/* CoreSites */ "b"].getCurrentSiteId();
                let lesson = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getLesson(courseId, module.id, { siteId });
                // Get the lesson password if it's needed.
                const passwordData = yield this.getLessonPassword(lesson.id, {
                    readingStrategy: 2 /* ONLY_NETWORK */,
                    askPassword: single,
                    siteId,
                });
                lesson = passwordData.lesson || lesson;
                // Get intro files and media files.
                let files = lesson.mediafiles || [];
                files = files.concat(this.getIntroFilesFromInstance(module, lesson));
                const result = yield _services_plugin_file_delegate__WEBPACK_IMPORTED_MODULE_7__[/* CorePluginFileDelegate */ "a"].getFilesDownloadSize(files);
                // Get the pages to calculate the size.
                const pages = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getPages(lesson.id, {
                    cmId: module.id,
                    password: passwordData.password,
                    siteId,
                });
                pages.forEach((page) => {
                    result.size += page.filessizetotal;
                });
                return result;
            });
        }
        /**
         * Get the lesson password if needed. If not stored, it can ask the user to enter it.
         *
         * @param lessonId Lesson ID.
         * @param options Other options.
         * @return Promise resolved when done.
         */
        getLessonPassword(lessonId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                options.siteId = options.siteId || _services_sites__WEBPACK_IMPORTED_MODULE_8__[/* CoreSites */ "b"].getCurrentSiteId();
                // Get access information to check if password is needed.
                const accessInfo = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getAccessInformation(lessonId, options);
                if (!accessInfo.preventaccessreasons.length) {
                    // Password not needed.
                    return { accessInfo };
                }
                const passwordNeeded = accessInfo.preventaccessreasons.length == 1 &&
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].isPasswordProtected(accessInfo);
                if (!passwordNeeded) {
                    // Lesson cannot be played, reject.
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__[/* CoreError */ "a"](accessInfo.preventaccessreasons[0].message);
                }
                // The lesson requires a password. Check if there is one in DB.
                let password = yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_10__[/* CoreUtils */ "a"].ignoreErrors(_lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getStoredPassword(lessonId));
                if (password) {
                    try {
                        return this.validatePassword(lessonId, accessInfo, password, options);
                    }
                    catch (_a) {
                        // Error validating it.
                    }
                }
                // Ask for the password if allowed.
                if (!options.askPassword) {
                    // Cannot ask for password, reject.
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__[/* CoreError */ "a"](accessInfo.preventaccessreasons[0].message);
                }
                password = yield this.askUserPassword();
                return this.validatePassword(lessonId, accessInfo, password, options);
            });
        }
        /**
         * Invalidate the prefetched content.
         *
         * @param moduleId The module ID.
         * @param courseId The course ID the module belongs to.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateContent(moduleId, courseId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Only invalidate the data that doesn't ignore cache when prefetching.
                yield Promise.all([
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].invalidateLessonData(courseId),
                    _features_course_services_course__WEBPACK_IMPORTED_MODULE_4__[/* CoreCourse */ "a"].invalidateModule(moduleId),
                    _services_groups__WEBPACK_IMPORTED_MODULE_6__[/* CoreGroups */ "a"].invalidateActivityAllowedGroups(moduleId),
                ]);
            });
        }
        /**
         * Invalidate WS calls needed to determine module status.
         *
         * @param module Module.
         * @param courseId Course ID the module belongs to.
         * @return Promise resolved when invalidated.
         */
        invalidateModule(module, courseId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Invalidate data to determine if module is downloadable.
                const siteId = _services_sites__WEBPACK_IMPORTED_MODULE_8__[/* CoreSites */ "b"].getCurrentSiteId();
                const lesson = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getLesson(courseId, module.id, {
                    readingStrategy: 1 /* PREFER_CACHE */,
                    siteId,
                });
                yield Promise.all([
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].invalidateLessonData(courseId, siteId),
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].invalidateAccessInformation(lesson.id, siteId),
                ]);
            });
        }
        /**
         * Check if a module can be downloaded. If the function is not defined, we assume that all modules are downloadable.
         *
         * @param module Module.
         * @param courseId Course ID the module belongs to.
         * @return Whether the module can be downloaded. The promise should never be rejected.
         */
        isDownloadable(module, courseId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const siteId = _services_sites__WEBPACK_IMPORTED_MODULE_8__[/* CoreSites */ "b"].getCurrentSiteId();
                const lesson = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getLesson(courseId, module.id, { siteId });
                const accessInfo = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getAccessInformation(lesson.id, { cmId: module.id, siteId });
                // If it's a student and lesson isn't offline, it isn't downloadable.
                if (!accessInfo.canviewreports && !_lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].isLessonOffline(lesson)) {
                    return false;
                }
                // It's downloadable if there are no prevent access reasons or there is just 1 and it's password.
                return !accessInfo.preventaccessreasons.length ||
                    (accessInfo.preventaccessreasons.length == 1 && _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].isPasswordProtected(accessInfo));
            });
        }
        /**
         * Whether or not the handler is enabled on a site level.
         *
         * @return Promise resolved with a boolean indicating if the handler is enabled.
         */
        isEnabled() {
            return _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].isPluginEnabled();
        }
        /**
         * @inheritdoc
         */
        prefetch(module, courseId, single) {
            return this.prefetchPackage(module, courseId, this.prefetchLesson.bind(this, module, courseId, !!single));
        }
        /**
         * Prefetch a lesson.
         *
         * @param module Module.
         * @param courseId Course ID the module belongs to.
         * @param single True if we're downloading a single module, false if we're downloading a whole section.
         * @param siteId Site ID.
         * @return Promise resolved when done.
         */
        prefetchLesson(module, courseId, single, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const commonOptions = {
                    readingStrategy: 2 /* ONLY_NETWORK */,
                    siteId,
                };
                const modOptions = Object.assign({ cmId: module.id }, commonOptions);
                let lesson = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getLesson(courseId, module.id, commonOptions);
                // Get the lesson password if it's needed.
                const passwordData = yield this.getLessonPassword(lesson.id, {
                    readingStrategy: 2 /* ONLY_NETWORK */,
                    askPassword: single,
                    siteId,
                });
                lesson = passwordData.lesson || lesson;
                let accessInfo = passwordData.accessInfo;
                const password = passwordData.password;
                if (_lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].isLessonOffline(lesson) && !_lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].leftDuringTimed(accessInfo)) {
                    // The user didn't left during a timed session. Call launch retake to make sure there is a started retake.
                    accessInfo = yield this.launchRetake(lesson.id, password, modOptions, siteId);
                }
                const promises = [];
                // Download intro files and media files.
                let files = (lesson.mediafiles || []);
                files = files.concat(this.getIntroFilesFromInstance(module, lesson));
                promises.push(_services_filepool__WEBPACK_IMPORTED_MODULE_5__[/* CoreFilepool */ "a"].addFilesToQueue(siteId, files, this.component, module.id));
                if (_lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].isLessonOffline(lesson)) {
                    promises.push(this.prefetchPlayData(lesson, password, accessInfo.attemptscount, modOptions));
                }
                if (accessInfo.canviewreports) {
                    promises.push(this.prefetchGroupInfo(module.id, lesson.id, modOptions));
                    promises.push(this.prefetchReportsData(module.id, lesson.id, modOptions));
                }
                yield Promise.all(promises);
            });
        }
        /**
         * Launch a retake and return the updated access information.
         *
         * @param lessonId Lesson ID.
         * @param password Password (if needed).
         * @param modOptions Options.
         * @param siteId Site ID.
         */
        launchRetake(lessonId, password, modOptions, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // The user didn't left during a timed session. Call launch retake to make sure there is a started retake.
                yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].launchRetake(lessonId, password, undefined, false, siteId);
                const results = yield Promise.all([
                    _services_utils_utils__WEBPACK_IMPORTED_MODULE_10__[/* CoreUtils */ "a"].ignoreErrors(_services_filepool__WEBPACK_IMPORTED_MODULE_5__[/* CoreFilepool */ "a"].updatePackageDownloadTime(siteId, this.component, module.i)),
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getAccessInformation(lessonId, modOptions),
                ]);
                return results[1];
            });
        }
        /**
         * Prefetch data to play the lesson in offline.
         *
         * @param lesson Lesson.
         * @param password Password (if needed).
         * @param retake Retake to prefetch.
         * @param options Options.
         * @return Promise resolved when done.
         */
        prefetchPlayData(lesson, password, retake, modOptions) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const passwordOptions = Object.assign({ password }, modOptions);
                yield Promise.all([
                    this.prefetchPagesData(lesson, passwordOptions),
                    // Prefetch user timers to be able to calculate timemodified in offline.
                    _services_utils_utils__WEBPACK_IMPORTED_MODULE_10__[/* CoreUtils */ "a"].ignoreErrors(_lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getTimers(lesson.id, modOptions)),
                    // Prefetch viewed pages in last retake to calculate progress.
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getContentPagesViewedOnline(lesson.id, retake, modOptions),
                    // Prefetch question attempts in last retake for offline calculations.
                    _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getQuestionsAttemptsOnline(lesson.id, retake, modOptions),
                ]);
            });
        }
        /**
         * Prefetch data related to pages.
         *
         * @param lesson Lesson.
         * @param options Options.
         * @return Promise resolved when done.
         */
        prefetchPagesData(lesson, options) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const pages = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getPages(lesson.id, options);
                let hasRandomBranch = false;
                // Get the data for each page.
                const promises = pages.map((data) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    // Check if any page has a RANDOMBRANCH jump.
                    if (!hasRandomBranch) {
                        for (let i = 0; i < data.jumps.length; i++) {
                            if (data.jumps[i] == _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLessonProvider */ "b"].LESSON_RANDOMBRANCH) {
                                hasRandomBranch = true;
                                break;
                            }
                        }
                    }
                    // Get the page data. We don't pass accessInfo because we don't need to calculate the offline data.
                    const pageData = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getPageData(lesson, data.page.id, Object.assign({ includeContents: true, includeOfflineData: false }, options));
                    // Download the page files.
                    let pageFiles = pageData.contentfiles || [];
                    pageData.answers.forEach((answer) => {
                        pageFiles = pageFiles.concat(answer.answerfiles);
                        pageFiles = pageFiles.concat(answer.responsefiles);
                    });
                    yield _services_filepool__WEBPACK_IMPORTED_MODULE_5__[/* CoreFilepool */ "a"].addFilesToQueue(options.siteId, pageFiles, this.component, module.i);
                }));
                // Prefetch the list of possible jumps for offline navigation. Do it here because we know hasRandomBranch.
                promises.push(this.prefetchPossibleJumps(lesson.id, hasRandomBranch, options));
                yield Promise.all(promises);
            });
        }
        /**
         * Prefetch possible jumps.
         *
         * @param lessonId Lesson ID.
         * @param hasRandomBranch Whether any page has a random branch jump.
         * @param modOptions Options.
         * @return Promise resolved when done.
         */
        prefetchPossibleJumps(lessonId, hasRandomBranch, modOptions) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                try {
                    yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getPagesPossibleJumps(lessonId, modOptions);
                }
                catch (error) {
                    if (hasRandomBranch) {
                        // The WebSevice probably failed because RANDOMBRANCH aren't supported if the user hasn't seen any page.
                        throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_2__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_11__[/* Translate */ "L"].instant('addon.mod_lesson.errorprefetchrandombranch'));
                    }
                    throw error;
                }
            });
        }
        /**
         * Prefetch group info.
         *
         * @param moduleId Module ID.
         * @param lessonId Lesson ID.
         * @param modOptions Options.
         * @return Promise resolved when done.
         */
        prefetchGroupInfo(moduleId, lessonId, modOptions) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const groupInfo = yield _services_groups__WEBPACK_IMPORTED_MODULE_6__[/* CoreGroups */ "a"].getActivityGroupInfo(moduleId, false, undefined, modOptions.siteId, true);
                yield Promise.all(((_a = groupInfo.groups) === null || _a === void 0 ? void 0 : _a.map((group) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getRetakesOverview(lessonId, Object.assign({ groupId: group.id }, modOptions));
                }))) || []);
            });
        }
        /**
         * Prefetch reports data.
         *
         * @param moduleId Module ID.
         * @param lessonId Lesson ID.
         * @param modOptions Options.
         * @return Promise resolved when done.
         */
        prefetchReportsData(moduleId, lessonId, modOptions) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Always get all participants, even if there are no groups.
                const data = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getRetakesOverview(lessonId, modOptions);
                if (!data || !data.students) {
                    return;
                }
                // Prefetch the last retake for each user.
                yield Promise.all(data.students.map((student) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    var _a;
                    const lastRetake = (_a = student.attempts) === null || _a === void 0 ? void 0 : _a[student.attempts.length - 1];
                    if (!lastRetake) {
                        return;
                    }
                    const attempt = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getUserRetake(lessonId, lastRetake.try, Object.assign({ userId: student.id }, modOptions));
                    if (!(attempt === null || attempt === void 0 ? void 0 : attempt.answerpages)) {
                        return;
                    }
                    // Download embedded files in essays.
                    const files = [];
                    attempt.answerpages.forEach((answerPage) => {
                        var _a, _b;
                        if (!answerPage.page || answerPage.page.qtype != _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_ESSAY) {
                            return;
                        }
                        (_b = (_a = answerPage.answerdata) === null || _a === void 0 ? void 0 : _a.answers) === null || _b === void 0 ? void 0 : _b.forEach((answer) => {
                            files.push(..._services_filepool__WEBPACK_IMPORTED_MODULE_5__[/* CoreFilepool */ "a"].extractDownloadableFilesFromHtmlAsFakeFileObjects(answer[0]));
                        });
                    });
                    yield _services_filepool__WEBPACK_IMPORTED_MODULE_5__[/* CoreFilepool */ "a"].addFilesToQueue(modOptions.siteId, files, this.component, moduleId);
                })));
            });
        }
        /**
         * Validate the password.
         *
         * @param lessonId Lesson ID.
         * @param info Lesson access info.
         * @param pwd Password to check.
         * @param options Other options.
         * @return Promise resolved when done.
         */
        validatePassword(lessonId, accessInfo, password, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                options.siteId = options.siteId || _services_sites__WEBPACK_IMPORTED_MODULE_8__[/* CoreSites */ "b"].getCurrentSiteId();
                const lesson = yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].getLessonWithPassword(lessonId, Object.assign({ password }, options));
                // Password is ok, store it and return the data.
                yield _lesson__WEBPACK_IMPORTED_MODULE_13__[/* AddonModLesson */ "a"].storePassword(lesson.id, password, options.siteId);
                return {
                    password,
                    lesson,
                    accessInfo,
                };
            });
        }
        /**
         * Sync a module.
         *
         * @param module Module.
         * @param courseId Course ID the module belongs to
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when done.
         */
        sync(module, courseId, siteId) {
            return _lesson_sync__WEBPACK_IMPORTED_MODULE_14__[/* AddonModLessonSync */ "a"].syncLesson(module.instance, false, false, siteId);
        }
    }
    AddonModLessonPrefetchHandlerService.ɵfac = function AddonModLessonPrefetchHandlerService_Factory(t) { return ɵAddonModLessonPrefetchHandlerService_BaseFactory(t || AddonModLessonPrefetchHandlerService); };
    AddonModLessonPrefetchHandlerService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModLessonPrefetchHandlerService, factory: AddonModLessonPrefetchHandlerService.ɵfac, providedIn: 'root' });
    return AddonModLessonPrefetchHandlerService;
})();
const ɵAddonModLessonPrefetchHandlerService_BaseFactory = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetInheritedFactory */ "Gc"](AddonModLessonPrefetchHandlerService);
const AddonModLessonPrefetchHandler = Object(_singletons__WEBPACK_IMPORTED_MODULE_11__[/* makeSingleton */ "P"])(AddonModLessonPrefetchHandlerService);


/***/ }),

/***/ "20uA":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModWorkshopIndexComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _features_course_classes_main_activity_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Q2Ls");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ULAo");
/* harmony import */ var _services_groups__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("mWdr");
/* harmony import */ var _services_navigator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("pHTc");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("j3ag");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("fjkH");
/* harmony import */ var _services_handlers_module__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("TxeM");
/* harmony import */ var _services_workshop__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("i1f9");
/* harmony import */ var _services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("8/zp");
/* harmony import */ var _services_workshop_offline__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("EyWp");
/* harmony import */ var _services_workshop_sync__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("GuJL");
/* harmony import */ var _phase_phase__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("0w4i");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__("fXoL");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__("TEn/");
/* harmony import */ var _features_course_pages_contents_contents__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__("YUBR");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


















function AddonModWorkshopIndexComponent_core_context_menu_item_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "core-context-menu-item", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](1, "translate");
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 900)("content", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](1, 3, "core.openinbrowser"))("href", ctx_r0.externalUrl);
    }
}
function AddonModWorkshopIndexComponent_core_context_menu_item_3_Template(rf, ctx) {
    if (rf & 1) {
        const _r13 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-context-menu-item", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("action", function AddonModWorkshopIndexComponent_core_context_menu_item_3_Template_core_context_menu_item_action_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r13); const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r12.expandDescription(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 800)("content", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](1, 2, "core.moduleintro"));
    }
}
function AddonModWorkshopIndexComponent_core_context_menu_item_4_Template(rf, ctx) {
    if (rf & 1) {
        const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-context-menu-item", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("action", function AddonModWorkshopIndexComponent_core_context_menu_item_4_Template_core_context_menu_item_action_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r15); const ctx_r14 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r14.gotoBlog(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpropertyInterpolate */ "Wc"]("content", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](1, 2, "addon.blog.blog"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 750);
    }
}
function AddonModWorkshopIndexComponent_core_context_menu_item_5_Template(rf, ctx) {
    if (rf & 1) {
        const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-context-menu-item", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("action", function AddonModWorkshopIndexComponent_core_context_menu_item_5_Template_core_context_menu_item_action_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r17); const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r16.doRefresh(null, $event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 700)("content", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](1, 4, "core.refresh"))("iconAction", ctx_r3.refreshIcon)("closeOnClick", false);
    }
}
function AddonModWorkshopIndexComponent_core_context_menu_item_6_Template(rf, ctx) {
    if (rf & 1) {
        const _r19 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-context-menu-item", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("action", function AddonModWorkshopIndexComponent_core_context_menu_item_6_Template_core_context_menu_item_action_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r19); const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r18.doRefresh(null, $event, true); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 600)("content", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](1, 4, "core.settings.synchronizenow"))("iconAction", ctx_r4.syncIcon)("closeOnClick", false);
    }
}
function AddonModWorkshopIndexComponent_core_context_menu_item_7_Template(rf, ctx) {
    if (rf & 1) {
        const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-context-menu-item", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("action", function AddonModWorkshopIndexComponent_core_context_menu_item_7_Template_core_context_menu_item_action_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r21); const ctx_r20 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r20.prefetch($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 500)("content", ctx_r5.prefetchText)("iconAction", ctx_r5.prefetchStatusIcon)("closeOnClick", false);
    }
}
const _c0 = function (a0) { return { $a: a0 }; };
function AddonModWorkshopIndexComponent_core_context_menu_item_8_Template(rf, ctx) {
    if (rf & 1) {
        const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-context-menu-item", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("action", function AddonModWorkshopIndexComponent_core_context_menu_item_8_Template_core_context_menu_item_action_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r23); const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r22.removeFiles($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](1, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("priority", 200)("content", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind2 */ "Rc"](1, 3, "core.clearstoreddata", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpureFunction1 */ "ad"](6, _c0, ctx_r6.size)))("closeOnClick", false);
    }
}
function AddonModWorkshopIndexComponent_core_course_module_info_10_Template(rf, ctx) {
    if (rf & 1) {
        const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-course-module-info", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("completionChanged", function AddonModWorkshopIndexComponent_core_course_module_info_10_Template_core_course_module_info_completionChanged_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r25); const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r24.onCompletionChange(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("module", ctx_r7.module)("showManualCompletion", true);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "ion-icon", 26);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "ion-icon", 27);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "ion-icon", 28);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "ion-icon", 29);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_p_8_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "p", 30);
    }
    if (rf & 2) {
        const task_r28 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]().$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("innerHTML", task_r28.details, _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵsanitizeHtml */ "hd"]);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_9_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "ion-icon", 31);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r37 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_Template_ion_item_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r37); const task_r28 = ctx.$implicit; const ctx_r36 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3); return ctx_r36.runTask(task_r28); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_1_Template, 1, 0, "ion-icon", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_2_Template, 1, 0, "ion-icon", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_3_Template, 1, 0, "ion-icon", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](4, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_4_Template, 1, 0, "ion-icon", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](5, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](6, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](8, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_p_8_Template, 1, 1, "p", 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](9, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_ion_icon_9_Template, 1, 0, "ion-icon", 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const task_r28 = ctx.$implicit;
        const ctx_r27 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵclassProp */ "qc"]("item-dimmed", task_r28.code == "submit" && !ctx_r27.showSubmit);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", task_r28.completed == null);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", task_r28.completed == "");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", task_r28.completed == "info");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", task_r28.completed == "1");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](task_r28.title);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", task_r28.details);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", task_r28.link && task_r28.code != "submit");
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_ion_item_1_Template, 10, 9, "ion-item", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r26 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r26.phases[ctx_r26.workshop.phase].tasks);
    }
}
function AddonModWorkshopIndexComponent_ion_card_11_Template(rf, ctx) {
    if (rf & 1) {
        const _r39 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopIndexComponent_ion_card_11_Template_ion_item_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r39); const ctx_r38 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](); return ctx_r38.viewPhaseInfo(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopIndexComponent_ion_card_11_ng_container_5_Template, 2, 1, "ng-container", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](ctx_r8.phases[ctx_r8.workshop.phase].title);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r8.phases && ctx_r8.phases[ctx_r8.workshop.phase] && ctx_r8.phases[ctx_r8.workshop.phase].tasks && ctx_r8.phases[ctx_r8.workshop.phase].tasks.length);
    }
}
function AddonModWorkshopIndexComponent_ion_card_12_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](2, "ion-icon", 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind2 */ "Rc"](5, 1, "core.hasdatatosync", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpureFunction1 */ "ad"](4, _c0, ctx_r9.moduleName)));
    }
}
function AddonModWorkshopIndexComponent_ion_card_13_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](6, "core-format-text", 34);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 6, "core.description"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("text", ctx_r10.description)("component", ctx_r10.component)("componentId", ctx_r10.componentId)("contextInstanceId", ctx_r10.module.id)("courseId", ctx_r10.courseId);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](6, "core-format-text", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r46 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 6, "addon.mod_workshop.conclusion"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("component", ctx_r46.component)("componentId", ctx_r46.module.id)("text", ctx_r46.workshop.conclusion)("contextInstanceId", ctx_r46.module.id)("courseId", ctx_r46.courseId);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_2_ion_item_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](5, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r48 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](4, 2, "addon.mod_workshop.submissiongrade"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](ctx_r48.userGrades.submissionlongstrgrade);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_2_ion_item_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](5, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r49 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](4, 2, "addon.mod_workshop.gradinggrade"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](ctx_r49.userGrades.assessmentlongstrgrade);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item-divider", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_2_ion_item_6_Template, 7, 4, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](7, AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_2_ion_item_7_Template, 7, 4, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r47 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 3, "addon.mod_workshop.yourgrades"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r47.userGrades.submissionlongstrgrade);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r47.userGrades.assessmentlongstrgrade);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_1_Template, 7, 8, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ng_container_1_ion_card_2_Template, 8, 5, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r40.workshop.conclusion);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r40.userGrades);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](6, "core-format-text", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r41 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 6, "addon.mod_workshop.areainstructauthors"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("component", ctx_r41.component)("componentId", ctx_r41.module.id)("text", ctx_r41.workshop.instructauthors)("contextInstanceId", ctx_r41.module.id)("courseId", ctx_r41.courseId);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_h2_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "addon.mod_workshop.yoursubmission"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_h2_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "addon.mod_workshop.yoursubmissionwithassessments"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_5_p_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "addon.mod_workshop.noyoursubmission"));
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_5_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_5_p_2_Template, 3, 3, "p", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r52 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r52.submission);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_addon_mod_workshop_submission_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](0, "addon-mod-workshop-submission", 38);
    }
    if (rf & 2) {
        const ctx_r53 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("submission", ctx_r53.submission)("courseId", ctx_r53.workshop.course)("module", ctx_r53.module)("workshop", ctx_r53.workshop)("access", ctx_r53.access);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_ion_button_2_Template(rf, ctx) {
    if (rf & 1) {
        const _r59 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_ion_button_2_Template_ion_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r59); const ctx_r58 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4); return ctx_r58.gotoSubmit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](1, "ion-icon", 41);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](3, 1, "addon.mod_workshop.createsubmission"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_ion_button_3_Template(rf, ctx) {
    if (rf & 1) {
        const _r61 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_ion_button_3_Template_ion_button_click_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r61); const ctx_r60 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4); return ctx_r60.gotoSubmit(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](1, "ion-icon", 42);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](3, 1, "addon.mod_workshop.editsubmission"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_ion_button_2_Template, 4, 3, "ion-button", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_ion_button_3_Template, 4, 3, "ion-button", 39);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r54 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r54.access.creatingsubmissionallowed && !ctx_r54.submission);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r54.access.modifyingsubmissionallowed && ctx_r54.submission);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item-divider", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_div_14_ion_card_3_h2_3_Template, 3, 3, "h2", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](4, AddonModWorkshopIndexComponent_div_14_ion_card_3_h2_4_Template, 3, 3, "h2", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_5_Template, 3, 1, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_div_14_ion_card_3_addon_mod_workshop_submission_6_Template, 1, 5, "addon-mod-workshop-submission", 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](7, AddonModWorkshopIndexComponent_div_14_ion_card_3_ion_item_7_Template, 4, 2, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r42.workshop.phase != ctx_r42.PHASE_CLOSED || !ctx_r42.submission);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r42.workshop.phase == ctx_r42.PHASE_CLOSED && ctx_r42.submission);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r42.submission);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r42.submission);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r42.showSubmit);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_4_ion_card_1_ng_container_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](1, "addon-mod-workshop-submission", 44);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const submission_r64 = ctx.$implicit;
        const ctx_r63 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("submission", submission_r64)("courseId", ctx_r63.workshop.course)("module", ctx_r63.module)("workshop", ctx_r63.workshop)("access", ctx_r63.access);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_4_ion_card_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item-divider", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_div_14_ng_container_4_ion_card_1_ng_container_6_Template, 2, 5, "ng-container", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r62 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 2, "addon.mod_workshop.publishedsubmissions"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r62.publishedSubmissions);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_div_14_ng_container_4_ion_card_1_Template, 7, 4, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r43 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r43.publishedSubmissions && ctx_r43.publishedSubmissions.length);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](6, "core-format-text", 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r65 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 6, "addon.mod_workshop.areainstructreviewers"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("component", ctx_r65.component)("componentId", ctx_r65.module.id)("text", ctx_r65.workshop.instructreviewers)("contextInstanceId", ctx_r65.module.id)("courseId", ctx_r65.courseId);
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_2_ion_item_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "p");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](4, 1, "addon.mod_workshop.assignedassessmentsnone"));
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_2_ng_container_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](1, "addon-mod-workshop-submission", 45);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const assessment_r69 = ctx.$implicit;
        const ctx_r68 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("submission", assessment_r69.submission)("assessment", assessment_r69)("courseId", ctx_r68.workshop.course)("module", ctx_r68.module)("workshop", ctx_r68.workshop)("access", ctx_r68.access);
    }
}
const _c1 = function () { return []; };
function AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item-divider", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](5, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_2_ion_item_6_Template, 5, 3, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](7, AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_2_ng_container_7_Template, 2, 6, "ng-container", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r66 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](5, 3, "addon.mod_workshop.assignedassessments"));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", !ctx_r66.assessments || !ctx_r66.assessments.length);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r66.assessments || _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpureFunction0 */ "Zc"](5, _c1));
    }
}
function AddonModWorkshopIndexComponent_div_14_ng_container_5_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_1_Template, 7, 8, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ng_container_5_ion_card_2_Template, 8, 6, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const ctx_r44 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r44.workshop.phase == ctx_r44.PHASE_ASSESSMENT && ctx_r44.workshop.instructreviewers);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r44.canAssess);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_h2_3_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "addon.mod_workshop.submissionsreport"));
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_h2_4_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate */ "qd"](_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "addon.mod_workshop.gradesreport"));
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_ion_label_1_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-label", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.groupsseparate"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_ion_label_2_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-label", 49);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](2, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](2, 1, "core.groupsvisible"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_ion_select_option_5_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-select-option", 50);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const groupOpt_r78 = ctx.$implicit;
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("value", groupOpt_r78.id);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", groupOpt_r78.name, " ");
    }
}
const _c2 = function (a0) { return { header: a0 }; };
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_Template(rf, ctx) {
    if (rf & 1) {
        const _r80 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-item", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_ion_label_1_Template, 3, 3, "ion-label", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_ion_label_2_Template, 3, 3, "ion-label", 46);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](3, "ion-select", 47);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("ngModelChange", function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_Template_ion_select_ngModelChange_3_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r80); const ctx_r79 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3); return ctx_r79.group = $event; })("ionChange", function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_Template_ion_select_ionChange_3_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r80); const ctx_r81 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3); return ctx_r81.setGroup(ctx_r81.group); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_ion_select_option_5_Template, 2, 2, "ion-select-option", 48);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r72 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r72.groupInfo.separateGroups);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r72.groupInfo.visibleGroups);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngModel", ctx_r72.group)("interfaceOptions", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpureFunction1 */ "ad"](7, _c2, _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](4, 5, "core.group")));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r72.groupInfo.groups);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ng_container_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerStart */ "Cc"](0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](1, "addon-mod-workshop-submission", 44);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementContainerEnd */ "Bc"]();
    }
    if (rf & 2) {
        const submission_r82 = ctx.$implicit;
        const ctx_r73 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("submission", submission_r82)("courseId", ctx_r73.workshop.course)("module", ctx_r73.module)("workshop", ctx_r73.workshop)("access", ctx_r73.access);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_ion_col_2_Template(rf, ctx) {
    if (rf & 1) {
        const _r86 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-col");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-button", 52);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_ion_col_2_Template_ion_button_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r86); const ctx_r85 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4); return ctx_r85.gotoSubmissionsPage(ctx_r85.page - 1); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](2, "ion-icon", 53);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](4, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](4, 1, "core.previous"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_ion_col_3_Template(rf, ctx) {
    if (rf & 1) {
        const _r88 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-col");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-button", 40);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵlistener */ "Mc"]("click", function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_ion_col_3_Template_ion_button_click_1_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵrestoreView */ "gd"](_r88); const ctx_r87 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](4); return ctx_r87.gotoSubmissionsPage(ctx_r87.page + 1); });
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtext */ "pd"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipe */ "Pc"](3, "translate");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelement */ "zc"](4, "ion-icon", 54);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtextInterpolate1 */ "rd"](" ", _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵpipeBind1 */ "Qc"](3, 1, "core.next"), " ");
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-grid");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-row", 51);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_ion_col_2_Template, 5, 3, "ion-col", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_ion_col_3_Template, 5, 3, "ion-col", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r74 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r74.page > 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r74.hasNextPage);
    }
}
function AddonModWorkshopIndexComponent_div_14_ion_card_6_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "ion-card");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "ion-item-divider", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](2, "ion-label");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_div_14_ion_card_6_h2_3_Template, 3, 3, "h2", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](4, AddonModWorkshopIndexComponent_div_14_ion_card_6_h2_4_Template, 3, 3, "h2", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_item_5_Template, 6, 9, "ion-item", 36);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_div_14_ion_card_6_ng_container_6_Template, 2, 5, "ng-container", 43);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](7, AddonModWorkshopIndexComponent_div_14_ion_card_6_ion_grid_7_Template, 4, 2, "ion-grid", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r45 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r45.workshop.phase == ctx_r45.PHASE_SUBMISSION);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r45.workshop.phase > ctx_r45.PHASE_SUBMISSION);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r45.groupInfo && (ctx_r45.groupInfo.separateGroups || ctx_r45.groupInfo.visibleGroups));
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngForOf", ctx_r45.grades);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r45.page > 0 || ctx_r45.hasNextPage);
    }
}
function AddonModWorkshopIndexComponent_div_14_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "div");
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](1, AddonModWorkshopIndexComponent_div_14_ng_container_1_Template, 3, 2, "ng-container", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_div_14_ion_card_2_Template, 7, 8, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_div_14_ion_card_3_Template, 8, 5, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](4, AddonModWorkshopIndexComponent_div_14_ng_container_4_Template, 2, 1, "ng-container", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopIndexComponent_div_14_ng_container_5_Template, 3, 2, "ng-container", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_div_14_ion_card_6_Template, 8, 5, "ion-card", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r11.workshop.phase >= ctx_r11.PHASE_CLOSED);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r11.workshop.phase == ctx_r11.PHASE_SUBMISSION && ctx_r11.workshop.instructauthors);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r11.canSubmit);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r11.workshop.phase >= ctx_r11.PHASE_CLOSED);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r11.workshop.phase >= ctx_r11.PHASE_ASSESSMENT);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx_r11.access.canviewallsubmissions && ctx_r11.workshop.phase >= ctx_r11.PHASE_SUBMISSION && (ctx_r11.grades && ctx_r11.grades.length || ctx_r11.groupInfo && (ctx_r11.groupInfo.separateGroups || ctx_r11.groupInfo.visibleGroups)));
    }
}
/**
 * Component that displays a workshop index page.
 */
let AddonModWorkshopIndexComponent = /*@__PURE__*/ (() => {
    class AddonModWorkshopIndexComponent extends _features_course_classes_main_activity_component__WEBPACK_IMPORTED_MODULE_1__[/* CoreCourseModuleMainActivityComponent */ "a"] {
        constructor(content, courseContentsPage) {
            super('AddonModWorkshopIndexComponent', content, courseContentsPage);
            this.group = 0;
            this.component = _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopProvider */ "f"].COMPONENT;
            this.moduleName = 'workshop';
            this.page = 0;
            this.grades = [];
            this.assessments = [];
            this.publishedSubmissions = [];
            this.groupInfo = {
                groups: [],
                separateGroups: false,
                visibleGroups: false,
                defaultGroupId: 0,
            };
            this.canSubmit = false;
            this.showSubmit = false;
            this.canAssess = false;
            this.hasNextPage = false;
            this.PHASE_SETUP = _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_SETUP;
            this.PHASE_SUBMISSION = _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_SUBMISSION;
            this.PHASE_ASSESSMENT = _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_ASSESSMENT;
            this.PHASE_EVALUATION = _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_EVALUATION;
            this.PHASE_CLOSED = _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_CLOSED;
            this.offlineSubmissions = [];
            this.syncEventName = _services_workshop_sync__WEBPACK_IMPORTED_MODULE_13__[/* AddonModWorkshopSyncProvider */ "b"].AUTO_SYNCED;
            // Listen to submission and assessment changes.
            this.obsSubmissionChanged = _singletons_events__WEBPACK_IMPORTED_MODULE_8__[/* CoreEvents */ "b"].on(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopProvider */ "f"].SUBMISSION_CHANGED, (data) => {
                this.eventReceived(data);
            }, this.siteId);
            // Listen to submission and assessment changes.
            this.obsAssessmentSaved = _singletons_events__WEBPACK_IMPORTED_MODULE_8__[/* CoreEvents */ "b"].on(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopProvider */ "f"].ASSESSMENT_SAVED, (data) => {
                this.eventReceived(data);
            }, this.siteId);
            // Since most actions will take the user out of the app, we should refresh the view when the app is resumed.
            this.appResumeSubscription = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Platform */ "C"].resume.subscribe(() => {
                this.showLoadingAndRefresh(true);
            });
            // Refresh workshop on sync.
            this.syncObserver = _singletons_events__WEBPACK_IMPORTED_MODULE_8__[/* CoreEvents */ "b"].on(_services_workshop_sync__WEBPACK_IMPORTED_MODULE_13__[/* AddonModWorkshopSyncProvider */ "b"].AUTO_SYNCED, (data) => {
                // Update just when all database is synced.
                this.eventReceived(data);
            }, this.siteId);
        }
        /**
         * @inheritdoc
         */
        ngOnInit() {
            const _super = Object.create(null, {
                ngOnInit: { get: () => super.ngOnInit }
            });
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                _super.ngOnInit.call(this);
                yield this.loadContent(false, true);
                if (!this.workshop) {
                    return;
                }
                try {
                    yield _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].logView(this.workshop.id, this.workshop.name);
                    _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourse */ "a"].checkModuleCompletion(this.courseId, this.module.completiondata);
                }
                catch (error) {
                    // Ignore errors.
                }
            });
        }
        /**
         * Function called when we receive an event of submission changes.
         *
         * @param data Data received by the event.
         */
        eventReceived(data) {
            var _a;
            if (((_a = this.workshop) === null || _a === void 0 ? void 0 : _a.id) === data.workshopId) {
                this.showLoadingAndRefresh(true);
                // Check completion since it could be configured to complete once the user adds a new discussion or replies.
                _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourse */ "a"].checkModuleCompletion(this.courseId, this.module.completiondata);
            }
        }
        /**
         * Perform the invalidate content function.
         *
         * @return Resolved when done.
         */
        invalidateContent() {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const promises = [];
                promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateWorkshopData(this.courseId));
                if (this.workshop) {
                    promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateWorkshopAccessInformationData(this.workshop.id));
                    promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateUserPlanPhasesData(this.workshop.id));
                    if (this.canSubmit) {
                        promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateSubmissionsData(this.workshop.id));
                    }
                    if ((_a = this.access) === null || _a === void 0 ? void 0 : _a.canviewallsubmissions) {
                        promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateGradeReportData(this.workshop.id));
                        promises.push(_services_groups__WEBPACK_IMPORTED_MODULE_3__[/* CoreGroups */ "a"].invalidateActivityAllowedGroups(this.workshop.coursemodule));
                        promises.push(_services_groups__WEBPACK_IMPORTED_MODULE_3__[/* CoreGroups */ "a"].invalidateActivityGroupMode(this.workshop.coursemodule));
                    }
                    if (this.canAssess) {
                        promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateReviewerAssesmentsData(this.workshop.id));
                    }
                    promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateGradesData(this.workshop.id));
                    promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].invalidateWorkshopWSData(this.workshop.id));
                }
                yield Promise.all(promises);
            });
        }
        /**
         * Compares sync event data with current data to check if refresh content is needed.
         *
         * @param syncEventData Data receiven on sync observer.
         * @return True if refresh is needed, false otherwise.
         */
        isRefreshSyncNeeded(syncEventData) {
            var _a;
            if (this.workshop && syncEventData.workshopId == this.workshop.id) {
                // Refresh the data.
                (_a = this.content) === null || _a === void 0 ? void 0 : _a.scrollToTop();
                return true;
            }
            return false;
        }
        /**
         * Download feedback contents.
         *
         * @param refresh If it's refreshing content.
         * @param sync If it should try to sync.
         * @param showErrors If show errors to the user of hide them.
         * @return Promise resolved when done.
         */
        fetchContent(refresh = false, sync = false, showErrors = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                try {
                    this.workshop = yield _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].getWorkshop(this.courseId, this.module.id);
                    this.description = this.workshop.intro;
                    this.dataRetrieved.emit(this.workshop);
                    if (sync) {
                        // Try to synchronize the feedback.
                        yield this.syncActivity(showErrors);
                    }
                    // Check if there are answers stored in offline.
                    this.access = yield _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].getWorkshopAccessInformation(this.workshop.id, { cmId: this.module.id });
                    if (this.access.canviewallsubmissions) {
                        this.groupInfo = yield _services_groups__WEBPACK_IMPORTED_MODULE_3__[/* CoreGroups */ "a"].getActivityGroupInfo(this.workshop.coursemodule);
                        this.group = _services_groups__WEBPACK_IMPORTED_MODULE_3__[/* CoreGroups */ "a"].validateGroupId(this.group, this.groupInfo);
                    }
                    this.phases = yield _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].getUserPlanPhases(this.workshop.id, { cmId: this.module.id });
                    this.phases[this.workshop.phase].tasks.forEach((task) => {
                        if (!task.link && (task.code == 'examples' || task.code == 'prepareexamples')) {
                            // Add links to manage examples.
                            task.link = this.externalUrl;
                        }
                    });
                    // Check if there are info stored in offline.
                    this.hasOffline = yield _services_workshop_offline__WEBPACK_IMPORTED_MODULE_12__[/* AddonModWorkshopOffline */ "a"].hasWorkshopOfflineData(this.workshop.id);
                    if (this.hasOffline) {
                        this.offlineSubmissions = yield _services_workshop_offline__WEBPACK_IMPORTED_MODULE_12__[/* AddonModWorkshopOffline */ "a"].getSubmissions(this.workshop.id);
                    }
                    else {
                        this.offlineSubmissions = [];
                    }
                    yield this.setPhaseInfo();
                }
                finally {
                    this.fillContextMenu(refresh);
                }
            });
        }
        /**
         * Retrieves and shows submissions grade page.
         *
         * @param page Page number to be retrieved.
         * @return Resolved when done.
         */
        gotoSubmissionsPage(page) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const report = yield _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].getGradesReport(this.workshop.id, {
                    groupId: this.group,
                    page,
                    cmId: this.module.id,
                });
                const numEntries = (report && report.grades && report.grades.length) || 0;
                this.page = page;
                this.hasNextPage = numEntries >= _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopProvider */ "f"].PER_PAGE && ((this.page + 1) *
                    _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopProvider */ "f"].PER_PAGE) < report.totalcount;
                const grades = report.grades || [];
                this.grades = [];
                yield Promise.all(grades.map((grade) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    var _a, _b, _c, _d;
                    const submission = {
                        id: grade.submissionid,
                        workshopid: this.workshop.id,
                        example: false,
                        authorid: grade.userid,
                        timecreated: grade.submissionmodified,
                        timemodified: grade.submissionmodified,
                        title: grade.submissiontitle,
                        content: '',
                        contenttrust: 0,
                        attachment: 0,
                        grade: grade.submissiongrade,
                        gradeover: grade.submissiongradeover,
                        gradeoverby: grade.submissiongradeoverby,
                        published: !!grade.submissionpublished,
                        gradinggrade: grade.gradinggrade,
                        late: 0,
                        reviewedby: this.parseReviewer(grade.reviewedby),
                        reviewerof: this.parseReviewer(grade.reviewerof),
                    };
                    if (this.workshop.phase == _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_ASSESSMENT) {
                        submission.reviewedbydone = ((_a = grade.reviewedby) === null || _a === void 0 ? void 0 : _a.reduce((a, b) => a + (b.grade ? 1 : 0), 0)) || 0;
                        submission.reviewerofdone = ((_b = grade.reviewerof) === null || _b === void 0 ? void 0 : _b.reduce((a, b) => a + (b.grade ? 1 : 0), 0)) || 0;
                        submission.reviewedbycount = ((_c = grade.reviewedby) === null || _c === void 0 ? void 0 : _c.length) || 0;
                        submission.reviewerofcount = ((_d = grade.reviewerof) === null || _d === void 0 ? void 0 : _d.length) || 0;
                    }
                    const offlineData = yield _services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].applyOfflineData(submission, this.offlineSubmissions);
                    if (typeof offlineData != 'undefined') {
                        this.grades.push(offlineData);
                    }
                })));
            });
        }
        parseReviewer(reviewers = []) {
            return reviewers.map((reviewer) => {
                const parsed = {
                    grade: reviewer.grade,
                    gradinggrade: reviewer.gradinggrade,
                    gradinggradeover: reviewer.gradinggradeover,
                    id: reviewer.assessmentid,
                    reviewerid: reviewer.userid,
                    submissionid: reviewer.submissionid,
                    weight: reviewer.weight,
                    timecreated: 0,
                    timemodified: 0,
                    feedbackauthor: '',
                    gradinggradeoverby: 0,
                    feedbackattachmentfiles: [],
                    feedbackcontentfiles: [],
                    feedbackauthorattachment: 0,
                };
                return parsed;
            });
        }
        /**
         * Open task.
         *
         * @param task Task to be done.
         */
        runTask(task) {
            if (task.code == 'submit') {
                this.gotoSubmit();
            }
            else if (task.link) {
                _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].openInBrowser(task.link);
            }
        }
        /**
         * Go to submit page.
         */
        gotoSubmit() {
            var _a;
            if (this.canSubmit && ((this.access.creatingsubmissionallowed && !this.submission) ||
                (this.access.modifyingsubmissionallowed && this.submission))) {
                const params = {
                    module: this.module,
                    access: this.access,
                };
                const submissionId = ((_a = this.submission) === null || _a === void 0 ? void 0 : _a.id) || 0;
                _services_navigator__WEBPACK_IMPORTED_MODULE_4__[/* CoreNavigator */ "a"].navigateToSitePath(_services_handlers_module__WEBPACK_IMPORTED_MODULE_9__[/* AddonModWorkshopModuleHandlerService */ "b"].PAGE_NAME + `/${this.courseId}/${this.module.id}/${submissionId}/edit`, { params });
            }
        }
        /**
         * View Phase info.
         */
        viewPhaseInfo() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.phases) {
                    const modalData = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_5__[/* CoreDomUtils */ "a"].openModal({
                        component: _phase_phase__WEBPACK_IMPORTED_MODULE_14__[/* AddonModWorkshopPhaseInfoComponent */ "a"],
                        componentProps: {
                            phases: _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].objectToArray(this.phases),
                            workshopPhase: this.workshop.phase,
                            externalUrl: this.externalUrl,
                            showSubmit: this.showSubmit,
                        },
                    });
                    if (modalData === true) {
                        this.gotoSubmit();
                    }
                }
            });
        }
        /**
         * Set group to see the workshop.
         *
         * @param groupId Group Id.
         * @return Promise resolved when done.
         */
        setGroup(groupId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                this.group = groupId;
                yield this.gotoSubmissionsPage(0);
            });
        }
        /**
         * Convenience function to set current phase information.
         *
         * @return Promise resolved when done.
         */
        setPhaseInfo() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                this.submission = undefined;
                this.canAssess = false;
                this.assessments = [];
                this.userGrades = undefined;
                this.publishedSubmissions = [];
                this.canSubmit = _services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].canSubmit(this.workshop, this.access, this.phases[_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_SUBMISSION].tasks);
                this.showSubmit = this.canSubmit &&
                    ((this.access.creatingsubmissionallowed && !this.submission) ||
                        (this.access.modifyingsubmissionallowed && !!this.submission));
                const promises = [];
                if (this.canSubmit) {
                    promises.push(_services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].getUserSubmission(this.workshop.id, { cmId: this.module.id })
                        .then((submission) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                        this.submission = yield _services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].applyOfflineData(submission, this.offlineSubmissions);
                        return;
                    })));
                }
                if (this.access.canviewallsubmissions && this.workshop.phase >= _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_SUBMISSION) {
                    promises.push(this.gotoSubmissionsPage(this.page));
                }
                let assessPromise = Promise.resolve();
                if (this.workshop.phase >= _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_ASSESSMENT) {
                    this.canAssess = _services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].canAssess(this.workshop, this.access);
                    if (this.canAssess) {
                        assessPromise = _services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].getReviewerAssessments(this.workshop.id, {
                            cmId: this.module.id,
                        }).then((assessments) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                            yield Promise.all(assessments.map((assessment) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                                assessment.strategy = this.workshop.strategy;
                                if (!this.hasOffline) {
                                    return;
                                }
                                try {
                                    const offlineAssessment = yield _services_workshop_offline__WEBPACK_IMPORTED_MODULE_12__[/* AddonModWorkshopOffline */ "a"].getAssessment(this.workshop.id, assessment.id);
                                    assessment.offline = true;
                                    assessment.timemodified = Math.floor(offlineAssessment.timemodified / 1000);
                                }
                                catch (_a) {
                                    // Ignore errors.
                                }
                            })));
                            this.assessments = assessments;
                            return;
                        }));
                    }
                }
                if (this.workshop.phase == _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshopPhase */ "e"].PHASE_CLOSED) {
                    promises.push(_services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].getGrades(this.workshop.id, { cmId: this.module.id }).then((grades) => {
                        this.userGrades = grades.submissionlongstrgrade || grades.assessmentlongstrgrade ? grades : undefined;
                        return;
                    }));
                    if (this.access.canviewpublishedsubmissions) {
                        promises.push(assessPromise.then(() => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                            const submissions = yield _services_workshop__WEBPACK_IMPORTED_MODULE_10__[/* AddonModWorkshop */ "a"].getSubmissions(this.workshop.id, { cmId: this.module.id });
                            this.publishedSubmissions = submissions.filter((submission) => {
                                if (submission.published) {
                                    submission.reviewedby = [];
                                    this.assessments.forEach((assessment) => {
                                        if (assessment.submissionid == submission.id) {
                                            submission.reviewedby.push(_services_workshop_helper__WEBPACK_IMPORTED_MODULE_11__[/* AddonModWorkshopHelper */ "a"].realGradeValue(this.workshop, assessment));
                                        }
                                    });
                                    return true;
                                }
                                return false;
                            });
                            return;
                        })));
                    }
                }
                yield Promise.all(promises);
            });
        }
        /**
         * Performs the sync of the activity.
         *
         * @return Promise resolved when done.
         */
        sync() {
            return _services_workshop_sync__WEBPACK_IMPORTED_MODULE_13__[/* AddonModWorkshopSync */ "a"].syncWorkshop(this.workshop.id);
        }
        /**
         * Checks if sync has succeed from result sync data.
         *
         * @param result Data returned on the sync function.
         * @return If suceed or not.
         */
        hasSyncSucceed(result) {
            return result.updated;
        }
        /**
         * Component being destroyed.
         */
        ngOnDestroy() {
            var _a, _b, _c;
            super.ngOnDestroy();
            (_a = this.obsSubmissionChanged) === null || _a === void 0 ? void 0 : _a.off();
            (_b = this.obsAssessmentSaved) === null || _b === void 0 ? void 0 : _b.off();
            (_c = this.appResumeSubscription) === null || _c === void 0 ? void 0 : _c.unsubscribe();
        }
    }
    AddonModWorkshopIndexComponent.ɵfac = function AddonModWorkshopIndexComponent_Factory(t) { return new (t || AddonModWorkshopIndexComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵdirectiveInject */ "yc"](_ionic_angular__WEBPACK_IMPORTED_MODULE_16__[/* IonContent */ "u"], 8), _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵdirectiveInject */ "yc"](_features_course_pages_contents_contents__WEBPACK_IMPORTED_MODULE_17__[/* CoreCourseContentsPage */ "a"], 8)); };
    AddonModWorkshopIndexComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵdefineComponent */ "sc"]({ type: AddonModWorkshopIndexComponent, selectors: [["addon-mod-workshop-index"]], inputs: { group: "group" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵInheritDefinitionFeature */ "ic"]], decls: 15, vars: 13, consts: [["slot", "end"], ["iconAction", "fas-external-link-alt", 3, "priority", "content", "href", 4, "ngIf"], ["iconAction", "fas-arrow-right", 3, "priority", "content", "action", 4, "ngIf"], ["iconAction", "far-newspaper", 3, "priority", "content", "action", 4, "ngIf"], [3, "priority", "content", "iconAction", "closeOnClick", "action", 4, "ngIf"], ["iconDescription", "fas-archive", "iconAction", "fas-trash", 3, "priority", "content", "closeOnClick", "action", 4, "ngIf"], [3, "hideUntil"], [3, "module", "showManualCompletion", "completionChanged", 4, "ngIf"], [4, "ngIf"], ["class", "core-warning-card", 4, "ngIf"], ["iconAction", "fas-external-link-alt", 3, "priority", "content", "href"], ["iconAction", "fas-arrow-right", 3, "priority", "content", "action"], ["iconAction", "far-newspaper", 3, "priority", "content", "action"], [3, "priority", "content", "iconAction", "closeOnClick", "action"], ["iconDescription", "fas-archive", "iconAction", "fas-trash", 3, "priority", "content", "closeOnClick", "action"], [3, "module", "showManualCompletion", "completionChanged"], ["button", "", "detail", "true", 3, "click"], [1, "ion-text-wrap"], ["button", "", "class", "ion-text-wrap", "detail", "false", 3, "item-dimmed", "click", 4, "ngFor", "ngForOf"], ["button", "", "detail", "false", 1, "ion-text-wrap", 3, "click"], ["slot", "start", "name", "far-circle", "aria-hidden", "true", 4, "ngIf"], ["slot", "start", "name", "fas-times-circle", "color", "danger", "aria-hidden", "true", 4, "ngIf"], ["slot", "start", "name", "fas-info-circle", "color", "info", "aria-hidden", "true", 4, "ngIf"], ["slot", "start", "name", "fas-check-circle", "color", "success", "aria-hidden", "true", 4, "ngIf"], [3, "innerHTML", 4, "ngIf"], ["slot", "end", "name", "fas-external-link-alt", "aria-hidden", "true", 4, "ngIf"], ["slot", "start", "name", "far-circle", "aria-hidden", "true"], ["slot", "start", "name", "fas-times-circle", "color", "danger", "aria-hidden", "true"], ["slot", "start", "name", "fas-info-circle", "color", "info", "aria-hidden", "true"], ["slot", "start", "name", "fas-check-circle", "color", "success", "aria-hidden", "true"], [3, "innerHTML"], ["slot", "end", "name", "fas-external-link-alt", "aria-hidden", "true"], [1, "core-warning-card"], ["name", "fas-exclamation-triangle", "slot", "start", "aria-hidden", "true"], ["contextLevel", "module", 3, "text", "component", "componentId", "contextInstanceId", "courseId"], ["fullOnClick", "true", "contextLevel", "module", 3, "component", "componentId", "text", "contextInstanceId", "courseId"], ["class", "ion-text-wrap", 4, "ngIf"], [3, "submission", "courseId", "module", "workshop", "access", 4, "ngIf"], [3, "submission", "courseId", "module", "workshop", "access"], ["expand", "block", 3, "click", 4, "ngIf"], ["expand", "block", 3, "click"], ["slot", "start", "name", "fas-plus", "aria-hidden", "true"], ["slot", "start", "name", "fas-edit", "aria-hidden", "true"], [4, "ngFor", "ngForOf"], ["summary", "true", 1, "core-as-item", 3, "submission", "courseId", "module", "workshop", "access"], ["summary", "true", 1, "core-as-item", 3, "submission", "assessment", "courseId", "module", "workshop", "access"], ["id", "addon-workshop-groupslabel", 4, "ngIf"], ["aria-labelledby", "addon-workshop-groupslabel", "interface", "action-sheet", 3, "ngModel", "interfaceOptions", "ngModelChange", "ionChange"], [3, "value", 4, "ngFor", "ngForOf"], ["id", "addon-workshop-groupslabel"], [3, "value"], [1, "ion-align-items-center"], ["expand", "block", "fill", "outline", 3, "click"], ["name", "fas-chevron-left", "slot", "start", "aria-hidden", "true"], ["name", "fas-chevron-right", "slot", "end", "aria-hidden", "true"]], template: function AddonModWorkshopIndexComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](0, "core-navbar-buttons", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](1, "core-context-menu");
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](2, AddonModWorkshopIndexComponent_core_context_menu_item_2_Template, 2, 5, "core-context-menu-item", 1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](3, AddonModWorkshopIndexComponent_core_context_menu_item_3_Template, 2, 4, "core-context-menu-item", 2);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](4, AddonModWorkshopIndexComponent_core_context_menu_item_4_Template, 2, 4, "core-context-menu-item", 3);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](5, AddonModWorkshopIndexComponent_core_context_menu_item_5_Template, 2, 6, "core-context-menu-item", 4);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](6, AddonModWorkshopIndexComponent_core_context_menu_item_6_Template, 2, 6, "core-context-menu-item", 4);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](7, AddonModWorkshopIndexComponent_core_context_menu_item_7_Template, 1, 4, "core-context-menu-item", 4);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](8, AddonModWorkshopIndexComponent_core_context_menu_item_8_Template, 2, 8, "core-context-menu-item", 5);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementStart */ "Ec"](9, "core-loading", 6);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](10, AddonModWorkshopIndexComponent_core_course_module_info_10_Template, 1, 2, "core-course-module-info", 7);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](11, AddonModWorkshopIndexComponent_ion_card_11_Template, 6, 2, "ion-card", 8);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](12, AddonModWorkshopIndexComponent_ion_card_12_Template, 6, 6, "ion-card", 9);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](13, AddonModWorkshopIndexComponent_ion_card_13_Template, 7, 8, "ion-card", 8);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵtemplate */ "nd"](14, AddonModWorkshopIndexComponent_div_14_Template, 7, 6, "div", 8);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵelementEnd */ "Dc"]();
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.externalUrl);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.description);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.blog);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.loaded && !ctx.hasOffline && ctx.isOnline);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.loaded && ctx.hasOffline && ctx.isOnline);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.prefetchStatusIcon);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.size);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("hideUntil", ctx.loaded);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.showCompletion);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.phases);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.hasOffline);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.description && ctx.workshop && ctx.workshop.phase == ctx.PHASE_SETUP);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_15__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.access && ctx.workshop && ctx.workshop.phase >= ctx.PHASE_SUBMISSION);
            }
        }, encapsulation: 2 });
    return AddonModWorkshopIndexComponent;
})();


/***/ }),

/***/ "2D5N":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreCourseModuleCompletionLegacyComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _features_user_services_user__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("4pns");
/* harmony import */ var _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("ULAo");
/* harmony import */ var _features_filter_services_filter_helper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("D2MD");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _features_course_classes_module_completion__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("L0Ri");
/* harmony import */ var _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("GBcW");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("ofXK");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("TEn/");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.










function CoreCourseModuleCompletionLegacyComponent_img_0_Template(rf, ctx) {
    if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵelement */ "zc"](0, "img", 2);
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵproperty */ "Vc"]("src", ctx_r0.completionImage, _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵsanitizeUrl */ "jd"])("alt", ctx_r0.completionDescription);
    }
}
function CoreCourseModuleCompletionLegacyComponent_ion_button_1_Template(rf, ctx) {
    if (rf & 1) {
        const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵelementStart */ "Ec"](0, "ion-button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵlistener */ "Mc"]("click", function CoreCourseModuleCompletionLegacyComponent_ion_button_1_Template_ion_button_click_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵrestoreView */ "gd"](_r3); const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵnextContext */ "Oc"](); return ctx_r2.completionClicked($event); });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵelement */ "zc"](1, "img", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵproperty */ "Vc"]("title", ctx_r1.completionDescription);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵadvance */ "lc"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵproperty */ "Vc"]("src", ctx_r1.completionImage, _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵsanitizeUrl */ "jd"]);
    }
}
/**
 * Component to handle activity completion in sites previous to 3.11.
 * It shows a checkbox with the current status, and allows manually changing the completion if it's allowed.
 *
 * Example usage:
 *
 * <core-course-module-completion-legacy [completion]="module.completiondata" [moduleName]="module.name"
 *     (completionChanged)="completionChanged()"></core-course-module-completion-legacy>
 */
let CoreCourseModuleCompletionLegacyComponent = /*@__PURE__*/ (() => {
    class CoreCourseModuleCompletionLegacyComponent extends _features_course_classes_module_completion__WEBPACK_IMPORTED_MODULE_5__[/* CoreCourseModuleCompletionBaseComponent */ "a"] {
        /**
         * @inheritdoc
         */
        calculateData() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!this.completion) {
                    return;
                }
                const moduleName = this.moduleName || '';
                let langKey;
                let image;
                if (this.completion.tracking === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_TRACKING_MANUAL &&
                    this.completion.state === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_INCOMPLETE) {
                    image = 'completion-manual-n';
                    langKey = 'core.completion-alt-manual-n';
                }
                else if (this.completion.tracking === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_TRACKING_MANUAL &&
                    this.completion.state === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_COMPLETE) {
                    image = 'completion-manual-y';
                    langKey = 'core.completion-alt-manual-y';
                }
                else if (this.completion.tracking === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_TRACKING_AUTOMATIC &&
                    this.completion.state === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_INCOMPLETE) {
                    image = 'completion-auto-n';
                    langKey = 'core.completion-alt-auto-n';
                }
                else if (this.completion.tracking === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_TRACKING_AUTOMATIC &&
                    this.completion.state === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_COMPLETE) {
                    image = 'completion-auto-y';
                    langKey = 'core.completion-alt-auto-y';
                }
                else if (this.completion.tracking === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_TRACKING_AUTOMATIC &&
                    this.completion.state === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_COMPLETE_PASS) {
                    image = 'completion-auto-pass';
                    langKey = 'core.completion-alt-auto-pass';
                }
                else if (this.completion.tracking === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_TRACKING_AUTOMATIC &&
                    this.completion.state === _features_course_services_course__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseProvider */ "b"].COMPLETION_COMPLETE_FAIL) {
                    image = 'completion-auto-fail';
                    langKey = 'core.completion-alt-auto-fail';
                }
                if (image) {
                    if (this.completion.overrideby && this.completion.overrideby > 0) {
                        image += '-override';
                    }
                    this.completionImage = 'assets/img/completion/' + image + '.svg';
                }
                if (!moduleName || !this.moduleId || !langKey) {
                    return;
                }
                const result = yield _features_filter_services_filter_helper__WEBPACK_IMPORTED_MODULE_3__[/* CoreFilterHelper */ "a"].getFiltersAndFormatText(moduleName, 'module', this.moduleId, { clean: true, singleLine: true, shortenLength: 50, courseId: this.completion.courseId });
                let translateParams = {
                    $a: result.text,
                };
                if (this.completion.overrideby && this.completion.overrideby > 0) {
                    langKey += '-override';
                    const profile = yield _features_user_services_user__WEBPACK_IMPORTED_MODULE_1__[/* CoreUser */ "a"].getProfile(this.completion.overrideby, this.completion.courseId, true);
                    translateParams = {
                        $a: {
                            overrideuser: profile.fullname,
                            modname: result.text,
                        },
                    };
                }
                this.completionDescription = _singletons__WEBPACK_IMPORTED_MODULE_4__[/* Translate */ "L"].instant(langKey, translateParams);
            });
        }
        /**
         * Completion clicked.
         *
         * @param event The click event.
         */
        completionClicked(event) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!this.completion) {
                    return;
                }
                yield _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_6__[/* CoreCourseHelper */ "a"].changeManualCompletion(this.completion, event);
                this.calculateData();
                this.completionChanged.emit(this.completion);
            });
        }
    }
    CoreCourseModuleCompletionLegacyComponent.ɵfac = function CoreCourseModuleCompletionLegacyComponent_Factory(t) { return ɵCoreCourseModuleCompletionLegacyComponent_BaseFactory(t || CoreCourseModuleCompletionLegacyComponent); };
    CoreCourseModuleCompletionLegacyComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵdefineComponent */ "sc"]({ type: CoreCourseModuleCompletionLegacyComponent, selectors: [["core-course-module-completion-legacy"]], features: [_angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵInheritDefinitionFeature */ "ic"]], decls: 2, vars: 2, consts: [[3, "src", "alt", 4, "ngIf"], ["fill", "clear", 3, "title", "click", 4, "ngIf"], [3, "src", "alt"], ["fill", "clear", 3, "title", "click"], ["role", "presentation", "alt", "", 3, "src"]], template: function CoreCourseModuleCompletionLegacyComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵtemplate */ "nd"](0, CoreCourseModuleCompletionLegacyComponent_img_0_Template, 1, 2, "img", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵtemplate */ "nd"](1, CoreCourseModuleCompletionLegacyComponent_ion_button_1_Template, 2, 2, "ion-button", 1);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.completion && ctx.completion.tracking !== 1);
                _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.completion && ctx.completion.tracking === 1);
            }
        }, directives: [_angular_common__WEBPACK_IMPORTED_MODULE_8__[/* NgIf */ "t"], _ionic_angular__WEBPACK_IMPORTED_MODULE_9__[/* IonButton */ "k"]], styles: ["[_nghost-%COMP%]{min-width:var(--a11y-min-target-size);min-height:var(--a11y-min-target-size);--size:30px}[_nghost-%COMP%]   img[_ngcontent-%COMP%]{padding:5px;width:var(--size);vertical-align:middle;max-width:none;margin:7px}[_nghost-%COMP%]   ion-button[_ngcontent-%COMP%]{--padding-top:0;--padding-start:0;--padding-end:0;--padding-bottom:0}"] });
    return CoreCourseModuleCompletionLegacyComponent;
})();
const ɵCoreCourseModuleCompletionLegacyComponent_BaseFactory = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_7__[/* ɵɵgetInheritedFactory */ "Gc"](CoreCourseModuleCompletionLegacyComponent);


/***/ }),

/***/ "2QA8":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return rxSubscriber; });
/* unused harmony export $$rxSubscriber */
const rxSubscriber = /*@__PURE__*/ (() => typeof Symbol === 'function'
    ? Symbol('rxSubscriber')
    : '@@rxSubscriber_' + Math.random())();
const $$rxSubscriber = rxSubscriber;
//# sourceMappingURL=rxSubscriber.js.map


/***/ }),

/***/ "2Vo4":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return BehaviorSubject; });
/* harmony import */ var _Subject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("XNiG");
/* harmony import */ var _util_ObjectUnsubscribedError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("9ppp");


class BehaviorSubject extends _Subject__WEBPACK_IMPORTED_MODULE_0__[/* Subject */ "a"] {
    constructor(_value) {
        super();
        this._value = _value;
    }
    get value() {
        return this.getValue();
    }
    _subscribe(subscriber) {
        const subscription = super._subscribe(subscriber);
        if (subscription && !subscription.closed) {
            subscriber.next(this._value);
        }
        return subscription;
    }
    getValue() {
        if (this.hasError) {
            throw this.thrownError;
        }
        else if (this.closed) {
            throw new _util_ObjectUnsubscribedError__WEBPACK_IMPORTED_MODULE_1__[/* ObjectUnsubscribedError */ "a"]();
        }
        else {
            return this._value;
        }
    }
    next(value) {
        super.next(this._value = value);
    }
}
//# sourceMappingURL=BehaviorSubject.js.map


/***/ }),

/***/ "2aj3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ ADDON_MOD_RESOURCE_SERVICES; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ resource_module_AddonModResourceModule; });

// EXTERNAL MODULE: ./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js + 4 modules
var core = __webpack_require__("fXoL");

// EXTERNAL MODULE: ./src/core/features/contentlinks/services/contentlinks-delegate.ts
var contentlinks_delegate = __webpack_require__("mbU7");

// EXTERNAL MODULE: ./src/core/features/course/services/module-delegate.ts + 1 modules
var module_delegate = __webpack_require__("yQ+R");

// EXTERNAL MODULE: ./src/core/features/course/services/module-prefetch-delegate.ts
var module_prefetch_delegate = __webpack_require__("zbKZ");

// EXTERNAL MODULE: ./src/core/features/mainmenu/mainmenu-tab-routing.module.ts
var mainmenu_tab_routing_module = __webpack_require__("wG2S");

// EXTERNAL MODULE: ./src/core/services/plugin-file-delegate.ts
var plugin_file_delegate = __webpack_require__("js7F");

// EXTERNAL MODULE: ./src/addons/mod/resource/components/components.module.ts
var components_module = __webpack_require__("HA9i");

// EXTERNAL MODULE: ./src/core/features/contentlinks/classes/module-index-handler.ts
var module_index_handler = __webpack_require__("llas");

// EXTERNAL MODULE: ./src/core/singletons/index.ts
var singletons = __webpack_require__("j3ag");

// EXTERNAL MODULE: ./src/addons/mod/resource/services/resource.ts
var resource = __webpack_require__("grtm");

// CONCATENATED MODULE: ./src/addons/mod/resource/services/handlers/index-link.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Handler to treat links to resource.
 */
let index_link_AddonModResourceIndexLinkHandlerService = /*@__PURE__*/ (() => {
    class AddonModResourceIndexLinkHandlerService extends module_index_handler["a" /* CoreContentLinksModuleIndexHandler */] {
        constructor() {
            super('AddonModResource', 'resource', 'r');
            this.name = 'AddonModResourceLinkHandler';
        }
        /**
         * @inheritdoc
         */
        isEnabled(siteId) {
            return resource["a" /* AddonModResource */].isPluginEnabled(siteId);
        }
    }
    AddonModResourceIndexLinkHandlerService.ɵfac = function AddonModResourceIndexLinkHandlerService_Factory(t) { return new (t || AddonModResourceIndexLinkHandlerService)(); };
    AddonModResourceIndexLinkHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: AddonModResourceIndexLinkHandlerService, factory: AddonModResourceIndexLinkHandlerService.ɵfac, providedIn: 'root' });
    return AddonModResourceIndexLinkHandlerService;
})();
const AddonModResourceIndexLinkHandler = Object(singletons["P" /* makeSingleton */])(index_link_AddonModResourceIndexLinkHandlerService);

// EXTERNAL MODULE: ./src/core/features/contentlinks/classes/module-list-handler.ts
var module_list_handler = __webpack_require__("hZkd");

// CONCATENATED MODULE: ./src/addons/mod/resource/services/handlers/list-link.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Handler to treat links to resource list page.
 */
let list_link_AddonModResourceListLinkHandlerService = /*@__PURE__*/ (() => {
    class AddonModResourceListLinkHandlerService extends module_list_handler["a" /* CoreContentLinksModuleListHandler */] {
        constructor() {
            super('AddonModResource', 'resource');
            this.name = 'AddonModResourceListLinkHandler';
        }
        /**
         * @inheritdoc
         */
        isEnabled(siteId) {
            return resource["a" /* AddonModResource */].isPluginEnabled(siteId);
        }
    }
    AddonModResourceListLinkHandlerService.ɵfac = function AddonModResourceListLinkHandlerService_Factory(t) { return new (t || AddonModResourceListLinkHandlerService)(); };
    AddonModResourceListLinkHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: AddonModResourceListLinkHandlerService, factory: AddonModResourceListLinkHandlerService.ɵfac, providedIn: 'root' });
    return AddonModResourceListLinkHandlerService;
})();
const AddonModResourceListLinkHandler = Object(singletons["P" /* makeSingleton */])(list_link_AddonModResourceListLinkHandlerService);

// EXTERNAL MODULE: ./node_modules/tslib/tslib.es6.js
var tslib_es6 = __webpack_require__("mrSG");

// EXTERNAL MODULE: ./src/core/constants.ts
var constants = __webpack_require__("BaYo");

// EXTERNAL MODULE: ./src/core/features/course/services/course.ts
var course = __webpack_require__("ULAo");

// EXTERNAL MODULE: ./src/core/services/file-helper.ts
var file_helper = __webpack_require__("L2dF");

// EXTERNAL MODULE: ./src/core/services/navigator.ts
var services_navigator = __webpack_require__("pHTc");

// EXTERNAL MODULE: ./src/core/services/utils/mimetype.ts
var utils_mimetype = __webpack_require__("vbeB");

// EXTERNAL MODULE: ./src/core/services/utils/text.ts + 1 modules
var utils_text = __webpack_require__("vuGA");

// EXTERNAL MODULE: ./src/core/services/utils/time.ts
var time = __webpack_require__("Q98t");

// EXTERNAL MODULE: ./src/addons/mod/resource/components/index/index.ts
var index = __webpack_require__("IvzY");

// EXTERNAL MODULE: ./src/addons/mod/resource/services/resource-helper.ts
var resource_helper = __webpack_require__("RmZH");

// CONCATENATED MODULE: ./src/addons/mod/resource/services/handlers/module.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.














/**
 * Handler to support resource modules.
 */
let module_AddonModResourceModuleHandlerService = /*@__PURE__*/ (() => {
    class AddonModResourceModuleHandlerService {
        constructor() {
            this.name = 'AddonModResource';
            this.modName = 'resource';
            this.supportedFeatures = {
                [constants["a" /* CoreConstants */].FEATURE_MOD_ARCHETYPE]: constants["a" /* CoreConstants */].MOD_ARCHETYPE_RESOURCE,
                [constants["a" /* CoreConstants */].FEATURE_GROUPS]: false,
                [constants["a" /* CoreConstants */].FEATURE_GROUPINGS]: false,
                [constants["a" /* CoreConstants */].FEATURE_MOD_INTRO]: true,
                [constants["a" /* CoreConstants */].FEATURE_COMPLETION_TRACKS_VIEWS]: true,
                [constants["a" /* CoreConstants */].FEATURE_GRADE_HAS_GRADE]: false,
                [constants["a" /* CoreConstants */].FEATURE_GRADE_OUTCOMES]: false,
                [constants["a" /* CoreConstants */].FEATURE_BACKUP_MOODLE2]: true,
                [constants["a" /* CoreConstants */].FEATURE_SHOW_DESCRIPTION]: true,
            };
        }
        /**
         * @inheritdoc
         */
        isEnabled() {
            return resource["a" /* AddonModResource */].isPluginEnabled();
        }
        /**
         * Get the data required to display the module in the course contents view.
         *
         * @param module The module object.
         * @param courseId The course ID.
         * @param sectionId The section ID.
         * @return Data to render the module.
         */
        getData(module, courseId) {
            const updateStatus = (status) => {
                handlerData.buttons[0].hidden = status !== constants["a" /* CoreConstants */].DOWNLOADED ||
                    resource_helper["a" /* AddonModResourceHelper */].isDisplayedInIframe(module);
            };
            const openWithPicker = file_helper["a" /* CoreFileHelper */].defaultIsOpenWithPicker();
            const handlerData = {
                icon: course["a" /* CoreCourse */].getModuleIconSrc(this.modName, 'modicon' in module ? module.modicon : undefined),
                title: module.name,
                class: 'addon-mod_resource-handler',
                showDownloadButton: true,
                action(event, module, courseId, options) {
                    options = options || {};
                    options.params = options.params || {};
                    Object.assign(options.params, { module });
                    const routeParams = '/' + courseId + '/' + module.id;
                    services_navigator["a" /* CoreNavigator */].navigateToSitePath(AddonModResourceModuleHandlerService.PAGE_NAME + routeParams, options);
                },
                updateStatus: updateStatus.bind(this),
                buttons: [{
                        hidden: true,
                        icon: openWithPicker ? 'fas-share-square' : 'fas-file',
                        label: module.name + ': ' + singletons["L" /* Translate */].instant(openWithPicker ? 'core.openwith' : 'addon.mod_resource.openthefile'),
                        action: (event, module, courseId) => Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                            const hide = yield this.hideOpenButton(module, courseId);
                            if (!hide) {
                                resource_helper["a" /* AddonModResourceHelper */].openModuleFile(module, courseId);
                            }
                        }),
                    }],
            };
            this.getResourceData(module, courseId, handlerData).then((data) => {
                handlerData.icon = data.icon;
                handlerData.extraBadge = data.extra;
                handlerData.extraBadgeColor = 'light';
                return;
            }).catch(() => {
                // Ignore errors.
            });
            return handlerData;
        }
        /**
         * Returns if contents are loaded to show open button.
         *
         * @param module The module object.
         * @param courseId The course ID.
         * @return Resolved when done.
         */
        hideOpenButton(module, courseId) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (!('contentsinfo' in module) || !module.contentsinfo) {
                    yield course["a" /* CoreCourse */].loadModuleContents(module, courseId, undefined, false, false, undefined, this.modName);
                }
                const status = yield module_prefetch_delegate["a" /* CoreCourseModulePrefetchDelegate */].getModuleStatus(module, courseId);
                return status !== constants["a" /* CoreConstants */].DOWNLOADED || resource_helper["a" /* AddonModResourceHelper */].isDisplayedInIframe(module);
            });
        }
        /**
         * Returns the activity icon and data.
         *
         * @param module The module object.
         * @param courseId The course ID.
         * @return Resource data.
         */
        getResourceData(module, courseId, handlerData) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const promises = [];
                let infoFiles = [];
                let options = {};
                // Check if the button needs to be shown or not.
                promises.push(this.hideOpenButton(module, courseId).then((hideOpenButton) => {
                    handlerData.buttons[0].hidden = hideOpenButton;
                    return;
                }));
                if ('customdata' in module && typeof module.customdata != 'undefined') {
                    options = utils_text["a" /* CoreTextUtils */].unserialize(utils_text["a" /* CoreTextUtils */].parseJSON(module.customdata));
                }
                else if (resource["a" /* AddonModResource */].isGetResourceWSAvailable()) {
                    // Get the resource data.
                    promises.push(resource["a" /* AddonModResource */].getResourceData(courseId, module.id).then((info) => {
                        infoFiles = info.contentfiles;
                        options = utils_text["a" /* CoreTextUtils */].unserialize(info.displayoptions);
                        return;
                    }));
                }
                yield Promise.all(promises);
                const files = module.contents && module.contents.length
                    ? module.contents
                    : infoFiles;
                const resourceData = {
                    icon: '',
                    extra: '',
                };
                const extra = [];
                if ('contentsinfo' in module && module.contentsinfo) {
                    // No need to use the list of files.
                    const mimetype = module.contentsinfo.mimetypes[0];
                    if (mimetype) {
                        resourceData.icon = utils_mimetype["a" /* CoreMimetypeUtils */].getMimetypeIcon(mimetype);
                    }
                    resourceData.extra = utils_text["a" /* CoreTextUtils */].cleanTags(module.afterlink);
                }
                else if (files && files.length) {
                    const file = files[0];
                    resourceData.icon = utils_mimetype["a" /* CoreMimetypeUtils */].getFileIcon(file.filename || '');
                    if (options.showsize) {
                        const size = options.filedetails
                            ? options.filedetails.size
                            : files.reduce((result, file) => result + (file.filesize || 0), 0);
                        extra.push(utils_text["a" /* CoreTextUtils */].bytesToSize(size, 1));
                    }
                    if (options.showtype) {
                        // We should take it from options.filedetails.size if available but it's already translated.
                        extra.push(utils_mimetype["a" /* CoreMimetypeUtils */].getMimetypeDescription(file));
                    }
                    if (options.showdate) {
                        const timecreated = 'timecreated' in file ? file.timecreated : 0;
                        if (options.filedetails && options.filedetails.modifieddate) {
                            extra.push(singletons["L" /* Translate */].instant('addon.mod_resource.modifieddate', { $a: time["a" /* CoreTimeUtils */].userDate(options.filedetails.modifieddate * 1000, 'core.strftimedatetimeshort') }));
                        }
                        else if (options.filedetails && options.filedetails.uploadeddate) {
                            extra.push(singletons["L" /* Translate */].instant('addon.mod_resource.uploadeddate', { $a: time["a" /* CoreTimeUtils */].userDate(options.filedetails.uploadeddate * 1000, 'core.strftimedatetimeshort') }));
                        }
                        else if ((file.timemodified || 0) > timecreated + constants["a" /* CoreConstants */].SECONDS_MINUTE * 5) {
                            /* Modified date may be up to several minutes later than uploaded date just because
                                teacher did not submit the form promptly. Give teacher up to 5 minutes to do it. */
                            extra.push(singletons["L" /* Translate */].instant('addon.mod_resource.modifieddate', { $a: time["a" /* CoreTimeUtils */].userDate((file.timemodified || 0) * 1000, 'core.strftimedatetimeshort') }));
                        }
                        else {
                            extra.push(singletons["L" /* Translate */].instant('addon.mod_resource.uploadeddate', { $a: time["a" /* CoreTimeUtils */].userDate(timecreated * 1000, 'core.strftimedatetimeshort') }));
                        }
                    }
                    resourceData.extra += extra.join(' ');
                }
                // No previously set, just set the icon.
                if (resourceData.icon == '') {
                    resourceData.icon = course["a" /* CoreCourse */].getModuleIconSrc(this.modName, 'modicon' in module ? module.modicon : undefined);
                }
                return resourceData;
            });
        }
        /**
         * @inheritdoc
         */
        getMainComponent() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                return index["a" /* AddonModResourceIndexComponent */];
            });
        }
    }
    AddonModResourceModuleHandlerService.PAGE_NAME = 'mod_resource';
    AddonModResourceModuleHandlerService.ɵfac = function AddonModResourceModuleHandlerService_Factory(t) { return new (t || AddonModResourceModuleHandlerService)(); };
    AddonModResourceModuleHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: AddonModResourceModuleHandlerService, factory: AddonModResourceModuleHandlerService.ɵfac, providedIn: 'root' });
    return AddonModResourceModuleHandlerService;
})();
const AddonModResourceModuleHandler = Object(singletons["P" /* makeSingleton */])(module_AddonModResourceModuleHandlerService);

// CONCATENATED MODULE: ./src/addons/mod/resource/services/handlers/pluginfile.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Handler to treat links to resource.
 */
let pluginfile_AddonModResourcePluginFileHandlerService = /*@__PURE__*/ (() => {
    class AddonModResourcePluginFileHandlerService {
        constructor() {
            this.name = 'AddonModResourcePluginFileHandler';
            this.component = 'mod_resource';
        }
        /**
         * @inheritdoc
         */
        getComponentRevisionRegExp(args) {
            // Check filearea.
            if (args[2] == 'content') {
                // Component + Filearea + Revision
                return new RegExp('/mod_resource/content/([0-9]+)/');
            }
        }
        /**
         * @inheritdoc
         */
        getComponentRevisionReplace() {
            // Component + Filearea + Revision
            return '/mod_resource/content/0/';
        }
        /**
         * @inheritdoc
         */
        isEnabled() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                return true;
            });
        }
    }
    AddonModResourcePluginFileHandlerService.ɵfac = function AddonModResourcePluginFileHandlerService_Factory(t) { return new (t || AddonModResourcePluginFileHandlerService)(); };
    AddonModResourcePluginFileHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: AddonModResourcePluginFileHandlerService, factory: AddonModResourcePluginFileHandlerService.ɵfac, providedIn: 'root' });
    return AddonModResourcePluginFileHandlerService;
})();
const AddonModResourcePluginFileHandler = Object(singletons["P" /* makeSingleton */])(pluginfile_AddonModResourcePluginFileHandlerService);

// EXTERNAL MODULE: ./src/core/features/course/classes/resource-prefetch-handler.ts
var resource_prefetch_handler = __webpack_require__("BFzo");

// EXTERNAL MODULE: ./src/core/services/filepool.ts
var filepool = __webpack_require__("ozqY");

// EXTERNAL MODULE: ./src/core/services/sites.ts
var sites = __webpack_require__("9+EE");

// CONCATENATED MODULE: ./src/addons/mod/resource/services/handlers/prefetch.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.










/**
 * Handler to prefetch resources.
 */
let prefetch_AddonModResourcePrefetchHandlerService = /*@__PURE__*/ (() => {
    class AddonModResourcePrefetchHandlerService extends resource_prefetch_handler["a" /* CoreCourseResourcePrefetchHandlerBase */] {
        constructor() {
            super(...arguments);
            this.name = 'AddonModResource';
            this.modName = 'resource';
            this.component = resource["b" /* AddonModResourceProvider */].COMPONENT;
        }
        /**
         * @inheritdoc
         */
        determineStatus(module, status) {
            if (status == constants["a" /* CoreConstants */].DOWNLOADED && module) {
                // If the main file is an external file, always display the module as outdated.
                if ('contentsinfo' in module && module.contentsinfo) {
                    if (module.contentsinfo.repositorytype) {
                        // It's an external file.
                        return constants["a" /* CoreConstants */].OUTDATED;
                    }
                }
                else if (module.contents) {
                    const mainFile = module.contents[0];
                    if (mainFile && mainFile.isexternalfile) {
                        return constants["a" /* CoreConstants */].OUTDATED;
                    }
                }
            }
            return status;
        }
        /**
         * @inheritdoc
         */
        downloadOrPrefetch(module, courseId, prefetch) {
            const _super = Object.create(null, {
                downloadOrPrefetch: { get: () => super.downloadOrPrefetch }
            });
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                let dirPath;
                if (resource_helper["a" /* AddonModResourceHelper */].isDisplayedInIframe(module)) {
                    dirPath = yield filepool["a" /* CoreFilepool */].getPackageDirPathByUrl(sites["b" /* CoreSites */].getCurrentSiteId(), module.url);
                }
                const promises = [];
                promises.push(_super.downloadOrPrefetch.call(this, module, courseId, prefetch, dirPath));
                if (resource["a" /* AddonModResource */].isGetResourceWSAvailable()) {
                    promises.push(resource["a" /* AddonModResource */].getResourceData(courseId, module.id));
                }
                yield Promise.all(promises);
            });
        }
        /**
         * @inheritdoc
         */
        invalidateContent(moduleId, courseId) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                yield resource["a" /* AddonModResource */].invalidateContent(moduleId, courseId);
            });
        }
        /**
         * @inheritdoc
         */
        invalidateModule(module, courseId) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const promises = [];
                promises.push(resource["a" /* AddonModResource */].invalidateResourceData(courseId));
                promises.push(course["a" /* CoreCourse */].invalidateModule(module.id, undefined, this.modName));
                yield Promise.all(promises);
            });
        }
        /**
         * @inheritdoc
         */
        isDownloadable(module, courseId) {
            var _a;
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if ((_a = sites["b" /* CoreSites */].getCurrentSite()) === null || _a === void 0 ? void 0 : _a.isVersionGreaterEqualThan('3.7')) {
                    // Nextcloud files are downloadable from 3.7 onwards.
                    return true;
                }
                // Don't allow downloading Nextcloud files in older sites.
                yield this.loadContents(module, courseId, false);
                return !resource_helper["a" /* AddonModResourceHelper */].isNextcloudFile(module);
            });
        }
        /**
         * @inheritdoc
         */
        isEnabled() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                return resource["a" /* AddonModResource */].isPluginEnabled();
            });
        }
    }
    AddonModResourcePrefetchHandlerService.ɵfac = function AddonModResourcePrefetchHandlerService_Factory(t) { return ɵAddonModResourcePrefetchHandlerService_BaseFactory(t || AddonModResourcePrefetchHandlerService); };
    AddonModResourcePrefetchHandlerService.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: AddonModResourcePrefetchHandlerService, factory: AddonModResourcePrefetchHandlerService.ɵfac, providedIn: 'root' });
    return AddonModResourcePrefetchHandlerService;
})();
const ɵAddonModResourcePrefetchHandlerService_BaseFactory = /*@__PURE__*/ core["Gc" /* ɵɵgetInheritedFactory */](prefetch_AddonModResourcePrefetchHandlerService);
const AddonModResourcePrefetchHandler = Object(singletons["P" /* makeSingleton */])(prefetch_AddonModResourcePrefetchHandlerService);

// CONCATENATED MODULE: ./src/addons/mod/resource/resource.module.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.















const ADDON_MOD_RESOURCE_SERVICES = [
    resource["b" /* AddonModResourceProvider */],
];
const routes = [
    {
        path: module_AddonModResourceModuleHandlerService.PAGE_NAME,
        loadChildren: () => __webpack_require__.e(/* import() */ 69).then(__webpack_require__.bind(null, "67Bv")).then(m => m.AddonModResourceLazyModule),
    },
];
let resource_module_AddonModResourceModule = /*@__PURE__*/ (() => {
    class AddonModResourceModule {
    }
    AddonModResourceModule.ɵmod = core["wc" /* ɵɵdefineNgModule */]({ type: AddonModResourceModule });
    AddonModResourceModule.ɵinj = core["vc" /* ɵɵdefineInjector */]({ factory: function AddonModResourceModule_Factory(t) { return new (t || AddonModResourceModule)(); }, providers: [
            {
                provide: core["d" /* APP_INITIALIZER */],
                multi: true,
                deps: [],
                useFactory: () => () => {
                    module_delegate["a" /* CoreCourseModuleDelegate */].registerHandler(AddonModResourceModuleHandler.instance);
                    contentlinks_delegate["a" /* CoreContentLinksDelegate */].registerHandler(AddonModResourceIndexLinkHandler.instance);
                    contentlinks_delegate["a" /* CoreContentLinksDelegate */].registerHandler(AddonModResourceListLinkHandler.instance);
                    module_prefetch_delegate["a" /* CoreCourseModulePrefetchDelegate */].registerHandler(AddonModResourcePrefetchHandler.instance);
                    plugin_file_delegate["a" /* CorePluginFileDelegate */].registerHandler(AddonModResourcePluginFileHandler.instance);
                },
            },
        ], imports: [[
                mainmenu_tab_routing_module["a" /* CoreMainMenuTabRoutingModule */].forChild(routes),
                components_module["a" /* AddonModResourceComponentsModule */],
            ]] });
    return AddonModResourceModule;
})();
(function () { (typeof ngJitMode === "undefined" || ngJitMode) && core["ld" /* ɵɵsetNgModuleScope */](resource_module_AddonModResourceModule, { imports: [mainmenu_tab_routing_module["a" /* CoreMainMenuTabRoutingModule */], components_module["a" /* AddonModResourceComponentsModule */]] }); })();


/***/ }),

/***/ "2eZG":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CorePushNotificationsDelegateService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CorePushNotificationsDelegate; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("XNiG");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("3j9v");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.







/**
 * Service to handle push notifications actions to perform when clicked and received.
 */
let CorePushNotificationsDelegateService = /*@__PURE__*/ (() => {
    class CorePushNotificationsDelegateService {
        constructor() {
            this.observables = {};
            this.clickHandlers = {};
            this.counterHandlers = {};
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_5__[/* CoreLogger */ "a"].getInstance('CorePushNotificationsDelegate');
            this.observables['receive'] = new rxjs__WEBPACK_IMPORTED_MODULE_1__[/* Subject */ "a"]();
        }
        /**
         * Function called when a push notification is clicked. Sends notification to handlers.
         *
         * @param notification Notification clicked.
         * @return Promise resolved when done.
         */
        clicked(notification) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!notification) {
                    return;
                }
                let handlers = [];
                const promises = Object.values(this.clickHandlers).map((handler) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    // Check if the handler is disabled for the site.
                    const disabled = yield this.isFeatureDisabled(handler, notification.site);
                    if (disabled) {
                        return;
                    }
                    // Check if the handler handles the notification.
                    const handles = yield handler.handles(notification);
                    if (handles) {
                        handlers.push(handler);
                    }
                }));
                yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_3__[/* CoreUtils */ "a"].ignoreErrors(_services_utils_utils__WEBPACK_IMPORTED_MODULE_3__[/* CoreUtils */ "a"].allPromises(promises));
                // Sort by priority.
                handlers = handlers.sort((a, b) => (a.priority || 0) <= (b.priority || 0) ? 1 : -1);
                // Execute the first one.
                (_a = handlers[0]) === null || _a === void 0 ? void 0 : _a.handleClick(notification);
            });
        }
        /**
         * Check if a handler's feature is disabled for a certain site.
         *
         * @param handler Handler to check.
         * @param siteId The site ID to check.
         * @return Promise resolved with boolean: whether the handler feature is disabled.
         */
        isFeatureDisabled(handler, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (!siteId) {
                    // Notification doesn't belong to a site. Assume all handlers are enabled.
                    return false;
                }
                else if (handler.featureName) {
                    // Check if the feature is disabled.
                    return _services_sites__WEBPACK_IMPORTED_MODULE_2__[/* CoreSites */ "b"].isFeatureDisabled(handler.featureName, siteId);
                }
                else {
                    return false;
                }
            });
        }
        /**
         * Function called when a push notification is received in foreground (cannot tell when it's received in background).
         * Sends notification to all handlers.
         *
         * @param notification Notification received.
         */
        received(notification) {
            this.observables['receive'].next(notification);
        }
        /**
         * Register a push notifications observable for a certain event. Right now, only receive is supported.
         * let observer = pushNotificationsDelegate.on('receive').subscribe((notification) => {
         * ...
         * observer.unsuscribe();
         *
         * @param eventName Only receive is permitted.
         * @return Observer to subscribe.
         */
        on(eventName) {
            if (typeof this.observables[eventName] == 'undefined') {
                const eventNames = Object.keys(this.observables).join(', ');
                this.logger.warn(`'${eventName}' event name is not allowed. Use one of the following: '${eventNames}'.`);
                return new rxjs__WEBPACK_IMPORTED_MODULE_1__[/* Subject */ "a"]();
            }
            return this.observables[eventName];
        }
        /**
         * Register a click handler.
         *
         * @param handler The handler to register.
         * @return True if registered successfully, false otherwise.
         */
        registerClickHandler(handler) {
            if (typeof this.clickHandlers[handler.name] !== 'undefined') {
                this.logger.log(`Addon '${handler.name}' already registered`);
                return false;
            }
            this.logger.log(`Registered addon '${handler.name}'`);
            this.clickHandlers[handler.name] = handler;
            handler.priority = handler.priority || 0;
            return true;
        }
        /**
         * Register a push notifications handler for update badge counter.
         *
         * @param name Handler's name.
         */
        registerCounterHandler(name) {
            if (typeof this.counterHandlers[name] == 'undefined') {
                this.logger.debug(`Registered handler '${name}' as badge counter handler.`);
                this.counterHandlers[name] = name;
            }
            else {
                this.logger.log(`Handler '${name}' as badge counter handler already registered.`);
            }
        }
        /**
         * Check if a counter handler is present.
         *
         * @param name Handler's name.
         * @return If handler name is present.
         */
        isCounterHandlerRegistered(name) {
            return typeof this.counterHandlers[name] != 'undefined';
        }
        /**
         * Get all counter badge handlers.
         *
         * @return with all the handler names.
         */
        getCounterHandlers() {
            return this.counterHandlers;
        }
    }
    CorePushNotificationsDelegateService.ɵfac = function CorePushNotificationsDelegateService_Factory(t) { return new (t || CorePushNotificationsDelegateService)(); };
    CorePushNotificationsDelegateService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵdefineInjectable */ "uc"]({ token: CorePushNotificationsDelegateService, factory: CorePushNotificationsDelegateService.ɵfac, providedIn: 'root' });
    return CorePushNotificationsDelegateService;
})();
const CorePushNotificationsDelegate = Object(_singletons__WEBPACK_IMPORTED_MODULE_4__[/* makeSingleton */ "P"])(CorePushNotificationsDelegateService);


/***/ }),

/***/ "2fFW":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return config; });
let _enable_super_gross_mode_that_will_cause_bad_things = false;
const config = {
    Promise: undefined,
    set useDeprecatedSynchronousErrorHandling(value) {
        if (value) {
            const error = new Error();
            console.warn('DEPRECATED! RxJS was set to use deprecated synchronous error handling behavior by code at: \n' + error.stack);
        }
        else if (_enable_super_gross_mode_that_will_cause_bad_things) {
            console.log('RxJS: Back to a better error behavior. Thank you. <3');
        }
        _enable_super_gross_mode_that_will_cause_bad_things = value;
    },
    get useDeprecatedSynchronousErrorHandling() {
        return _enable_super_gross_mode_that_will_cause_bad_things;
    },
};
//# sourceMappingURL=config.js.map


/***/ }),

/***/ "2fjn":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : French (Canada) [fr-ca]
//! author : Jonathan Abourbih : https://github.com/jonbca

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var frCa = moment.defineLocale('fr-ca', {
        months: 'janvier_février_mars_avril_mai_juin_juillet_août_septembre_octobre_novembre_décembre'.split(
            '_'
        ),
        monthsShort: 'janv._févr._mars_avr._mai_juin_juil._août_sept._oct._nov._déc.'.split(
            '_'
        ),
        monthsParseExact: true,
        weekdays: 'dimanche_lundi_mardi_mercredi_jeudi_vendredi_samedi'.split('_'),
        weekdaysShort: 'dim._lun._mar._mer._jeu._ven._sam.'.split('_'),
        weekdaysMin: 'di_lu_ma_me_je_ve_sa'.split('_'),
        weekdaysParseExact: true,
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'YYYY-MM-DD',
            LL: 'D MMMM YYYY',
            LLL: 'D MMMM YYYY HH:mm',
            LLLL: 'dddd D MMMM YYYY HH:mm',
        },
        calendar: {
            sameDay: '[Aujourd’hui à] LT',
            nextDay: '[Demain à] LT',
            nextWeek: 'dddd [à] LT',
            lastDay: '[Hier à] LT',
            lastWeek: 'dddd [dernier à] LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: 'dans %s',
            past: 'il y a %s',
            s: 'quelques secondes',
            ss: '%d secondes',
            m: 'une minute',
            mm: '%d minutes',
            h: 'une heure',
            hh: '%d heures',
            d: 'un jour',
            dd: '%d jours',
            M: 'un mois',
            MM: '%d mois',
            y: 'un an',
            yy: '%d ans',
        },
        dayOfMonthOrdinalParse: /\d{1,2}(er|e)/,
        ordinal: function (number, period) {
            switch (period) {
                // Words with masculine grammatical gender: mois, trimestre, jour
                default:
                case 'M':
                case 'Q':
                case 'D':
                case 'DDD':
                case 'd':
                    return number + (number === 1 ? 'er' : 'e');

                // Words with feminine grammatical gender: semaine
                case 'w':
                case 'W':
                    return number + (number === 1 ? 're' : 'e');
            }
        },
    });

    return frCa;

})));


/***/ }),

/***/ "2kx2":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModLessonHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModLessonHelper; });
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("vuGA");
/* harmony import */ var _services_utils_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("Q98t");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("j3ag");
/* harmony import */ var _lesson__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("ovS5");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("fXoL");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("3Pt+");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.








/**
 * Helper service that provides some features for quiz.
 */
let AddonModLessonHelperProvider = /*@__PURE__*/ (() => {
    class AddonModLessonHelperProvider {
        constructor(formBuilder) {
            this.formBuilder = formBuilder;
        }
        /**
         * Given the HTML of next activity link, format it to extract the href and the text.
         *
         * @param activityLink HTML of the activity link.
         * @return Formatted data.
         */
        formatActivityLink(activityLink) {
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(activityLink);
            const anchor = element.querySelector('a');
            if (!anchor) {
                // Anchor not found, return the original HTML.
                return {
                    formatted: false,
                    label: activityLink,
                    href: '',
                };
            }
            return {
                formatted: true,
                label: anchor.innerHTML,
                href: anchor.href,
            };
        }
        /**
         * Given the HTML of an answer from a content page, extract the data to render the answer.
         *
         * @param html Answer's HTML.
         * @return Data to render the answer.
         */
        getContentPageAnswerDataFromHtml(html) {
            const data = {
                buttonText: '',
                content: '',
            };
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(html);
            // Search the input button.
            const button = element.querySelector('input[type="button"]');
            if (button) {
                // Extract the button content and remove it from the HTML.
                data.buttonText = button.value;
                button.remove();
            }
            data.content = element.innerHTML.trim();
            return data;
        }
        /**
         * Get the buttons to change pages.
         *
         * @param html Page's HTML.
         * @return List of buttons.
         */
        getPageButtonsFromHtml(html) {
            const buttons = [];
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(html);
            // Get the container of the buttons if it exists.
            let buttonsContainer = element.querySelector('.branchbuttoncontainer');
            if (!buttonsContainer) {
                // Button container not found, might be a legacy lesson (from 1.9).
                if (!element.querySelector('form input[type="submit"]')) {
                    // No buttons found.
                    return buttons;
                }
                buttonsContainer = element;
            }
            const forms = Array.from(buttonsContainer.querySelectorAll('form'));
            forms.forEach((form) => {
                const buttonSelector = 'input[type="submit"], button[type="submit"]';
                const buttonEl = form.querySelector(buttonSelector);
                const inputs = Array.from(form.querySelectorAll('input'));
                if (!buttonEl || !inputs || !inputs.length) {
                    // Button not found or no inputs, ignore it.
                    return;
                }
                const button = {
                    id: buttonEl.id,
                    title: buttonEl.title || buttonEl.value,
                    content: buttonEl.tagName == 'INPUT' ? buttonEl.value : buttonEl.innerHTML.trim(),
                    data: {},
                };
                inputs.forEach((input) => {
                    if (input.type != 'submit') {
                        button.data[input.name] = input.value;
                    }
                });
                buttons.push(button);
            });
            return buttons;
        }
        /**
         * Given a page data, get the page contents.
         *
         * @param data Page data.
         * @return Page contents.
         */
        getPageContentsFromPageData(data) {
            var _a, _b, _c;
            // Search the page contents inside the whole page HTML. Use data.pagecontent because it's filtered.
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(data.pagecontent || '');
            const contents = element.querySelector('.contents');
            if (contents) {
                return contents.innerHTML.trim();
            }
            // Cannot find contents element.
            if (_lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLesson */ "a"].isQuestionPage(((_a = data.page) === null || _a === void 0 ? void 0 : _a.type) || -1) ||
                ((_b = data.page) === null || _b === void 0 ? void 0 : _b.qtype) == _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_BRANCHTABLE) {
                // Return page.contents to prevent having duplicated elements (some elements like videos might not work).
                return ((_c = data.page) === null || _c === void 0 ? void 0 : _c.contents) || '';
            }
            else {
                // It's an end of cluster, end of branch, etc. Return the whole pagecontent to match what's displayed in web.
                return data.pagecontent || '';
            }
        }
        /**
         * Get a question and all the data required to render it from the page data.
         *
         * @param questionForm The form group where to add the controls.
         * @param pageData Page data.
         * @return Question data.
         */
        getQuestionFromPageData(questionForm, pageData) {
            var _a;
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(pageData.pagecontent || '');
            // Get the container of the question answers if it exists.
            const fieldContainer = element.querySelector('.fcontainer');
            // Get hidden inputs and add their data to the form group.
            const hiddenInputs = Array.from(element.querySelectorAll('input[type="hidden"]'));
            hiddenInputs.forEach((input) => {
                questionForm.addControl(input.name, this.formBuilder.control(input.value));
            });
            // Get the submit button and extract its value.
            const submitButton = element.querySelector('input[type="submit"]');
            const question = {
                template: '',
                submitLabel: submitButton ? submitButton.value : _singletons__WEBPACK_IMPORTED_MODULE_3__[/* Translate */ "L"].instant('addon.mod_lesson.submit'),
            };
            if (!fieldContainer) {
                // Element not found, return.
                return question;
            }
            let type = 'text';
            switch ((_a = pageData.page) === null || _a === void 0 ? void 0 : _a.qtype) {
                case _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_TRUEFALSE:
                case _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_MULTICHOICE:
                    return this.getMultiChoiceQuestionData(questionForm, question, fieldContainer);
                case _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_NUMERICAL:
                    type = 'number';
                case _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_SHORTANSWER:
                    return this.getInputQuestionData(questionForm, question, fieldContainer, type);
                case _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_ESSAY: {
                    return this.getEssayQuestionData(questionForm, question, fieldContainer);
                }
                case _lesson__WEBPACK_IMPORTED_MODULE_4__[/* AddonModLessonProvider */ "b"].LESSON_PAGE_MATCHING: {
                    return this.getMatchingQuestionData(questionForm, question, fieldContainer);
                }
            }
            return question;
        }
        /**
         * Get a multichoice question data.
         *
         * @param questionForm The form group where to add the controls.
         * @param question Basic question data.
         * @param fieldContainer HTMLElement containing the data.
         * @return Question data.
         */
        getMultiChoiceQuestionData(questionForm, question, fieldContainer) {
            const multiChoiceQuestion = Object.assign(Object.assign({}, question), { template: 'multichoice', options: [], multi: false });
            // Get all the inputs. Search radio first.
            let inputs = Array.from(fieldContainer.querySelectorAll('input[type="radio"]'));
            if (!inputs || !inputs.length) {
                // Radio buttons not found, it might be a multi answer. Search for checkbox.
                multiChoiceQuestion.multi = true;
                inputs = Array.from(fieldContainer.querySelectorAll('input[type="checkbox"]'));
                if (!inputs || !inputs.length) {
                    // No checkbox found either. Stop.
                    return multiChoiceQuestion;
                }
            }
            let controlAdded = false;
            inputs.forEach((input) => {
                const parent = input.parentElement;
                const option = {
                    id: input.id,
                    name: input.name,
                    value: input.value,
                    checked: !!input.checked,
                    disabled: !!input.disabled,
                    text: '',
                };
                if (option.checked || multiChoiceQuestion.multi) {
                    // Add the control.
                    const value = multiChoiceQuestion.multi ?
                        { value: option.checked, disabled: option.disabled } : option.value;
                    questionForm.addControl(option.name, this.formBuilder.control(value));
                    controlAdded = true;
                }
                // Remove the input and use the rest of the parent contents as the label.
                input.remove();
                option.text = (parent === null || parent === void 0 ? void 0 : parent.innerHTML.trim()) || '';
                multiChoiceQuestion.options.push(option);
            });
            if (!multiChoiceQuestion.multi) {
                multiChoiceQuestion.controlName = inputs[0].name;
                if (!controlAdded) {
                    // No checked option for single choice, add the control with an empty value.
                    questionForm.addControl(multiChoiceQuestion.controlName, this.formBuilder.control(''));
                }
            }
            return multiChoiceQuestion;
        }
        /**
         * Get an input question data.
         *
         * @param questionForm The form group where to add the controls.
         * @param question Basic question data.
         * @param fieldContainer HTMLElement containing the data.
         * @param type Type of the input.
         * @return Question data.
         */
        getInputQuestionData(questionForm, question, fieldContainer, type) {
            const inputQuestion = question;
            inputQuestion.template = 'shortanswer';
            // Get the input.
            const input = fieldContainer.querySelector('input[type="text"], input[type="number"]');
            if (!input) {
                return inputQuestion;
            }
            inputQuestion.input = {
                id: input.id,
                name: input.name,
                maxlength: input.maxLength,
                type,
            };
            // Init the control.
            questionForm.addControl(input.name, this.formBuilder.control({ value: input.value, disabled: input.readOnly }));
            return inputQuestion;
        }
        /**
         * Get an essay question data.
         *
         * @param questionForm The form group where to add the controls.
         * @param question Basic question data.
         * @param fieldContainer HTMLElement containing the data.
         * @return Question data.
         */
        getEssayQuestionData(questionForm, question, fieldContainer) {
            const essayQuestion = question;
            essayQuestion.template = 'essay';
            // Get the textarea.
            const textarea = fieldContainer.querySelector('textarea');
            if (!textarea) {
                // Textarea not found, probably review mode.
                const answerEl = fieldContainer.querySelector('.reviewessay');
                if (!answerEl) {
                    // Answer not found, stop.
                    return essayQuestion;
                }
                essayQuestion.useranswer = answerEl.innerHTML;
            }
            else {
                essayQuestion.textarea = {
                    id: textarea.id,
                    name: textarea.name || 'answer[text]',
                };
                // Init the control.
                essayQuestion.control = this.formBuilder.control('');
                questionForm.addControl(essayQuestion.textarea.name, essayQuestion.control);
            }
            return essayQuestion;
        }
        /**
         * Get a matching question data.
         *
         * @param questionForm The form group where to add the controls.
         * @param question Basic question data.
         * @param fieldContainer HTMLElement containing the data.
         * @return Question data.
         */
        getMatchingQuestionData(questionForm, question, fieldContainer) {
            const matchingQuestion = Object.assign(Object.assign({}, question), { template: 'matching', rows: [] });
            const rows = Array.from(fieldContainer.querySelectorAll('.answeroption'));
            rows.forEach((row) => {
                const label = row.querySelector('label');
                const select = row.querySelector('select');
                const options = Array.from(row.querySelectorAll('option'));
                if (!label || !select || !options || !options.length) {
                    return;
                }
                // Get the row's text (label).
                const rowData = {
                    text: label.innerHTML.trim(),
                    id: select.id,
                    name: select.name,
                    options: [],
                };
                // Treat each option.
                let controlAdded = false;
                options.forEach((option) => {
                    if (typeof option.value == 'undefined') {
                        // Option not valid, ignore it.
                        return;
                    }
                    const optionData = {
                        value: option.value,
                        label: option.innerHTML.trim(),
                        selected: option.selected,
                    };
                    if (optionData.selected) {
                        controlAdded = true;
                        questionForm.addControl(rowData.name, this.formBuilder.control({ value: optionData.value, disabled: !!select.disabled }));
                    }
                    rowData.options.push(optionData);
                });
                if (!controlAdded) {
                    // No selected option, add the control with an empty value.
                    questionForm.addControl(rowData.name, this.formBuilder.control({ value: '', disabled: !!select.disabled }));
                }
                matchingQuestion.rows.push(rowData);
            });
            return matchingQuestion;
        }
        /**
         * Given the HTML of an answer from a question page, extract the data to render the answer.
         *
         * @param html Answer's HTML.
         * @return Object with the data to render the answer. If the answer doesn't require any parsing, return a string with the HTML.
         */
        getQuestionPageAnswerDataFromHtml(html) {
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(html);
            // Check if it has a checkbox.
            let input = element.querySelector('input[type="checkbox"][name*="answer"]');
            if (input) {
                // Truefalse or multichoice.
                const data = {
                    isCheckbox: true,
                    checked: !!input.checked,
                    name: input.name,
                    highlight: !!element.querySelector('.highlight'),
                    content: '',
                };
                input.remove();
                data.content = element.innerHTML.trim();
                return data;
            }
            // Check if it has an input text or number.
            input = element.querySelector('input[type="number"],input[type="text"]');
            if (input) {
                // Short answer or numeric.
                return {
                    isText: true,
                    value: input.value,
                };
            }
            // Check if it has a select.
            const select = element.querySelector('select');
            if (select === null || select === void 0 ? void 0 : select.options) {
                // Matching.
                const selectedOption = select.options[select.selectedIndex];
                const data = {
                    isSelect: true,
                    id: select.id,
                    value: selectedOption ? selectedOption.value : '',
                    content: '',
                };
                select.remove();
                data.content = element.innerHTML.trim();
                return data;
            }
            // The answer doesn't need any parsing, return the HTML as it is.
            return html;
        }
        /**
         * Get a label to identify a retake (lesson attempt).
         *
         * @param retake Retake object.
         * @param includeDuration Whether to include the duration of the retake.
         * @return Retake label.
         */
        getRetakeLabel(retake, includeDuration) {
            const data = {
                retake: retake.try + 1,
                grade: '',
                timestart: '',
                duration: '',
            };
            const hasGrade = retake.grade != null;
            if (hasGrade || retake.end) {
                // Retake finished with or without grade (if the lesson only has content pages, it has no grade).
                if (hasGrade) {
                    data.grade = _singletons__WEBPACK_IMPORTED_MODULE_3__[/* Translate */ "L"].instant('core.percentagenumber', { $a: retake.grade });
                }
                data.timestart = _services_utils_time__WEBPACK_IMPORTED_MODULE_2__[/* CoreTimeUtils */ "a"].userDate(retake.timestart * 1000);
                if (includeDuration) {
                    data.duration = _services_utils_time__WEBPACK_IMPORTED_MODULE_2__[/* CoreTimeUtils */ "a"].formatTime(retake.timeend - retake.timestart);
                }
            }
            else {
                // The user has not completed the retake.
                data.grade = _singletons__WEBPACK_IMPORTED_MODULE_3__[/* Translate */ "L"].instant('addon.mod_lesson.notcompleted');
                if (retake.timestart) {
                    data.timestart = _services_utils_time__WEBPACK_IMPORTED_MODULE_2__[/* CoreTimeUtils */ "a"].userDate(retake.timestart * 1000);
                }
            }
            return _singletons__WEBPACK_IMPORTED_MODULE_3__[/* Translate */ "L"].instant('addon.mod_lesson.retakelabel' + (includeDuration ? 'full' : 'short'), data);
        }
        /**
         * Prepare the question data to be sent to server.
         *
         * @param question Question to prepare.
         * @param data Data to prepare.
         * @return Data to send.
         */
        prepareQuestionData(question, data) {
            if (question.template == 'essay') {
                const textarea = question.textarea;
                // Add some HTML to the answer if needed.
                if (textarea) {
                    data[textarea.name] = _services_utils_text__WEBPACK_IMPORTED_MODULE_1__[/* CoreTextUtils */ "a"].formatHtmlLines(data[textarea.name]);
                }
            }
            else if (question.template == 'multichoice' && question.multi) {
                // Only send the options with value set to true.
                for (const name in data) {
                    if (name.match(/answer\[\d+\]/) && data[name] == false) {
                        delete data[name];
                    }
                }
            }
            return data;
        }
        /**
         * Given the feedback of a process page in HTML, remove the question text.
         *
         * @param html Feedback's HTML.
         * @return Feedback without the question text.
         */
        removeQuestionFromFeedback(html) {
            const element = _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].convertToElement(html);
            // Remove the question text.
            _services_utils_dom__WEBPACK_IMPORTED_MODULE_0__[/* CoreDomUtils */ "a"].removeElement(element, '.generalbox:not(.feedback):not(.correctanswer)');
            return element.innerHTML.trim();
        }
    }
    AddonModLessonHelperProvider.ɵfac = function AddonModLessonHelperProvider_Factory(t) { return new (t || AddonModLessonHelperProvider)(_angular_core__WEBPACK_IMPORTED_MODULE_5__[/* ɵɵinject */ "Ic"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__[/* FormBuilder */ "f"])); };
    AddonModLessonHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_5__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModLessonHelperProvider, factory: AddonModLessonHelperProvider.ɵfac, providedIn: 'root' });
    return AddonModLessonHelperProvider;
})();
const AddonModLessonHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_3__[/* makeSingleton */ "P"])(AddonModLessonHelperProvider);


/***/ }),

/***/ "2oDI":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreUpdateManagerProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreUpdateManager; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _services_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("BBqZ");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("BaYo");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3j9v");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("j3ag");
/* harmony import */ var _features_h5p_services_h5p__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("G3bH");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.







const VERSION_APPLIED = 'version_applied';
/**
 * Factory to handle app updates. This factory shouldn't be used outside of core.
 *
 * This service handles processes that need to be run when updating the app, like migrate Ionic 1 database data to Ionic 3.
 */
let CoreUpdateManagerProvider = /*@__PURE__*/ (() => {
    class CoreUpdateManagerProvider {
        constructor() {
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_3__[/* CoreLogger */ "a"].getInstance('CoreUpdateManagerProvider');
        }
        /**
         * Check if the app has been updated and performs the needed processes.
         * This function shouldn't be used outside of core.
         *
         * @return Promise resolved when the update process finishes.
         */
        load() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const promises = [];
                const versionCode = _core_constants__WEBPACK_IMPORTED_MODULE_2__[/* CoreConstants */ "a"].CONFIG.versioncode;
                const versionApplied = yield _services_config__WEBPACK_IMPORTED_MODULE_1__[/* CoreConfig */ "a"].get(VERSION_APPLIED, 0);
                if (versionCode >= 3950 && versionApplied < 3950 && versionApplied > 0) {
                    promises.push(_features_h5p_services_h5p__WEBPACK_IMPORTED_MODULE_5__[/* CoreH5P */ "a"].h5pPlayer.deleteAllContentIndexes());
                }
                try {
                    yield Promise.all(promises);
                    yield _services_config__WEBPACK_IMPORTED_MODULE_1__[/* CoreConfig */ "a"].set(VERSION_APPLIED, versionCode);
                }
                catch (error) {
                    this.logger.error(`Error applying update from ${versionApplied} to ${versionCode}`, error);
                }
            });
        }
    }
    CoreUpdateManagerProvider.ɵfac = function CoreUpdateManagerProvider_Factory(t) { return new (t || CoreUpdateManagerProvider)(); };
    CoreUpdateManagerProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_6__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreUpdateManagerProvider, factory: CoreUpdateManagerProvider.ɵfac, providedIn: 'root' });
    return CoreUpdateManagerProvider;
})();
const CoreUpdateManager = Object(_singletons__WEBPACK_IMPORTED_MODULE_4__[/* makeSingleton */ "P"])(CoreUpdateManagerProvider);


/***/ }),

/***/ "2oRL":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreFileUploaderDelegateService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreFileUploaderDelegate; });
/* harmony import */ var _classes_delegate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("03Vu");
/* harmony import */ var _singletons_events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fjkH");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Delegate to register handlers to be shown in the file picker.
 */
let CoreFileUploaderDelegateService = /*@__PURE__*/ (() => {
    class CoreFileUploaderDelegateService extends _classes_delegate__WEBPACK_IMPORTED_MODULE_0__[/* CoreDelegate */ "a"] {
        constructor() {
            super('CoreFileUploaderDelegate', true);
            _singletons_events__WEBPACK_IMPORTED_MODULE_1__[/* CoreEvents */ "b"].on(_singletons_events__WEBPACK_IMPORTED_MODULE_1__[/* CoreEvents */ "b"].LOGOUT, this.clearSiteHandlers.bind(this));
        }
        /**
         * Clear current site handlers. Reserved for core use.
         */
        clearSiteHandlers() {
            this.enabledHandlers = {};
        }
        /**
         * Get the handlers for the current site.
         *
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @return List of handlers data.
         */
        getHandlers(mimetypes) {
            const handlers = [];
            for (const name in this.enabledHandlers) {
                const handler = this.enabledHandlers[name];
                let supportedMimetypes;
                if (mimetypes) {
                    if (!handler.getSupportedMimetypes) {
                        // Handler doesn't implement a required function, don't add it.
                        continue;
                    }
                    supportedMimetypes = handler.getSupportedMimetypes(mimetypes);
                    if (!supportedMimetypes.length) {
                        // Handler doesn't support any mimetype, don't add it.
                        continue;
                    }
                }
                const data = handler.getData();
                data.priority = handler.priority || 0;
                data.mimetypes = supportedMimetypes;
                handlers.push(data);
            }
            // Sort them by priority.
            handlers.sort((a, b) => a.priority <= b.priority ? 1 : -1);
            return handlers;
        }
    }
    CoreFileUploaderDelegateService.ɵfac = function CoreFileUploaderDelegateService_Factory(t) { return new (t || CoreFileUploaderDelegateService)(); };
    CoreFileUploaderDelegateService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_3__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreFileUploaderDelegateService, factory: CoreFileUploaderDelegateService.ɵfac, providedIn: 'root' });
    return CoreFileUploaderDelegateService;
})();
const CoreFileUploaderDelegate = Object(_singletons__WEBPACK_IMPORTED_MODULE_2__[/* makeSingleton */ "P"])(CoreFileUploaderDelegateService);


/***/ }),

/***/ "2tv+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreFileUploaderHelperProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreFileUploaderHelper; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("nvXB");
/* harmony import */ var _services_file__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("EmGO");
/* harmony import */ var _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("3LXp");
/* harmony import */ var _services_utils_mimetype__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("vbeB");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("vuGA");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("j3ag");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("3j9v");
/* harmony import */ var _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("n9nU");
/* harmony import */ var _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("93ts");
/* harmony import */ var _fileuploader__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("hSQQ");
/* harmony import */ var _fileuploader_delegate__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__("2oRL");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__("9+EE");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.















/**
 * Helper service to upload files.
 */
let CoreFileUploaderHelperProvider = /*@__PURE__*/ (() => {
    class CoreFileUploaderHelperProvider {
        constructor() {
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_8__[/* CoreLogger */ "a"].getInstance('CoreFileUploaderHelperProvider');
        }
        /**
         * Choose any type of file and upload it.
         *
         * @param maxSize Max size of the upload. -1 for no max size.
         * @param upload True if the file should be uploaded, false to return the picked file.
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @param allowOffline True to allow uploading in offline.
         * @return Promise resolved when done.
         */
        chooseAndUploadFile(maxSize, upload, allowOffline, mimetypes) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showModalLoading();
                const result = yield _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Chooser */ "g"].getFileMetadata(mimetypes ? mimetypes.join(',') : undefined);
                modal.dismiss();
                if (!result) {
                    // User canceled.
                    throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__[/* CoreCanceledError */ "a"]();
                }
                if (result.name == 'File') {
                    // In some Android 4.4 devices the file name cannot be retrieved. Try to use the one from the URI.
                    result.name = this.getChosenFileNameFromPath(result) || result.name;
                }
                // Verify that the mimetype is supported.
                const error = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].isInvalidMimetype(mimetypes, result.name, result.mediaType);
                if (error) {
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](error);
                }
                const options = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].getFileUploadOptions(result.uri, result.name, result.mediaType, true);
                if (upload) {
                    return this.uploadFile(result.uri, maxSize || -1, true, options);
                }
                else {
                    return this.copyToTmpFolder(result.uri, false, maxSize, undefined, options);
                }
            });
        }
        /**
         * Show a confirmation modal to the user if the size of the file is bigger than the allowed threshold.
         *
         * @param size File size.
         * @param alwaysConfirm True to show a confirm even if the size isn't high.
         * @param allowOffline True to allow uploading in offline.
         * @param wifiThreshold Threshold for WiFi connection. Default: CoreFileUploaderProvider.WIFI_SIZE_WARNING.
         * @param limitedThreshold Threshold for limited connection. Default: CoreFileUploaderProvider.LIMITED_SIZE_WARNING.
         * @return Promise resolved when the user confirms or if there's no need to show a modal.
         */
        confirmUploadFile(size, alwaysConfirm, allowOffline, wifiThreshold, limitedThreshold) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (size == 0) {
                    return;
                }
                if (!allowOffline && !_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isOnline()) {
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.errormustbeonlinetoupload'));
                }
                wifiThreshold = typeof wifiThreshold == 'undefined' ? _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploaderProvider */ "b"].WIFI_SIZE_WARNING : wifiThreshold;
                limitedThreshold = typeof limitedThreshold == 'undefined' ?
                    _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploaderProvider */ "b"].LIMITED_SIZE_WARNING : limitedThreshold;
                if (size < 0) {
                    return _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showConfirm(_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.confirmuploadunknownsize'));
                }
                else if (size >= wifiThreshold || (_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isNetworkAccessLimited() && size >= limitedThreshold)) {
                    const readableSize = _services_utils_text__WEBPACK_IMPORTED_MODULE_5__[/* CoreTextUtils */ "a"].bytesToSize(size, 2);
                    return _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showConfirm(_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.confirmuploadfile', { size: readableSize }));
                }
                else if (alwaysConfirm) {
                    return _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showConfirm(_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.areyousure'));
                }
            });
        }
        /**
         * Create a temporary copy of a file and upload it.
         *
         * @param file File to copy and upload.
         * @param upload True if the file should be uploaded, false to return the copy of the file.
         * @param name Name to use when uploading the file. If not defined, use the file's name.
         * @return Promise resolved when the file is uploaded.
         */
        copyAndUploadFile(file, upload, name) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                name = name || file.name;
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showModalLoading('core.fileuploader.readingfile', true);
                let fileEntry;
                try {
                    // Get unique name for the copy.
                    const newName = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getUniqueNameInFolder(_services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFileProvider */ "b"].TMPFOLDER, name);
                    const filePath = _services_utils_text__WEBPACK_IMPORTED_MODULE_5__[/* CoreTextUtils */ "a"].concatenatePaths(_services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFileProvider */ "b"].TMPFOLDER, newName);
                    // Write the data into the file.
                    fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].writeFileDataInFile(file, filePath, (progress) => this.showProgressModal(modal, 'core.fileuploader.readingfileperc', progress));
                }
                catch (error) {
                    this.logger.error('Error reading file to upload.', error);
                    modal.dismiss();
                    throw error;
                }
                modal.dismiss();
                if (upload) {
                    // Pass true to delete the copy after the upload.
                    return this.uploadGenericFile(fileEntry.toURL(), name, file.type, true);
                }
                else {
                    return fileEntry;
                }
            });
        }
        /**
         * Copy or move a file to the app temporary folder.
         *
         * @param path Path of the file.
         * @param shouldDelete True if original file should be deleted (move), false otherwise (copy).
         * @param maxSize Max size of the file. If not defined or -1, no max size.
         * @param defaultExt Defaut extension to use if the file doesn't have any.
         * @return Promise resolved with the copied file.
         */
        copyToTmpFolder(path, shouldDelete, maxSize, defaultExt, options) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const fileName = (options === null || options === void 0 ? void 0 : options.fileName) || _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileAndDirectoryFromPath(path).name;
                // Check that size isn't too large.
                if (typeof maxSize != 'undefined' && maxSize != -1) {
                    try {
                        const fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getExternalFile(path);
                        const fileData = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileObjectFromFileEntry(fileEntry);
                        if (fileData.size > maxSize) {
                            throw this.createMaxBytesError(maxSize, fileEntry.name);
                        }
                    }
                    catch (error) {
                        // Ignore failures.
                    }
                }
                // File isn't too large.
                // Get a unique name in the folder to prevent overriding another file.
                const newName = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getUniqueNameInFolder(_services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFileProvider */ "b"].TMPFOLDER, fileName, defaultExt);
                // Now move or copy the file.
                const destPath = _services_utils_text__WEBPACK_IMPORTED_MODULE_5__[/* CoreTextUtils */ "a"].concatenatePaths(_services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFileProvider */ "b"].TMPFOLDER, newName);
                if (shouldDelete) {
                    return _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].moveExternalFile(path, destPath);
                }
                else {
                    return _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].copyExternalFile(path, destPath);
                }
            });
        }
        /**
         * Function called when trying to upload a file bigger than max size. Creates an error instance.
         *
         * @param maxSize Max size (bytes).
         * @param fileName Name of the file.
         * @return Message.
         */
        createMaxBytesError(maxSize, fileName) {
            return new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.maxbytesfile', {
                $a: {
                    file: fileName,
                    size: _services_utils_text__WEBPACK_IMPORTED_MODULE_5__[/* CoreTextUtils */ "a"].bytesToSize(maxSize, 2),
                },
            }));
        }
        /**
         * Function called when the file picker is closed.
         */
        filePickerClosed() {
            if (this.filePickerDeferred) {
                this.filePickerDeferred.reject(new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__[/* CoreCanceledError */ "a"]());
                this.filePickerDeferred = undefined;
            }
        }
        /**
         * Function to call once a file is uploaded using the file picker.
         *
         * @param result Result of the upload process.
         */
        fileUploaded(result) {
            var _a;
            if (this.filePickerDeferred) {
                this.filePickerDeferred.resolve(result);
                this.filePickerDeferred = undefined;
            }
            // Close the action sheet if it's opened.
            (_a = this.actionSheet) === null || _a === void 0 ? void 0 : _a.dismiss();
        }
        /**
         * Given the result of choosing a file, try to get its file name from the path.
         *
         * @param result Chosen file data.
         * @return File name, undefined if cannot get it.
         */
        getChosenFileNameFromPath(result) {
            const nameAndDir = _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileAndDirectoryFromPath(result.uri);
            if (!nameAndDir.name) {
                return;
            }
            let extension = _services_utils_mimetype__WEBPACK_IMPORTED_MODULE_4__[/* CoreMimetypeUtils */ "a"].getFileExtension(nameAndDir.name);
            if (!extension) {
                // The URI doesn't have an extension, add it now.
                extension = _services_utils_mimetype__WEBPACK_IMPORTED_MODULE_4__[/* CoreMimetypeUtils */ "a"].getExtension(result.mediaType);
                if (extension) {
                    nameAndDir.name += '.' + extension;
                }
            }
            return decodeURIComponent(nameAndDir.name);
        }
        /**
         * Open the "file picker" to select and upload a file.
         *
         * @param maxSize Max size of the file to upload. If not defined or -1, no max size.
         * @param title File picker title.
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @return Promise resolved when a file is uploaded, rejected if file picker is closed without a file uploaded.
         *         The resolve value is the response of the upload request.
         */
        selectAndUploadFile(maxSize, title, mimetypes) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return yield this.selectFileWithPicker(maxSize, false, title, mimetypes, true);
            });
        }
        /**
         * Open the "file picker" to select a file without uploading it.
         *
         * @param maxSize Max size of the file. If not defined or -1, no max size.
         * @param allowOffline True to allow selecting in offline, false to require connection.
         * @param title File picker title.
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @return Promise resolved when a file is selected, rejected if file picker is closed without selecting a file.
         *         The resolve value is the FileEntry of a copy of the picked file, so it can be deleted afterwards.
         */
        selectFile(maxSize, allowOffline, title, mimetypes) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                return yield this.selectFileWithPicker(maxSize, allowOffline, title, mimetypes, false);
            });
        }
        /**
         * Open the "file picker" to select a file and maybe uploading it.
         *
         * @param maxSize Max size of the file. If not defined or -1, no max size.
         * @param allowOffline True to allow selecting in offline, false to require connection.
         * @param title File picker title.
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @param upload Whether the file should be uploaded.
         * @return Promise resolved when a file is selected/uploaded, rejected if file picker is closed.
         */
        selectFileWithPicker(maxSize, allowOffline, title, mimetypes, upload) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                // Create the cancel button and get the handlers to upload the file.
                const buttons = [{
                        text: _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.cancel'),
                        role: 'cancel',
                        handler: () => {
                            // User cancelled the action sheet.
                            this.filePickerClosed();
                        },
                    }];
                const handlers = _fileuploader_delegate__WEBPACK_IMPORTED_MODULE_12__[/* CoreFileUploaderDelegate */ "a"].getHandlers(mimetypes);
                this.filePickerDeferred = _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].promiseDefer();
                // Create a button for each handler.
                handlers.forEach((handler) => {
                    buttons.push({
                        text: _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant(handler.title),
                        icon: handler.icon,
                        cssClass: handler.class,
                        handler: () => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                            if (!handler.action) {
                                // Nothing to do.
                                return false;
                            }
                            if (!allowOffline && !_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isOnline()) {
                                // Not allowed, show error.
                                _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showErrorModal('core.fileuploader.errormustbeonlinetoupload', true);
                                return false;
                            }
                            try {
                                const data = yield handler.action(maxSize, upload, allowOffline, handler.mimetypes);
                                let result;
                                if (data.treated) {
                                    // The handler already treated the file. Return the result.
                                    result = data.result;
                                }
                                else if (data.fileEntry) {
                                    // The handler provided us a fileEntry, use it.
                                    result = yield this.uploadFileEntry(data.fileEntry, !!data.delete, maxSize, upload, allowOffline);
                                }
                                else if (data.path) {
                                    let fileEntry;
                                    try {
                                        // The handler provided a path. First treat it like it's a relative path.
                                        fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFile(data.path);
                                    }
                                    catch (error) {
                                        // File not found, it's probably an absolute path.
                                        fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getExternalFile(data.path);
                                    }
                                    // File found, treat it.
                                    result = yield this.uploadFileEntry(fileEntry, !!data.delete, maxSize, upload, allowOffline);
                                }
                                if (!result) {
                                    // Nothing received, fail.
                                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"]('No file received');
                                }
                                this.fileUploaded(result);
                                return true;
                            }
                            catch (error) {
                                _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.errorreadingfile'));
                                return false;
                            }
                        }),
                    });
                });
                this.actionSheet = yield _singletons__WEBPACK_IMPORTED_MODULE_7__[/* ActionSheetController */ "a"].create({
                    header: title ? title : _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.' + (upload ? 'uploadafile' : 'selectafile')),
                    buttons: buttons,
                });
                yield this.actionSheet.present();
                // Call afterRender for each button.
                setTimeout(() => {
                    handlers.forEach((handler) => {
                        if (handler.afterRender) {
                            handler.afterRender(maxSize, upload, allowOffline, handler.mimetypes);
                        }
                    });
                }, 500);
                return this.filePickerDeferred.promise;
            });
        }
        /**
         * Convenience function to upload a file on a certain site, showing a confirm if needed.
         *
         * @param fileEntry FileEntry of the file to upload.
         * @param deleteAfterUpload Whether the file should be deleted after upload.
         * @param siteId Id of the site to upload the file to. If not defined, use current site.
         * @return Promise resolved when the file is uploaded.
         */
        showConfirmAndUploadInSite(fileEntry, deleteAfterUpload, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                try {
                    const file = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileObjectFromFileEntry(fileEntry);
                    yield this.confirmUploadFile(file.size);
                    yield this.uploadGenericFile(fileEntry.toURL(), file.name, file.type, deleteAfterUpload, siteId);
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showToast('core.fileuploader.fileuploaded', true, undefined, 'core-toast-success');
                }
                catch (error) {
                    _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showErrorModalDefault(error, 'core.fileuploader.errorreadingfile', true);
                    throw error;
                }
            });
        }
        /**
         * Treat a capture audio/video error.
         *
         * @param error Error returned by the Cordova plugin.
         * @param defaultMessage Key of the default message to show.
         * @return Rejected promise.
         */
        treatCaptureError(error, defaultMessage) {
            // Cancelled or error. If cancelled, error is an object with code = 3.
            if (error) {
                if (error.code != 3) {
                    // Error, not cancelled.
                    this.logger.error('Error while recording audio/video', error);
                    const message = this.isNoAppError(error) ? _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.errornoapp') :
                        (error.message || _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant(defaultMessage));
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](message);
                }
                else {
                    throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__[/* CoreCanceledError */ "a"]();
                }
            }
            throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"]('Error capturing media');
        }
        /**
         * Check if a capture error is because there is no app to capture.
         *
         * @param error Error.
         * @return Whether it's because there is no app.
         */
        isNoAppError(error) {
            return error && error.code == 20;
        }
        /**
         * Treat a capture image or browse album error.
         *
         * @param error Error returned by the Cordova plugin.
         * @param defaultMessage Key of the default message to show.
         * @return Rejected promise. If it doesn't have an error message it means it was cancelled.
         */
        treatImageError(error, defaultMessage) {
            // Cancelled or error.
            if (!error || typeof error == 'number') {
                return new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](defaultMessage);
            }
            if (typeof error == 'string') {
                if (error.toLowerCase().indexOf('no image selected') > -1) {
                    // User cancelled.
                    return new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__[/* CoreCanceledError */ "a"]();
                }
                return new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](error);
            }
            else if ('code' in error && error.code == 3) {
                throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__[/* CoreCanceledError */ "a"]();
            }
            else {
                throw error;
            }
        }
        /**
         * Convenient helper for the user to record and upload a video.
         *
         * @param isAudio True if uploading an audio, false if it's a video.
         * @param maxSize Max size of the upload. -1 for no max size.
         * @param upload True if the file should be uploaded, false to return the picked file.
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @return Promise resolved when done.
         */
        uploadAudioOrVideo(isAudio, maxSize, upload, mimetypes) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                this.logger.debug('Trying to record a ' + (isAudio ? 'audio' : 'video') + ' file');
                // The mimetypes param is only for browser, the Cordova plugin doesn't support it.
                const captureOptions = { limit: 1, mimetypes: mimetypes };
                let media;
                try {
                    const medias = isAudio ? yield _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].captureAudio(captureOptions) :
                        yield _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].captureVideo(captureOptions);
                    media = medias[0]; // We used limit 1, we only want 1 media.
                }
                catch (error) {
                    if (isAudio && this.isNoAppError(error) && _services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isMobile() &&
                        (!_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Platform */ "C"].is('android') || _services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].getPlatformMajorVersion() < 10)) {
                        // No app to record audio, fallback to capture it ourselves.
                        // In Android it will only be done in Android 9 or lower because there's a bug in the plugin.
                        try {
                            media = yield _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].captureAudioInApp();
                        }
                        catch (error) {
                            throw this.treatCaptureError(error, 'core.fileuploader.errorcapturingaudio'); // Throw the right error.
                        }
                    }
                    else {
                        const defaultError = isAudio ? 'core.fileuploader.errorcapturingaudio' : 'core.fileuploader.errorcapturingvideo';
                        throw this.treatCaptureError(error, defaultError); // Throw the right error.
                    }
                }
                let path = media.fullPath;
                const error = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].isInvalidMimetype(mimetypes, path); // Verify that the mimetype is supported.
                if (error) {
                    throw new Error(error);
                }
                // Make sure the path has the protocol. In iOS it doesn't.
                if (_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isMobile() && path.indexOf('file://') == -1) {
                    path = 'file://' + path;
                }
                const options = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].getMediaUploadOptions(media);
                if (upload) {
                    return this.uploadFile(path, maxSize || -1, true, options);
                }
                else {
                    // Copy or move the file to our temporary folder.
                    return this.copyToTmpFolder(path, true, maxSize, undefined, options);
                }
            });
        }
        /**
         * Uploads a file of any type.
         * This function will not check the size of the file, please check it before calling this function.
         *
         * @param uri File URI.
         * @param name File name.
         * @param type File type.
         * @param deleteAfterUpload Whether the file should be deleted after upload.
         * @param siteId Id of the site to upload the file to. If not defined, use current site.
         * @return Promise resolved when the file is uploaded.
         */
        uploadGenericFile(uri, name, type, deleteAfterUpload, siteId) {
            const options = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].getFileUploadOptions(uri, name, type, deleteAfterUpload);
            return this.uploadFile(uri, -1, false, options, siteId);
        }
        /**
         * Convenient helper for the user to upload an image, either from the album or taking it with the camera.
         *
         * @param fromAlbum True if the image should be selected from album, false if it should be taken with camera.
         * @param maxSize Max size of the upload. -1 for no max size.
         * @param upload True if the file should be uploaded, false to return the picked file.
         * @param mimetypes List of supported mimetypes. If undefined, all mimetypes supported.
         * @return Promise resolved when done.
         */
        uploadImage(fromAlbum, maxSize, upload, mimetypes) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                this.logger.debug('Trying to capture an image with camera');
                const options = {
                    quality: 50,
                    destinationType: _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].DestinationType.FILE_URI,
                    correctOrientation: true,
                };
                if (fromAlbum) {
                    const imageSupported = !mimetypes || _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].indexOfRegexp(mimetypes, /^image\//) > -1;
                    const videoSupported = !mimetypes || _services_utils_utils__WEBPACK_IMPORTED_MODULE_6__[/* CoreUtils */ "a"].indexOfRegexp(mimetypes, /^video\//) > -1;
                    options.sourceType = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].PictureSourceType.PHOTOLIBRARY;
                    options.popoverOptions = {
                        x: 10,
                        y: 10,
                        width: _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Platform */ "C"].width() - 200,
                        height: _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Platform */ "C"].height() - 200,
                        arrowDir: _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].PopoverArrowDirection.ARROW_ANY,
                    };
                    // Determine the mediaType based on the mimetypes.
                    if (imageSupported && !videoSupported) {
                        options.mediaType = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].MediaType.PICTURE;
                    }
                    else if (!imageSupported && videoSupported) {
                        options.mediaType = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].MediaType.VIDEO;
                    }
                    else if (_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isIOS()) {
                        // Only get all media in iOS because in Android using this option allows uploading any kind of file.
                        options.mediaType = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].MediaType.ALLMEDIA;
                    }
                }
                else if (mimetypes) {
                    if (mimetypes.indexOf('image/jpeg') > -1) {
                        options.encodingType = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].EncodingType.JPEG;
                    }
                    else if (mimetypes.indexOf('image/png') > -1) {
                        options.encodingType = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Camera */ "f"].EncodingType.PNG;
                    }
                }
                let path;
                try {
                    path = yield _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].getPicture(options);
                }
                catch (error) {
                    const defaultError = fromAlbum ? 'core.fileuploader.errorgettingimagealbum' : 'core.fileuploader.errorcapturingimage';
                    throw this.treatImageError(error, _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant(defaultError));
                }
                const error = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].isInvalidMimetype(mimetypes, path); // Verify that the mimetype is supported.
                if (error) {
                    throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_10__[/* CoreError */ "a"](error);
                }
                const uploadOptions = _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].getCameraUploadOptions(path, fromAlbum);
                if (upload) {
                    return this.uploadFile(path, maxSize || -1, true, uploadOptions);
                }
                else {
                    // Copy or move the file to our temporary folder.
                    return this.copyToTmpFolder(path, !fromAlbum, maxSize, 'jpg', uploadOptions);
                }
            });
        }
        /**
         * Upload a file given the file entry.
         *
         * @param fileEntry The file entry.
         * @param deleteAfter True if the file should be deleted once treated.
         * @param maxSize Max size of the file. If not defined or -1, no max size.
         * @param upload True if the file should be uploaded, false to return the picked file.
         * @param allowOffline True to allow selecting in offline, false to require connection.
         * @param name Name to use when uploading the file. If not defined, use the file's name.
         * @return Promise resolved when done.
         */
        uploadFileEntry(fileEntry, deleteAfter, maxSize, upload, allowOffline, name) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const file = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileObjectFromFileEntry(fileEntry);
                const result = yield this.uploadFileObject(file, maxSize, upload, allowOffline, name);
                if (deleteAfter) {
                    // We have uploaded and deleted a copy of the file. Now delete the original one.
                    _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].removeFileByFileEntry(fileEntry);
                }
                return result;
            });
        }
        /**
         * Upload a file given the file object.
         *
         * @param file The file object.
         * @param maxSize Max size of the file. If not defined or -1, no max size.
         * @param upload True if the file should be uploaded, false to return the picked file.
         * @param allowOffline True to allow selecting in offline, false to require connection.
         * @param name Name to use when uploading the file. If not defined, use the file's name.
         * @return Promise resolved when done.
         */
        uploadFileObject(file, maxSize, upload, allowOffline, name) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (maxSize === 0) {
                    const siteInfo = (_a = _services_sites__WEBPACK_IMPORTED_MODULE_13__[/* CoreSites */ "b"].getCurrentSite()) === null || _a === void 0 ? void 0 : _a.getInfo();
                    if (siteInfo && siteInfo.usermaxuploadfilesize) {
                        maxSize = siteInfo.usermaxuploadfilesize;
                    }
                }
                if (maxSize !== undefined && maxSize != -1 && file.size > maxSize) {
                    throw this.createMaxBytesError(maxSize, file.name);
                }
                if (upload) {
                    yield this.confirmUploadFile(file.size, false, allowOffline);
                }
                // We have the data of the file to be uploaded, but not its URL (needed). Create a copy of the file to upload it.
                return this.copyAndUploadFile(file, upload, name);
            });
        }
        /**
         * Convenience function to upload a file, allowing to retry if it fails.
         *
         * @param path Absolute path of the file to upload.
         * @param maxSize Max size of the upload. -1 for no max size.
         * @param checkSize True to check size.
         * @param Options.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved if the file is uploaded, rejected otherwise.
         */
        uploadFile(path, maxSize, checkSize, options, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const errorStr = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.error');
                const retryStr = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.retry');
                const uploadingStr = _singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.uploading');
                const errorUploading = (error) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    // Allow the user to retry.
                    try {
                        yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showConfirm(error, errorStr, retryStr);
                    }
                    catch (error) {
                        // User cancelled. Delete the file if needed.
                        if (options.deleteAfterUpload) {
                            _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].removeExternalFile(path);
                        }
                        throw new _classes_errors_cancelederror__WEBPACK_IMPORTED_MODULE_9__[/* CoreCanceledError */ "a"]();
                    }
                    // Try again.
                    return this.uploadFile(path, maxSize, checkSize, options, siteId);
                });
                if (!_services_app__WEBPACK_IMPORTED_MODULE_1__[/* CoreApp */ "a"].isOnline()) {
                    return errorUploading(_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant('core.fileuploader.errormustbeonlinetoupload'));
                }
                let file;
                let size = 0;
                if (checkSize) {
                    try {
                        // Check that file size is the right one.
                        const fileEntry = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getExternalFile(path);
                        file = yield _services_file__WEBPACK_IMPORTED_MODULE_2__[/* CoreFile */ "a"].getFileObjectFromFileEntry(fileEntry);
                        size = file.size;
                    }
                    catch (error) {
                        // Ignore failures.
                    }
                }
                if (maxSize != -1 && size > maxSize) {
                    throw this.createMaxBytesError(maxSize, file.name);
                }
                if (size > 0) {
                    yield this.confirmUploadFile(size);
                }
                // File isn't too large and user confirmed, let's upload.
                const modal = yield _services_utils_dom__WEBPACK_IMPORTED_MODULE_3__[/* CoreDomUtils */ "a"].showModalLoading(uploadingStr);
                try {
                    return yield _fileuploader__WEBPACK_IMPORTED_MODULE_11__[/* CoreFileUploader */ "a"].uploadFile(path, options, (progress) => {
                        this.showProgressModal(modal, 'core.fileuploader.uploadingperc', progress);
                    }, siteId);
                }
                catch (error) {
                    this.logger.error('Error uploading file.', error);
                    modal.dismiss();
                    return errorUploading(error);
                }
                finally {
                    modal.dismiss();
                }
            });
        }
        /**
         * Show a progress modal.
         *
         * @param modal The modal where to show the progress.
         * @param stringKey The key of the string to display.
         * @param progress The progress event.
         */
        showProgressModal(modal, stringKey, progress) {
            if (!progress || !progress.lengthComputable) {
                return;
            }
            // Calculate the progress percentage.
            const perc = Math.min((progress.loaded / progress.total) * 100, 100);
            if (isNaN(perc) || perc < 0) {
                return;
            }
            modal.updateText(_singletons__WEBPACK_IMPORTED_MODULE_7__[/* Translate */ "L"].instant(stringKey, { $a: perc.toFixed(1) }));
        }
    }
    CoreFileUploaderHelperProvider.ɵfac = function CoreFileUploaderHelperProvider_Factory(t) { return new (t || CoreFileUploaderHelperProvider)(); };
    CoreFileUploaderHelperProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_14__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreFileUploaderHelperProvider, factory: CoreFileUploaderHelperProvider.ɵfac, providedIn: 'root' });
    return CoreFileUploaderHelperProvider;
})();
const CoreFileUploaderHelper = Object(_singletons__WEBPACK_IMPORTED_MODULE_7__[/* makeSingleton */ "P"])(CoreFileUploaderHelperProvider);


/***/ }),

/***/ "2vUU":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreSitePluginsModuleIndexComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("BaYo");
/* harmony import */ var _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("GBcW");
/* harmony import */ var _features_course_services_module_delegate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("yQ+R");
/* harmony import */ var _features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("zbKZ");
/* harmony import */ var _features_siteplugins_services_siteplugins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("TSsE");
/* harmony import */ var _services_utils_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("vuGA");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("j3ag");
/* harmony import */ var _plugin_content_plugin_content__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("BTA1");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.











function CoreSitePluginsModuleIndexComponent_core_site_plugins_plugin_content_11_Template(rf, ctx) {
    if (rf & 1) {
        const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵgetCurrentView */ "Fc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](0, "core-site-plugins-plugin-content", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵlistener */ "Mc"]("onContentLoaded", function CoreSitePluginsModuleIndexComponent_core_site_plugins_plugin_content_11_Template_core_site_plugins_plugin_content_onContentLoaded_0_listener($event) { _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵrestoreView */ "gd"](_r2); const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵnextContext */ "Oc"](); return ctx_r1.contentLoaded($event); })("onLoadingContent", function CoreSitePluginsModuleIndexComponent_core_site_plugins_plugin_content_11_Template_core_site_plugins_plugin_content_onLoadingContent_0_listener() { _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵrestoreView */ "gd"](_r2); const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵnextContext */ "Oc"](); return ctx_r3.contentLoading(); });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
    }
    if (rf & 2) {
        const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵnextContext */ "Oc"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("component", ctx_r0.component)("method", ctx_r0.method)("args", ctx_r0.args)("initResult", ctx_r0.initResult)("data", ctx_r0.jsData)("pageTitle", ctx_r0.pageTitle)("preSets", ctx_r0.preSets);
    }
}
const _c0 = function (a0) { return { $a: a0 }; };
/**
 * Component that displays the index of a module site plugin.
 */
let CoreSitePluginsModuleIndexComponent = /*@__PURE__*/ (() => {
    class CoreSitePluginsModuleIndexComponent {
        constructor() {
            this.displayOpenInBrowser = true;
            this.displayDescription = true;
            this.displayRefresh = true;
            this.displayPrefetch = true;
            this.displaySize = true;
            this.ptrEnabled = true;
            this.isDestroyed = false;
        }
        /**
         * Component being initialized.
         */
        ngOnInit() {
            this.refreshIcon = _core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].ICON_LOADING;
            if (!this.module) {
                return;
            }
            const handlerName = _features_course_services_module_delegate__WEBPACK_IMPORTED_MODULE_3__[/* CoreCourseModuleDelegate */ "a"].getHandlerName(this.module.modname);
            const handler = _features_siteplugins_services_siteplugins__WEBPACK_IMPORTED_MODULE_5__[/* CoreSitePlugins */ "a"].getSitePluginHandler(handlerName);
            if (handler) {
                this.component = handler.plugin.component;
                this.preSets = { componentId: this.module.id };
                this.method = handler.handlerSchema.method;
                this.args = {
                    courseid: this.courseId,
                    cmid: this.module.id,
                };
                this.initResult = handler.initResult;
                this.jsData = {
                    module: this.module,
                    courseId: this.courseId,
                };
                const handlerSchema = handler.handlerSchema;
                this.displayOpenInBrowser = !_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isFalseOrZero(handlerSchema.displayopeninbrowser);
                this.displayDescription = !_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isFalseOrZero(handlerSchema.displaydescription);
                this.displayRefresh = !_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isFalseOrZero(handlerSchema.displayrefresh);
                this.displayPrefetch = !_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isFalseOrZero(handlerSchema.displayprefetch);
                this.displaySize = !_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isFalseOrZero(handlerSchema.displaysize);
                this.ptrEnabled = !_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isFalseOrZero(handlerSchema.ptrenabled);
            }
            // Get the data for the context menu.
            this.description = this.module.description;
            this.externalUrl = this.module.url;
        }
        /**
         * Refresh the data.
         *
         * @param refresher Refresher.
         * @param done Function to call when done.
         * @return Promise resolved when done.
         */
        doRefresh(refresher, done) {
            var _a;
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                if (this.content) {
                    this.refreshIcon = _core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].ICON_LOADING;
                }
                try {
                    yield ((_a = this.content) === null || _a === void 0 ? void 0 : _a.refreshContent(false));
                }
                finally {
                    refresher === null || refresher === void 0 ? void 0 : refresher.complete();
                    done && done();
                }
            });
        }
        /**
         * Function called when the data of the site plugin content is loaded.
         */
        contentLoaded(refresh) {
            this.refreshIcon = _core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].ICON_REFRESH;
            // Check if there is a prefetch handler for this type of module.
            if (_features_course_services_module_prefetch_delegate__WEBPACK_IMPORTED_MODULE_4__[/* CoreCourseModulePrefetchDelegate */ "a"].getPrefetchHandlerFor(this.module)) {
                _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseHelper */ "a"].fillContextMenu(this, this.module, this.courseId, refresh, this.component);
            }
        }
        /**
         * Function called when starting to load the data of the site plugin content.
         */
        contentLoading() {
            this.refreshIcon = _core_constants__WEBPACK_IMPORTED_MODULE_1__[/* CoreConstants */ "a"].ICON_LOADING;
        }
        /**
         * Expand the description.
         */
        expandDescription() {
            _services_utils_text__WEBPACK_IMPORTED_MODULE_6__[/* CoreTextUtils */ "a"].viewText(_singletons__WEBPACK_IMPORTED_MODULE_8__[/* Translate */ "L"].instant('core.description'), this.description, {
                component: this.component,
                componentId: this.module.id,
                filter: true,
                contextLevel: 'module',
                instanceId: this.module.id,
                courseId: this.courseId,
            });
        }
        /**
         * Prefetch the module.
         */
        prefetch() {
            _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseHelper */ "a"].contextMenuPrefetch(this, this.module, this.courseId);
        }
        /**
         * Confirm and remove downloaded files.
         */
        removeFiles() {
            _features_course_services_course_helper__WEBPACK_IMPORTED_MODULE_2__[/* CoreCourseHelper */ "a"].confirmAndRemoveFiles(this.module, this.courseId);
        }
        /**
         * Component destroyed.
         */
        ngOnDestroy() {
            this.isDestroyed = true;
        }
        /**
         * Call a certain function on the component instance.
         *
         * @param name Name of the function to call.
         * @param params List of params to send to the function.
         * @return Result of the call. Undefined if no component instance or the function doesn't exist.
         */
        callComponentFunction(name, params) {
            var _a;
            return (_a = this.content) === null || _a === void 0 ? void 0 : _a.callComponentFunction(name, params);
        }
    }
    CoreSitePluginsModuleIndexComponent.ɵfac = function CoreSitePluginsModuleIndexComponent_Factory(t) { return new (t || CoreSitePluginsModuleIndexComponent)(); };
    CoreSitePluginsModuleIndexComponent.ɵcmp = _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵdefineComponent */ "sc"]({ type: CoreSitePluginsModuleIndexComponent, selectors: [["core-site-plugins-module-index"]], viewQuery: function CoreSitePluginsModuleIndexComponent_Query(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵviewQuery */ "ud"](_plugin_content_plugin_content__WEBPACK_IMPORTED_MODULE_9__[/* CoreSitePluginsPluginContentComponent */ "a"], true);
            }
            if (rf & 2) {
                var _t;
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵqueryRefresh */ "ed"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵloadQuery */ "Nc"]()) && (ctx.content = _t.first);
            }
        }, inputs: { module: "module", courseId: "courseId", pageTitle: "pageTitle" }, decls: 12, vars: 34, consts: [["slot", "end"], ["iconAction", "fas-external-link-alt", 3, "hidden", "priority", "content", "href"], ["iconAction", "fas-arrow-right", 3, "hidden", "priority", "content", "action"], [3, "hidden", "priority", "content", "iconAction", "closeOnClick", "action"], ["iconAction", "fas-trash", 3, "hidden", "priority", "content", "iconDescription", "closeOnClick", "action"], [3, "component", "method", "args", "initResult", "data", "pageTitle", "preSets", "onContentLoaded", "onLoadingContent", 4, "ngIf"], [3, "component", "method", "args", "initResult", "data", "pageTitle", "preSets", "onContentLoaded", "onLoadingContent"]], template: function CoreSitePluginsModuleIndexComponent_Template(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](0, "core-navbar-buttons", 0);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](1, "core-context-menu");
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelement */ "zc"](2, "core-context-menu-item", 1);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipe */ "Pc"](3, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](4, "core-context-menu-item", 2);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵlistener */ "Mc"]("action", function CoreSitePluginsModuleIndexComponent_Template_core_context_menu_item_action_4_listener() { return ctx.expandDescription(); });
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipe */ "Pc"](5, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](6, "core-context-menu-item", 3);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵlistener */ "Mc"]("action", function CoreSitePluginsModuleIndexComponent_Template_core_context_menu_item_action_6_listener($event) { return ctx.doRefresh(null, $event); });
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipe */ "Pc"](7, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](8, "core-context-menu-item", 3);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵlistener */ "Mc"]("action", function CoreSitePluginsModuleIndexComponent_Template_core_context_menu_item_action_8_listener() { return ctx.prefetch(); });
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementStart */ "Ec"](9, "core-context-menu-item", 4);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵlistener */ "Mc"]("action", function CoreSitePluginsModuleIndexComponent_Template_core_context_menu_item_action_9_listener() { return ctx.removeFiles(); });
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipe */ "Pc"](10, "translate");
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵelementEnd */ "Dc"]();
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵtemplate */ "nd"](11, CoreSitePluginsModuleIndexComponent_core_site_plugins_plugin_content_11_Template, 1, 7, "core-site-plugins-plugin-content", 5);
            }
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("hidden", !ctx.displayOpenInBrowser || !ctx.externalUrl || (ctx.content == null ? null : ctx.content.compileComponent == null ? null : ctx.content.compileComponent.componentInstance == null ? null : ctx.content.compileComponent.componentInstance.displayOpenInBrowser) === false)("priority", 900)("content", _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipeBind1 */ "Qc"](3, 23, "core.openinbrowser"))("href", ctx.externalUrl);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("hidden", !ctx.displayDescription || !ctx.description || (ctx.content == null ? null : ctx.content.compileComponent == null ? null : ctx.content.compileComponent.componentInstance == null ? null : ctx.content.compileComponent.componentInstance.displayDescription) === false)("priority", 800)("content", _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipeBind1 */ "Qc"](5, 25, "core.moduleintro"));
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("hidden", !ctx.displayRefresh || (ctx.content == null ? null : ctx.content.compileComponent == null ? null : ctx.content.compileComponent.componentInstance == null ? null : ctx.content.compileComponent.componentInstance.displayRefresh) === false)("priority", 700)("content", _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipeBind1 */ "Qc"](7, 27, "core.refresh"))("iconAction", ctx.refreshIcon)("closeOnClick", false);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("hidden", !ctx.displayPrefetch || !ctx.prefetchStatusIcon || (ctx.content == null ? null : ctx.content.compileComponent == null ? null : ctx.content.compileComponent.componentInstance == null ? null : ctx.content.compileComponent.componentInstance.displayPrefetch) === false)("priority", 600)("content", ctx.prefetchText)("iconAction", ctx.prefetchStatusIcon)("closeOnClick", false);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵadvance */ "lc"](1);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("hidden", !ctx.displaySize || !ctx.size || (ctx.content == null ? null : ctx.content.compileComponent == null ? null : ctx.content.compileComponent.componentInstance == null ? null : ctx.content.compileComponent.componentInstance.displaySize) === false)("priority", 500)("content", _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpipeBind2 */ "Rc"](10, 29, "core.clearstoreddata", _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵpureFunction1 */ "ad"](32, _c0, ctx.size)))("iconDescription", "fas-archive")("closeOnClick", false);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵadvance */ "lc"](2);
                _angular_core__WEBPACK_IMPORTED_MODULE_10__[/* ɵɵproperty */ "Vc"]("ngIf", ctx.component && ctx.method);
            }
        }, styles: ["[_nghost-%COMP%] { display: contents; }"] });
    return CoreSitePluginsModuleIndexComponent;
})();


/***/ }),

/***/ "2yhU":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Badge; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _ionic_native_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("C6fG");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");




var Badge = /** @class */ /*@__PURE__*/ (function (_super) {
    Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __extends */ "b"])(Badge, _super);
    function Badge() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Badge.prototype.clear = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "clear", {}, arguments); };
    Badge.prototype.set = function (badgeNumber) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "set", {}, arguments); };
    Badge.prototype.get = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "get", {}, arguments); };
    Badge.prototype.increase = function (increaseBy) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "increase", {}, arguments); };
    Badge.prototype.decrease = function (decreaseBy) { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "decrease", {}, arguments); };
    Badge.prototype.isSupported = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "isSupported", {}, arguments); };
    Badge.prototype.hasPermission = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "hasPermission", {}, arguments); };
    Badge.prototype.requestPermission = function () { return Object(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* cordova */ "c"])(this, "requestPermission", {}, arguments); };
    Badge.pluginName = "Badge";
    Badge.plugin = "cordova-plugin-badge";
    Badge.pluginRef = "cordova.plugins.notification.badge";
    Badge.repo = "https://github.com/katzer/cordova-plugin-badge";
    Badge.platforms = ["Android", "Browser", "iOS", "Windows"];
    Badge.ɵfac = function Badge_Factory(t) { return ɵBadge_BaseFactory(t || Badge); };
    Badge.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineInjectable */ "uc"]({ token: Badge, factory: function (t) { return Badge.ɵfac(t); } });
    var ɵBadge_BaseFactory = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵgetInheritedFactory */ "Gc"](Badge);
    return Badge;
}(_ionic_native_core__WEBPACK_IMPORTED_MODULE_1__[/* IonicNativePlugin */ "a"]));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9AaW9uaWMtbmF0aXZlL3BsdWdpbnMvYmFkZ2Uvbmd4L2luZGV4LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sOEJBQXNDLE1BQU0sb0JBQW9CLENBQUM7O0FBQ3hFO0FBSVMsSUE0QmtCLHlCQUFpQjtBQUFDO0FBRTlCO0FBR0o7QUFDUCxJQUFGLHFCQUFLO0FBS2EsSUFLbEIsbUJBQUcsYUFBQyxXQUFtQjtBQUtmLElBSVIsbUJBQUc7QUFLaUIsSUFLcEIsd0JBQVEsYUFBQyxVQUFrQjtBQUtkLElBS2Isd0JBQVEsYUFBQyxVQUFrQjtBQUtkLElBSWIsMkJBQVc7QUFLaUIsSUFJNUIsNkJBQWE7QUFLaUIsSUFJOUIsaUNBQWlCO0FBSXNCO0FBQWdDO0FBQTJDO0FBQTREO0FBQW1FO3lDQTdFbFAsVUFBVTs7Ozs7MEJBQ0w7QUFBQyxnQkFsQ1A7QUFBRSxFQWtDeUIsaUJBQWlCO0FBQzNDLFNBRFksS0FBSztBQUFJIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQ29yZG92YSwgSW9uaWNOYXRpdmVQbHVnaW4sIFBsdWdpbiB9IGZyb20gJ0Bpb25pYy1uYXRpdmUvY29yZSc7XG5cbi8qKlxuICogQG5hbWUgQmFkZ2VcbiAqIEBwcmVtaWVyIGJhZGdlXG4gKiBAZGVzY3JpcHRpb25cbiAqIFRoZSBlc3NlbnRpYWwgcHVycG9zZSBvZiBiYWRnZSBudW1iZXJzIGlzIHRvIGVuYWJsZSBhbiBhcHBsaWNhdGlvbiB0byBpbmZvcm0gaXRzIHVzZXJzIHRoYXQgaXQgaGFzIHNvbWV0aGluZyBmb3IgdGhlbSDigJQgZm9yIGV4YW1wbGUsIHVucmVhZCBtZXNzYWdlcyDigJQgd2hlbiB0aGUgYXBwbGljYXRpb24gaXNu4oCZdCBydW5uaW5nIGluIHRoZSBmb3JlZ3JvdW5kLlxuICpcbiAqIFJlcXVpcmVzIENvcmRvdmEgcGx1Z2luOiBjb3Jkb3ZhLXBsdWdpbi1iYWRnZS4gRm9yIG1vcmUgaW5mbywgcGxlYXNlIHNlZSB0aGUgW0JhZGdlIHBsdWdpbiBkb2NzXShodHRwczovL2dpdGh1Yi5jb20va2F0emVyL2NvcmRvdmEtcGx1Z2luLWJhZGdlKS5cbiAqXG4gKiBBbmRyb2lkIE5vdGU6IEJhZGdlcyBoYXZlIGhpc3RvcmljYWxseSBvbmx5IGJlZW4gYSBmZWF0dXJlIGltcGxlbWVudGVkIGJ5IHRoaXJkIHBhcnR5IGxhdW5jaGVycyBhbmQgbm90IHZpc2libGUgdW5sZXNzIG9uZSBvZiB0aG9zZSBsYXVuY2hlcnMgd2FzIGJlaW5nIHVzZWQgKEUuRy4gU2Ftc3VuZyBvciBOb3ZhIExhdW5jaGVyKSBhbmQgaWYgZW5hYmxlZCBieSB0aGUgdXNlci4gQXMgb2YgQW5kcm9pZCA4IChPcmVvKSwgW25vdGlmaWNhdGlvbiBiYWRnZXNdKGh0dHBzOi8vZGV2ZWxvcGVyLmFuZHJvaWQuY29tL3RyYWluaW5nL25vdGlmeS11c2VyL2JhZGdlcykgd2VyZSBpbnRyb2R1Y2VkIG9mZmljaWFsbHkgdG8gcmVmbGVjdCB1bnJlYWQgbm90aWZpY2F0aW9ucy4gVGhpcyBwbHVnaW4gaXMgdW5saWtlbHkgdG8gd29yayBhcyBleHBlY3RlZCBvbiBkZXZpY2VzIHJ1bm5pbmcgQW5kcm9pZCA4IG9yIG5ld2VyLiBQbGVhc2Ugc2VlIHRoZSBbbG9jYWwgbm90aWZpY2F0aW9ucyBwbHVnaW4gZG9jc10oaHR0cHM6Ly9naXRodWIuY29tL2thdHplci9jb3Jkb3ZhLXBsdWdpbi1sb2NhbC1ub3RpZmljYXRpb25zKSBmb3IgbW9yZSBpbmZvcm1hdGlvbiBvbiBiYWRnZSB1c2Ugd2l0aCBub3RpZmljYXRpb25zLlxuICpcbiAqIEB1c2FnZVxuICogYGBgdHlwZXNjcmlwdFxuICogaW1wb3J0IHsgQmFkZ2UgfSBmcm9tICdAaW9uaWMtbmF0aXZlL2JhZGdlL25neCc7XG4gKlxuICogY29uc3RydWN0b3IocHJpdmF0ZSBiYWRnZTogQmFkZ2UpIHsgfVxuICpcbiAqIC4uLlxuICpcbiAqIHRoaXMuYmFkZ2Uuc2V0KDEwKTtcbiAqIHRoaXMuYmFkZ2UuaW5jcmVhc2UoMSk7XG4gKiB0aGlzLmJhZGdlLmNsZWFyKCk7XG4gKiBgYGBcbiAqL1xuQFBsdWdpbih7XG4gIHBsdWdpbk5hbWU6ICdCYWRnZScsXG4gIHBsdWdpbjogJ2NvcmRvdmEtcGx1Z2luLWJhZGdlJyxcbiAgcGx1Z2luUmVmOiAnY29yZG92YS5wbHVnaW5zLm5vdGlmaWNhdGlvbi5iYWRnZScsXG4gIHJlcG86ICdodHRwczovL2dpdGh1Yi5jb20va2F0emVyL2NvcmRvdmEtcGx1Z2luLWJhZGdlJyxcbiAgcGxhdGZvcm1zOiBbJ0FuZHJvaWQnLCAnQnJvd3NlcicsICdpT1MnLCAnV2luZG93cyddLFxufSlcbkBJbmplY3RhYmxlKClcbmV4cG9ydCBjbGFzcyBCYWRnZSBleHRlbmRzIElvbmljTmF0aXZlUGx1Z2luIHtcbiAgLyoqXG4gICAqIENsZWFyIHRoZSBiYWRnZSBvZiB0aGUgYXBwIGljb24uXG4gICAqIEByZXR1cm5zIHtQcm9taXNlPGJvb2xlYW4+fVxuICAgKi9cbiAgQENvcmRvdmEoKVxuICBjbGVhcigpOiBQcm9taXNlPGJvb2xlYW4+IHtcbiAgICByZXR1cm47XG4gIH1cblxuICAvKipcbiAgICogU2V0IHRoZSBiYWRnZSBvZiB0aGUgYXBwIGljb24uXG4gICAqIEBwYXJhbSB7bnVtYmVyfSBiYWRnZU51bWJlciAgVGhlIG5ldyBiYWRnZSBudW1iZXIuXG4gICAqIEByZXR1cm5zIHtQcm9taXNlPGFueT59XG4gICAqL1xuICBAQ29yZG92YSgpXG4gIHNldChiYWRnZU51bWJlcjogbnVtYmVyKTogUHJvbWlzZTxhbnk+IHtcbiAgICByZXR1cm47XG4gIH1cblxuICAvKipcbiAgICogR2V0IHRoZSBiYWRnZSBvZiB0aGUgYXBwIGljb24uXG4gICAqIEByZXR1cm5zIHtQcm9taXNlPGFueT59XG4gICAqL1xuICBAQ29yZG92YSgpXG4gIGdldCgpOiBQcm9taXNlPGFueT4ge1xuICAgIHJldHVybjtcbiAgfVxuXG4gIC8qKlxuICAgKiBJbmNyZWFzZSB0aGUgYmFkZ2UgbnVtYmVyLlxuICAgKiBAcGFyYW0ge251bWJlcn0gaW5jcmVhc2VCeSAgQ291bnQgdG8gYWRkIHRvIHRoZSBjdXJyZW50IGJhZGdlIG51bWJlclxuICAgKiBAcmV0dXJucyB7UHJvbWlzZTxhbnk+fVxuICAgKi9cbiAgQENvcmRvdmEoKVxuICBpbmNyZWFzZShpbmNyZWFzZUJ5OiBudW1iZXIpOiBQcm9taXNlPGFueT4ge1xuICAgIHJldHVybjtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWNyZWFzZSB0aGUgYmFkZ2UgbnVtYmVyLlxuICAgKiBAcGFyYW0ge251bWJlcn0gZGVjcmVhc2VCeSAgQ291bnQgdG8gc3VidHJhY3QgZnJvbSB0aGUgY3VycmVudCBiYWRnZSBudW1iZXJcbiAgICogQHJldHVybnMge1Byb21pc2U8YW55Pn1cbiAgICovXG4gIEBDb3Jkb3ZhKClcbiAgZGVjcmVhc2UoZGVjcmVhc2VCeTogbnVtYmVyKTogUHJvbWlzZTxhbnk+IHtcbiAgICByZXR1cm47XG4gIH1cblxuICAvKipcbiAgICogQ2hlY2sgc3VwcG9ydCB0byBzaG93IGJhZGdlcy5cbiAgICogQHJldHVybnMge1Byb21pc2U8YW55Pn1cbiAgICovXG4gIEBDb3Jkb3ZhKClcbiAgaXNTdXBwb3J0ZWQoKTogUHJvbWlzZTxhbnk+IHtcbiAgICByZXR1cm47XG4gIH1cblxuICAvKipcbiAgICogRGV0ZXJtaW5lIGlmIHRoZSBhcHAgaGFzIHBlcm1pc3Npb24gdG8gc2hvdyBiYWRnZXMuXG4gICAqIEByZXR1cm5zIHtQcm9taXNlPGFueT59XG4gICAqL1xuICBAQ29yZG92YSgpXG4gIGhhc1Blcm1pc3Npb24oKTogUHJvbWlzZTxhbnk+IHtcbiAgICByZXR1cm47XG4gIH1cblxuICAvKipcbiAgICogUmVnaXN0ZXIgcGVybWlzc2lvbiB0byBzZXQgYmFkZ2Ugbm90aWZpY2F0aW9uc1xuICAgKiBAcmV0dXJucyB7UHJvbWlzZTxhbnk+fVxuICAgKi9cbiAgQENvcmRvdmEoKVxuICByZXF1ZXN0UGVybWlzc2lvbigpOiBQcm9taXNlPGFueT4ge1xuICAgIHJldHVybjtcbiAgfVxufVxuIl19


/***/ }),

/***/ "2ykv":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Dutch (Belgium) [nl-be]
//! author : Joris Röling : https://github.com/jorisroling
//! author : Jacob Middag : https://github.com/middagj

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var monthsShortWithDots = 'jan._feb._mrt._apr._mei_jun._jul._aug._sep._okt._nov._dec.'.split(
            '_'
        ),
        monthsShortWithoutDots = 'jan_feb_mrt_apr_mei_jun_jul_aug_sep_okt_nov_dec'.split(
            '_'
        ),
        monthsParse = [
            /^jan/i,
            /^feb/i,
            /^maart|mrt.?$/i,
            /^apr/i,
            /^mei$/i,
            /^jun[i.]?$/i,
            /^jul[i.]?$/i,
            /^aug/i,
            /^sep/i,
            /^okt/i,
            /^nov/i,
            /^dec/i,
        ],
        monthsRegex = /^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december|jan\.?|feb\.?|mrt\.?|apr\.?|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i;

    var nlBe = moment.defineLocale('nl-be', {
        months: 'januari_februari_maart_april_mei_juni_juli_augustus_september_oktober_november_december'.split(
            '_'
        ),
        monthsShort: function (m, format) {
            if (!m) {
                return monthsShortWithDots;
            } else if (/-MMM-/.test(format)) {
                return monthsShortWithoutDots[m.month()];
            } else {
                return monthsShortWithDots[m.month()];
            }
        },

        monthsRegex: monthsRegex,
        monthsShortRegex: monthsRegex,
        monthsStrictRegex: /^(januari|februari|maart|april|mei|ju[nl]i|augustus|september|oktober|november|december)/i,
        monthsShortStrictRegex: /^(jan\.?|feb\.?|mrt\.?|apr\.?|mei|ju[nl]\.?|aug\.?|sep\.?|okt\.?|nov\.?|dec\.?)/i,

        monthsParse: monthsParse,
        longMonthsParse: monthsParse,
        shortMonthsParse: monthsParse,

        weekdays: 'zondag_maandag_dinsdag_woensdag_donderdag_vrijdag_zaterdag'.split(
            '_'
        ),
        weekdaysShort: 'zo._ma._di._wo._do._vr._za.'.split('_'),
        weekdaysMin: 'zo_ma_di_wo_do_vr_za'.split('_'),
        weekdaysParseExact: true,
        longDateFormat: {
            LT: 'HH:mm',
            LTS: 'HH:mm:ss',
            L: 'DD/MM/YYYY',
            LL: 'D MMMM YYYY',
            LLL: 'D MMMM YYYY HH:mm',
            LLLL: 'dddd D MMMM YYYY HH:mm',
        },
        calendar: {
            sameDay: '[vandaag om] LT',
            nextDay: '[morgen om] LT',
            nextWeek: 'dddd [om] LT',
            lastDay: '[gisteren om] LT',
            lastWeek: '[afgelopen] dddd [om] LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: 'over %s',
            past: '%s geleden',
            s: 'een paar seconden',
            ss: '%d seconden',
            m: 'één minuut',
            mm: '%d minuten',
            h: 'één uur',
            hh: '%d uur',
            d: 'één dag',
            dd: '%d dagen',
            M: 'één maand',
            MM: '%d maanden',
            y: 'één jaar',
            yy: '%d jaar',
        },
        dayOfMonthOrdinalParse: /\d{1,2}(ste|de)/,
        ordinal: function (number) {
            return (
                number +
                (number === 1 || number === 8 || number >= 20 ? 'ste' : 'de')
            );
        },
        week: {
            dow: 1, // Monday is the first day of the week.
            doy: 4, // The week that contains Jan 4th is the first week of the year.
        },
    });

    return nlBe;

})));


/***/ }),

/***/ "2zUM":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return EVENTS_TABLE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return DELETED_EVENTS_TABLE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CALENDAR_OFFLINE_SITE_SCHEMA; });
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/**
 * Database variables for AddonDatabaseOffline service.
 */
const EVENTS_TABLE = 'addon_calendar_offline_events';
const DELETED_EVENTS_TABLE = 'addon_calendar_deleted_events';
const CALENDAR_OFFLINE_SITE_SCHEMA = {
    name: 'AddonCalendarOfflineProvider',
    version: 1,
    tables: [
        {
            name: EVENTS_TABLE,
            columns: [
                {
                    name: 'id',
                    type: 'INTEGER',
                    primaryKey: true,
                },
                {
                    name: 'name',
                    type: 'TEXT',
                    notNull: true,
                },
                {
                    name: 'timestart',
                    type: 'INTEGER',
                    notNull: true,
                },
                {
                    name: 'eventtype',
                    type: 'TEXT',
                    notNull: true,
                },
                {
                    name: 'categoryid',
                    type: 'INTEGER',
                },
                {
                    name: 'courseid',
                    type: 'INTEGER',
                },
                {
                    name: 'groupcourseid',
                    type: 'INTEGER',
                },
                {
                    name: 'groupid',
                    type: 'INTEGER',
                },
                {
                    name: 'description',
                    type: 'TEXT',
                },
                {
                    name: 'location',
                    type: 'TEXT',
                },
                {
                    name: 'duration',
                    type: 'INTEGER',
                },
                {
                    name: 'timedurationuntil',
                    type: 'INTEGER',
                },
                {
                    name: 'timedurationminutes',
                    type: 'INTEGER',
                },
                {
                    name: 'repeat',
                    type: 'INTEGER',
                },
                {
                    name: 'repeats',
                    type: 'INTEGER',
                },
                {
                    name: 'repeatid',
                    type: 'INTEGER',
                },
                {
                    name: 'repeateditall',
                    type: 'INTEGER',
                },
                {
                    name: 'userid',
                    type: 'INTEGER',
                },
                {
                    name: 'timecreated',
                    type: 'INTEGER',
                },
            ],
        },
        {
            name: DELETED_EVENTS_TABLE,
            columns: [
                {
                    name: 'id',
                    type: 'INTEGER',
                    primaryKey: true,
                },
                {
                    name: 'name',
                    type: 'TEXT',
                    notNull: true,
                },
                {
                    name: 'repeat',
                    type: 'INTEGER',
                },
                {
                    name: 'timemodified',
                    type: 'INTEGER',
                },
            ],
        },
    ],
};


/***/ }),

/***/ "35jd":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CoreMainMenuDelegateService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreMainMenuDelegate; });
/* harmony import */ var _classes_delegate_sorted__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("4Qvl");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("j3ag");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("fXoL");
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.




/**
 * Service to interact with plugins to be shown in the main menu. Provides functions to register a plugin
 * and notify an update in the data.
 */
let CoreMainMenuDelegateService = /*@__PURE__*/ (() => {
    class CoreMainMenuDelegateService extends _classes_delegate_sorted__WEBPACK_IMPORTED_MODULE_0__[/* CoreSortedDelegate */ "a"] {
        constructor() {
            super('CoreMainMenuDelegate');
            this.featurePrefix = 'CoreMainMenuDelegate_';
        }
    }
    CoreMainMenuDelegateService.ɵfac = function CoreMainMenuDelegateService_Factory(t) { return new (t || CoreMainMenuDelegateService)(); };
    CoreMainMenuDelegateService.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_2__[/* ɵɵdefineInjectable */ "uc"]({ token: CoreMainMenuDelegateService, factory: CoreMainMenuDelegateService.ɵfac, providedIn: 'root' });
    return CoreMainMenuDelegateService;
})();
const CoreMainMenuDelegate = Object(_singletons__WEBPACK_IMPORTED_MODULE_1__[/* makeSingleton */ "P"])(CoreMainMenuDelegateService);


/***/ }),

/***/ "39eS":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AddonModDataAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return AddonModDataTemplateType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return AddonModDataTemplateMode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return AddonModDataProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AddonModData; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _classes_errors_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("93ts");
/* harmony import */ var _classes_site__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("kxYv");
/* harmony import */ var _features_course_services_log_helper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("TmfO");
/* harmony import */ var _services_app__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("nvXB");
/* harmony import */ var _services_filepool__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("ozqY");
/* harmony import */ var _services_sites__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("9+EE");
/* harmony import */ var _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("bFG1");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("j3ag");
/* harmony import */ var _data_fields_delegate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("Z5pz");
/* harmony import */ var _data_offline__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("RORn");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.












const ROOT_CACHE_KEY = 'mmaModData:';
var AddonModDataAction = /*@__PURE__*/ (function (AddonModDataAction) {
    AddonModDataAction["ADD"] = "add";
    AddonModDataAction["EDIT"] = "edit";
    AddonModDataAction["DELETE"] = "delete";
    AddonModDataAction["APPROVE"] = "approve";
    AddonModDataAction["DISAPPROVE"] = "disapprove";
    AddonModDataAction["USER"] = "user";
    AddonModDataAction["USERPICTURE"] = "userpicture";
    AddonModDataAction["MORE"] = "more";
    AddonModDataAction["MOREURL"] = "moreurl";
    AddonModDataAction["COMMENTS"] = "comments";
    AddonModDataAction["TIMEADDED"] = "timeadded";
    AddonModDataAction["TIMEMODIFIED"] = "timemodified";
    AddonModDataAction["TAGS"] = "tags";
    AddonModDataAction["APPROVALSTATUS"] = "approvalstatus";
    AddonModDataAction["DELCHECK"] = "delcheck";
    AddonModDataAction["EXPORT"] = "export";
    return AddonModDataAction;
})({});
var AddonModDataTemplateType = /*@__PURE__*/ (function (AddonModDataTemplateType) {
    AddonModDataTemplateType["LIST_HEADER"] = "listtemplateheader";
    AddonModDataTemplateType["LIST"] = "listtemplate";
    AddonModDataTemplateType["LIST_FOOTER"] = "listtemplatefooter";
    AddonModDataTemplateType["ADD"] = "addtemplate";
    AddonModDataTemplateType["SEARCH"] = "asearchtemplate";
    AddonModDataTemplateType["SINGLE"] = "singletemplate";
    return AddonModDataTemplateType;
})({});
var AddonModDataTemplateMode = /*@__PURE__*/ (function (AddonModDataTemplateMode) {
    AddonModDataTemplateMode["LIST"] = "list";
    AddonModDataTemplateMode["EDIT"] = "edit";
    AddonModDataTemplateMode["SHOW"] = "show";
    AddonModDataTemplateMode["SEARCH"] = "search";
    return AddonModDataTemplateMode;
})({});
/**
 * Service that provides some features for databases.
 */
let AddonModDataProvider = /*@__PURE__*/ (() => {
    class AddonModDataProvider {
        /**
         * Adds a new entry to a database.
         *
         * @param dataId Data instance ID.
         * @param entryId EntryId or provisional entry ID when offline.
         * @param courseId Course ID.
         * @param contents The fields data to be created.
         * @param groupId Group id, 0 means that the function will determine the user group.
         * @param fields The fields that define the contents.
         * @param siteId Site ID. If not defined, current site.
         * @param forceOffline Force editing entry in offline.
         * @return Promise resolved when the action is done.
         */
        addEntry(dataId, entryId, courseId, contents, groupId = 0, fields, siteId, forceOffline = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
                // Convenience function to store a data to be synchronized later.
                const storeOffline = () => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    const entry = yield _data_offline__WEBPACK_IMPORTED_MODULE_10__[/* AddonModDataOffline */ "a"].saveEntry(dataId, entryId, AddonModDataAction.ADD, courseId, groupId, contents, undefined, siteId);
                    return {
                        // Return provissional entry Id.
                        newentryid: entry.entryid,
                        sent: false,
                    };
                });
                // Checks to store offline.
                if (!_services_app__WEBPACK_IMPORTED_MODULE_4__[/* CoreApp */ "a"].isOnline() || forceOffline) {
                    const notifications = this.checkFields(fields, contents);
                    if (notifications.length > 0) {
                        return { fieldnotifications: notifications };
                    }
                }
                // Remove unnecessary not synced actions.
                yield this.deleteEntryOfflineAction(dataId, entryId, AddonModDataAction.ADD, siteId);
                // App is offline, store the action.
                if (!_services_app__WEBPACK_IMPORTED_MODULE_4__[/* CoreApp */ "a"].isOnline() || forceOffline) {
                    return storeOffline();
                }
                try {
                    const result = yield this.addEntryOnline(dataId, contents, groupId, siteId);
                    result.sent = true;
                    return result;
                }
                catch (error) {
                    if (_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // The WebService has thrown an error, this means that responses cannot be submitted.
                        throw error;
                    }
                    // Couldn't connect to server, store in offline.
                    return storeOffline();
                }
            });
        }
        /**
         * Adds a new entry to a database. It does not cache calls. It will fail if offline or cannot connect.
         *
         * @param dataId Database ID.
         * @param data The fields data to be created.
         * @param groupId Group id, 0 means that the function will determine the user group.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the action is done.
         */
        addEntryOnline(dataId, data, groupId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                const params = {
                    databaseid: dataId,
                    data,
                };
                if (typeof groupId !== 'undefined') {
                    params.groupid = groupId;
                }
                return site.write('mod_data_add_entry', params);
            });
        }
        /**
         * Approves or unapproves an entry.
         *
         * @param dataId Database ID.
         * @param entryId Entry ID.
         * @param approve Whether to approve (true) or unapprove the entry.
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the action is done.
         */
        approveEntry(dataId, entryId, approve, courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
                // Convenience function to store a data to be synchronized later.
                const storeOffline = () => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    const action = approve ? AddonModDataAction.APPROVE : AddonModDataAction.DISAPPROVE;
                    yield _data_offline__WEBPACK_IMPORTED_MODULE_10__[/* AddonModDataOffline */ "a"].saveEntry(dataId, entryId, action, courseId, undefined, undefined, undefined, siteId);
                    return {
                        sent: false,
                    };
                });
                // Get if the opposite action is not synced.
                const oppositeAction = approve ? AddonModDataAction.DISAPPROVE : AddonModDataAction.APPROVE;
                const found = yield this.deleteEntryOfflineAction(dataId, entryId, oppositeAction, siteId);
                if (found) {
                    // Offline action has been found and deleted. Stop here.
                    return;
                }
                if (!_services_app__WEBPACK_IMPORTED_MODULE_4__[/* CoreApp */ "a"].isOnline()) {
                    // App is offline, store the action.
                    return storeOffline();
                }
                try {
                    yield this.approveEntryOnline(entryId, approve, siteId);
                    return {
                        sent: true,
                    };
                }
                catch (error) {
                    if (_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // The WebService has thrown an error, this means that responses cannot be submitted.
                        throw error;
                    }
                    // Couldn't connect to server, store in offline.
                    return storeOffline();
                }
            });
        }
        /**
         * Approves or unapproves an entry. It does not cache calls. It will fail if offline or cannot connect.
         *
         * @param entryId Entry ID.
         * @param approve Whether to approve (true) or unapprove the entry.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the action is done.
         */
        approveEntryOnline(entryId, approve, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                const params = {
                    entryid: entryId,
                    approve,
                };
                yield site.write('mod_data_approve_entry', params);
            });
        }
        /**
         * Convenience function to check fields requeriments here named "notifications".
         *
         * @param fields The fields that define the contents.
         * @param contents The contents data of the fields.
         * @return Array of notifications if any or false.
         */
        checkFields(fields, contents) {
            const notifications = [];
            const contentsIndexed = _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].arrayToObjectMultiple(contents, 'fieldid');
            // App is offline, check required fields.
            fields.forEach((field) => {
                const notification = _data_fields_delegate__WEBPACK_IMPORTED_MODULE_9__[/* AddonModDataFieldsDelegate */ "a"].getFieldsNotifications(field, contentsIndexed[field.id]);
                if (notification) {
                    notifications.push({
                        fieldname: field.name,
                        notification,
                    });
                }
            });
            return notifications;
        }
        /**
         * Deletes an entry.
         *
         * @param dataId Database ID.
         * @param entryId Entry ID.
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the action is done.
         */
        deleteEntry(dataId, entryId, courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
                // Convenience function to store a data to be synchronized later.
                const storeOffline = () => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    yield _data_offline__WEBPACK_IMPORTED_MODULE_10__[/* AddonModDataOffline */ "a"].saveEntry(dataId, entryId, AddonModDataAction.DELETE, courseId, undefined, undefined, undefined, siteId);
                });
                // Check if the opposite action is not synced and just delete it.
                const addedOffline = yield this.deleteEntryOfflineAction(dataId, entryId, AddonModDataAction.ADD, siteId);
                if (addedOffline) {
                    // Offline add action found and deleted. Stop here.
                    return;
                }
                if (!_services_app__WEBPACK_IMPORTED_MODULE_4__[/* CoreApp */ "a"].isOnline()) {
                    // App is offline, store the action.
                    return storeOffline();
                }
                try {
                    yield this.deleteEntryOnline(entryId, siteId);
                }
                catch (error) {
                    if (_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // The WebService has thrown an error, this means that responses cannot be submitted.
                        throw error;
                    }
                    // Couldn't connect to server, store in offline.
                    return storeOffline();
                }
            });
        }
        /**
         * Deletes an entry. It does not cache calls. It will fail if offline or cannot connect.
         *
         * @param entryId Entry ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the action is done.
         */
        deleteEntryOnline(entryId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                const params = {
                    entryid: entryId,
                };
                yield site.write('mod_data_delete_entry', params);
            });
        }
        /**
         * Delete entry offline action.
         *
         * @param dataId Database ID.
         * @param entryId Entry ID.
         * @param action Action name to delete.
         * @param siteId Site ID.
         * @return Resolved with true if the action has been found and deleted.
         */
        deleteEntryOfflineAction(dataId, entryId, action, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                try {
                    // Get other not not synced actions.
                    yield _data_offline__WEBPACK_IMPORTED_MODULE_10__[/* AddonModDataOffline */ "a"].getEntry(dataId, entryId, action, siteId);
                    yield _data_offline__WEBPACK_IMPORTED_MODULE_10__[/* AddonModDataOffline */ "a"].deleteEntry(dataId, entryId, action, siteId);
                    return true;
                }
                catch (_a) {
                    // Not found.
                    return false;
                }
            });
        }
        /**
         * Updates an existing entry.
         *
         * @param dataId Database ID.
         * @param entryId Entry ID.
         * @param courseId Course ID.
         * @param contents The contents data to be updated.
         * @param fields The fields that define the contents.
         * @param siteId Site ID. If not defined, current site.
         * @param forceOffline Force editing entry in offline.
         * @return Promise resolved when the action is done.
         */
        editEntry(dataId, entryId, courseId, contents, fields, siteId, forceOffline = false) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
                // Convenience function to store a data to be synchronized later.
                const storeOffline = () => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    yield _data_offline__WEBPACK_IMPORTED_MODULE_10__[/* AddonModDataOffline */ "a"].saveEntry(dataId, entryId, AddonModDataAction.EDIT, courseId, undefined, contents, undefined, siteId);
                    return {
                        updated: true,
                        sent: false,
                    };
                });
                if (!_services_app__WEBPACK_IMPORTED_MODULE_4__[/* CoreApp */ "a"].isOnline() || forceOffline) {
                    const notifications = this.checkFields(fields, contents);
                    if (notifications.length > 0) {
                        return { fieldnotifications: notifications };
                    }
                }
                // Remove unnecessary not synced actions.
                yield this.deleteEntryOfflineAction(dataId, entryId, AddonModDataAction.EDIT, siteId);
                if (!_services_app__WEBPACK_IMPORTED_MODULE_4__[/* CoreApp */ "a"].isOnline() || forceOffline) {
                    // App is offline, store the action.
                    return storeOffline();
                }
                try {
                    const result = yield this.editEntryOnline(entryId, contents, siteId);
                    result.sent = true;
                    return result;
                }
                catch (error) {
                    if (_services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].isWebServiceError(error)) {
                        // The WebService has thrown an error, this means that responses cannot be submitted.
                        throw error;
                    }
                    // Couldn't connect to server, store in offline.
                    return storeOffline();
                }
            });
        }
        /**
         * Updates an existing entry. It does not cache calls. It will fail if offline or cannot connect.
         *
         * @param entryId Entry ID.
         * @param data The fields data to be updated.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the action is done.
         */
        editEntryOnline(entryId, data, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                const params = {
                    entryid: entryId,
                    data,
                };
                return site.write('mod_data_update_entry', params);
            });
        }
        /**
         * Performs the whole fetch of the entries in the database.
         *
         * @param dataId Data ID.
         * @param options Other options.
         * @return Promise resolved when done.
         */
        fetchAllEntries(dataId, options = {}) {
            options.siteId = options.siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
            options = Object.assign({
                page: 0,
                perPage: AddonModDataProvider.PER_PAGE,
            }, options);
            return this.fetchEntriesRecursive(dataId, [], options);
        }
        /**
         * Recursive call on fetch all entries.
         *
         * @param dataId Data ID.
         * @param entries Entries already fetch (just to concatenate them).
         * @param options Other options.
         * @return Promise resolved when done.
         */
        fetchEntriesRecursive(dataId, entries, options) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const result = yield this.getEntries(dataId, options);
                entries = entries.concat(result.entries);
                const canLoadMore = options.perPage > 0 && ((options.page + 1) * options.perPage) < result.totalcount;
                if (canLoadMore) {
                    options.page++;
                    return this.fetchEntriesRecursive(dataId, entries, options);
                }
                return entries;
            });
        }
        /**
         * Get cache key for data data WS calls.
         *
         * @param courseId Course ID.
         * @return Cache key.
         */
        getDatabaseDataCacheKey(courseId) {
            return ROOT_CACHE_KEY + 'data:' + courseId;
        }
        /**
         * Get prefix cache key for all database activity data WS calls.
         *
         * @param dataId Data ID.
         * @return Cache key.
         */
        getDatabaseDataPrefixCacheKey(dataId) {
            return ROOT_CACHE_KEY + dataId;
        }
        /**
         * Get a database data. If more than one is found, only the first will be returned.
         *
         * @param courseId Course ID.
         * @param key Name of the property to check.
         * @param value Value to search.
         * @param options Other options.
         * @return Promise resolved when the data is retrieved.
         */
        getDatabaseByKey(courseId, key, value, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(options.siteId);
                const params = {
                    courseids: [courseId],
                };
                const preSets = Object.assign({ cacheKey: this.getDatabaseDataCacheKey(courseId), updateFrequency: _classes_site__WEBPACK_IMPORTED_MODULE_2__[/* CoreSite */ "a"].FREQUENCY_RARELY, component: AddonModDataProvider.COMPONENT }, _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getReadingStrategyPreSets(options.readingStrategy));
                const response = yield site.read('mod_data_get_databases_by_courses', params, preSets);
                const currentData = response.databases.find((data) => data[key] == value);
                if (currentData) {
                    return currentData;
                }
                throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_1__[/* CoreError */ "a"]('Activity not found');
            });
        }
        /**
         * Get a data by course module ID.
         *
         * @param courseId Course ID.
         * @param cmId Course module ID.
         * @param options Other options.
         * @return Promise resolved when the data is retrieved.
         */
        getDatabase(courseId, cmId, options = {}) {
            return this.getDatabaseByKey(courseId, 'coursemodule', cmId, options);
        }
        /**
         * Get a data by ID.
         *
         * @param courseId Course ID.
         * @param id Data ID.
         * @param options Other options.
         * @return Promise resolved when the data is retrieved.
         */
        getDatabaseById(courseId, id, options = {}) {
            return this.getDatabaseByKey(courseId, 'id', id, options);
        }
        /**
         * Get prefix cache key for all database access information data WS calls.
         *
         * @param dataId Data ID.
         * @return Cache key.
         */
        getDatabaseAccessInformationDataPrefixCacheKey(dataId) {
            return this.getDatabaseDataPrefixCacheKey(dataId) + ':access:';
        }
        /**
         * Get cache key for database access information data WS calls.
         *
         * @param dataId Data ID.
         * @param groupId Group ID.
         * @return Cache key.
         */
        getDatabaseAccessInformationDataCacheKey(dataId, groupId = 0) {
            return this.getDatabaseAccessInformationDataPrefixCacheKey(dataId) + groupId;
        }
        /**
         * Get access information for a given database.
         *
         * @param dataId Data ID.
         * @param options Other options.
         * @return Promise resolved when the database is retrieved.
         */
        getDatabaseAccessInformation(dataId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(options.siteId);
                options.groupId = options.groupId || 0;
                const params = {
                    databaseid: dataId,
                    groupid: options.groupId,
                };
                const preSets = Object.assign({ cacheKey: this.getDatabaseAccessInformationDataCacheKey(dataId, options.groupId), component: AddonModDataProvider.COMPONENT, componentId: options.cmId }, _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getReadingStrategyPreSets(options.readingStrategy));
                return site.read('mod_data_get_data_access_information', params, preSets);
            });
        }
        /**
         * Get entries for a specific database and group.
         *
         * @param dataId Data ID.
         * @param options Other options.
         * @return Promise resolved when the database is retrieved.
         */
        getEntries(dataId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                options = Object.assign({
                    groupId: 0,
                    sort: 0,
                    order: 'DESC',
                    page: 0,
                    perPage: AddonModDataProvider.PER_PAGE,
                }, options);
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(options.siteId);
                // Always use sort and order params to improve cache usage (entries are identified by params).
                const params = {
                    databaseid: dataId,
                    returncontents: true,
                    page: options.page,
                    perpage: options.perPage,
                    groupid: options.groupId,
                    sort: options.sort,
                    order: options.order,
                };
                const preSets = Object.assign({ cacheKey: this.getEntriesCacheKey(dataId, options.groupId), updateFrequency: _classes_site__WEBPACK_IMPORTED_MODULE_2__[/* CoreSite */ "a"].FREQUENCY_SOMETIMES, component: AddonModDataProvider.COMPONENT, componentId: options.cmId }, _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getReadingStrategyPreSets(options.readingStrategy));
                const response = yield site.read('mod_data_get_entries', params, preSets);
                const entriesFormatted = response.entries.map((entry) => this.formatEntryContents(entry));
                return Object.assign(response, {
                    entries: entriesFormatted,
                });
            });
        }
        /**
         * Get cache key for database entries data WS calls.
         *
         * @param dataId Data ID.
         * @param groupId Group ID.
         * @return Cache key.
         */
        getEntriesCacheKey(dataId, groupId = 0) {
            return this.getEntriesPrefixCacheKey(dataId) + groupId;
        }
        /**
         * Get prefix cache key for database all entries data WS calls.
         *
         * @param dataId Data ID.
         * @return Cache key.
         */
        getEntriesPrefixCacheKey(dataId) {
            return this.getDatabaseDataPrefixCacheKey(dataId) + ':entries:';
        }
        /**
         * Get an entry of the database activity.
         *
         * @param dataId Data ID for caching purposes.
         * @param entryId Entry ID.
         * @param options Other options.
         * @return Promise resolved when the entry is retrieved.
         */
        getEntry(dataId, entryId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(options.siteId);
                const params = {
                    entryid: entryId,
                    returncontents: true,
                };
                const preSets = Object.assign({ cacheKey: this.getEntryCacheKey(dataId, entryId), updateFrequency: _classes_site__WEBPACK_IMPORTED_MODULE_2__[/* CoreSite */ "a"].FREQUENCY_SOMETIMES, component: AddonModDataProvider.COMPONENT, componentId: options.cmId }, _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getReadingStrategyPreSets(options.readingStrategy));
                const response = yield site.read('mod_data_get_entry', params, preSets);
                return Object.assign(response, {
                    entry: this.formatEntryContents(response.entry),
                });
            });
        }
        /**
         * Formats the contents of an entry.
         *
         * @param entry Original WS entry.
         * @returns Entry with contents formatted.
         */
        formatEntryContents(entry) {
            return Object.assign(entry, {
                contents: _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].arrayToObject(entry.contents, 'fieldid'),
            });
        }
        /**
         * Get cache key for database entry data WS calls.
         *
         * @param dataId Data ID for caching purposes.
         * @param entryId Entry ID.
         * @return Cache key.
         */
        getEntryCacheKey(dataId, entryId) {
            return this.getDatabaseDataPrefixCacheKey(dataId) + ':entry:' + entryId;
        }
        /**
         * Get the list of configured fields for the given database.
         *
         * @param dataId Data ID.
         * @param options Other options.
         * @return Promise resolved when the fields are retrieved.
         */
        getFields(dataId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(options.siteId);
                const params = {
                    databaseid: dataId,
                };
                const preSets = Object.assign({ cacheKey: this.getFieldsCacheKey(dataId), updateFrequency: _classes_site__WEBPACK_IMPORTED_MODULE_2__[/* CoreSite */ "a"].FREQUENCY_RARELY, component: AddonModDataProvider.COMPONENT, componentId: options.cmId }, _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getReadingStrategyPreSets(options.readingStrategy));
                const response = yield site.read('mod_data_get_fields', params, preSets);
                if (response.fields) {
                    return response.fields;
                }
                throw new _classes_errors_error__WEBPACK_IMPORTED_MODULE_1__[/* CoreError */ "a"]('No fields were returned.');
            });
        }
        /**
         * Get cache key for database fields data WS calls.
         *
         * @param dataId Data ID.
         * @return Cache key.
         */
        getFieldsCacheKey(dataId) {
            return this.getDatabaseDataPrefixCacheKey(dataId) + ':fields';
        }
        /**
         * Invalidate the prefetched content.
         * To invalidate files, use AddonModDataProvider#invalidateFiles.
         *
         * @param moduleId The module ID.
         * @param courseId Course ID of the module.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateContent(moduleId, courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                siteId = siteId || _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getCurrentSiteId();
                const promises = [];
                promises.push(this.getDatabase(courseId, moduleId).then((database) => Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                    const ps = [];
                    // Do not invalidate module data before getting module info, we need it!
                    ps.push(this.invalidateDatabaseData(courseId, siteId));
                    ps.push(this.invalidateDatabaseWSData(database.id, siteId));
                    ps.push(this.invalidateFieldsData(database.id, siteId));
                    yield Promise.all(ps);
                    return;
                })));
                promises.push(this.invalidateFiles(moduleId, siteId));
                yield _services_utils_utils__WEBPACK_IMPORTED_MODULE_7__[/* CoreUtils */ "a"].allPromises(promises);
            });
        }
        /**
         * Invalidates database access information data.
         *
         * @param dataId Data ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateDatabaseAccessInformationData(dataId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                yield site.invalidateWsCacheForKeyStartingWith(this.getDatabaseAccessInformationDataPrefixCacheKey(dataId));
            });
        }
        /**
         * Invalidates database entries data.
         *
         * @param dataId Data ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateEntriesData(dataId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                yield site.invalidateWsCacheForKeyStartingWith(this.getEntriesPrefixCacheKey(dataId));
            });
        }
        /**
         * Invalidates database fields data.
         *
         * @param dataId Data ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateFieldsData(dataId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                yield site.invalidateWsCacheForKey(this.getFieldsCacheKey(dataId));
            });
        }
        /**
         * Invalidate the prefetched files.
         *
         * @param moduleId The module ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the files are invalidated.
         */
        invalidateFiles(moduleId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                yield _services_filepool__WEBPACK_IMPORTED_MODULE_5__[/* CoreFilepool */ "a"].invalidateFilesByComponent(siteId, AddonModDataProvider.COMPONENT, moduleId);
            });
        }
        /**
         * Invalidates database data.
         *
         * @param courseId Course ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateDatabaseData(courseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                yield site.invalidateWsCacheForKey(this.getDatabaseDataCacheKey(courseId));
            });
        }
        /**
         * Invalidates database data except files and module info.
         *
         * @param databaseId Data ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateDatabaseWSData(databaseId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                yield site.invalidateWsCacheForKeyStartingWith(this.getDatabaseDataPrefixCacheKey(databaseId));
            });
        }
        /**
         * Invalidates database entry data.
         *
         * @param dataId Data ID for caching purposes.
         * @param entryId Entry ID.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the data is invalidated.
         */
        invalidateEntryData(dataId, entryId, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                yield site.invalidateWsCacheForKey(this.getEntryCacheKey(dataId, entryId));
            });
        }
        /**
         * Return whether or not the plugin is enabled in a certain site. Plugin is enabled if the database WS are available.
         *
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved with true if plugin is enabled, rejected or resolved with false otherwise.
         * @since 3.3
         */
        isPluginEnabled(siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(siteId);
                return site.wsAvailable('mod_data_get_data_access_information');
            });
        }
        /**
         * Report the database as being viewed.
         *
         * @param id Module ID.
         * @param name Name of the data.
         * @param siteId Site ID. If not defined, current site.
         * @return Promise resolved when the WS call is successful.
         */
        logView(id, name, siteId) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const params = {
                    databaseid: id,
                };
                yield _features_course_services_log_helper__WEBPACK_IMPORTED_MODULE_3__[/* CoreCourseLogHelper */ "a"].logSingle('mod_data_view_database', params, AddonModDataProvider.COMPONENT, id, name, 'data', {}, siteId);
            });
        }
        /**
         * Performs search over a database.
         *
         * @param dataId The data instance id.
         * @param options Other options.
         * @return Promise resolved when the action is done.
         */
        searchEntries(dataId, options = {}) {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                const site = yield _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getSite(options.siteId);
                options.groupId = options.groupId || 0;
                options.sort = options.sort || 0;
                options.order || options.order || 'DESC';
                options.page = options.page || 0;
                options.perPage = options.perPage || AddonModDataProvider.PER_PAGE;
                options.readingStrategy = options.readingStrategy || 3 /* PREFER_NETWORK */;
                const params = {
                    databaseid: dataId,
                    groupid: options.groupId,
                    returncontents: true,
                    page: options.page,
                    perpage: options.perPage,
                };
                const preSets = Object.assign({ component: AddonModDataProvider.COMPONENT, componentId: options.cmId }, _services_sites__WEBPACK_IMPORTED_MODULE_6__[/* CoreSites */ "b"].getReadingStrategyPreSets(options.readingStrategy));
                if (typeof options.sort != 'undefined') {
                    params.sort = options.sort;
                }
                if (typeof options.order !== 'undefined') {
                    params.order = options.order;
                }
                if (typeof options.search !== 'undefined') {
                    params.search = options.search;
                }
                if (typeof options.advSearch !== 'undefined') {
                    params.advsearch = options.advSearch;
                }
                const response = yield site.read('mod_data_search_entries', params, preSets);
                const entriesFormatted = response.entries.map((entry) => this.formatEntryContents(entry));
                return Object.assign(response, {
                    entries: entriesFormatted,
                });
            });
        }
    }
    AddonModDataProvider.COMPONENT = 'mmaModData';
    AddonModDataProvider.PER_PAGE = 25;
    AddonModDataProvider.ENTRY_CHANGED = 'addon_mod_data_entry_changed';
    AddonModDataProvider.ɵfac = function AddonModDataProvider_Factory(t) { return new (t || AddonModDataProvider)(); };
    AddonModDataProvider.ɵprov = _angular_core__WEBPACK_IMPORTED_MODULE_11__[/* ɵɵdefineInjectable */ "uc"]({ token: AddonModDataProvider, factory: AddonModDataProvider.ɵfac, providedIn: 'root' });
    return AddonModDataProvider;
})();
const AddonModData = Object(_singletons__WEBPACK_IMPORTED_MODULE_8__[/* makeSingleton */ "P"])(AddonModDataProvider);


/***/ }),

/***/ "39oe":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export I */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return sanitizeDOMString; });
/**
 * Does a simple sanitization of all elements
 * in an untrusted string
 */
const sanitizeDOMString = (untrustedString) => {
  try {
    if (untrustedString instanceof IonicSafeString) {
      return untrustedString.value;
    }
    if (!isSanitizerEnabled() || typeof untrustedString !== 'string' || untrustedString === '') {
      return untrustedString;
    }
    /**
     * Create a document fragment
     * separate from the main DOM,
     * create a div to do our work in
     */
    const documentFragment = document.createDocumentFragment();
    const workingDiv = document.createElement('div');
    documentFragment.appendChild(workingDiv);
    workingDiv.innerHTML = untrustedString;
    /**
     * Remove any elements
     * that are blocked
     */
    blockedTags.forEach(blockedTag => {
      const getElementsToRemove = documentFragment.querySelectorAll(blockedTag);
      for (let elementIndex = getElementsToRemove.length - 1; elementIndex >= 0; elementIndex--) {
        const element = getElementsToRemove[elementIndex];
        if (element.parentNode) {
          element.parentNode.removeChild(element);
        }
        else {
          documentFragment.removeChild(element);
        }
        /**
         * We still need to sanitize
         * the children of this element
         * as they are left behind
         */
        const childElements = getElementChildren(element);
        /* tslint:disable-next-line */
        for (let childIndex = 0; childIndex < childElements.length; childIndex++) {
          sanitizeElement(childElements[childIndex]);
        }
      }
    });
    /**
     * Go through remaining elements and remove
     * non-allowed attribs
     */
    // IE does not support .children on document fragments, only .childNodes
    const dfChildren = getElementChildren(documentFragment);
    /* tslint:disable-next-line */
    for (let childIndex = 0; childIndex < dfChildren.length; childIndex++) {
      sanitizeElement(dfChildren[childIndex]);
    }
    // Append document fragment to div
    const fragmentDiv = document.createElement('div');
    fragmentDiv.appendChild(documentFragment);
    // First child is always the div we did our work in
    const getInnerDiv = fragmentDiv.querySelector('div');
    return (getInnerDiv !== null) ? getInnerDiv.innerHTML : fragmentDiv.innerHTML;
  }
  catch (err) {
    console.error(err);
    return '';
  }
};
/**
 * Clean up current element based on allowed attributes
 * and then recursively dig down into any child elements to
 * clean those up as well
 */
const sanitizeElement = (element) => {
  // IE uses childNodes, so ignore nodes that are not elements
  if (element.nodeType && element.nodeType !== 1) {
    return;
  }
  for (let i = element.attributes.length - 1; i >= 0; i--) {
    const attribute = element.attributes.item(i);
    const attributeName = attribute.name;
    // remove non-allowed attribs
    if (!allowedAttributes.includes(attributeName.toLowerCase())) {
      element.removeAttribute(attributeName);
      continue;
    }
    // clean up any allowed attribs
    // that attempt to do any JS funny-business
    const attributeValue = attribute.value;
    /* tslint:disable-next-line */
    if (attributeValue != null && attributeValue.toLowerCase().includes('javascript:')) {
      element.removeAttribute(attributeName);
    }
  }
  /**
   * Sanitize any nested children
   */
  const childElements = getElementChildren(element);
  /* tslint:disable-next-line */
  for (let i = 0; i < childElements.length; i++) {
    sanitizeElement(childElements[i]);
  }
};
/**
 * IE doesn't always support .children
 * so we revert to .childNodes instead
 */
const getElementChildren = (el) => {
  return (el.children != null) ? el.children : el.childNodes;
};
const isSanitizerEnabled = () => {
  const win = window;
  const config = win && win.Ionic && win.Ionic.config;
  if (config) {
    if (config.get) {
      return config.get('sanitizerEnabled', true);
    }
    else {
      return config.sanitizerEnabled === true || config.sanitizerEnabled === undefined;
    }
  }
  return true;
};
const allowedAttributes = ['class', 'id', 'href', 'src', 'name', 'slot'];
const blockedTags = ['script', 'style', 'iframe', 'meta', 'link', 'object', 'embed'];
class IonicSafeString {
  constructor(value) {
    this.value = value;
  }
}




/***/ }),

/***/ "3CSS":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CoreFaIconDirective; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("mrSG");
/* harmony import */ var _singletons_logger__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("3j9v");
/* harmony import */ var _singletons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("j3ag");
/* harmony import */ var _core_constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("BaYo");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("fXoL");

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.





/**
 * Directive to enable font-awesome 5 as ionicons.
 * Check available icons at https://fontawesome.com/icons?d=gallery&m=free
 *
 * Example usage:
 *
 * <ion-icon name="fas-icon">
 */
let CoreFaIconDirective = /*@__PURE__*/ (() => {
    class CoreFaIconDirective {
        constructor(el) {
            this.name = '';
            this.element = el.nativeElement;
            this.logger = _singletons_logger__WEBPACK_IMPORTED_MODULE_1__[/* CoreLogger */ "a"].getInstance('CoreFaIconDirective');
        }
        /**
         * Detect icon name and use svg.
         */
        setIcon() {
            return Object(tslib__WEBPACK_IMPORTED_MODULE_0__[/* __awaiter */ "a"])(this, void 0, void 0, function* () {
                let library = 'ionic';
                let iconName = this.name;
                const parts = iconName.split('-', 2);
                if (parts.length == 2) {
                    switch (parts[0]) {
                        case 'far':
                            library = 'regular';
                            iconName = iconName.substr(4);
                            break;
                        case 'fa':
                        case 'fas':
                            library = 'solid';
                            iconName = iconName.substr(parts[0].length + 1);
                            break;
                        case 'fab':
                            library = 'brands';
                            iconName = iconName.substr(4);
                            break;
                        default:
                            break;
                    }
                }
                if (library != 'ionic') {
                    const src = `assets/fonts/font-awesome/${library}/${iconName}.svg`;
                    this.element.setAttribute('src', src);
                    this.element.classList.add('faicon');
                    if (_core_constants__WEBPACK_IMPORTED_MODULE_3__[/* CoreConstants */ "a"].BUILD.isDevelopment || _core_constants__WEBPACK_IMPORTED_MODULE_3__[/* CoreConstants */ "a"].BUILD.isTesting) {
                        try {
                            yield _singletons__WEBPACK_IMPORTED_MODULE_2__[/* Http */ "q"].get(src, { responseType: 'text' }).toPromise();
                        }
                        catch (error) {
                            this.logger.error(`Icon ${this.name} not found`);
                        }
                    }
                }
                else {
                    this.element.removeAttribute('src');
                    this.logger.warn(`Ionic icon ${this.name} detected`);
                }
                return;
            });
        }
        /**
         * @inheritdoc
         */
        ngAfterViewInit() {
            if (!this.element.getAttribute('aria-label') &&
                !this.element.getAttribute('aria-labelledby') &&
                this.element.getAttribute('aria-hidden') != 'true') {
                this.logger.warn('Aria label not set on icon ' + this.name, this.element);
                this.element.setAttribute('aria-hidden', 'true');
            }
        }
        /**
         * Detect changes on input properties.
         */
        ngOnChanges(changes) {
            if (!changes.name || !this.name) {
                return;
            }
            this.setIcon();
        }
    }
    CoreFaIconDirective.ɵfac = function CoreFaIconDirective_Factory(t) { return new (t || CoreFaIconDirective)(_angular_core__WEBPACK_IMPORTED_MODULE_4__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_4__[/* ElementRef */ "r"])); };
    CoreFaIconDirective.ɵdir = _angular_core__WEBPACK_IMPORTED_MODULE_4__[/* ɵɵdefineDirective */ "tc"]({ type: CoreFaIconDirective, selectors: [["ion-icon", "name", ""]], inputs: { name: "name" }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_4__[/* ɵɵNgOnChangesFeature */ "jc"]] });
    return CoreFaIconDirective;
})();


/***/ }),

/***/ "3E1r":
/***/ (function(module, exports, __webpack_require__) {

//! moment.js locale configuration
//! locale : Hindi [hi]
//! author : Mayank Singhal : https://github.com/mayanksinghal

;(function (global, factory) {
    true ? factory(__webpack_require__("wd/R")) :
   undefined
}(this, (function (moment) { 'use strict';

    //! moment.js locale configuration

    var symbolMap = {
            1: '१',
            2: '२',
            3: '३',
            4: '४',
            5: '५',
            6: '६',
            7: '७',
            8: '८',
            9: '९',
            0: '०',
        },
        numberMap = {
            '१': '1',
            '२': '2',
            '३': '3',
            '४': '4',
            '५': '5',
            '६': '6',
            '७': '7',
            '८': '8',
            '९': '9',
            '०': '0',
        };

    var hi = moment.defineLocale('hi', {
        months: 'जनवरी_फ़रवरी_मार्च_अप्रैल_मई_जून_जुलाई_अगस्त_सितम्बर_अक्टूबर_नवम्बर_दिसम्बर'.split(
            '_'
        ),
        monthsShort: 'जन._फ़र._मार्च_अप्रै._मई_जून_जुल._अग._सित._अक्टू._नव._दिस.'.split(
            '_'
        ),
        monthsParseExact: true,
        weekdays: 'रविवार_सोमवार_मंगलवार_बुधवार_गुरूवार_शुक्रवार_शनिवार'.split('_'),
        weekdaysShort: 'रवि_सोम_मंगल_बुध_गुरू_शुक्र_शनि'.split('_'),
        weekdaysMin: 'र_सो_मं_बु_गु_शु_श'.split('_'),
        longDateFormat: {
            LT: 'A h:mm बजे',
            LTS: 'A h:mm:ss बजे',
            L: 'DD/MM/YYYY',
            LL: 'D MMMM YYYY',
            LLL: 'D MMMM YYYY, A h:mm बजे',
            LLLL: 'dddd, D MMMM YYYY, A h:mm बजे',
        },
        calendar: {
            sameDay: '[आज] LT',
            nextDay: '[कल] LT',
            nextWeek: 'dddd, LT',
            lastDay: '[कल] LT',
            lastWeek: '[पिछले] dddd, LT',
            sameElse: 'L',
        },
        relativeTime: {
            future: '%s में',
            past: '%s पहले',
            s: 'कुछ ही क्षण',
            ss: '%d सेकंड',
            m: 'एक मिनट',
            mm: '%d मिनट',
            h: 'एक घंटा',
            hh: '%d घंटे',
            d: 'एक दिन',
            dd: '%d दिन',
            M: 'एक महीने',
            MM: '%d महीने',
            y: 'एक वर्ष',
            yy: '%d वर्ष',
        },
        preparse: function (string) {
            return string.replace(/[१२३४५६७८९०]/g, function (match) {
                return numberMap[match];
            });
        },
        postformat: function (string) {
            return string.replace(/\d/g, function (match) {
                return symbolMap[match];
            });
        },
        // Hindi notation for meridiems are quite fuzzy in practice. While there exists
        // a rigid notion of a 'Pahar' it is not used as rigidly in modern Hindi.
        meridiemParse: /रात|सुबह|दोपहर|शाम/,
        meridiemHour: function (hour, meridiem) {
            if (hour === 12) {
                hour = 0;
            }
            if (meridiem === 'रात') {
                return hour < 4 ? hour : hour + 12;
            } else if (meridiem === 'सुबह') {
                return hour;
            } else if (meridiem === 'दोपहर') {
                return hour >= 10 ? hour : hour + 12;
            } else if (meridiem === 'शाम') {
                return hour + 12;
            }
        },
        meridiem: function (hour, minute, isLower) {
            if (hour < 4) {
                return 'रात';
            } else if (hour < 10) {
                return 'सुबह';
            } else if (hour < 17) {
                return 'दोपहर';
            } else if (hour < 20) {
                return 'शाम';
            } else {
                return 'रात';
            }
        },
        week: {
            dow: 0, // Sunday is the first day of the week.
            doy: 6, // The week that contains Jan 6th is the first week of the year.
        },
    });

    return hi;

})));


/***/ }),

/***/ "3LXp":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ dom_CoreDomUtilsProvider; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ CoreDomUtils; });

// EXTERNAL MODULE: ./node_modules/tslib/tslib.es6.js
var tslib_es6 = __webpack_require__("mrSG");

// EXTERNAL MODULE: ./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js + 4 modules
var core = __webpack_require__("fXoL");

// EXTERNAL MODULE: ./node_modules/@ionic/core/dist/esm/index.js
var esm = __webpack_require__("1Bn7");

// EXTERNAL MODULE: ./node_modules/ts-md5/dist/md5.js
var md5 = __webpack_require__("kScs");

// EXTERNAL MODULE: ./src/core/services/app.ts + 1 modules
var app = __webpack_require__("nvXB");

// EXTERNAL MODULE: ./src/core/services/config.ts + 1 modules
var config = __webpack_require__("BBqZ");

// EXTERNAL MODULE: ./src/core/services/file.ts
var file = __webpack_require__("EmGO");

// EXTERNAL MODULE: ./src/core/services/utils/text.ts + 1 modules
var utils_text = __webpack_require__("vuGA");

// EXTERNAL MODULE: ./src/core/services/utils/url.ts
var utils_url = __webpack_require__("mvS9");

// EXTERNAL MODULE: ./src/core/services/utils/utils.ts
var utils = __webpack_require__("bFG1");

// EXTERNAL MODULE: ./src/core/constants.ts
var constants = __webpack_require__("BaYo");

// EXTERNAL MODULE: ./src/core/singletons/index.ts
var singletons = __webpack_require__("j3ag");

// CONCATENATED MODULE: ./src/core/classes/ion-loading.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.



/**
 * Class to improve the behaviour of HTMLIonLoadingElement.
 *
 * In addition to present/dismiss, this loader can also be paused/resumed in order to allow stacking
 * modals in top of one another without interfering. Conceptually, a paused loader is still
 * active but will not be shown in the UI.
 */
class ion_loading_CoreIonLoadingElement {
    constructor(text) {
        this.text = text;
        this.scheduled = false;
        this.paused = false;
        this.listeners = [];
    }
    /**
     * Dismiss the loading element.
     *
     * @param data Dismiss data.
     * @param role Dismiss role.
     */
    dismiss(data, role) {
        return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
            if (this.paused) {
                this.paused = false;
                this.listeners.forEach(listener => listener());
                return;
            }
            if (!this.asyncLoadingElement) {
                if (this.scheduled) {
                    this.scheduled = false;
                    this.listeners.forEach(listener => listener());
                }
                return;
            }
            const asyncLoadingElement = this.asyncLoadingElement;
            delete this.asyncLoadingElement;
            const loadingElement = yield asyncLoadingElement;
            yield loadingElement.dismiss(data, role);
            this.listeners.forEach(listener => listener());
        });
    }
    /**
     * Register dismiss listener.
     *
     * @param listener Listener.
     */
    onDismiss(listener) {
        this.listeners.push(listener);
    }
    /**
     * Hide the loading element.
     */
    pause() {
        return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
            if (!this.asyncLoadingElement) {
                return;
            }
            this.paused = true;
            const asyncLoadingElement = this.asyncLoadingElement;
            delete this.asyncLoadingElement;
            const loadingElement = yield asyncLoadingElement;
            loadingElement.dismiss();
        });
    }
    /**
     * Present the loading element.
     */
    present() {
        return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
            if (this.paused || this.scheduled || this.asyncLoadingElement) {
                return;
            }
            // Wait a bit before presenting the modal, to prevent it being displayed if dismiss is called fast.
            this.scheduled = true;
            yield utils["a" /* CoreUtils */].wait(40);
            if (!this.scheduled) {
                return;
            }
            // Present modal.
            this.scheduled = false;
            yield this.presentLoadingElement();
        });
    }
    /**
     * Show loading element.
     */
    resume() {
        return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
            if (!this.paused) {
                return;
            }
            this.paused = false;
            yield this.presentLoadingElement();
        });
    }
    /**
     * Update text in the loading element.
     *
     * @param text Text.
     */
    updateText(text) {
        return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
            this.text = text;
            if (!this.asyncLoadingElement) {
                return;
            }
            const loadingElement = yield this.asyncLoadingElement;
            const contentElement = loadingElement.querySelector('.loading-content');
            if (contentElement) {
                contentElement.innerHTML = text;
            }
        });
    }
    /**
     * Create and present the loading element.
     */
    presentLoadingElement() {
        return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
            let resolveLoadingElement;
            this.asyncLoadingElement = new Promise(resolve => resolveLoadingElement = resolve);
            const loadingElement = yield singletons["t" /* LoadingController */].create({ message: this.text });
            yield loadingElement.present();
            resolveLoadingElement(loadingElement);
        });
    }
}

// EXTERNAL MODULE: ./src/core/classes/errors/cancelederror.ts
var cancelederror = __webpack_require__("n9nU");

// EXTERNAL MODULE: ./src/core/classes/errors/error.ts
var errors_error = __webpack_require__("93ts");

// EXTERNAL MODULE: ./src/core/classes/errors/silenterror.ts
var silenterror = __webpack_require__("f2wI");

// EXTERNAL MODULE: ./src/core/singletons/logger.ts + 1 modules
var logger = __webpack_require__("3j9v");

// EXTERNAL MODULE: ./src/core/classes/errors/network-error.ts
var network_error = __webpack_require__("+mW7");

// EXTERNAL MODULE: ./src/core/components/bs-tooltip/bs-tooltip.ts
var bs_tooltip = __webpack_require__("aEIl");

// EXTERNAL MODULE: ./src/core/features/viewer/components/image/image.ts
var image_image = __webpack_require__("h1zy");

// EXTERNAL MODULE: ./src/core/singletons/form.ts
var singletons_form = __webpack_require__("4reR");

// CONCATENATED MODULE: ./src/core/classes/modal-lateral-transition.ts
// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


/**
 * Sliding transition for lateral modals.
 */
function CoreModalLateralTransitionEnter(baseEl) {
    const OFF_RIGHT = singletons["C" /* Platform */].isRTL ? '-100%' : '100%';
    const backdropAnimation = Object(esm["i" /* createAnimation */])()
        .addElement(baseEl.querySelector('ion-backdrop'))
        .fromTo('opacity', 0.01, 0.4);
    const wrapperAnimation = Object(esm["i" /* createAnimation */])()
        .addElement(baseEl.querySelector('.modal-wrapper'))
        .fromTo('transform', 'translateX(' + OFF_RIGHT + ')', 'translateX(0)')
        .fromTo('opacity', 0.8, 1);
    return Object(esm["i" /* createAnimation */])()
        .addElement(baseEl)
        .easing('cubic-bezier(0.36,0.66,0.04,1)')
        .duration(300)
        .addAnimation([backdropAnimation, wrapperAnimation]);
}
function CoreModalLateralTransitionLeave(baseEl) {
    const OFF_RIGHT = singletons["C" /* Platform */].isRTL ? '-100%' : '100%';
    const backdropAnimation = Object(esm["i" /* createAnimation */])()
        .addElement(baseEl.querySelector('ion-backdrop'))
        .fromTo('opacity', 0.4, 0.0);
    const wrapperAnimation = Object(esm["i" /* createAnimation */])()
        .addElement(baseEl.querySelector('.modal-wrapper'))
        .beforeStyles({ opacity: 1 })
        .fromTo('transform', 'translateX(0)', 'translateX(' + OFF_RIGHT + ')');
    return Object(esm["i" /* createAnimation */])()
        .addElement(baseEl)
        .easing('cubic-bezier(0.36,0.66,0.04,1)')
        .duration(300)
        .addAnimation([backdropAnimation, wrapperAnimation]);
}

// CONCATENATED MODULE: ./src/core/services/utils/dom.ts

// (C) Copyright 2015 Moodle Pty Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.






















/*
 * "Utils" service with helper functions for UI, DOM elements and HTML code.
 */
let dom_CoreDomUtilsProvider = /*@__PURE__*/ (() => {
    class CoreDomUtilsProvider {
        constructor() {
            this.INSTANCE_ID_ATTR_NAME = 'core-instance-id';
            // List of input types that support keyboard.
            this.INPUT_SUPPORT_KEYBOARD = ['date', 'datetime', 'datetime-local', 'email', 'month', 'number',
                'password', 'search', 'tel', 'text', 'time', 'url', 'week'];
            this.template = document.createElement('template'); // A template element to convert HTML to element.
            this.instances = new WeakMap(); // Store component/directive instances indexed by element.
            this.debugDisplay = false; // Whether to display debug messages. Store it in a variable to make it synchronous.
            this.displayedAlerts = {}; // To prevent duplicated alerts.
            this.activeLoadingModals = [];
            this.logger = logger["a" /* CoreLogger */].getInstance('CoreDomUtilsProvider');
            this.init();
        }
        /**
         * Init some properties.
         */
        init() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                // Check if debug messages should be displayed.
                const debugDisplay = yield config["a" /* CoreConfig */].get(constants["a" /* CoreConstants */].SETTINGS_DEBUG_DISPLAY, 0);
                this.debugDisplay = debugDisplay != 0;
            });
        }
        /**
         * Equivalent to element.closest(). If the browser doesn't support element.closest, it will
         * traverse the parents to achieve the same functionality.
         * Returns the closest ancestor of the current element (or the current element itself) which matches the selector.
         *
         * @param element DOM Element.
         * @param selector Selector to search.
         * @return Closest ancestor.
         */
        closest(element, selector) {
            if (!element) {
                return null;
            }
            // Try to use closest if the browser supports it.
            if (typeof element.closest == 'function') {
                return element.closest(selector);
            }
            if (!this.matchesFunctionName) {
                // Find the matches function supported by the browser.
                ['matches', 'webkitMatchesSelector', 'mozMatchesSelector', 'msMatchesSelector', 'oMatchesSelector'].some((fn) => {
                    if (typeof document.body[fn] == 'function') {
                        this.matchesFunctionName = fn;
                        return true;
                    }
                    return false;
                });
                if (!this.matchesFunctionName) {
                    return null;
                }
            }
            // Traverse parents.
            let elementToTreat = element;
            while (elementToTreat) {
                if (elementToTreat[this.matchesFunctionName](selector)) {
                    return elementToTreat;
                }
                elementToTreat = elementToTreat.parentElement;
            }
            return null;
        }
        /**
         * If the download size is higher than a certain threshold shows a confirm dialog.
         *
         * @param size Object containing size to download and a boolean to indicate if its totally or partialy calculated.
         * @param message Code of the message to show. Default: 'core.course.confirmdownload'.
         * @param unknownMessage ID of the message to show if size is unknown.
         * @param wifiThreshold Threshold to show confirm in WiFi connection. Default: CoreWifiDownloadThreshold.
         * @param limitedThreshold Threshold to show confirm in limited connection. Default: CoreDownloadThreshold.
         * @param alwaysConfirm True to show a confirm even if the size isn't high, false otherwise.
         * @return Promise resolved when the user confirms or if no confirm needed.
         */
        confirmDownloadSize(size, message, unknownMessage, wifiThreshold, limitedThreshold, alwaysConfirm) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const readableSize = utils_text["a" /* CoreTextUtils */].bytesToSize(size.size, 2);
                const getAvailableBytes = () => Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                    const availableBytes = yield file["a" /* CoreFile */].calculateFreeSpace();
                    if (app["a" /* CoreApp */].isAndroid()) {
                        return availableBytes;
                    }
                    else {
                        // Space calculation is not accurate on iOS, but it gets more accurate when space is lower.
                        // We'll only use it when space is <500MB, or we're downloading more than twice the reported space.
                        if (availableBytes < constants["a" /* CoreConstants */].IOS_FREE_SPACE_THRESHOLD || size.size > availableBytes / 2) {
                            return availableBytes;
                        }
                        else {
                            return null;
                        }
                    }
                });
                const getAvailableSpace = (availableBytes) => {
                    if (availableBytes === null) {
                        return '';
                    }
                    else {
                        const availableSize = utils_text["a" /* CoreTextUtils */].bytesToSize(availableBytes, 2);
                        if (app["a" /* CoreApp */].isAndroid() && size.size > availableBytes - constants["a" /* CoreConstants */].MINIMUM_FREE_SPACE) {
                            throw new errors_error["a" /* CoreError */](singletons["L" /* Translate */].instant('core.course.insufficientavailablespace', { size: readableSize }));
                        }
                        return singletons["L" /* Translate */].instant('core.course.availablespace', { available: availableSize });
                    }
                };
                const availableBytes = yield getAvailableBytes();
                const availableSpace = getAvailableSpace(availableBytes);
                wifiThreshold = typeof wifiThreshold == 'undefined' ? constants["a" /* CoreConstants */].WIFI_DOWNLOAD_THRESHOLD : wifiThreshold;
                limitedThreshold = typeof limitedThreshold == 'undefined' ? constants["a" /* CoreConstants */].DOWNLOAD_THRESHOLD : limitedThreshold;
                let wifiPrefix = '';
                if (app["a" /* CoreApp */].isNetworkAccessLimited()) {
                    wifiPrefix = singletons["L" /* Translate */].instant('core.course.confirmlimiteddownload');
                }
                if (size.size < 0 || (size.size == 0 && !size.total)) {
                    // Seems size was unable to be calculated. Show a warning.
                    unknownMessage = unknownMessage || 'core.course.confirmdownloadunknownsize';
                    return this.showConfirm(wifiPrefix + singletons["L" /* Translate */].instant(unknownMessage, { availableSpace: availableSpace }));
                }
                else if (!size.total) {
                    // Filesize is only partial.
                    return this.showConfirm(wifiPrefix + singletons["L" /* Translate */].instant('core.course.confirmpartialdownloadsize', { size: readableSize, availableSpace: availableSpace }));
                }
                else if (alwaysConfirm || size.size >= wifiThreshold ||
                    (app["a" /* CoreApp */].isNetworkAccessLimited() && size.size >= limitedThreshold)) {
                    message = message || (size.size === 0 ? 'core.course.confirmdownloadzerosize' : 'core.course.confirmdownload');
                    return this.showConfirm(wifiPrefix + singletons["L" /* Translate */].instant(message, { size: readableSize, availableSpace: availableSpace }));
                }
            });
        }
        /**
         * Convert some HTML as text into an HTMLElement. This HTML is put inside a div or a body.
         *
         * @param html Text to convert.
         * @return Element.
         */
        convertToElement(html) {
            // Add a div to hold the content, that's the element that will be returned.
            this.template.innerHTML = '<div>' + html + '</div>';
            return this.template.content.children[0];
        }
        /**
         * Create a "cancelled" error. These errors won't display an error message in showErrorModal functions.
         *
         * @return The error object.
         * @deprecated since 3.9.5. Just create the error directly.
         */
        createCanceledError() {
            return new cancelederror["a" /* CoreCanceledError */]('');
        }
        /**
         * Given a list of changes for a component input detected by a KeyValueDiffers, create an object similar to the one
         * passed to the ngOnChanges functions.
         *
         * @param changes Changes detected by KeyValueDiffer.
         * @return Changes in a format like ngOnChanges.
         */
        createChangesFromKeyValueDiff(changes) {
            const newChanges = {};
            // Added items are considered first change.
            changes.forEachAddedItem((item) => {
                newChanges[item.key] = new core["T" /* SimpleChange */](item.previousValue, item.currentValue, true);
            });
            // Changed or removed items aren't first change.
            changes.forEachChangedItem((item) => {
                newChanges[item.key] = new core["T" /* SimpleChange */](item.previousValue, item.currentValue, false);
            });
            changes.forEachRemovedItem((item) => {
                newChanges[item.key] = new core["T" /* SimpleChange */](item.previousValue, item.currentValue, true);
            });
            return newChanges;
        }
        /**
         * Extract the downloadable URLs from an HTML code.
         *
         * @param html HTML code.
         * @return List of file urls.
         * @deprecated since 3.8. Use CoreFilepoolProvider.extractDownloadableFilesFromHtml instead.
         */
        extractDownloadableFilesFromHtml(html) {
            this.logger.error('The function extractDownloadableFilesFromHtml has been moved to CoreFilepoolProvider.' +
                ' Please use that function instead of this one.');
            const urls = [];
            const element = this.convertToElement(html);
            const elements = Array.from(element.querySelectorAll('a, img, audio, video, source, track'));
            for (let i = 0; i < elements.length; i++) {
                const element = elements[i];
                let url = 'href' in element ? element.href : element.src;
                if (url && utils_url["a" /* CoreUrlUtils */].isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                    urls.push(url);
                }
                // Treat video poster.
                if (element.tagName == 'VIDEO' && element.getAttribute('poster')) {
                    url = element.getAttribute('poster') || '';
                    if (url && utils_url["a" /* CoreUrlUtils */].isDownloadableUrl(url) && urls.indexOf(url) == -1) {
                        urls.push(url);
                    }
                }
            }
            return urls;
        }
        /**
         * Extract the downloadable URLs from an HTML code and returns them in fake file objects.
         *
         * @param html HTML code.
         * @return List of fake file objects with file URLs.
         * @deprecated since 3.8. Use CoreFilepoolProvider.extractDownloadableFilesFromHtmlAsFakeFileObjects instead.
         */
        extractDownloadableFilesFromHtmlAsFakeFileObjects(html) {
            const urls = this.extractDownloadableFilesFromHtml(html);
            // Convert them to fake file objects.
            return urls.map((url) => ({
                fileurl: url,
            }));
        }
        /**
         * Search all the URLs in a CSS file content.
         *
         * @param code CSS code.
         * @return List of URLs.
         */
        extractUrlsFromCSS(code) {
            // First of all, search all the url(...) occurrences that don't include "data:".
            const urls = [];
            const matches = code.match(/url\(\s*["']?(?!data:)([^)]+)\)/igm);
            if (!matches) {
                return urls;
            }
            // Extract the URL from each match.
            matches.forEach((match) => {
                const submatches = match.match(/url\(\s*['"]?([^'"]*)['"]?\s*\)/im);
                if (submatches === null || submatches === void 0 ? void 0 : submatches[1]) {
                    urls.push(submatches[1]);
                }
            });
            return urls;
        }
        /**
         * Fix syntax errors in HTML.
         *
         * @param html HTML text.
         * @return Fixed HTML text.
         */
        fixHtml(html) {
            this.template.innerHTML = html;
            // eslint-disable-next-line no-control-regex
            const attrNameRegExp = /[^\x00-\x20\x7F-\x9F"'>/=]+/;
            const fixElement = (element) => {
                // Remove attributes with an invalid name.
                Array.from(element.attributes).forEach((attr) => {
                    if (!attrNameRegExp.test(attr.name)) {
                        element.removeAttributeNode(attr);
                    }
                });
                Array.from(element.children).forEach(fixElement);
            };
            Array.from(this.template.content.children).forEach(fixElement);
            return this.template.innerHTML;
        }
        /**
         * Focus an element and open keyboard.
         *
         * @param el HTML element to focus.
         */
        focusElement(el) {
            if (el === null || el === void 0 ? void 0 : el.focus) {
                el.focus();
                if (app["a" /* CoreApp */].isAndroid() && this.supportsInputKeyboard(el)) {
                    // On some Android versions the keyboard doesn't open automatically.
                    app["a" /* CoreApp */].openKeyboard();
                }
            }
        }
        /**
         * Formats a size to be used as width/height of an element.
         * If the size is already valid (like '500px' or '50%') it won't be modified.
         * Returned size will have a format like '500px'.
         *
         * @param size Size to format.
         * @return Formatted size. If size is not valid, returns an empty string.
         */
        formatPixelsSize(size) {
            if (typeof size == 'string' && (size.indexOf('px') > -1 || size.indexOf('%') > -1 || size == 'auto' || size == 'initial')) {
                // It seems to be a valid size.
                return size;
            }
            if (typeof size == 'string') {
                // It's important to use parseInt instead of Number because Number('') is 0 instead of NaN.
                size = parseInt(size, 10);
            }
            if (!isNaN(size)) {
                return size + 'px';
            }
            return '';
        }
        /**
         * Returns the contents of a certain selection in a DOM element.
         *
         * @param element DOM element to search in.
         * @param selector Selector to search.
         * @return Selection contents. Undefined if not found.
         */
        getContentsOfElement(element, selector) {
            if (element) {
                const selected = element.querySelector(selector);
                if (selected) {
                    return selected.innerHTML;
                }
            }
        }
        /**
         * Get the data from a form. It will only collect elements that have a name.
         *
         * @param form The form to get the data from.
         * @return Object with the data. The keys are the names of the inputs.
         * @deprecated since 3.9.5. Function has been moved to CoreForms.
         */
        getDataFromForm(form) {
            return singletons_form["a" /* CoreForms */].getDataFromForm(form);
        }
        /**
         * Returns the attribute value of a string element. Only the first element will be selected.
         *
         * @param html HTML element in string.
         * @param attribute Attribute to get.
         * @return Attribute value.
         */
        getHTMLElementAttribute(html, attribute) {
            return this.convertToElement(html).children[0].getAttribute(attribute);
        }
        /**
         * Returns height of an element.
         *
         * @param element DOM element to measure.
         * @param usePadding Whether to use padding to calculate the measure.
         * @param useMargin Whether to use margin to calculate the measure.
         * @param useBorder Whether to use borders to calculate the measure.
         * @param innerMeasure If inner measure is needed: padding, margin or borders will be substracted.
         * @return Height in pixels.
         */
        getElementHeight(element, usePadding, useMargin, useBorder, innerMeasure) {
            return this.getElementMeasure(element, false, usePadding, useMargin, useBorder, innerMeasure);
        }
        /**
         * Returns height or width of an element.
         *
         * @param element DOM element to measure.
         * @param getWidth Whether to get width or height.
         * @param usePadding Whether to use padding to calculate the measure.
         * @param useMargin Whether to use margin to calculate the measure.
         * @param useBorder Whether to use borders to calculate the measure.
         * @param innerMeasure If inner measure is needed: padding, margin or borders will be substracted.
         * @return Measure in pixels.
         */
        getElementMeasure(element, getWidth, usePadding, useMargin, useBorder, innerMeasure) {
            const offsetMeasure = getWidth ? 'offsetWidth' : 'offsetHeight';
            const measureName = getWidth ? 'width' : 'height';
            const clientMeasure = getWidth ? 'clientWidth' : 'clientHeight';
            const priorSide = getWidth ? 'Left' : 'Top';
            const afterSide = getWidth ? 'Right' : 'Bottom';
            let measure = element[offsetMeasure] || element[measureName] || element[clientMeasure] || 0;
            // Measure not correctly taken.
            if (measure <= 0) {
                const style = getComputedStyle(element);
                if ((style === null || style === void 0 ? void 0 : style.display) == '') {
                    element.style.display = 'inline-block';
                    measure = element[offsetMeasure] || element[measureName] || element[clientMeasure] || 0;
                    element.style.display = '';
                }
            }
            if (usePadding || useMargin || useBorder) {
                const computedStyle = getComputedStyle(element);
                let surround = 0;
                if (usePadding) {
                    surround += this.getComputedStyleMeasure(computedStyle, 'padding' + priorSide) +
                        this.getComputedStyleMeasure(computedStyle, 'padding' + afterSide);
                }
                if (useMargin) {
                    surround += this.getComputedStyleMeasure(computedStyle, 'margin' + priorSide) +
                        this.getComputedStyleMeasure(computedStyle, 'margin' + afterSide);
                }
                if (useBorder) {
                    surround += this.getComputedStyleMeasure(computedStyle, 'border' + priorSide + 'Width') +
                        this.getComputedStyleMeasure(computedStyle, 'border' + afterSide + 'Width');
                }
                if (innerMeasure) {
                    measure = measure > surround ? measure - surround : 0;
                }
                else {
                    measure += surround;
                }
            }
            return measure;
        }
        /**
         * Returns the computed style measure or 0 if not found or NaN.
         *
         * @param style Style from getComputedStyle.
         * @param measure Measure to get.
         * @return Result of the measure.
         */
        getComputedStyleMeasure(style, measure) {
            return parseInt(style[measure], 10) || 0;
        }
        /**
         * Returns width of an element.
         *
         * @param element DOM element to measure.
         * @param usePadding Whether to use padding to calculate the measure.
         * @param useMargin Whether to use margin to calculate the measure.
         * @param useBorder Whether to use borders to calculate the measure.
         * @param innerMeasure If inner measure is needed: padding, margin or borders will be substracted.
         * @return Width in pixels.
         */
        getElementWidth(element, usePadding, useMargin, useBorder, innerMeasure) {
            return this.getElementMeasure(element, true, usePadding, useMargin, useBorder, innerMeasure);
        }
        getElementXY(container, selector, positionParentClass) {
            let element = (selector ? container.querySelector(selector) : container);
            let positionTop = 0;
            let positionLeft = 0;
            if (!positionParentClass) {
                positionParentClass = 'inner-scroll';
            }
            if (!element) {
                return null;
            }
            while (element) {
                positionLeft += (element.offsetLeft - element.scrollLeft + element.clientLeft);
                positionTop += (element.offsetTop - element.scrollTop + element.clientTop);
                const offsetElement = element.offsetParent;
                element = element.parentElement;
                // Every parent class has to be checked but the position has to be got form offsetParent.
                while (offsetElement != element && element) {
                    // If positionParentClass element is reached, stop adding tops.
                    if (element.className.indexOf(positionParentClass) != -1) {
                        element = null;
                    }
                    else {
                        element = element.parentElement;
                    }
                }
                // Finally, check again.
                if ((element === null || element === void 0 ? void 0 : element.className.indexOf(positionParentClass)) != -1) {
                    element = null;
                }
            }
            return [positionLeft, positionTop];
        }
        /**
         * Given a message, it deduce if it's a network error.
         *
         * @param message Message text.
         * @param error Error object.
         * @return True if the message error is a network error, false otherwise.
         */
        isNetworkError(message, error) {
            return message == singletons["L" /* Translate */].instant('core.networkerrormsg') ||
                message == singletons["L" /* Translate */].instant('core.fileuploader.errormustbeonlinetoupload') ||
                error instanceof network_error["a" /* CoreNetworkError */];
        }
        /**
         * Get the error message from an error, including debug data if needed.
         *
         * @param error Message to show.
         * @param needsTranslate Whether the error needs to be translated.
         * @return Error message, null if no error should be displayed.
         */
        getErrorMessage(error, needsTranslate) {
            if (typeof error != 'string' && !error) {
                return null;
            }
            let extraInfo = '';
            let errorMessage;
            if (typeof error == 'object') {
                if (this.debugDisplay) {
                    // Get the debug info. Escape the HTML so it is displayed as it is in the view.
                    if ('debuginfo' in error && error.debuginfo) {
                        extraInfo = '<br><br>' + utils_text["a" /* CoreTextUtils */].escapeHTML(error.debuginfo, false);
                    }
                    if ('backtrace' in error && error.backtrace) {
                        extraInfo += '<br><br>' + utils_text["a" /* CoreTextUtils */].replaceNewLines(utils_text["a" /* CoreTextUtils */].escapeHTML(error.backtrace, false), '<br>');
                    }
                    // eslint-disable-next-line no-console
                    console.error(error);
                }
                if (this.isSilentError(error)) {
                    // It's a silent error, don't display an error.
                    return null;
                }
                // We received an object instead of a string. Search for common properties.
                errorMessage = utils_text["a" /* CoreTextUtils */].getErrorMessageFromError(error);
                if (!errorMessage) {
                    // No common properties found, just stringify it.
                    errorMessage = JSON.stringify(error);
                    extraInfo = ''; // No need to add extra info because it's already in the error.
                }
                // Try to remove tokens from the contents.
                const matches = errorMessage.match(/token"?[=|:]"?(\w*)/);
                if (matches === null || matches === void 0 ? void 0 : matches[1]) {
                    errorMessage = errorMessage.replace(new RegExp(matches[1], 'g'), 'secret');
                }
            }
            else {
                errorMessage = error;
            }
            if (errorMessage == constants["a" /* CoreConstants */].DONT_SHOW_ERROR) {
                // The error shouldn't be shown, stop.
                return null;
            }
            let message = utils_text["a" /* CoreTextUtils */].decodeHTML(needsTranslate ? singletons["L" /* Translate */].instant(errorMessage) : errorMessage);
            if (extraInfo) {
                message += extraInfo;
            }
            return message;
        }
        /**
         * Retrieve component/directive instance.
         * Please use this function only if you cannot retrieve the instance using parent/child methods: ViewChild (or similar)
         * or Angular's injection.
         *
         * @param element The root element of the component/directive.
         * @return The instance, undefined if not found.
         */
        getInstanceByElement(element) {
            return this.instances.get(element);
        }
        /**
         * Check whether an error is an error caused because the user canceled a showConfirm.
         *
         * @param error Error to check.
         * @return Whether it's a canceled error.
         */
        isCanceledError(error) {
            return error instanceof cancelederror["a" /* CoreCanceledError */];
        }
        /**
         * Check whether an error is an error caused because the user canceled a showConfirm.
         *
         * @param error Error to check.
         * @return Whether it's a canceled error.
         */
        isSilentError(error) {
            return error instanceof silenterror["a" /* CoreSilentError */];
        }
        /**
         * Wait an element to exists using the findFunction.
         *
         * @param findFunction The function used to find the element.
         * @return Resolved if found, rejected if too many tries.
         */
        waitElementToExist(findFunction) {
            const promiseInterval = utils["a" /* CoreUtils */].promiseDefer();
            let tries = 100;
            const clear = setInterval(() => {
                const element = findFunction();
                if (element) {
                    clearInterval(clear);
                    promiseInterval.resolve(element);
                }
                else {
                    tries--;
                    if (tries <= 0) {
                        clearInterval(clear);
                        promiseInterval.reject();
                    }
                }
            }, 100);
            return promiseInterval.promise;
        }
        /**
         * Handle bootstrap tooltips in a certain element.
         *
         * @param element Element to check.
         */
        handleBootstrapTooltips(element) {
            const els = Array.from(element.querySelectorAll('[data-toggle="tooltip"]'));
            els.forEach((el) => {
                const content = el.getAttribute('title') || el.getAttribute('data-original-title');
                const trigger = el.getAttribute('data-trigger') || 'hover focus';
                const treated = el.getAttribute('data-bstooltip-treated');
                if (!content || treated === 'true' ||
                    (trigger.indexOf('hover') == -1 && trigger.indexOf('focus') == -1 && trigger.indexOf('click') == -1)) {
                    return;
                }
                el.setAttribute('data-bstooltip-treated', 'true'); // Mark it as treated.
                // Store the title in data-original-title instead of title, like BS does.
                el.setAttribute('data-original-title', content);
                el.setAttribute('title', '');
                el.addEventListener('click', (ev) => Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                    const html = el.getAttribute('data-html');
                    yield CoreDomUtils.openPopover({
                        component: bs_tooltip["a" /* CoreBSTooltipComponent */],
                        componentProps: {
                            content,
                            html: html === 'true',
                        },
                        event: ev,
                    });
                }));
            });
        }
        /**
         * Check if an element is outside of screen (viewport).
         *
         * @param scrollEl The element that must be scrolled.
         * @param element DOM element to check.
         * @return Whether the element is outside of the viewport.
         */
        isElementOutsideOfScreen(scrollEl, element) {
            const elementRect = element.getBoundingClientRect();
            if (!elementRect) {
                return false;
            }
            const elementMidPoint = Math.round((elementRect.bottom + elementRect.top) / 2);
            const scrollElRect = scrollEl.getBoundingClientRect();
            const scrollTopPos = (scrollElRect === null || scrollElRect === void 0 ? void 0 : scrollElRect.top) || 0;
            return elementMidPoint > window.innerHeight || elementMidPoint < scrollTopPos;
        }
        /**
         * Check if rich text editor is enabled.
         *
         * @return Promise resolved with boolean: true if enabled, false otherwise.
         */
        isRichTextEditorEnabled() {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const enabled = yield config["a" /* CoreConfig */].get(constants["a" /* CoreConstants */].SETTINGS_RICH_TEXT_EDITOR, true);
                return !!enabled;
            });
        }
        /**
         * Check if rich text editor is supported in the platform.
         *
         * @return Whether it's supported.
         * @deprecated since 3.9.5
         */
        isRichTextEditorSupported() {
            return true;
        }
        /**
         * Move children from one HTMLElement to another.
         *
         * @param oldParent The old parent.
         * @param newParent The new parent.
         * @param prepend If true, adds the children to the beginning of the new parent.
         * @return List of moved children.
         */
        moveChildren(oldParent, newParent, prepend) {
            const movedChildren = [];
            const referenceNode = prepend ? newParent.firstChild : null;
            while (oldParent.childNodes.length > 0) {
                const child = oldParent.childNodes[0];
                movedChildren.push(child);
                newParent.insertBefore(child, referenceNode);
            }
            return movedChildren;
        }
        /**
         * Search and remove a certain element from inside another element.
         *
         * @param element DOM element to search in.
         * @param selector Selector to search.
         */
        removeElement(element, selector) {
            if (element) {
                const selected = element.querySelector(selector);
                if (selected) {
                    selected.remove();
                }
            }
        }
        /**
         * Search and remove a certain element from an HTML code.
         *
         * @param html HTML code to change.
         * @param selector Selector to search.
         * @param removeAll True if it should remove all matches found, false if it should only remove the first one.
         * @return HTML without the element.
         */
        removeElementFromHtml(html, selector, removeAll) {
            const element = this.convertToElement(html);
            if (removeAll) {
                const selected = element.querySelectorAll(selector);
                for (let i = 0; i < selected.length; i++) {
                    selected[i].remove();
                }
            }
            else {
                const selected = element.querySelector(selector);
                if (selected) {
                    selected.remove();
                }
            }
            return element.innerHTML;
        }
        /**
         * Remove a component/directive instance using the DOM Element.
         *
         * @param element The root element of the component/directive.
         */
        removeInstanceByElement(element) {
            const id = element.getAttribute(this.INSTANCE_ID_ATTR_NAME);
            id && delete this.instances[id];
        }
        /**
         * Remove a component/directive instance using the ID.
         *
         * @param id The ID to remove.
         */
        removeInstanceById(id) {
            delete this.instances[id];
        }
        /**
         * Search for certain classes in an element contents and replace them with the specified new values.
         *
         * @param element DOM element.
         * @param map Mapping of the classes to replace. Keys must be the value to replace, values must be
         *            the new class name. Example: {'correct': 'core-question-answer-correct'}.
         */
        replaceClassesInElement(element, map) {
            for (const key in map) {
                const foundElements = element.querySelectorAll('.' + key);
                for (let i = 0; i < foundElements.length; i++) {
                    const foundElement = foundElements[i];
                    foundElement.className = foundElement.className.replace(key, map[key]);
                }
            }
        }
        /**
         * Given an HTML, search all links and media and tries to restore original sources using the paths object.
         *
         * @param html HTML code.
         * @param paths Object linking URLs in the html code with the real URLs to use.
         * @param anchorFn Function to call with each anchor. Optional.
         * @return Treated HTML code.
         */
        restoreSourcesInHtml(html, paths, anchorFn) {
            const element = this.convertToElement(html);
            // Treat elements with src (img, audio, video, ...).
            const media = Array.from(element.querySelectorAll('img, video, audio, source, track'));
            media.forEach((media) => {
                const currentSrc = media.getAttribute('src');
                const newSrc = currentSrc ?
                    paths[utils_url["a" /* CoreUrlUtils */].removeUrlParams(utils_text["a" /* CoreTextUtils */].decodeURIComponent(currentSrc))] :
                    undefined;
                if (typeof newSrc != 'undefined') {
                    media.setAttribute('src', newSrc);
                }
                // Treat video posters.
                if (media.tagName == 'VIDEO' && media.getAttribute('poster')) {
                    const currentPoster = media.getAttribute('poster');
                    const newPoster = paths[utils_text["a" /* CoreTextUtils */].decodeURIComponent(currentPoster)];
                    if (typeof newPoster !== 'undefined') {
                        media.setAttribute('poster', newPoster);
                    }
                }
            });
            // Now treat links.
            const anchors = Array.from(element.querySelectorAll('a'));
            anchors.forEach((anchor) => {
                const currentHref = anchor.getAttribute('href');
                const newHref = currentHref ?
                    paths[utils_url["a" /* CoreUrlUtils */].removeUrlParams(utils_text["a" /* CoreTextUtils */].decodeURIComponent(currentHref))] :
                    undefined;
                if (typeof newHref != 'undefined') {
                    anchor.setAttribute('href', newHref);
                    if (typeof anchorFn == 'function') {
                        anchorFn(anchor, newHref);
                    }
                }
            });
            return element.innerHTML;
        }
        /**
         * Scroll to somehere in the content.
         *
         * @param content Content to scroll.
         * @param x The x-value to scroll to.
         * @param y The y-value to scroll to.
         * @param duration Duration of the scroll animation in milliseconds.
         * @return Returns a promise which is resolved when the scroll has completed.
         * @deprecated since 3.9.5. Use directly the IonContent class.
         */
        scrollTo(content, x, y, duration) {
            return content === null || content === void 0 ? void 0 : content.scrollToPoint(x, y, duration || 0);
        }
        /**
         * Scroll to Bottom of the content.
         *
         * @param content Content to scroll.
         * @param duration Duration of the scroll animation in milliseconds.
         * @return Returns a promise which is resolved when the scroll has completed.
         * @deprecated since 3.9.5. Use directly the IonContent class.
         */
        scrollToBottom(content, duration) {
            return content === null || content === void 0 ? void 0 : content.scrollToBottom(duration);
        }
        /**
         * Scroll to Top of the content.
         *
         * @param content Content to scroll.
         * @param duration Duration of the scroll animation in milliseconds.
         * @return Returns a promise which is resolved when the scroll has completed.
         * @deprecated since 3.9.5. Use directly the IonContent class.
         */
        scrollToTop(content, duration) {
            return content === null || content === void 0 ? void 0 : content.scrollToTop(duration);
        }
        /**
         * Returns height of the content.
         *
         * @param content Content where to execute the function.
         * @return Promise resolved with content height.
         */
        getContentHeight(content) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                try {
                    const scrollElement = yield (content === null || content === void 0 ? void 0 : content.getScrollElement());
                    return (scrollElement === null || scrollElement === void 0 ? void 0 : scrollElement.clientHeight) || 0;
                }
                catch (error) {
                    return 0;
                }
            });
        }
        /**
         * Returns scroll height of the content.
         *
         * @param content Content where to execute the function.
         * @return Promise resolved with scroll height.
         */
        getScrollHeight(content) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                try {
                    const scrollElement = yield (content === null || content === void 0 ? void 0 : content.getScrollElement());
                    return (scrollElement === null || scrollElement === void 0 ? void 0 : scrollElement.scrollHeight) || 0;
                }
                catch (error) {
                    return 0;
                }
            });
        }
        /**
         * Returns scrollTop of the content.
         *
         * @param content Content where to execute the function.
         * @return Promise resolved with scroll top.
         */
        getScrollTop(content) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                try {
                    const scrollElement = yield (content === null || content === void 0 ? void 0 : content.getScrollElement());
                    return (scrollElement === null || scrollElement === void 0 ? void 0 : scrollElement.scrollTop) || 0;
                }
                catch (error) {
                    return 0;
                }
            });
        }
        /**
         * Scroll to a certain element.
         *
         * @param content The content that must be scrolled.
         * @param element The element to scroll to.
         * @param scrollParentClass Parent class where to stop calculating the position. Default inner-scroll.
         * @param duration Duration of the scroll animation in milliseconds.
         * @return True if the element is found, false otherwise.
         */
        scrollToElement(content, element, scrollParentClass, duration) {
            const position = this.getElementXY(element, undefined, scrollParentClass);
            if (!position) {
                return false;
            }
            content === null || content === void 0 ? void 0 : content.scrollToPoint(position[0], position[1], duration || 0);
            return true;
        }
        /**
         * Scroll to a certain element using a selector to find it.
         *
         * @param container The element that contains the element that must be scrolled.
         * @param content The content that must be scrolled.
         * @param selector Selector to find the element to scroll to.
         * @param scrollParentClass Parent class where to stop calculating the position. Default inner-scroll.
         * @param duration Duration of the scroll animation in milliseconds.
         * @return True if the element is found, false otherwise.
         */
        scrollToElementBySelector(container, content, selector, scrollParentClass, duration) {
            if (!container || !content) {
                return false;
            }
            try {
                const position = this.getElementXY(container, selector, scrollParentClass);
                if (!position) {
                    return false;
                }
                content === null || content === void 0 ? void 0 : content.scrollToPoint(position[0], position[1], duration || 0);
                return true;
            }
            catch (error) {
                return false;
            }
        }
        /**
         * Search for an input with error (core-input-error directive) and scrolls to it if found.
         *
         * @param container The element that contains the element that must be scrolled.
         * @param content The content that must be scrolled.
         * @param scrollParentClass Parent class where to stop calculating the position. Default inner-scroll.
         * @return True if the element is found, false otherwise.
         */
        scrollToInputError(container, content, scrollParentClass) {
            return this.scrollToElementBySelector(container, content, '.core-input-error', scrollParentClass);
        }
        /**
         * Set whether debug messages should be displayed.
         *
         * @param value Whether to display or not.
         */
        setDebugDisplay(value) {
            this.debugDisplay = value;
        }
        /**
         * Show an alert modal with a button to close it.
         *
         * @param title Title to show.
         * @param message Message to show.
         * @param buttonText Text of the button.
         * @param autocloseTime Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
         * @return Promise resolved with the alert modal.
         */
        showAlert(header, message, buttonText, autocloseTime) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                return this.showAlertWithOptions({
                    header,
                    message,
                    buttons: [buttonText || singletons["L" /* Translate */].instant('core.ok')],
                }, autocloseTime);
            });
        }
        /**
         * General show an alert modal.
         *
         * @param options Alert options to pass to the alert.
         * @param autocloseTime Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
         * @return Promise resolved with the alert modal.
         */
        showAlertWithOptions(options = {}, autocloseTime) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const hasHTMLTags = utils_text["a" /* CoreTextUtils */].hasHTMLTags(options.message || '');
                if (hasHTMLTags) {
                    // Format the text.
                    options.message = yield utils_text["a" /* CoreTextUtils */].formatText(options.message);
                }
                const alertId = md5["Md5"].hashAsciiStr((options.header || '') + '#' + (options.message || ''));
                if (this.displayedAlerts[alertId]) {
                    // There's already an alert with the same message and title. Return it.
                    return this.displayedAlerts[alertId];
                }
                const alert = yield singletons["b" /* AlertController */].create(options);
                if (Object.keys(this.displayedAlerts).length === 0) {
                    yield Promise.all(this.activeLoadingModals.slice(0).reverse().map(modal => modal.pause()));
                }
                // eslint-disable-next-line promise/catch-or-return
                alert.present().then(() => {
                    if (hasHTMLTags) {
                        // Treat all anchors so they don't override the app.
                        const alertMessageEl = alert.querySelector('.alert-message');
                        alertMessageEl && this.treatAnchors(alertMessageEl);
                    }
                    return;
                });
                // Store the alert and remove it when dismissed.
                this.displayedAlerts[alertId] = alert;
                // Set the callbacks to trigger an observable event.
                // eslint-disable-next-line promise/catch-or-return
                alert.onDidDismiss().then(() => Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                    delete this.displayedAlerts[alertId];
                    // eslint-disable-next-line promise/always-return
                    if (Object.keys(this.displayedAlerts).length === 0) {
                        yield Promise.all(this.activeLoadingModals.map(modal => modal.resume()));
                    }
                }));
                if (autocloseTime && autocloseTime > 0) {
                    setTimeout(() => Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                        var _a;
                        yield alert.dismiss();
                        if (options.buttons) {
                            // Execute dismiss function if any.
                            const cancelButton = options.buttons.find((button) => typeof button != 'string' && typeof button.handler != 'undefined' && button.role == 'cancel');
                            (_a = cancelButton.handler) === null || _a === void 0 ? void 0 : _a.call(cancelButton, null);
                        }
                    }), autocloseTime);
                }
                return alert;
            });
        }
        /**
         * Show an alert modal with a button to close it, translating the values supplied.
         *
         * @param title Title to show.
         * @param message Message to show.
         * @param buttonText Text of the button.
         * @param autocloseTime Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
         * @return Promise resolved with the alert modal.
         */
        showAlertTranslated(header, message, buttonText, autocloseTime) {
            header = header ? singletons["L" /* Translate */].instant(header) : header;
            message = message ? singletons["L" /* Translate */].instant(message) : message;
            buttonText = buttonText ? singletons["L" /* Translate */].instant(buttonText) : buttonText;
            return this.showAlert(header, message, buttonText, autocloseTime);
        }
        /**
         * Shortcut for a delete confirmation modal.
         *
         * @param translateMessage String key to show in the modal body translated. Default: 'core.areyousure'.
         * @param translateArgs Arguments to pass to translate if necessary.
         * @param options More options. See https://ionicframework.com/docs/v3/api/components/alert/AlertController/
         * @return Promise resolved if the user confirms and rejected with a canceled error if he cancels.
         */
        showDeleteConfirm(translateMessage = 'core.areyousure', translateArgs = {}, options) {
            return this.showConfirm(singletons["L" /* Translate */].instant(translateMessage, translateArgs), undefined, singletons["L" /* Translate */].instant('core.delete'), undefined, options);
        }
        /**
         * Show a confirm modal.
         *
         * @param message Message to show in the modal body.
         * @param header Header of the modal.
         * @param okText Text of the OK button.
         * @param cancelText Text of the Cancel button.
         * @param options More options.
         * @return Promise resolved if the user confirms and rejected with a canceled error if he cancels.
         */
        showConfirm(message, header, okText, cancelText, options = {}) {
            return new Promise((resolve, reject) => {
                options.header = header;
                options.message = message;
                options.buttons = [
                    {
                        text: cancelText || singletons["L" /* Translate */].instant('core.cancel'),
                        role: 'cancel',
                        handler: () => {
                            reject(new cancelederror["a" /* CoreCanceledError */](''));
                        },
                    },
                    {
                        text: okText || singletons["L" /* Translate */].instant('core.ok'),
                        handler: (data) => {
                            resolve(data);
                        },
                    },
                ];
                if (!header) {
                    options.cssClass = (options.cssClass || '') + ' core-nohead';
                }
                this.showAlertWithOptions(options, 0);
            });
        }
        /**
         * Show an alert modal with an error message.
         *
         * @param error Message to show.
         * @param needsTranslate Whether the error needs to be translated.
         * @param autocloseTime Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
         * @return Promise resolved with the alert modal.
         */
        showErrorModal(error, needsTranslate, autocloseTime) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (this.isCanceledError(error)) {
                    // It's a canceled error, don't display an error.
                    return null;
                }
                const message = this.getErrorMessage(error, needsTranslate);
                if (message === null) {
                    // Message doesn't need to be displayed, stop.
                    return null;
                }
                const alertOptions = {
                    message: message,
                    buttons: [singletons["L" /* Translate */].instant('core.ok')],
                };
                if (this.isNetworkError(message, error)) {
                    alertOptions.cssClass = 'core-alert-network-error';
                }
                else {
                    alertOptions.header = singletons["L" /* Translate */].instant('core.error');
                }
                return this.showAlertWithOptions(alertOptions, autocloseTime);
            });
        }
        /**
         * Show an alert modal with an error message. It uses a default message if error is not a string.
         *
         * @param error Message to show.
         * @param defaultError Message to show if the error is not a string.
         * @param needsTranslate Whether the error needs to be translated.
         * @param autocloseTime Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
         * @return Promise resolved with the alert modal.
         */
        showErrorModalDefault(error, defaultError, needsTranslate = false, autocloseTime) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (this.isCanceledError(error)) {
                    // It's a canceled error, don't display an error.
                    return null;
                }
                let errorMessage = error || undefined;
                if (error && typeof error != 'string') {
                    errorMessage = utils_text["a" /* CoreTextUtils */].getErrorMessageFromError(error);
                }
                return this.showErrorModal(typeof errorMessage == 'string' && errorMessage ? error : defaultError, needsTranslate, autocloseTime);
            });
        }
        /**
         * Show an alert modal with the first warning error message. It uses a default message if error is not a string.
         *
         * @param warnings Warnings returned.
         * @param defaultError Message to show if the error is not a string.
         * @param needsTranslate Whether the error needs to be translated.
         * @param autocloseTime Number of milliseconds to wait to close the modal. If not defined, modal won't be closed.
         * @return Promise resolved with the alert modal.
         */
        showErrorModalFirstWarning(warnings, defaultError, needsTranslate, autocloseTime) {
            return this.showErrorModalDefault(warnings === null || warnings === void 0 ? void 0 : warnings[0], defaultError, needsTranslate, autocloseTime);
        }
        /**
         * Displays a loading modal window.
         *
         * @param text The text of the modal window. Default: core.loading.
         * @param needsTranslate Whether the 'text' needs to be translated.
         * @return Loading element instance.
         * @description
         * Usage:
         *     let modal = await domUtils.showModalLoading(myText);
         *     ...
         *     modal.dismiss();
         */
        showModalLoading(text, needsTranslate) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (!text) {
                    text = singletons["L" /* Translate */].instant('core.loading');
                }
                else if (needsTranslate) {
                    text = singletons["L" /* Translate */].instant(text);
                }
                const loading = new ion_loading_CoreIonLoadingElement(text);
                loading.onDismiss(() => {
                    const index = this.activeLoadingModals.indexOf(loading);
                    if (index !== -1) {
                        this.activeLoadingModals.splice(index, 1);
                    }
                });
                this.activeLoadingModals.push(loading);
                yield loading.present();
                return loading;
            });
        }
        /**
         * Show a modal warning the user that he should use a different app.
         *
         * @param message The warning message.
         * @param link Link to the app to download if any.
         * @return Promise resolved when done.
         */
        showDownloadAppNoticeModal(message, link) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const buttons = [{
                        text: singletons["L" /* Translate */].instant('core.ok'),
                        role: 'cancel',
                    }];
                if (link) {
                    buttons.push({
                        text: singletons["L" /* Translate */].instant('core.download'),
                        handler: () => {
                            utils["a" /* CoreUtils */].openInBrowser(link);
                        },
                    });
                }
                const alert = yield this.showAlertWithOptions({
                    message: message,
                    buttons: buttons,
                });
                const isDevice = app["a" /* CoreApp */].isAndroid() || app["a" /* CoreApp */].isIOS();
                if (!isDevice) {
                    // Treat all anchors so they don't override the app.
                    const alertMessageEl = alert.querySelector('.alert-message');
                    alertMessageEl && this.treatAnchors(alertMessageEl);
                }
                yield alert.onDidDismiss();
            });
        }
        /**
         * Show a prompt modal to input some data.
         *
         * @param message Modal message.
         * @param header Modal header.
         * @param placeholder Placeholder of the input element. By default, "Password".
         * @param type Type of the input element. By default, password.
         * @param options More options to pass to the alert.
         * @return Promise resolved with the input data if the user clicks OK, rejected if cancels.
         */
        showPrompt(message, header, placeholder, type = 'password') {
            return new Promise((resolve, reject) => {
                placeholder = placeholder !== null && placeholder !== void 0 ? placeholder : singletons["L" /* Translate */].instant('core.login.password');
                const options = {
                    header,
                    message,
                    inputs: [
                        {
                            name: 'promptinput',
                            placeholder: placeholder,
                            type,
                        },
                    ],
                    buttons: [
                        {
                            text: singletons["L" /* Translate */].instant('core.cancel'),
                            role: 'cancel',
                            handler: () => {
                                reject();
                            },
                        },
                        {
                            text: singletons["L" /* Translate */].instant('core.ok'),
                            handler: (data) => {
                                resolve(data.promptinput);
                            },
                        },
                    ],
                };
                this.showAlertWithOptions(options);
            });
        }
        /**
         * Show a prompt modal to input a textarea.
         *
         * @param title Modal title.
         * @param message Modal message.
         * @param buttons Buttons to pass to the modal.
         * @param placeholder Placeholder of the input element if any.
         * @return Promise resolved with the entered text if any.
         */
        showTextareaPrompt(title, message, buttons, placeholder) {
            var _a, _b;
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const alert = yield singletons["b" /* AlertController */].create({
                    header: title,
                    message,
                    inputs: [
                        {
                            name: 'textarea-prompt',
                            type: 'textarea',
                            placeholder: placeholder,
                        },
                    ],
                    buttons,
                });
                yield alert.present();
                const result = yield alert.onWillDismiss();
                return (_b = (_a = result.data) === null || _a === void 0 ? void 0 : _a.values) === null || _b === void 0 ? void 0 : _b['textarea-prompt'];
            });
        }
        /**
         * Displays an autodimissable toast modal window.
         *
         * @param text The text of the toast.
         * @param needsTranslate Whether the 'text' needs to be translated.
         * @param duration Duration in ms of the dimissable toast.
         * @param cssClass Class to add to the toast.
         * @param dismissOnPageChange Dismiss the Toast on page change.
         * @return Toast instance.
         */
        showToast(text, needsTranslate, duration = 2000, cssClass = '') {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (needsTranslate) {
                    text = singletons["L" /* Translate */].instant(text);
                }
                const loader = yield singletons["K" /* ToastController */].create({
                    message: text,
                    duration: duration,
                    position: 'bottom',
                    cssClass: cssClass,
                });
                yield loader.present();
                return loader;
            });
        }
        /**
         * Stores a component/directive instance.
         *
         * @param element The root element of the component/directive.
         * @param instance The instance to store.
         */
        storeInstanceByElement(element, instance) {
            this.instances.set(element, instance);
        }
        /**
         * Check if an element supports input via keyboard.
         *
         * @param el HTML element to check.
         * @return Whether it supports input using keyboard.
         */
        supportsInputKeyboard(el) {
            return el &&
                !el.disabled &&
                (el.tagName.toLowerCase() == 'textarea' ||
                    (el.tagName.toLowerCase() == 'input' && this.INPUT_SUPPORT_KEYBOARD.indexOf(el.type) != -1));
        }
        /**
         * Converts HTML formatted text to DOM element(s).
         *
         * @param text HTML text.
         * @return Same text converted to HTMLCollection.
         */
        toDom(text) {
            const element = this.convertToElement(text);
            return element.children;
        }
        /**
         * Treat anchors inside alert/modals.
         *
         * @param container The HTMLElement that can contain anchors.
         */
        treatAnchors(container) {
            const anchors = Array.from(container.querySelectorAll('a'));
            anchors.forEach((anchor) => {
                anchor.addEventListener('click', (event) => {
                    if (event.defaultPrevented) {
                        // Stop.
                        return;
                    }
                    const href = anchor.getAttribute('href');
                    if (href) {
                        event.preventDefault();
                        event.stopPropagation();
                        utils["a" /* CoreUtils */].openInBrowser(href);
                    }
                });
            });
        }
        /**
         * Opens a Modal.
         *
         * @param modalOptions Modal Options.
         */
        openModal(modalOptions) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const modal = yield singletons["x" /* ModalController */].create(modalOptions);
                yield modal.present();
                // If onDidDismiss is nedded we can add a new param to the function to wait one function or the other.
                const result = yield modal.onWillDismiss();
                if (result === null || result === void 0 ? void 0 : result.data) {
                    return result === null || result === void 0 ? void 0 : result.data;
                }
            });
        }
        /**
         * Opens a side Modal.
         *
         * @param modalOptions Modal Options.
         */
        openSideModal(modalOptions) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                modalOptions = Object.assign(modalOptions, {
                    cssClass: 'core-modal-lateral',
                    showBackdrop: true,
                    backdropDismiss: true,
                    enterAnimation: CoreModalLateralTransitionEnter,
                    leaveAnimation: CoreModalLateralTransitionLeave,
                });
                return yield this.openModal(modalOptions);
            });
        }
        /**
         * Opens a popover.
         *
         * @param popoverOptions Modal Options.
         */
        openPopover(popoverOptions) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const popover = yield singletons["D" /* PopoverController */].create(popoverOptions);
                const zoomLevel = yield config["a" /* CoreConfig */].get(constants["a" /* CoreConstants */].SETTINGS_ZOOM_LEVEL, "normal" /* NORMAL */);
                yield popover.present();
                // Fix popover position if zoom is applied.
                if (zoomLevel !== "normal" /* NORMAL */) {
                    switch (Object(esm["k" /* getMode */])()) {
                        case 'ios':
                            fixIOSPopoverPosition(popover, popoverOptions.event);
                            break;
                        case 'md':
                            fixMDPopoverPosition(popover, popoverOptions.event);
                            break;
                    }
                }
                // If onDidDismiss is nedded we can add a new param to the function to wait one function or the other.
                const result = yield popover.onWillDismiss();
                if (result === null || result === void 0 ? void 0 : result.data) {
                    return result === null || result === void 0 ? void 0 : result.data;
                }
            });
        }
        /**
         * View an image in a modal.
         *
         * @param image URL of the image.
         * @param title Title of the page or modal.
         * @param component Component to link the image to if needed.
         * @param componentId An ID to use in conjunction with the component.
         * @param fullScreen Whether the modal should be full screen.
         */
        viewImage(image, title, component, componentId, fullScreen) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (!image) {
                    return;
                }
                yield CoreDomUtils.openModal({
                    component: image_image["a" /* CoreViewerImageComponent */],
                    componentProps: {
                        title,
                        image,
                        component,
                        componentId,
                    },
                    cssClass: fullScreen ? 'core-modal-fullscreen' : '',
                });
            });
        }
        /**
         * Wait for images to load.
         *
         * @param element The element to search in.
         * @return Promise resolved with a boolean: whether there was any image to load.
         */
        waitForImages(element) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                const imgs = Array.from(element.querySelectorAll('img'));
                const promises = [];
                let hasImgToLoad = false;
                imgs.forEach((img) => {
                    if (img && !img.complete) {
                        hasImgToLoad = true;
                        // Wait for image to load or fail.
                        promises.push(new Promise((resolve) => {
                            const imgLoaded = () => {
                                resolve();
                                img.removeEventListener('load', imgLoaded);
                                img.removeEventListener('error', imgLoaded);
                            };
                            img.addEventListener('load', imgLoaded);
                            img.addEventListener('error', imgLoaded);
                        }));
                    }
                });
                yield Promise.all(promises);
                return hasImgToLoad;
            });
        }
        /**
         * Wrap an HTMLElement with another element.
         *
         * @param el The element to wrap.
         * @param wrapper Wrapper.
         */
        wrapElement(el, wrapper) {
            var _a;
            // Insert the wrapper before the element.
            (_a = el.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(wrapper, el);
            // Now move the element into the wrapper.
            wrapper.appendChild(el);
        }
        /**
         * Trigger form cancelled event.
         *
         * @param form Form element.
         * @param siteId The site affected. If not provided, no site affected.
         * @deprecated since 3.9.5. Function has been moved to CoreForms.
         */
        triggerFormCancelledEvent(formRef, siteId) {
            singletons_form["a" /* CoreForms */].triggerFormCancelledEvent(formRef, siteId);
        }
        /**
         * Trigger form submitted event.
         *
         * @param form Form element.
         * @param online Whether the action was done in offline or not.
         * @param siteId The site affected. If not provided, no site affected.
         * @deprecated since 3.9.5. Function has been moved to CoreForms.
         */
        triggerFormSubmittedEvent(formRef, online, siteId) {
            singletons_form["a" /* CoreForms */].triggerFormSubmittedEvent(formRef, online, siteId);
        }
        /**
         * In iOS the resize event is triggered before the window size changes. Wait for the size to change.
         *
         * @param windowWidth Initial window width.
         * @param windowHeight Initial window height.
         * @param retries Number of retries done.
         */
        waitForResizeDone(windowWidth, windowHeight, retries = 0) {
            return Object(tslib_es6["a" /* __awaiter */])(this, void 0, void 0, function* () {
                if (!app["a" /* CoreApp */].isIOS()) {
                    return; // Only wait in iOS.
                }
                windowWidth = windowWidth || window.innerWidth;
                windowHeight = windowHeight || window.innerHeight;
                if (windowWidth != window.innerWidth || windowHeight != window.innerHeight || retries >= 10) {
                    // Window size changed or max number of retries reached, stop.
                    return;
                }
                // Wait a bit and try again.
                yield utils["a" /* CoreUtils */].wait(50);
                return this.waitForResizeDone(windowWidth, windowHeight, retries + 1);
            });
        }
    }
    CoreDomUtilsProvider.ɵfac = function CoreDomUtilsProvider_Factory(t) { return new (t || CoreDomUtilsProvider)(); };
    CoreDomUtilsProvider.ɵprov = core["uc" /* ɵɵdefineInjectable */]({ token: CoreDomUtilsProvider, factory: CoreDomUtilsProvider.ɵfac, providedIn: 'root' });
    return CoreDomUtilsProvider;
})();
/**
 * Fix the position of a popover that was created with a zoom level applied in iOS.
 *
 * This is necessary because Ionic's implementation gets the body dimensions from `element.ownerDocument.defaultView.innerXXX`,
 * which doesn't return the correct dimensions when the `zoom` CSS property is being used. This is specially necessary
 * in iOS because Android already respects system font sizes. Eventually, we should find an alternative implementation for iOS
 * that doesn't require this workaround (also because the `zoom` CSS property is not standard and its usage is discouraged for
 * production).
 *
 * This function has been copied in its entirety from Ionic's source code, only changing the aforementioned calculation
 * of the body dimensions with `document.body.clientXXX`.
 *
 * @see https://github.com/ionic-team/ionic-framework/blob/v5.6.6/core/src/components/popover/animations/ios.enter.ts
 */
function fixIOSPopoverPosition(baseEl, ev) {
    let originY = 'top';
    let originX = 'left';
    const POPOVER_IOS_BODY_PADDING = 5;
    const contentEl = baseEl.querySelector('.popover-content');
    const contentDimentions = contentEl.getBoundingClientRect();
    const contentWidth = contentDimentions.width;
    const contentHeight = contentDimentions.height;
    const bodyWidth = document.body.clientWidth;
    const bodyHeight = document.body.clientHeight;
    const targetDim = ev && ev.target && ev.target.getBoundingClientRect();
    const targetTop = targetDim != null && 'top' in targetDim ? targetDim.top : bodyHeight / 2 - contentHeight / 2;
    const targetLeft = targetDim != null && 'left' in targetDim ? targetDim.left : bodyWidth / 2;
    const targetWidth = (targetDim && targetDim.width) || 0;
    const targetHeight = (targetDim && targetDim.height) || 0;
    const arrowEl = baseEl.querySelector('.popover-arrow');
    const arrowDim = arrowEl.getBoundingClientRect();
    const arrowWidth = arrowDim.width;
    const arrowHeight = arrowDim.height;
    if (targetDim == null) {
        arrowEl.style.display = 'none';
    }
    const arrowCSS = {
        top: targetTop + targetHeight,
        left: targetLeft + targetWidth / 2 - arrowWidth / 2,
    };
    const popoverCSS = {
        top: targetTop + targetHeight + (arrowHeight - 1),
        left: targetLeft + targetWidth / 2 - contentWidth / 2,
    };
    let checkSafeAreaLeft = false;
    let checkSafeAreaRight = false;
    if (popoverCSS.left < POPOVER_IOS_BODY_PADDING + 25) {
        checkSafeAreaLeft = true;
        popoverCSS.left = POPOVER_IOS_BODY_PADDING;
    }
    else if (contentWidth + POPOVER_IOS_BODY_PADDING + popoverCSS.left + 25 > bodyWidth) {
        checkSafeAreaRight = true;
        popoverCSS.left = bodyWidth - contentWidth - POPOVER_IOS_BODY_PADDING;
        originX = 'right';
    }
    if (targetTop + targetHeight + contentHeight > bodyHeight && targetTop - contentHeight > 0) {
        arrowCSS.top = targetTop - (arrowHeight + 1);
        popoverCSS.top = targetTop - contentHeight - (arrowHeight - 1);
        baseEl.className = baseEl.className + ' popover-bottom';
        originY = 'bottom';
    }
    else if (targetTop + targetHeight + contentHeight > bodyHeight) {
        contentEl.style.bottom = POPOVER_IOS_BODY_PADDING + '%';
    }
    arrowEl.style.top = arrowCSS.top + 'px';
    arrowEl.style.left = arrowCSS.left + 'px';
    contentEl.style.top = popoverCSS.top + 'px';
    contentEl.style.left = popoverCSS.left + 'px';
    if (checkSafeAreaLeft) {
        contentEl.style.left = `calc(${popoverCSS.left}px + var(--ion-safe-area-left, 0px))`;
    }
    if (checkSafeAreaRight) {
        contentEl.style.left = `calc(${popoverCSS.left}px - var(--ion-safe-area-right, 0px))`;
    }
    contentEl.style.transformOrigin = originY + ' ' + originX;
}
/**
 * Fix the position of a popover that was created with a zoom level applied in Android.
 *
 * This is necessary because Ionic's implementation gets the body dimensions from `element.ownerDocument.defaultView.innerXXX`,
 * which doesn't return the correct dimensions when the `zoom` CSS property is being used. This is only a temporary solution
 * in Android because system zooming is already supported, so it won't be necessary to do it at an app level.
 *
 * @todo remove the ability to zoom in Android.
 *
 * This function has been copied in its entirety from Ionic's source code, only changing the aforementioned calculation
 * of the body dimensions with `document.body.clientXXX`.
 *
 * @see https://github.com/ionic-team/ionic-framework/blob/v5.6.6/core/src/components/popover/animations/md.enter.ts
 */
function fixMDPopoverPosition(baseEl, ev) {
    const POPOVER_MD_BODY_PADDING = 12;
    const isRTL = document.dir === 'rtl';
    let originY = 'top';
    let originX = isRTL ? 'right' : 'left';
    const contentEl = baseEl.querySelector('.popover-content');
    const contentDimentions = contentEl.getBoundingClientRect();
    const contentWidth = contentDimentions.width;
    const contentHeight = contentDimentions.height;
    const bodyWidth = document.body.clientWidth;
    const bodyHeight = document.body.clientHeight;
    const targetDim = ev && ev.target && ev.target.getBoundingClientRect();
    const targetTop = targetDim != null && 'bottom' in targetDim
        ? targetDim.bottom
        : bodyHeight / 2 - contentHeight / 2;
    const targetLeft = targetDim != null && 'left' in targetDim
        ? isRTL
            ? targetDim.left - contentWidth + targetDim.width
            : targetDim.left
        : bodyWidth / 2 - contentWidth / 2;
    const targetHeight = (targetDim && targetDim.height) || 0;
    const popoverCSS = {
        top: targetTop,
        left: targetLeft,
    };
    if (popoverCSS.left < POPOVER_MD_BODY_PADDING) {
        popoverCSS.left = POPOVER_MD_BODY_PADDING;
        originX = 'left';
    }
    else if (contentWidth + POPOVER_MD_BODY_PADDING + popoverCSS.left > bodyWidth) {
        popoverCSS.left = bodyWidth - contentWidth - POPOVER_MD_BODY_PADDING;
        originX = 'right';
    }
    if (targetTop + targetHeight + contentHeight > bodyHeight && targetTop - contentHeight > 0) {
        popoverCSS.top = targetTop - contentHeight - targetHeight;
        baseEl.className = baseEl.className + ' popover-bottom';
        originY = 'bottom';
    }
    else if (targetTop + targetHeight + contentHeight > bodyHeight) {
        contentEl.style.bottom = POPOVER_MD_BODY_PADDING + 'px';
    }
    contentEl.style.top = popoverCSS.top + 'px';
    contentEl.style.left = popoverCSS.left + 'px';
    contentEl.style.transformOrigin = originY + ' ' + originX;
}
const CoreDomUtils = Object(singletons["P" /* makeSingleton */])(dom_CoreDomUtilsProvider);


/***/ }),

/***/ "3N8a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ AsyncAction_AsyncAction; });

// EXTERNAL MODULE: ./node_modules/rxjs/_esm2015/internal/Subscription.js + 1 modules
var Subscription = __webpack_require__("quSY");

// CONCATENATED MODULE: ./node_modules/rxjs/_esm2015/internal/scheduler/Action.js

class Action_Action extends Subscription["a" /* Subscription */] {
    constructor(scheduler, work) {
        super();
    }
    schedule(state, delay = 0) {
        return this;
    }
}
//# sourceMappingURL=Action.js.map

// CONCATENATED MODULE: ./node_modules/rxjs/_esm2015/internal/scheduler/AsyncAction.js

class AsyncAction_AsyncAction extends Action_Action {
    constructor(scheduler, work) {
        super(scheduler, work);
        this.scheduler = scheduler;
        this.work = work;
        this.pending = false;
    }
    schedule(state, delay = 0) {
        if (this.closed) {
            return this;
        }
        this.state = state;
        const id = this.id;
        const scheduler = this.scheduler;
        if (id != null) {
            this.id = this.recycleAsyncId(scheduler, id, delay);
        }
        this.pending = true;
        this.delay = delay;
        this.id = this.id || this.requestAsyncId(scheduler, this.id, delay);
        return this;
    }
    requestAsyncId(scheduler, id, delay = 0) {
        return setInterval(scheduler.flush.bind(scheduler, this), delay);
    }
    recycleAsyncId(scheduler, id, delay = 0) {
        if (delay !== null && this.delay === delay && this.pending === false) {
            return id;
        }
        clearInterval(id);
        return undefined;
    }
    execute(state, delay) {
        if (this.closed) {
            return new Error('executing a cancelled action');
        }
        this.pending = false;
        const error = this._execute(state, delay);
        if (error) {
            return error;
        }
        else if (this.pending === false && this.id != null) {
            this.id = this.recycleAsyncId(this.scheduler, this.id, null);
        }
    }
    _execute(state, delay) {
        let errored = false;
        let errorValue = undefined;
        try {
            this.work(state);
        }
        catch (e) {
            errored = true;
            errorValue = !!e && e || new Error(e);
        }
        if (errored) {
            this.unsubscribe();
            return errorValue;
        }
    }
    _unsubscribe() {
        const id = this.id;
        const scheduler = this.scheduler;
        const actions = scheduler.actions;
        const index = actions.indexOf(this);
        this.work = null;
        this.state = null;
        this.pending = false;
        this.scheduler = null;
        if (index !== -1) {
            actions.splice(index, 1);
        }
        if (id != null) {
            this.id = this.recycleAsyncId(scheduler, id, null);
        }
        this.delay = null;
    }
}
//# sourceMappingURL=AsyncAction.js.map


/***/ }),

/***/ "3Pt+":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export AbstractControl */
/* unused harmony export AbstractControlDirective */
/* unused harmony export AbstractFormGroupDirective */
/* unused harmony export COMPOSITION_BUFFER_MODE */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CheckboxControlValueAccessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CheckboxRequiredValidator; });
/* unused harmony export ControlContainer */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return DefaultValueAccessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return EmailValidator; });
/* unused harmony export FormArray */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return FormArrayName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return FormBuilder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return FormControl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return FormControlDirective; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return FormControlName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return FormGroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return FormGroupDirective; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return FormGroupName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return FormsModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return MaxLengthValidator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return MinLengthValidator; });
/* unused harmony export NG_ASYNC_VALIDATORS */
/* unused harmony export NG_VALIDATORS */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return NG_VALUE_ACCESSOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return NgControl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return NgControlStatus; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "s", function() { return NgControlStatusGroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "t", function() { return NgForm; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "u", function() { return NgModel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v", function() { return NgModelGroup; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "w", function() { return NgSelectOption; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "x", function() { return NumberValueAccessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "y", function() { return PatternValidator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "z", function() { return RadioControlValueAccessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "A", function() { return RangeValueAccessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "B", function() { return ReactiveFormsModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "C", function() { return RequiredValidator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "D", function() { return SelectControlValueAccessor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "E", function() { return SelectMultipleControlValueAccessor; });
/* unused harmony export VERSION */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "F", function() { return Validators; });
/* unused harmony export ɵInternalFormsSharedModule */
/* unused harmony export ɵNgNoValidate */
/* unused harmony export ɵNgSelectMultipleOption */
/* unused harmony export ɵangular_packages_forms_forms_a */
/* unused harmony export ɵangular_packages_forms_forms_b */
/* unused harmony export ɵangular_packages_forms_forms_ba */
/* unused harmony export ɵangular_packages_forms_forms_bb */
/* unused harmony export ɵangular_packages_forms_forms_bc */
/* unused harmony export ɵangular_packages_forms_forms_bd */
/* unused harmony export ɵangular_packages_forms_forms_be */
/* unused harmony export ɵangular_packages_forms_forms_c */
/* unused harmony export ɵangular_packages_forms_forms_d */
/* unused harmony export ɵangular_packages_forms_forms_e */
/* unused harmony export ɵangular_packages_forms_forms_f */
/* unused harmony export ɵangular_packages_forms_forms_g */
/* unused harmony export ɵangular_packages_forms_forms_h */
/* unused harmony export ɵangular_packages_forms_forms_i */
/* unused harmony export ɵangular_packages_forms_forms_j */
/* unused harmony export ɵangular_packages_forms_forms_k */
/* unused harmony export ɵangular_packages_forms_forms_l */
/* unused harmony export ɵangular_packages_forms_forms_m */
/* unused harmony export ɵangular_packages_forms_forms_n */
/* unused harmony export ɵangular_packages_forms_forms_o */
/* unused harmony export ɵangular_packages_forms_forms_p */
/* unused harmony export ɵangular_packages_forms_forms_q */
/* unused harmony export ɵangular_packages_forms_forms_r */
/* unused harmony export ɵangular_packages_forms_forms_s */
/* unused harmony export ɵangular_packages_forms_forms_t */
/* unused harmony export ɵangular_packages_forms_forms_u */
/* unused harmony export ɵangular_packages_forms_forms_v */
/* unused harmony export ɵangular_packages_forms_forms_w */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "G", function() { return ɵNgSelectMultipleOption; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "H", function() { return ɵNgNoValidate; });
/* unused harmony export ɵangular_packages_forms_forms_z */
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("fXoL");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("ofXK");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("cp0P");
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("Cfvw");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("lJxs");
/**
 * @license Angular v10.0.14
 * (c) 2010-2020 Google LLC. https://angular.io/
 * License: MIT
 */




/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Used to provide a `ControlValueAccessor` for form controls.
 *
 * See `DefaultValueAccessor` for how to implement one.
 *
 * @publicApi
 */

const NG_VALUE_ACCESSOR = /*@__PURE__*/ new _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* InjectionToken */ "w"]('NgValueAccessor');
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const CHECKBOX_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => CheckboxControlValueAccessor),
    multi: true,
};
let CheckboxControlValueAccessor = /*@__PURE__*/ (() => {
    class CheckboxControlValueAccessor {
        constructor(_renderer, _elementRef) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            /**
             * @description
             * The registered callback function called when a change event occurs on the input element.
             */
            this.onChange = (_) => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
        }
        /**
         * Sets the "checked" property on the input element.
         *
         * @param value The checked value
         */
        writeValue(value) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'checked', value);
        }
        /**
         * @description
         * Registers a function called when the control value changes.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this.onChange = fn;
        }
        /**
         * @description
         * Registers a function called when the control is touched.
         *
         * @param fn The callback function
         */
        registerOnTouched(fn) {
            this.onTouched = fn;
        }
        /**
         * Sets the "disabled" property on the input element.
         *
         * @param isDisabled The disabled value
         */
        setDisabledState(isDisabled) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
        }
    }
    CheckboxControlValueAccessor.ɵfac = function CheckboxControlValueAccessor_Factory(t) { return new (t || CheckboxControlValueAccessor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"])); };
    CheckboxControlValueAccessor.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: CheckboxControlValueAccessor, selectors: [["input", "type", "checkbox", "formControlName", ""], ["input", "type", "checkbox", "formControl", ""], ["input", "type", "checkbox", "ngModel", ""]], hostBindings: function CheckboxControlValueAccessor_HostBindings(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("change", function CheckboxControlValueAccessor_change_HostBindingHandler($event) { return ctx.onChange($event.target.checked); })("blur", function CheckboxControlValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
            }
        }, features: [/*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵProvidersFeature */ "kc"]([CHECKBOX_VALUE_ACCESSOR])] });
    return CheckboxControlValueAccessor;
})();
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const DEFAULT_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => DefaultValueAccessor),
    multi: true
};
/**
 * We must check whether the agent is Android because composition events
 * behave differently between iOS and Android.
 */
function _isAndroid() {
    const userAgent = Object(_angular_common__WEBPACK_IMPORTED_MODULE_1__[/* ɵgetDOM */ "K"])() ? Object(_angular_common__WEBPACK_IMPORTED_MODULE_1__[/* ɵgetDOM */ "K"])().getUserAgent() : '';
    return /android (\d+)/.test(userAgent.toLowerCase());
}
/**
 * @description
 * Provide this token to control if form directives buffer IME input until
 * the "compositionend" event occurs.
 * @publicApi
 */
const COMPOSITION_BUFFER_MODE = /*@__PURE__*/ new _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* InjectionToken */ "w"]('CompositionEventMode');
let DefaultValueAccessor = /*@__PURE__*/ (() => {
    class DefaultValueAccessor {
        constructor(_renderer, _elementRef, _compositionMode) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            this._compositionMode = _compositionMode;
            /**
             * @description
             * The registered callback function called when an input event occurs on the input element.
             */
            this.onChange = (_) => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
            /** Whether the user is creating a composition string (IME events). */
            this._composing = false;
            if (this._compositionMode == null) {
                this._compositionMode = !_isAndroid();
            }
        }
        /**
         * Sets the "value" property on the input element.
         *
         * @param value The checked value
         */
        writeValue(value) {
            const normalizedValue = value == null ? '' : value;
            this._renderer.setProperty(this._elementRef.nativeElement, 'value', normalizedValue);
        }
        /**
         * @description
         * Registers a function called when the control value changes.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this.onChange = fn;
        }
        /**
         * @description
         * Registers a function called when the control is touched.
         *
         * @param fn The callback function
         */
        registerOnTouched(fn) {
            this.onTouched = fn;
        }
        /**
         * Sets the "disabled" property on the input element.
         *
         * @param isDisabled The disabled value
         */
        setDisabledState(isDisabled) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
        }
        /** @internal */
        _handleInput(value) {
            if (!this._compositionMode || (this._compositionMode && !this._composing)) {
                this.onChange(value);
            }
        }
        /** @internal */
        _compositionStart() {
            this._composing = true;
        }
        /** @internal */
        _compositionEnd(value) {
            this._composing = false;
            this._compositionMode && this.onChange(value);
        }
    }
    DefaultValueAccessor.ɵfac = function DefaultValueAccessor_Factory(t) { return new (t || DefaultValueAccessor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](COMPOSITION_BUFFER_MODE, 8)); };
    DefaultValueAccessor.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: DefaultValueAccessor, selectors: [["input", "formControlName", "", 3, "type", "checkbox"], ["textarea", "formControlName", ""], ["input", "formControl", "", 3, "type", "checkbox"], ["textarea", "formControl", ""], ["input", "ngModel", "", 3, "type", "checkbox"], ["textarea", "ngModel", ""], ["", "ngDefaultControl", ""]], hostBindings: function DefaultValueAccessor_HostBindings(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("input", function DefaultValueAccessor_input_HostBindingHandler($event) { return ctx._handleInput($event.target.value); })("blur", function DefaultValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); })("compositionstart", function DefaultValueAccessor_compositionstart_HostBindingHandler() { return ctx._compositionStart(); })("compositionend", function DefaultValueAccessor_compositionend_HostBindingHandler($event) { return ctx._compositionEnd($event.target.value); });
            }
        }, features: [/*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵProvidersFeature */ "kc"]([DEFAULT_VALUE_ACCESSOR])] });
    return DefaultValueAccessor;
})();
let AbstractControlDirective = /*@__PURE__*/ (() => {
    class AbstractControlDirective {
        /**
         * @description
         * Reports the value of the control if it is present, otherwise null.
         */
        get value() {
            return this.control ? this.control.value : null;
        }
        /**
         * @description
         * Reports whether the control is valid. A control is considered valid if no
         * validation errors exist with the current value.
         * If the control is not present, null is returned.
         */
        get valid() {
            return this.control ? this.control.valid : null;
        }
        /**
         * @description
         * Reports whether the control is invalid, meaning that an error exists in the input value.
         * If the control is not present, null is returned.
         */
        get invalid() {
            return this.control ? this.control.invalid : null;
        }
        /**
         * @description
         * Reports whether a control is pending, meaning that that async validation is occurring and
         * errors are not yet available for the input value. If the control is not present, null is
         * returned.
         */
        get pending() {
            return this.control ? this.control.pending : null;
        }
        /**
         * @description
         * Reports whether the control is disabled, meaning that the control is disabled
         * in the UI and is exempt from validation checks and excluded from aggregate
         * values of ancestor controls. If the control is not present, null is returned.
         */
        get disabled() {
            return this.control ? this.control.disabled : null;
        }
        /**
         * @description
         * Reports whether the control is enabled, meaning that the control is included in ancestor
         * calculations of validity or value. If the control is not present, null is returned.
         */
        get enabled() {
            return this.control ? this.control.enabled : null;
        }
        /**
         * @description
         * Reports the control's validation errors. If the control is not present, null is returned.
         */
        get errors() {
            return this.control ? this.control.errors : null;
        }
        /**
         * @description
         * Reports whether the control is pristine, meaning that the user has not yet changed
         * the value in the UI. If the control is not present, null is returned.
         */
        get pristine() {
            return this.control ? this.control.pristine : null;
        }
        /**
         * @description
         * Reports whether the control is dirty, meaning that the user has changed
         * the value in the UI. If the control is not present, null is returned.
         */
        get dirty() {
            return this.control ? this.control.dirty : null;
        }
        /**
         * @description
         * Reports whether the control is touched, meaning that the user has triggered
         * a `blur` event on it. If the control is not present, null is returned.
         */
        get touched() {
            return this.control ? this.control.touched : null;
        }
        /**
         * @description
         * Reports the validation status of the control. Possible values include:
         * 'VALID', 'INVALID', 'DISABLED', and 'PENDING'.
         * If the control is not present, null is returned.
         */
        get status() {
            return this.control ? this.control.status : null;
        }
        /**
         * @description
         * Reports whether the control is untouched, meaning that the user has not yet triggered
         * a `blur` event on it. If the control is not present, null is returned.
         */
        get untouched() {
            return this.control ? this.control.untouched : null;
        }
        /**
         * @description
         * Returns a multicasting observable that emits a validation status whenever it is
         * calculated for the control. If the control is not present, null is returned.
         */
        get statusChanges() {
            return this.control ? this.control.statusChanges : null;
        }
        /**
         * @description
         * Returns a multicasting observable of value changes for the control that emits every time the
         * value of the control changes in the UI or programmatically.
         * If the control is not present, null is returned.
         */
        get valueChanges() {
            return this.control ? this.control.valueChanges : null;
        }
        /**
         * @description
         * Returns an array that represents the path from the top-level form to this control.
         * Each index is the string name of the control on that level.
         */
        get path() {
            return null;
        }
        /**
         * @description
         * Resets the control with the provided value if the control is present.
         */
        reset(value = undefined) {
            if (this.control)
                this.control.reset(value);
        }
        /**
         * @description
         * Reports whether the control with the given path has the error specified.
         *
         * @param errorCode The code of the error to check
         * @param path A list of control names that designates how to move from the current control
         * to the control that should be queried for errors.
         *
         * @usageNotes
         * For example, for the following `FormGroup`:
         *
         * ```
         * form = new FormGroup({
         *   address: new FormGroup({ street: new FormControl() })
         * });
         * ```
         *
         * The path to the 'street' control from the root form would be 'address' -> 'street'.
         *
         * It can be provided to this method in one of two formats:
         *
         * 1. An array of string control names, e.g. `['address', 'street']`
         * 1. A period-delimited list of control names in one string, e.g. `'address.street'`
         *
         * If no path is given, this method checks for the error on the current control.
         *
         * @returns whether the given error is present in the control at the given path.
         *
         * If the control is not present, false is returned.
         */
        hasError(errorCode, path) {
            return this.control ? this.control.hasError(errorCode, path) : false;
        }
        /**
         * @description
         * Reports error data for the control with the given path.
         *
         * @param errorCode The code of the error to check
         * @param path A list of control names that designates how to move from the current control
         * to the control that should be queried for errors.
         *
         * @usageNotes
         * For example, for the following `FormGroup`:
         *
         * ```
         * form = new FormGroup({
         *   address: new FormGroup({ street: new FormControl() })
         * });
         * ```
         *
         * The path to the 'street' control from the root form would be 'address' -> 'street'.
         *
         * It can be provided to this method in one of two formats:
         *
         * 1. An array of string control names, e.g. `['address', 'street']`
         * 1. A period-delimited list of control names in one string, e.g. `'address.street'`
         *
         * @returns error data for that particular error. If the control or error is not present,
         * null is returned.
         */
        getError(errorCode, path) {
            return this.control ? this.control.getError(errorCode, path) : null;
        }
    }
    AbstractControlDirective.ɵfac = function AbstractControlDirective_Factory(t) { return new (t || AbstractControlDirective)(); };
    AbstractControlDirective.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: AbstractControlDirective });
    return AbstractControlDirective;
})();
let ControlContainer = /*@__PURE__*/ (() => {
    class ControlContainer extends AbstractControlDirective {
        /**
         * @description
         * The top-level form directive for the control.
         */
        get formDirective() {
            return null;
        }
        /**
         * @description
         * The path to this group.
         */
        get path() {
            return null;
        }
    }
    ControlContainer.ɵfac = function ControlContainer_Factory(t) { return ɵControlContainer_BaseFactory(t || ControlContainer); };
    ControlContainer.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: ControlContainer, features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵInheritDefinitionFeature */ "ic"]] });
    return ControlContainer;
})();
const ɵControlContainer_BaseFactory = /*@__PURE__*/ /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵgetInheritedFactory */ "Gc"](ControlContainer);
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function unimplemented() {
    throw new Error('unimplemented');
}
/**
 * @description
 * A base class that all `FormControl`-based directives extend. It binds a `FormControl`
 * object to a DOM element.
 *
 * @publicApi
 */
class NgControl extends AbstractControlDirective {
    constructor() {
        super(...arguments);
        /**
         * @description
         * The parent form for the control.
         *
         * @internal
         */
        this._parent = null;
        /**
         * @description
         * The name for the control
         */
        this.name = null;
        /**
         * @description
         * The value accessor for the control
         */
        this.valueAccessor = null;
        /**
         * @description
         * The uncomposed array of synchronous validators for the control
         *
         * @internal
         */
        this._rawValidators = [];
        /**
         * @description
         * The uncomposed array of async validators for the control
         *
         * @internal
         */
        this._rawAsyncValidators = [];
    }
    /**
     * @description
     * The registered synchronous validator function for the control
     *
     * @throws An exception that this method is not implemented
     */
    get validator() {
        return unimplemented();
    }
    /**
     * @description
     * The registered async validator function for the control
     *
     * @throws An exception that this method is not implemented
     */
    get asyncValidator() {
        return unimplemented();
    }
}
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
class AbstractControlStatus {
    constructor(cd) {
        this._cd = cd;
    }
    get ngClassUntouched() {
        return this._cd.control ? this._cd.control.untouched : false;
    }
    get ngClassTouched() {
        return this._cd.control ? this._cd.control.touched : false;
    }
    get ngClassPristine() {
        return this._cd.control ? this._cd.control.pristine : false;
    }
    get ngClassDirty() {
        return this._cd.control ? this._cd.control.dirty : false;
    }
    get ngClassValid() {
        return this._cd.control ? this._cd.control.valid : false;
    }
    get ngClassInvalid() {
        return this._cd.control ? this._cd.control.invalid : false;
    }
    get ngClassPending() {
        return this._cd.control ? this._cd.control.pending : false;
    }
}
const ngControlStatusHost = {
    '[class.ng-untouched]': 'ngClassUntouched',
    '[class.ng-touched]': 'ngClassTouched',
    '[class.ng-pristine]': 'ngClassPristine',
    '[class.ng-dirty]': 'ngClassDirty',
    '[class.ng-valid]': 'ngClassValid',
    '[class.ng-invalid]': 'ngClassInvalid',
    '[class.ng-pending]': 'ngClassPending',
};
let NgControlStatus = /*@__PURE__*/ (() => {
    class NgControlStatus extends AbstractControlStatus {
        constructor(cd) {
            super(cd);
        }
    }
    NgControlStatus.ɵfac = function NgControlStatus_Factory(t) { return new (t || NgControlStatus)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](NgControl, 2)); };
    NgControlStatus.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: NgControlStatus, selectors: [["", "formControlName", ""], ["", "ngModel", ""], ["", "formControl", ""]], hostVars: 14, hostBindings: function NgControlStatus_HostBindings(rf, ctx) {
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵclassProp */ "qc"]("ng-untouched", ctx.ngClassUntouched)("ng-touched", ctx.ngClassTouched)("ng-pristine", ctx.ngClassPristine)("ng-dirty", ctx.ngClassDirty)("ng-valid", ctx.ngClassValid)("ng-invalid", ctx.ngClassInvalid)("ng-pending", ctx.ngClassPending);
            }
        }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵInheritDefinitionFeature */ "ic"]] });
    return NgControlStatus;
})();
let NgControlStatusGroup = /*@__PURE__*/ (() => {
    class NgControlStatusGroup extends AbstractControlStatus {
        constructor(cd) {
            super(cd);
        }
    }
    NgControlStatusGroup.ɵfac = function NgControlStatusGroup_Factory(t) { return new (t || NgControlStatusGroup)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](ControlContainer, 2)); };
    NgControlStatusGroup.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: NgControlStatusGroup, selectors: [["", "formGroupName", ""], ["", "formArrayName", ""], ["", "ngModelGroup", ""], ["", "formGroup", ""], ["form", 3, "ngNoForm", ""], ["", "ngForm", ""]], hostVars: 14, hostBindings: function NgControlStatusGroup_HostBindings(rf, ctx) {
            if (rf & 2) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵclassProp */ "qc"]("ng-untouched", ctx.ngClassUntouched)("ng-touched", ctx.ngClassTouched)("ng-pristine", ctx.ngClassPristine)("ng-dirty", ctx.ngClassDirty)("ng-valid", ctx.ngClassValid)("ng-invalid", ctx.ngClassInvalid)("ng-pending", ctx.ngClassPending);
            }
        }, features: [_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵInheritDefinitionFeature */ "ic"]] });
    return NgControlStatusGroup;
})();
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function isEmptyInputValue(value) {
    // we don't check for string here so it also works with arrays
    return value == null || value.length === 0;
}
function hasValidLength(value) {
    // non-strict comparison is intentional, to check for both `null` and `undefined` values
    return value != null && typeof value.length === 'number';
}
/**
 * @description
 * An `InjectionToken` for registering additional synchronous validators used with
 * `AbstractControl`s.
 *
 * @see `NG_ASYNC_VALIDATORS`
 *
 * @usageNotes
 *
 * ### Providing a custom validator
 *
 * The following example registers a custom validator directive. Adding the validator to the
 * existing collection of validators requires the `multi: true` option.
 *
 * ```typescript
 * @Directive({
 *   selector: '[customValidator]',
 *   providers: [{provide: NG_VALIDATORS, useExisting: CustomValidatorDirective, multi: true}]
 * })
 * class CustomValidatorDirective implements Validator {
 *   validate(control: AbstractControl): ValidationErrors | null {
 *     return { 'custom': true };
 *   }
 * }
 * ```
 *
 * @publicApi
 */
const NG_VALIDATORS = /*@__PURE__*/ new _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* InjectionToken */ "w"]('NgValidators');
/**
 * @description
 * An `InjectionToken` for registering additional asynchronous validators used with
 * `AbstractControl`s.
 *
 * @see `NG_VALIDATORS`
 *
 * @publicApi
 */
const NG_ASYNC_VALIDATORS = /*@__PURE__*/ new _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* InjectionToken */ "w"]('NgAsyncValidators');
/**
 * A regular expression that matches valid e-mail addresses.
 *
 * At a high level, this regexp matches e-mail addresses of the format `local-part@tld`, where:
 * - `local-part` consists of one or more of the allowed characters (alphanumeric and some
 *   punctuation symbols).
 * - `local-part` cannot begin or end with a period (`.`).
 * - `local-part` cannot be longer than 64 characters.
 * - `tld` consists of one or more `labels` separated by periods (`.`). For example `localhost` or
 *   `foo.com`.
 * - A `label` consists of one or more of the allowed characters (alphanumeric, dashes (`-`) and
 *   periods (`.`)).
 * - A `label` cannot begin or end with a dash (`-`) or a period (`.`).
 * - A `label` cannot be longer than 63 characters.
 * - The whole address cannot be longer than 254 characters.
 *
 * ## Implementation background
 *
 * This regexp was ported over from AngularJS (see there for git history):
 * https://github.com/angular/angular.js/blob/c133ef836/src/ng/directive/input.js#L27
 * It is based on the
 * [WHATWG version](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address) with
 * some enhancements to incorporate more RFC rules (such as rules related to domain names and the
 * lengths of different parts of the address). The main differences from the WHATWG version are:
 *   - Disallow `local-part` to begin or end with a period (`.`).
 *   - Disallow `local-part` length to exceed 64 characters.
 *   - Disallow total address length to exceed 254 characters.
 *
 * See [this commit](https://github.com/angular/angular.js/commit/f3f5cf72e) for more details.
 */
const EMAIL_REGEXP = /^(?=.{1,254}$)(?=.{1,64}@)[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&'*+/=?^_`{|}~-]+)*@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/;
/**
 * @description
 * Provides a set of built-in validators that can be used by form controls.
 *
 * A validator is a function that processes a `FormControl` or collection of
 * controls and returns an error map or null. A null map means that validation has passed.
 *
 * @see [Form Validation](/guide/form-validation)
 *
 * @publicApi
 */
class Validators {
    /**
     * @description
     * Validator that requires the control's value to be greater than or equal to the provided number.
     * The validator exists only as a function and not as a directive.
     *
     * @usageNotes
     *
     * ### Validate against a minimum of 3
     *
     * ```typescript
     * const control = new FormControl(2, Validators.min(3));
     *
     * console.log(control.errors); // {min: {min: 3, actual: 2}}
     * ```
     *
     * @returns A validator function that returns an error map with the
     * `min` property if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static min(min) {
        return (control) => {
            if (isEmptyInputValue(control.value) || isEmptyInputValue(min)) {
                return null; // don't validate empty values to allow optional controls
            }
            const value = parseFloat(control.value);
            // Controls with NaN values after parsing should be treated as not having a
            // minimum, per the HTML forms spec: https://www.w3.org/TR/html5/forms.html#attr-input-min
            return !isNaN(value) && value < min ? { 'min': { 'min': min, 'actual': control.value } } : null;
        };
    }
    /**
     * @description
     * Validator that requires the control's value to be less than or equal to the provided number.
     * The validator exists only as a function and not as a directive.
     *
     * @usageNotes
     *
     * ### Validate against a maximum of 15
     *
     * ```typescript
     * const control = new FormControl(16, Validators.max(15));
     *
     * console.log(control.errors); // {max: {max: 15, actual: 16}}
     * ```
     *
     * @returns A validator function that returns an error map with the
     * `max` property if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static max(max) {
        return (control) => {
            if (isEmptyInputValue(control.value) || isEmptyInputValue(max)) {
                return null; // don't validate empty values to allow optional controls
            }
            const value = parseFloat(control.value);
            // Controls with NaN values after parsing should be treated as not having a
            // maximum, per the HTML forms spec: https://www.w3.org/TR/html5/forms.html#attr-input-max
            return !isNaN(value) && value > max ? { 'max': { 'max': max, 'actual': control.value } } : null;
        };
    }
    /**
     * @description
     * Validator that requires the control have a non-empty value.
     *
     * @usageNotes
     *
     * ### Validate that the field is non-empty
     *
     * ```typescript
     * const control = new FormControl('', Validators.required);
     *
     * console.log(control.errors); // {required: true}
     * ```
     *
     * @returns An error map with the `required` property
     * if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static required(control) {
        return isEmptyInputValue(control.value) ? { 'required': true } : null;
    }
    /**
     * @description
     * Validator that requires the control's value be true. This validator is commonly
     * used for required checkboxes.
     *
     * @usageNotes
     *
     * ### Validate that the field value is true
     *
     * ```typescript
     * const control = new FormControl('', Validators.requiredTrue);
     *
     * console.log(control.errors); // {required: true}
     * ```
     *
     * @returns An error map that contains the `required` property
     * set to `true` if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static requiredTrue(control) {
        return control.value === true ? null : { 'required': true };
    }
    /**
     * @description
     * Validator that requires the control's value pass an email validation test.
     *
     * Tests the value using a [regular
     * expression](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions)
     * pattern suitable for common usecases. The pattern is based on the definition of a valid email
     * address in the [WHATWG HTML
     * specification](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address) with
     * some enhancements to incorporate more RFC rules (such as rules related to domain names and the
     * lengths of different parts of the address).
     *
     * The differences from the WHATWG version include:
     * - Disallow `local-part` (the part before the `@` symbol) to begin or end with a period (`.`).
     * - Disallow `local-part` to be longer than 64 characters.
     * - Disallow the whole address to be longer than 254 characters.
     *
     * If this pattern does not satisfy your business needs, you can use `Validators.pattern()` to
     * validate the value against a different pattern.
     *
     * @usageNotes
     *
     * ### Validate that the field matches a valid email pattern
     *
     * ```typescript
     * const control = new FormControl('bad@', Validators.email);
     *
     * console.log(control.errors); // {email: true}
     * ```
     *
     * @returns An error map with the `email` property
     * if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static email(control) {
        if (isEmptyInputValue(control.value)) {
            return null; // don't validate empty values to allow optional controls
        }
        return EMAIL_REGEXP.test(control.value) ? null : { 'email': true };
    }
    /**
     * @description
     * Validator that requires the length of the control's value to be greater than or equal
     * to the provided minimum length. This validator is also provided by default if you use the
     * the HTML5 `minlength` attribute. Note that the `minLength` validator is intended to be used
     * only for types that have a numeric `length` property, such as strings or arrays. The
     * `minLength` validator logic is also not invoked for values when their `length` property is 0
     * (for example in case of an empty string or an empty array), to support optional controls. You
     * can use the standard `required` validator if empty values should not be considered valid.
     *
     * @usageNotes
     *
     * ### Validate that the field has a minimum of 3 characters
     *
     * ```typescript
     * const control = new FormControl('ng', Validators.minLength(3));
     *
     * console.log(control.errors); // {minlength: {requiredLength: 3, actualLength: 2}}
     * ```
     *
     * ```html
     * <input minlength="5">
     * ```
     *
     * @returns A validator function that returns an error map with the
     * `minlength` if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static minLength(minLength) {
        return (control) => {
            if (isEmptyInputValue(control.value) || !hasValidLength(control.value)) {
                // don't validate empty values to allow optional controls
                // don't validate values without `length` property
                return null;
            }
            return control.value.length < minLength ?
                { 'minlength': { 'requiredLength': minLength, 'actualLength': control.value.length } } :
                null;
        };
    }
    /**
     * @description
     * Validator that requires the length of the control's value to be less than or equal
     * to the provided maximum length. This validator is also provided by default if you use the
     * the HTML5 `maxlength` attribute. Note that the `maxLength` validator is intended to be used
     * only for types that have a numeric `length` property, such as strings or arrays.
     *
     * @usageNotes
     *
     * ### Validate that the field has maximum of 5 characters
     *
     * ```typescript
     * const control = new FormControl('Angular', Validators.maxLength(5));
     *
     * console.log(control.errors); // {maxlength: {requiredLength: 5, actualLength: 7}}
     * ```
     *
     * ```html
     * <input maxlength="5">
     * ```
     *
     * @returns A validator function that returns an error map with the
     * `maxlength` property if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static maxLength(maxLength) {
        return (control) => {
            return hasValidLength(control.value) && control.value.length > maxLength ?
                { 'maxlength': { 'requiredLength': maxLength, 'actualLength': control.value.length } } :
                null;
        };
    }
    /**
     * @description
     * Validator that requires the control's value to match a regex pattern. This validator is also
     * provided by default if you use the HTML5 `pattern` attribute.
     *
     * @usageNotes
     *
     * ### Validate that the field only contains letters or spaces
     *
     * ```typescript
     * const control = new FormControl('1', Validators.pattern('[a-zA-Z ]*'));
     *
     * console.log(control.errors); // {pattern: {requiredPattern: '^[a-zA-Z ]*$', actualValue: '1'}}
     * ```
     *
     * ```html
     * <input pattern="[a-zA-Z ]*">
     * ```
     *
     * @param pattern A regular expression to be used as is to test the values, or a string.
     * If a string is passed, the `^` character is prepended and the `$` character is
     * appended to the provided string (if not already present), and the resulting regular
     * expression is used to test the values.
     *
     * @returns A validator function that returns an error map with the
     * `pattern` property if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static pattern(pattern) {
        if (!pattern)
            return Validators.nullValidator;
        let regex;
        let regexStr;
        if (typeof pattern === 'string') {
            regexStr = '';
            if (pattern.charAt(0) !== '^')
                regexStr += '^';
            regexStr += pattern;
            if (pattern.charAt(pattern.length - 1) !== '$')
                regexStr += '$';
            regex = new RegExp(regexStr);
        }
        else {
            regexStr = pattern.toString();
            regex = pattern;
        }
        return (control) => {
            if (isEmptyInputValue(control.value)) {
                return null; // don't validate empty values to allow optional controls
            }
            const value = control.value;
            return regex.test(value) ? null :
                { 'pattern': { 'requiredPattern': regexStr, 'actualValue': value } };
        };
    }
    /**
     * @description
     * Validator that performs no operation.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static nullValidator(control) {
        return null;
    }
    static compose(validators) {
        if (!validators)
            return null;
        const presentValidators = validators.filter(isPresent);
        if (presentValidators.length == 0)
            return null;
        return function (control) {
            return mergeErrors(executeValidators(control, presentValidators));
        };
    }
    /**
     * @description
     * Compose multiple async validators into a single function that returns the union
     * of the individual error objects for the provided control.
     *
     * @returns A validator function that returns an error map with the
     * merged error objects of the async validators if the validation check fails, otherwise `null`.
     *
     * @see `updateValueAndValidity()`
     *
     */
    static composeAsync(validators) {
        if (!validators)
            return null;
        const presentValidators = validators.filter(isPresent);
        if (presentValidators.length == 0)
            return null;
        return function (control) {
            const observables = executeValidators(control, presentValidators).map(toObservable);
            return Object(rxjs__WEBPACK_IMPORTED_MODULE_2__[/* forkJoin */ "a"])(observables).pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_4__[/* map */ "a"])(mergeErrors));
        };
    }
}
function isPresent(o) {
    return o != null;
}
function toObservable(r) {
    const obs = Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵisPromise */ "Pb"])(r) ? Object(rxjs__WEBPACK_IMPORTED_MODULE_3__[/* from */ "a"])(r) : r;
    if (!(Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵisObservable */ "Ob"])(obs))) {
        throw new Error(`Expected validator to return Promise or Observable.`);
    }
    return obs;
}
function mergeErrors(arrayOfErrors) {
    let res = {};
    // Not using Array.reduce here due to a Chrome 80 bug
    // https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
    arrayOfErrors.forEach((errors) => {
        res = errors != null ? Object.assign(Object.assign({}, res), errors) : res;
    });
    return Object.keys(res).length === 0 ? null : res;
}
function executeValidators(control, validators) {
    return validators.map(validator => validator(control));
}
function isValidatorFn(validator) {
    return !validator.validate;
}
/**
 * Given the list of validators that may contain both functions as well as classes, return the list
 * of validator functions (convert validator classes into validator functions). This is needed to
 * have consistent structure in validators list before composing them.
 *
 * @param validators The set of validators that may contain validators both in plain function form
 *     as well as represented as a validator class.
 */
function normalizeValidators(validators) {
    return validators.map(validator => {
        return isValidatorFn(validator) ?
            validator :
            ((c) => validator.validate(c));
    });
}
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const NUMBER_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => NumberValueAccessor),
    multi: true
};
let NumberValueAccessor = /*@__PURE__*/ (() => {
    class NumberValueAccessor {
        constructor(_renderer, _elementRef) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            /**
             * @description
             * The registered callback function called when a change or input event occurs on the input
             * element.
             */
            this.onChange = (_) => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
        }
        /**
         * Sets the "value" property on the input element.
         *
         * @param value The checked value
         */
        writeValue(value) {
            // The value needs to be normalized for IE9, otherwise it is set to 'null' when null
            const normalizedValue = value == null ? '' : value;
            this._renderer.setProperty(this._elementRef.nativeElement, 'value', normalizedValue);
        }
        /**
         * @description
         * Registers a function called when the control value changes.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this.onChange = (value) => {
                fn(value == '' ? null : parseFloat(value));
            };
        }
        /**
         * @description
         * Registers a function called when the control is touched.
         *
         * @param fn The callback function
         */
        registerOnTouched(fn) {
            this.onTouched = fn;
        }
        /**
         * Sets the "disabled" property on the input element.
         *
         * @param isDisabled The disabled value
         */
        setDisabledState(isDisabled) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
        }
    }
    NumberValueAccessor.ɵfac = function NumberValueAccessor_Factory(t) { return new (t || NumberValueAccessor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"])); };
    NumberValueAccessor.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: NumberValueAccessor, selectors: [["input", "type", "number", "formControlName", ""], ["input", "type", "number", "formControl", ""], ["input", "type", "number", "ngModel", ""]], hostBindings: function NumberValueAccessor_HostBindings(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("input", function NumberValueAccessor_input_HostBindingHandler($event) { return ctx.onChange($event.target.value); })("blur", function NumberValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
            }
        }, features: [/*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵProvidersFeature */ "kc"]([NUMBER_VALUE_ACCESSOR])] });
    return NumberValueAccessor;
})();
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const RADIO_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => RadioControlValueAccessor),
    multi: true
};
let RadioControlRegistry = /*@__PURE__*/ (() => {
    class RadioControlRegistry {
        constructor() {
            this._accessors = [];
        }
        /**
         * @description
         * Adds a control to the internal registry. For internal use only.
         */
        add(control, accessor) {
            this._accessors.push([control, accessor]);
        }
        /**
         * @description
         * Removes a control from the internal registry. For internal use only.
         */
        remove(accessor) {
            for (let i = this._accessors.length - 1; i >= 0; --i) {
                if (this._accessors[i][1] === accessor) {
                    this._accessors.splice(i, 1);
                    return;
                }
            }
        }
        /**
         * @description
         * Selects a radio button. For internal use only.
         */
        select(accessor) {
            this._accessors.forEach((c) => {
                if (this._isSameGroup(c, accessor) && c[1] !== accessor) {
                    c[1].fireUncheck(accessor.value);
                }
            });
        }
        _isSameGroup(controlPair, accessor) {
            if (!controlPair[0].control)
                return false;
            return controlPair[0]._parent === accessor._control._parent &&
                controlPair[1].name === accessor.name;
        }
    }
    RadioControlRegistry.ɵfac = function RadioControlRegistry_Factory(t) { return new (t || RadioControlRegistry)(); };
    RadioControlRegistry.ɵprov = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineInjectable */ "uc"]({ token: RadioControlRegistry, factory: RadioControlRegistry.ɵfac });
    return RadioControlRegistry;
})();
let RadioControlValueAccessor = /*@__PURE__*/ (() => {
    class RadioControlValueAccessor {
        constructor(_renderer, _elementRef, _registry, _injector) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            this._registry = _registry;
            this._injector = _injector;
            /**
             * @description
             * The registered callback function called when a change event occurs on the input element.
             */
            this.onChange = () => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
        }
        /**
         * @description
         * A lifecycle method called when the directive is initialized. For internal use only.
         */
        ngOnInit() {
            this._control = this._injector.get(NgControl);
            this._checkName();
            this._registry.add(this._control, this);
        }
        /**
         * @description
         * Lifecycle method called before the directive's instance is destroyed. For internal use only.
         */
        ngOnDestroy() {
            this._registry.remove(this);
        }
        /**
         * @description
         * Sets the "checked" property value on the radio input element.
         *
         * @param value The checked value
         */
        writeValue(value) {
            this._state = value === this.value;
            this._renderer.setProperty(this._elementRef.nativeElement, 'checked', this._state);
        }
        /**
         * @description
         * Registers a function called when the control value changes.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this._fn = fn;
            this.onChange = () => {
                fn(this.value);
                this._registry.select(this);
            };
        }
        /**
         * Sets the "value" on the radio input element and unchecks it.
         *
         * @param value
         */
        fireUncheck(value) {
            this.writeValue(value);
        }
        /**
         * @description
         * Registers a function called when the control is touched.
         *
         * @param fn The callback function
         */
        registerOnTouched(fn) {
            this.onTouched = fn;
        }
        /**
         * Sets the "disabled" property on the input element.
         *
         * @param isDisabled The disabled value
         */
        setDisabledState(isDisabled) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
        }
        _checkName() {
            if (this.name && this.formControlName && this.name !== this.formControlName) {
                this._throwNameError();
            }
            if (!this.name && this.formControlName)
                this.name = this.formControlName;
        }
        _throwNameError() {
            throw new Error(`
      If you define both a name and a formControlName attribute on your radio button, their values
      must match. Ex: <input type="radio" formControlName="food" name="food">
    `);
        }
    }
    RadioControlValueAccessor.ɵfac = function RadioControlValueAccessor_Factory(t) { return new (t || RadioControlValueAccessor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](RadioControlRegistry), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Injector */ "x"])); };
    RadioControlValueAccessor.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: RadioControlValueAccessor, selectors: [["input", "type", "radio", "formControlName", ""], ["input", "type", "radio", "formControl", ""], ["input", "type", "radio", "ngModel", ""]], hostBindings: function RadioControlValueAccessor_HostBindings(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("change", function RadioControlValueAccessor_change_HostBindingHandler() { return ctx.onChange(); })("blur", function RadioControlValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
            }
        }, inputs: { name: "name", formControlName: "formControlName", value: "value" }, features: [/*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵProvidersFeature */ "kc"]([RADIO_VALUE_ACCESSOR])] });
    return RadioControlValueAccessor;
})();
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const RANGE_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => RangeValueAccessor),
    multi: true
};
let RangeValueAccessor = /*@__PURE__*/ (() => {
    class RangeValueAccessor {
        constructor(_renderer, _elementRef) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            /**
             * @description
             * The registered callback function called when a change or input event occurs on the input
             * element.
             */
            this.onChange = (_) => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
        }
        /**
         * Sets the "value" property on the input element.
         *
         * @param value The checked value
         */
        writeValue(value) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'value', parseFloat(value));
        }
        /**
         * @description
         * Registers a function called when the control value changes.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this.onChange = (value) => {
                fn(value == '' ? null : parseFloat(value));
            };
        }
        /**
         * @description
         * Registers a function called when the control is touched.
         *
         * @param fn The callback function
         */
        registerOnTouched(fn) {
            this.onTouched = fn;
        }
        /**
         * Sets the "disabled" property on the range input element.
         *
         * @param isDisabled The disabled value
         */
        setDisabledState(isDisabled) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
        }
    }
    RangeValueAccessor.ɵfac = function RangeValueAccessor_Factory(t) { return new (t || RangeValueAccessor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"])); };
    RangeValueAccessor.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: RangeValueAccessor, selectors: [["input", "type", "range", "formControlName", ""], ["input", "type", "range", "formControl", ""], ["input", "type", "range", "ngModel", ""]], hostBindings: function RangeValueAccessor_HostBindings(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("change", function RangeValueAccessor_change_HostBindingHandler($event) { return ctx.onChange($event.target.value); })("input", function RangeValueAccessor_input_HostBindingHandler($event) { return ctx.onChange($event.target.value); })("blur", function RangeValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
            }
        }, features: [/*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵProvidersFeature */ "kc"]([RANGE_VALUE_ACCESSOR])] });
    return RangeValueAccessor;
})();
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const FormErrorExamples = {
    formControlName: `
    <div [formGroup]="myGroup">
      <input formControlName="firstName">
    </div>

    In your class:

    this.myGroup = new FormGroup({
       firstName: new FormControl()
    });`,
    formGroupName: `
    <div [formGroup]="myGroup">
       <div formGroupName="person">
          <input formControlName="firstName">
       </div>
    </div>

    In your class:

    this.myGroup = new FormGroup({
       person: new FormGroup({ firstName: new FormControl() })
    });`,
    formArrayName: `
    <div [formGroup]="myGroup">
      <div formArrayName="cities">
        <div *ngFor="let city of cityArray.controls; index as i">
          <input [formControlName]="i">
        </div>
      </div>
    </div>

    In your class:

    this.cityArray = new FormArray([new FormControl('SF')]);
    this.myGroup = new FormGroup({
      cities: this.cityArray
    });`,
    ngModelGroup: `
    <form>
       <div ngModelGroup="person">
          <input [(ngModel)]="person.name" name="firstName">
       </div>
    </form>`,
    ngModelWithFormGroup: `
    <div [formGroup]="myGroup">
       <input formControlName="firstName">
       <input [(ngModel)]="showMoreControls" [ngModelOptions]="{standalone: true}">
    </div>
  `
};
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
class ReactiveErrors {
    static controlParentException() {
        throw new Error(`formControlName must be used with a parent formGroup directive.  You'll want to add a formGroup
       directive and pass it an existing FormGroup instance (you can create one in your class).

      Example:

      ${FormErrorExamples.formControlName}`);
    }
    static ngModelGroupException() {
        throw new Error(`formControlName cannot be used with an ngModelGroup parent. It is only compatible with parents
       that also have a "form" prefix: formGroupName, formArrayName, or formGroup.

       Option 1:  Update the parent to be formGroupName (reactive form strategy)

        ${FormErrorExamples.formGroupName}

        Option 2: Use ngModel instead of formControlName (template-driven strategy)

        ${FormErrorExamples.ngModelGroup}`);
    }
    static missingFormException() {
        throw new Error(`formGroup expects a FormGroup instance. Please pass one in.

       Example:

       ${FormErrorExamples.formControlName}`);
    }
    static groupParentException() {
        throw new Error(`formGroupName must be used with a parent formGroup directive.  You'll want to add a formGroup
      directive and pass it an existing FormGroup instance (you can create one in your class).

      Example:

      ${FormErrorExamples.formGroupName}`);
    }
    static arrayParentException() {
        throw new Error(`formArrayName must be used with a parent formGroup directive.  You'll want to add a formGroup
       directive and pass it an existing FormGroup instance (you can create one in your class).

        Example:

        ${FormErrorExamples.formArrayName}`);
    }
    static disabledAttrWarning() {
        console.warn(`
      It looks like you're using the disabled attribute with a reactive form directive. If you set disabled to true
      when you set up this control in your component class, the disabled attribute will actually be set in the DOM for
      you. We recommend using this approach to avoid 'changed after checked' errors.

      Example:
      form = new FormGroup({
        first: new FormControl({value: 'Nancy', disabled: true}, Validators.required),
        last: new FormControl('Drew', Validators.required)
      });
    `);
    }
    static ngModelWarning(directiveName) {
        console.warn(`
    It looks like you're using ngModel on the same form field as ${directiveName}.
    Support for using the ngModel input property and ngModelChange event with
    reactive form directives has been deprecated in Angular v6 and will be removed
    in a future version of Angular.

    For more information on this, see our API docs here:
    https://angular.io/api/forms/${directiveName === 'formControl' ? 'FormControlDirective' :
            'FormControlName'}#use-with-ngmodel
    `);
    }
}
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const SELECT_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => SelectControlValueAccessor),
    multi: true
};
function _buildValueString(id, value) {
    if (id == null)
        return `${value}`;
    if (value && typeof value === 'object')
        value = 'Object';
    return `${id}: ${value}`.slice(0, 50);
}
function _extractId(valueString) {
    return valueString.split(':')[0];
}
let SelectControlValueAccessor = /*@__PURE__*/ (() => {
    class SelectControlValueAccessor {
        constructor(_renderer, _elementRef) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            /** @internal */
            this._optionMap = new Map();
            /** @internal */
            this._idCounter = 0;
            /**
             * @description
             * The registered callback function called when a change event occurs on the input element.
             */
            this.onChange = (_) => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
            this._compareWith = Object.is;
        }
        /**
         * @description
         * Tracks the option comparison algorithm for tracking identities when
         * checking for changes.
         */
        set compareWith(fn) {
            if (typeof fn !== 'function') {
                throw new Error(`compareWith must be a function, but received ${JSON.stringify(fn)}`);
            }
            this._compareWith = fn;
        }
        /**
         * Sets the "value" property on the input element. The "selectedIndex"
         * property is also set if an ID is provided on the option element.
         *
         * @param value The checked value
         */
        writeValue(value) {
            this.value = value;
            const id = this._getOptionId(value);
            if (id == null) {
                this._renderer.setProperty(this._elementRef.nativeElement, 'selectedIndex', -1);
            }
            const valueString = _buildValueString(id, value);
            this._renderer.setProperty(this._elementRef.nativeElement, 'value', valueString);
        }
        /**
         * @description
         * Registers a function called when the control value changes.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this.onChange = (valueString) => {
                this.value = this._getOptionValue(valueString);
                fn(this.value);
            };
        }
        /**
         * @description
         * Registers a function called when the control is touched.
         *
         * @param fn The callback function
         */
        registerOnTouched(fn) {
            this.onTouched = fn;
        }
        /**
         * Sets the "disabled" property on the select input element.
         *
         * @param isDisabled The disabled value
         */
        setDisabledState(isDisabled) {
            this._renderer.setProperty(this._elementRef.nativeElement, 'disabled', isDisabled);
        }
        /** @internal */
        _registerOption() {
            return (this._idCounter++).toString();
        }
        /** @internal */
        _getOptionId(value) {
            for (const id of Array.from(this._optionMap.keys())) {
                if (this._compareWith(this._optionMap.get(id), value))
                    return id;
            }
            return null;
        }
        /** @internal */
        _getOptionValue(valueString) {
            const id = _extractId(valueString);
            return this._optionMap.has(id) ? this._optionMap.get(id) : valueString;
        }
    }
    SelectControlValueAccessor.ɵfac = function SelectControlValueAccessor_Factory(t) { return new (t || SelectControlValueAccessor)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"])); };
    SelectControlValueAccessor.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: SelectControlValueAccessor, selectors: [["select", "formControlName", "", 3, "multiple", ""], ["select", "formControl", "", 3, "multiple", ""], ["select", "ngModel", "", 3, "multiple", ""]], hostBindings: function SelectControlValueAccessor_HostBindings(rf, ctx) {
            if (rf & 1) {
                _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵlistener */ "Mc"]("change", function SelectControlValueAccessor_change_HostBindingHandler($event) { return ctx.onChange($event.target.value); })("blur", function SelectControlValueAccessor_blur_HostBindingHandler() { return ctx.onTouched(); });
            }
        }, inputs: { compareWith: "compareWith" }, features: [/*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵProvidersFeature */ "kc"]([SELECT_VALUE_ACCESSOR])] });
    return SelectControlValueAccessor;
})();
let NgSelectOption = /*@__PURE__*/ (() => {
    class NgSelectOption {
        constructor(_element, _renderer, _select) {
            this._element = _element;
            this._renderer = _renderer;
            this._select = _select;
            if (this._select)
                this.id = this._select._registerOption();
        }
        /**
         * @description
         * Tracks the value bound to the option element. Unlike the value binding,
         * ngValue supports binding to objects.
         */
        set ngValue(value) {
            if (this._select == null)
                return;
            this._select._optionMap.set(this.id, value);
            this._setElementValue(_buildValueString(this.id, value));
            this._select.writeValue(this._select.value);
        }
        /**
         * @description
         * Tracks simple string values bound to the option element.
         * For objects, use the `ngValue` input binding.
         */
        set value(value) {
            this._setElementValue(value);
            if (this._select)
                this._select.writeValue(this._select.value);
        }
        /** @internal */
        _setElementValue(value) {
            this._renderer.setProperty(this._element.nativeElement, 'value', value);
        }
        /**
         * @description
         * Lifecycle method called before the directive's instance is destroyed. For internal use only.
         */
        ngOnDestroy() {
            if (this._select) {
                this._select._optionMap.delete(this.id);
                this._select.writeValue(this._select.value);
            }
        }
    }
    NgSelectOption.ɵfac = function NgSelectOption_Factory(t) { return new (t || NgSelectOption)(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ElementRef */ "r"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* Renderer2 */ "O"]), _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdirectiveInject */ "yc"](SelectControlValueAccessor, 9)); };
    NgSelectOption.ɵdir = /*@__PURE__*/ _angular_core__WEBPACK_IMPORTED_MODULE_0__[/* ɵɵdefineDirective */ "tc"]({ type: NgSelectOption, selectors: [["option"]], inputs: { ngValue: "ngValue", value: "value" } });
    return NgSelectOption;
})();
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const SELECT_MULTIPLE_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: /*@__PURE__*/ Object(_angular_core__WEBPACK_IMPORTED_MODULE_0__[/* forwardRef */ "gb"])(() => SelectMultipleControlValueAccessor),
    multi: true
};
function _buildValueString$1(id, value) {
    if (id == null)
        return `${value}`;
    if (typeof value === 'string')
        value = `'${value}'`;
    if (value && typeof value === 'object')
        value = 'Object';
    return `${id}: ${value}`.slice(0, 50);
}
function _extractId$1(valueString) {
    return valueString.split(':')[0];
}
/** Mock interface for HTMLCollection */
class HTMLCollection {
}
let SelectMultipleControlValueAccessor = /*@__PURE__*/ (() => {
    class SelectMultipleControlValueAccessor {
        constructor(_renderer, _elementRef) {
            this._renderer = _renderer;
            this._elementRef = _elementRef;
            /** @internal */
            this._optionMap = new Map();
            /** @internal */
            this._idCounter = 0;
            /**
             * @description
             * The registered callback function called when a change event occurs on the input element.
             */
            this.onChange = (_) => { };
            /**
             * @description
             * The registered callback function called when a blur event occurs on the input element.
             */
            this.onTouched = () => { };
            this._compareWith = Object.is;
        }
        /**
         * @description
         * Tracks the option comparison algorithm for tracking identities when
         * checking for changes.
         */
        set compareWith(fn) {
            if (typeof fn !== 'function') {
                throw new Error(`compareWith must be a function, but received ${JSON.stringify(fn)}`);
            }
            this._compareWith = fn;
        }
        /**
         * @description
         * Sets the "value" property on one or of more
         * of the select's options.
         *
         * @param value The value
         */
        writeValue(value) {
            this.value = value;
            let optionSelectedStateSetter;
            if (Array.isArray(value)) {
                // convert values to ids
                const ids = value.map((v) => this._getOptionId(v));
                optionSelectedStateSetter = (opt, o) => {
                    opt._setSelected(ids.indexOf(o.toString()) > -1);
                };
            }
            else {
                optionSelectedStateSetter = (opt, o) => {
                    opt._setSelected(false);
                };
            }
            this._optionMap.forEach(optionSelectedStateSetter);
        }
        /**
         * @description
         * Registers a function called when the control value changes
         * and writes an array of the selected options.
         *
         * @param fn The callback function
         */
        registerOnChange(fn) {
            this.onChange = (_) => {
                const selected = [];
                if (_.selectedOptions !== undefined) {
                    const options = _.selectedOptions;
                    for (let i = 0; i < options.length;